/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto.PBKDF2;

import net.lingala.zip4j.crypto.PBKDF2.MacBasedPRF;
import net.lingala.zip4j.crypto.PBKDF2.PBKDF2Parameters;
import net.lingala.zip4j.crypto.PBKDF2.PRF;
import net.lingala.zip4j.util.Zip4jUtil;

public class PBKDF2Engine {
    private PBKDF2Parameters parameters;
    private PRF prf;

    public PBKDF2Engine(PBKDF2Parameters pBKDF2Parameters) {
        this(pBKDF2Parameters, null);
    }

    public PBKDF2Engine(PBKDF2Parameters pBKDF2Parameters, PRF pRF) {
        this.parameters = pBKDF2Parameters;
        this.prf = pRF;
    }

    private void assertPRF(byte[] byArray) {
        if (this.prf == null) {
            this.prf = new MacBasedPRF(this.parameters.getHashAlgorithm());
        }
        this.prf.init(byArray);
    }

    private byte[] PBKDF2(PRF pRF, byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        int n4 = pRF.getHLen();
        int n5 = ((PBKDF2Engine)object).ceil(n3, n4);
        int n6 = n3 - (n5 - 1) * n4;
        byte[] byArray2 = new byte[n5 * n4];
        int n7 = 0;
        for (int i2 = 1; i2 <= n5; ++i2) {
            ((PBKDF2Engine)object)._F(byArray2, n7, pRF, byArray, n2, i2);
            n7 += n4;
        }
        if (n6 < n4) {
            byte[] byArray3 = new byte[n3];
            Object object = byArray3;
            System.arraycopy(byArray2, 0, object, 0, n3);
            return byArray3;
        }
        return byArray2;
    }

    private int ceil(int n2, int n3) {
        int n4 = 0;
        if (n2 % n3 > 0) {
            n4 = 1;
        }
        return n2 / n3 + n4;
    }

    private void _F(byte[] byArray, int n2, PRF pRF, byte[] byArray2, int n3, int n4) {
        int n5 = pRF.getHLen();
        byte[] byArray3 = new byte[n5];
        byte[] byArray4 = new byte[byArray2.length + 4];
        int n6 = byArray2.length;
        System.arraycopy(byArray2, 0, byArray4, 0, n6);
        this.INT(byArray4, byArray2.length, n4);
        for (n4 = 0; n4 < n3; ++n4) {
            byArray4 = pRF.doFinal(byArray4);
            this.xor(byArray3, byArray4);
        }
        System.arraycopy(byArray3, 0, byArray, n2, n5);
    }

    private void xor(byte[] byArray, byte[] byArray2) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = (byte)(byArray[i2] ^ byArray2[i2]);
        }
    }

    public byte[] deriveKey(char[] cArray, int n2, boolean bl) {
        cArray.getClass();
        ((PBKDF2Engine)object).assertPRF(Zip4jUtil.convertCharArrayToByteArray(cArray, bl));
        if (n2 == 0) {
            n2 = ((PBKDF2Engine)object).prf.getHLen();
        }
        PBKDF2Engine pBKDF2Engine = object;
        PBKDF2Engine pBKDF2Engine2 = object;
        Object object = pBKDF2Engine2.parameters.getSalt();
        return pBKDF2Engine.PBKDF2(pBKDF2Engine.prf, (byte[])object, pBKDF2Engine2.parameters.getIterationCount(), n2);
    }

    protected void INT(byte[] byArray, int n2, int n3) {
        byArray[n2] = (byte)(n3 / 0x1000000);
        int n4 = n2 + 1;
        byArray[n4] = (byte)(n3 / 65536);
        n4 = n2 + 2;
        byArray[n4] = (byte)(n3 / 256);
        n4 = n2 + 3;
        byArray[n4] = (byte)n3;
    }

    public PBKDF2Parameters getParameters() {
        return this.parameters;
    }

    public void setParameters(PBKDF2Parameters pBKDF2Parameters) {
        this.parameters = pBKDF2Parameters;
    }

    public void setPseudoRandomFunction(PRF pRF) {
        this.prf = pRF;
    }
}

