/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto.PBKDF2;

import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.lingala.zip4j.crypto.PBKDF2.PRF;

public class MacBasedPRF
implements PRF {
    private Mac mac;
    private int hLen;
    private String macAlgorithm;
    private ByteArrayOutputStream macCache;

    public MacBasedPRF(String string2) {
        MacBasedPRF macBasedPRF = mac;
        MacBasedPRF macBasedPRF2 = mac;
        macBasedPRF2.macAlgorithm = string2;
        macBasedPRF2.macCache = new ByteArrayOutputStream(4096);
        try {
            Mac mac = Mac.getInstance(string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        macBasedPRF.mac = mac;
        macBasedPRF.hLen = mac.getMacLength();
    }

    private void doMacUpdate(int n2) {
        byte[] byArray = this.macCache.toByteArray();
        n2 = byArray.length - n2;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3 + 16;
            int n5 = n4 <= n2 ? 16 : n2 - n3;
            this.mac.update(byArray, n3, n5);
            n3 = n4;
        }
        this.macCache.reset();
    }

    @Override
    public byte[] doFinal(byte[] byArray) {
        if (this.macCache.size() > 0) {
            this.doMacUpdate(0);
        }
        return this.mac.doFinal(byArray);
    }

    public byte[] doFinal() {
        return this.doFinal(0);
    }

    public byte[] doFinal(int n2) {
        if (this.macCache.size() > 0) {
            this.doMacUpdate(n2);
        }
        return this.mac.doFinal();
    }

    @Override
    public int getHLen() {
        return this.hLen;
    }

    @Override
    public void init(byte[] byArray) {
        try {
            this.mac.init(new SecretKeySpec(byArray, this.macAlgorithm));
            return;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException);
        }
    }

    public void update(byte[] byArray) {
        int n2 = byArray.length;
        this.update(byArray, 0, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(byte[] byArray, int n2, int n3) {
        try {
            if (this.macCache.size() + n3 > 4096) {
                this.doMacUpdate(0);
            }
            this.macCache.write(byArray, n2, n3);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            throw new RuntimeException(illegalStateException);
        }
    }
}

