/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.headers.HeaderReader;
import net.lingala.zip4j.headers.HeaderUtil;
import net.lingala.zip4j.headers.HeaderWriter;
import net.lingala.zip4j.io.inputstream.NumberedSplitRandomAccessFile;
import net.lingala.zip4j.io.inputstream.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.UnzipParameters;
import net.lingala.zip4j.model.Zip4jConfig;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.RandomAccessFileMode;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.tasks.AddFilesToZipTask;
import net.lingala.zip4j.tasks.AddFolderToZipTask;
import net.lingala.zip4j.tasks.AddStreamToZipTask;
import net.lingala.zip4j.tasks.AsyncZipTask;
import net.lingala.zip4j.tasks.ExtractAllFilesTask;
import net.lingala.zip4j.tasks.ExtractFileTask;
import net.lingala.zip4j.tasks.MergeSplitZipFileTask;
import net.lingala.zip4j.tasks.RemoveFilesFromZipTask;
import net.lingala.zip4j.tasks.RenameFilesTask;
import net.lingala.zip4j.tasks.SetCommentTask;
import net.lingala.zip4j.util.FileUtils;
import net.lingala.zip4j.util.InternalZipConstants;
import net.lingala.zip4j.util.RawIO;
import net.lingala.zip4j.util.UnzipUtil;
import net.lingala.zip4j.util.Zip4jUtil;

public class ZipFile
implements Closeable {
    private File zipFile;
    private ZipModel zipModel;
    private boolean isEncrypted;
    private ProgressMonitor progressMonitor;
    private boolean runInThread;
    private char[] password;
    private HeaderWriter headerWriter;
    private Charset charset;
    private ThreadFactory threadFactory;
    private ExecutorService executorService;
    private int bufferSize;
    private List<InputStream> openInputStreams;
    private boolean useUtf8CharsetForPasswords;

    public ZipFile(String string2) {
        File file;
        ZipFile zipFile = file2;
        File file2 = file;
        file = new File(string2);
        zipFile(file2, null);
    }

    public ZipFile(String string2, char[] cArray) {
        File file;
        ZipFile zipFile = file2;
        File file2 = file;
        file = new File(string2);
        zipFile(file2, cArray);
    }

    public ZipFile(File file) {
        this(file, null);
    }

    public ZipFile(File file, char[] cArray) {
        ArrayList arrayList;
        HeaderWriter headerWriter;
        Object object = headerWriter;
        headerWriter = new HeaderWriter();
        ((ZipFile)((Object)progressMonitor2)).headerWriter = object;
        ((ZipFile)((Object)progressMonitor2)).charset = null;
        ((ZipFile)((Object)progressMonitor2)).bufferSize = 4096;
        object = arrayList;
        arrayList = new ArrayList();
        ((ZipFile)((Object)progressMonitor2)).openInputStreams = object;
        ((ZipFile)((Object)progressMonitor2)).useUtf8CharsetForPasswords = true;
        if (file != null) {
            ProgressMonitor progressMonitor;
            ZipFile zipFile = progressMonitor2;
            zipFile.zipFile = file;
            zipFile.password = cArray;
            zipFile.runInThread = false;
            ProgressMonitor progressMonitor2 = progressMonitor;
            progressMonitor = new ProgressMonitor();
            zipFile.progressMonitor = progressMonitor2;
            return;
        }
        throw new IllegalArgumentException("input zip file parameter is null");
    }

    private void addFolder(File file, ZipParameters zipParameters, boolean bl) throws ZipException {
        ZipFile zipFile = zip4jConfig;
        zipFile.readZipInfo();
        Object object = zipFile.zipModel;
        if (object != null) {
            AddFolderToZipTask.AddFolderToZipTaskParameters addFolderToZipTaskParameters;
            if (bl && ((ZipModel)object).isSplitArchive()) {
                throw new ZipException("This is a split archive. Zip file format does not allow updating split/spanned files");
            }
            ZipFile zipFile2 = zip4jConfig;
            Object object2 = zipFile2.zipModel;
            object = zipFile2.password;
            HeaderWriter headerWriter = zipFile2.headerWriter;
            AsyncZipTask.AsyncTaskParameters asyncTaskParameters = zipFile2.buildAsyncParameters();
            AddFolderToZipTask addFolderToZipTask = new AddFolderToZipTask((ZipModel)object2, (char[])object, headerWriter, asyncTaskParameters);
            object2 = addFolderToZipTaskParameters;
            Zip4jConfig zip4jConfig = ((ZipFile)((Object)zip4jConfig)).buildConfig();
            addFolderToZipTaskParameters = new AddFolderToZipTask.AddFolderToZipTaskParameters(file, zipParameters, zip4jConfig);
            addFolderToZipTask.execute(object2);
            return;
        }
        throw new ZipException("internal error: zip model is null");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readZipInfo() throws ZipException {
        HeaderReader headerReader;
        if (this.zipModel != null) {
            return;
        }
        if (!this.zipFile.exists()) {
            this.createNewZipModel();
            return;
        }
        if (!this.zipFile.canRead()) throw new ZipException("no read access for the input zip file");
        RandomAccessFile randomAccessFile = this.initializeRandomAccessFileForHeaderReading();
        Object object = headerReader;
        try {
            ((HeaderReader)object)();
            object = headerReader.readAllHeaders(randomAccessFile, this.buildConfig());
        }
        catch (Throwable throwable) {
            if (randomAccessFile == null) throw throwable;
            try {
                randomAccessFile.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                try {
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new ZipException(iOException);
                }
                catch (ZipException zipException) {
                    throw zipException;
                }
            }
        }
        this.zipModel = object;
        ((ZipModel)object).setZipFile(this.zipFile);
        if (randomAccessFile == null) return;
        randomAccessFile.close();
    }

    private void createNewZipModel() {
        ZipModel zipModel;
        ZipModel zipModel2;
        ZipModel zipModel3 = zipModel2 = zipModel;
        zipModel3();
        this.zipModel = zipModel3;
        zipModel.setZipFile(this.zipFile);
    }

    private RandomAccessFile initializeRandomAccessFileForHeaderReading() throws IOException {
        if (FileUtils.isNumberedSplitFile(this.zipFile)) {
            File[] fileArray = FileUtils.getAllSortedNumberedSplitFiles(this.zipFile);
            NumberedSplitRandomAccessFile numberedSplitRandomAccessFile = new NumberedSplitRandomAccessFile(this.zipFile, RandomAccessFileMode.READ.getValue(), fileArray);
            numberedSplitRandomAccessFile.openLastSplitFileForReading();
            return numberedSplitRandomAccessFile;
        }
        return new RandomAccessFile(this.zipFile, RandomAccessFileMode.READ.getValue());
    }

    private AsyncZipTask.AsyncTaskParameters buildAsyncParameters() {
        if (autoCloseable.runInThread) {
            if (autoCloseable.threadFactory == null) {
                autoCloseable.threadFactory = Executors.defaultThreadFactory();
            }
            autoCloseable.executorService = Executors.newSingleThreadExecutor(autoCloseable.threadFactory);
        }
        ZipFile zipFile = autoCloseable;
        AutoCloseable autoCloseable = zipFile.executorService;
        boolean bl = zipFile.runInThread;
        ProgressMonitor progressMonitor = zipFile.progressMonitor;
        return new AsyncZipTask.AsyncTaskParameters((ExecutorService)autoCloseable, bl, progressMonitor);
    }

    private boolean verifyAllSplitFilesOfZipExists(List<File> list) {
        Iterator<File> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (((File)iterator.next()).exists()) continue;
            return false;
        }
        return true;
    }

    private Zip4jConfig buildConfig() {
        ZipFile zipFile = charset;
        Charset charset = zipFile.charset;
        int n2 = zipFile.bufferSize;
        boolean bl = zipFile.useUtf8CharsetForPasswords;
        return new Zip4jConfig(charset, n2, bl);
    }

    public void createSplitZipFile(List<File> list, ZipParameters zipParameters, boolean bl, long l2) throws ZipException {
        if (!this.zipFile.exists()) {
            if (list != null && list.size() != 0) {
                ZipFile zipFile = this;
                zipFile.createNewZipModel();
                zipFile.zipModel.setSplitArchive(bl);
                zipFile.zipModel.setSplitLength(l2);
                ZipFile zipFile2 = this;
                ZipModel zipModel = zipFile2.zipModel;
                char[] cArray = zipFile2.password;
                HeaderWriter headerWriter = zipFile2.headerWriter;
                AsyncZipTask.AsyncTaskParameters asyncTaskParameters = zipFile2.buildAsyncParameters();
                new AddFilesToZipTask(zipModel, cArray, headerWriter, asyncTaskParameters).execute(new AddFilesToZipTask.AddFilesToZipTaskParameters(list, zipParameters, this.buildConfig()));
                return;
            }
            throw new ZipException("input file List is null, cannot create zip file");
        }
        throw new ZipException("zip file: " + this.zipFile + " already exists. To add files to existing zip file use addFile method");
    }

    public void createSplitZipFileFromFolder(File file, ZipParameters zipParameters, boolean bl, long l2) throws ZipException {
        if (file != null) {
            if (zipParameters != null) {
                if (!this.zipFile.exists()) {
                    ZipFile zipFile = this;
                    zipFile.createNewZipModel();
                    zipFile.zipModel.setSplitArchive(bl);
                    if (bl) {
                        this.zipModel.setSplitLength(l2);
                    }
                    this.addFolder(file, zipParameters, false);
                    return;
                }
                throw new ZipException("zip file: " + this.zipFile + " already exists. To add files to existing zip file use addFolder method");
            }
            throw new ZipException("input parameters are null, cannot create zip file from folder");
        }
        throw new ZipException("folderToAdd is null, cannot create zip file from folder");
    }

    public void addFile(String string2) throws ZipException {
        ZipParameters zipParameters;
        ZipFile zipFile = zipParameters2;
        ZipParameters zipParameters2 = zipParameters;
        zipParameters = new ZipParameters();
        zipFile.addFile(string2, zipParameters2);
    }

    public void addFile(String string2, ZipParameters zipParameters) throws ZipException {
        if (Zip4jUtil.isStringNotNullAndNotEmpty(string2)) {
            this.addFiles(Collections.singletonList(new File(string2)), zipParameters);
            return;
        }
        throw new ZipException("file to add is null or empty");
    }

    public void addFile(File object) throws ZipException {
        ZipParameters zipParameters;
        ZipFile zipFile = list;
        List<File> list = Collections.singletonList(object);
        object = zipParameters;
        zipParameters = new ZipParameters();
        zipFile.addFiles(list, (ZipParameters)object);
    }

    public void addFile(File file, ZipParameters zipParameters) throws ZipException {
        this.addFiles(Collections.singletonList(file), zipParameters);
    }

    public void addFiles(List<File> list) throws ZipException {
        ZipParameters zipParameters;
        ZipFile zipFile = zipParameters2;
        ZipParameters zipParameters2 = zipParameters;
        zipParameters = new ZipParameters();
        zipFile.addFiles(list, zipParameters2);
    }

    public void addFiles(List<File> list, ZipParameters zipParameters) throws ZipException {
        if (list != null && list.size() != 0) {
            if (zipParameters != null) {
                ZipFile zipFile = zip4jConfig;
                zipFile.readZipInfo();
                if (zipFile.zipModel != null) {
                    AddFilesToZipTask.AddFilesToZipTaskParameters addFilesToZipTaskParameters;
                    if (((ZipFile)((Object)zip4jConfig)).zipFile.exists() && ((ZipFile)((Object)zip4jConfig)).zipModel.isSplitArchive()) {
                        throw new ZipException("Zip file already exists. Zip file format does not allow updating split/spanned files");
                    }
                    ZipFile zipFile2 = zip4jConfig;
                    Object object = zipFile2.zipModel;
                    char[] cArray = zipFile2.password;
                    HeaderWriter headerWriter = zipFile2.headerWriter;
                    AsyncZipTask.AsyncTaskParameters asyncTaskParameters = zipFile2.buildAsyncParameters();
                    AddFilesToZipTask addFilesToZipTask = new AddFilesToZipTask((ZipModel)object, cArray, headerWriter, asyncTaskParameters);
                    object = addFilesToZipTaskParameters;
                    Zip4jConfig zip4jConfig = ((ZipFile)((Object)zip4jConfig)).buildConfig();
                    addFilesToZipTaskParameters = new AddFilesToZipTask.AddFilesToZipTaskParameters(list, zipParameters, zip4jConfig);
                    addFilesToZipTask.execute(object);
                    return;
                }
                throw new ZipException("internal error: zip model is null");
            }
            throw new ZipException("input parameters are null");
        }
        throw new ZipException("input file List is null or empty");
    }

    public void addFolder(File file) throws ZipException {
        ZipParameters zipParameters;
        ZipFile zipFile = zipParameters2;
        ZipParameters zipParameters2 = zipParameters;
        zipParameters = new ZipParameters();
        zipFile.addFolder(file, zipParameters2);
    }

    public void addFolder(File file, ZipParameters zipParameters) throws ZipException {
        if (file != null) {
            if (file.exists()) {
                if (file.isDirectory()) {
                    if (file.canRead()) {
                        if (zipParameters != null) {
                            this.addFolder(file, zipParameters, true);
                            return;
                        }
                        throw new ZipException("input parameters are null, cannot add folder to zip file");
                    }
                    throw new ZipException("cannot read input folder");
                }
                throw new ZipException("input folder is not a directory");
            }
            throw new ZipException("folder does not exist");
        }
        throw new ZipException("input path is null, cannot add folder to zip file");
    }

    public void addStream(InputStream inputStream, ZipParameters zipParameters) throws ZipException {
        if (inputStream != null) {
            if (zipParameters != null) {
                ZipFile zipFile = zip4jConfig;
                zipFile.setRunInThread(false);
                zipFile.readZipInfo();
                if (zipFile.zipModel != null) {
                    AddStreamToZipTask.AddStreamToZipTaskParameters addStreamToZipTaskParameters;
                    if (((ZipFile)((Object)zip4jConfig)).zipFile.exists() && ((ZipFile)((Object)zip4jConfig)).zipModel.isSplitArchive()) {
                        throw new ZipException("Zip file already exists. Zip file format does not allow updating split/spanned files");
                    }
                    ZipFile zipFile2 = zip4jConfig;
                    Object object = zipFile2.zipModel;
                    char[] cArray = zipFile2.password;
                    HeaderWriter headerWriter = zipFile2.headerWriter;
                    AsyncZipTask.AsyncTaskParameters asyncTaskParameters = zipFile2.buildAsyncParameters();
                    AddStreamToZipTask addStreamToZipTask = new AddStreamToZipTask((ZipModel)object, cArray, headerWriter, asyncTaskParameters);
                    object = addStreamToZipTaskParameters;
                    Zip4jConfig zip4jConfig = ((ZipFile)((Object)zip4jConfig)).buildConfig();
                    addStreamToZipTaskParameters = new AddStreamToZipTask.AddStreamToZipTaskParameters(inputStream, zipParameters, zip4jConfig);
                    addStreamToZipTask.execute(object);
                    return;
                }
                throw new ZipException("internal error: zip model is null");
            }
            throw new ZipException("zip parameters are null");
        }
        throw new ZipException("inputstream is null, cannot add file to zip");
    }

    public void extractAll(String string2) throws ZipException {
        UnzipParameters unzipParameters;
        ZipFile zipFile = unzipParameters2;
        UnzipParameters unzipParameters2 = unzipParameters;
        unzipParameters = new UnzipParameters();
        zipFile.extractAll(string2, unzipParameters2);
    }

    public void extractAll(String string2, UnzipParameters object) throws ZipException {
        if (Zip4jUtil.isStringNotNullAndNotEmpty(string2)) {
            if (Zip4jUtil.createDirectoryIfNotExists(new File(string2))) {
                ZipModel zipModel;
                if (this.zipModel == null) {
                    this.readZipInfo();
                }
                if ((zipModel = this.zipModel) != null) {
                    ExtractAllFilesTask.ExtractAllFilesTaskParameters extractAllFilesTaskParameters;
                    ZipFile zipFile = this;
                    char[] cArray = zipFile.password;
                    AsyncZipTask.AsyncTaskParameters asyncTaskParameters = zipFile.buildAsyncParameters();
                    ExtractAllFilesTask extractAllFilesTask = new ExtractAllFilesTask(zipModel, cArray, (UnzipParameters)object, asyncTaskParameters);
                    object = extractAllFilesTaskParameters;
                    extractAllFilesTaskParameters = new ExtractAllFilesTask.ExtractAllFilesTaskParameters(string2, this.buildConfig());
                    extractAllFilesTask.execute(object);
                    return;
                }
                throw new ZipException("Internal error occurred when extracting zip file");
            }
            throw new ZipException("invalid output path");
        }
        throw new ZipException("output path is null or invalid");
    }

    public void extractFile(FileHeader fileHeader, String string2) throws ZipException {
        UnzipParameters unzipParameters;
        ZipFile zipFile = unzipParameters2;
        UnzipParameters unzipParameters2 = unzipParameters;
        unzipParameters = new UnzipParameters();
        zipFile.extractFile(fileHeader, string2, null, unzipParameters2);
    }

    public void extractFile(FileHeader fileHeader, String string2, UnzipParameters unzipParameters) throws ZipException {
        this.extractFile(fileHeader, string2, null, unzipParameters);
    }

    public void extractFile(FileHeader fileHeader, String string2, String string3, UnzipParameters unzipParameters) throws ZipException {
        if (fileHeader != null) {
            this.extractFile(fileHeader.getFileName(), string2, string3, unzipParameters);
            return;
        }
        throw new ZipException("input file header is null, cannot extract file");
    }

    public void extractFile(String string2, String string3) throws ZipException {
        UnzipParameters unzipParameters;
        ZipFile zipFile = unzipParameters2;
        UnzipParameters unzipParameters2 = unzipParameters;
        unzipParameters = new UnzipParameters();
        zipFile.extractFile(string2, string3, null, unzipParameters2);
    }

    public void extractFile(String string2, String string3, UnzipParameters unzipParameters) throws ZipException {
        this.extractFile(string2, string3, null, unzipParameters);
    }

    public void extractFile(String string2, String string3, String string4) throws ZipException {
        UnzipParameters unzipParameters;
        ZipFile zipFile = unzipParameters2;
        UnzipParameters unzipParameters2 = unzipParameters;
        unzipParameters = new UnzipParameters();
        zipFile.extractFile(string2, string3, string4, unzipParameters2);
    }

    public void extractFile(FileHeader fileHeader, String string2, String string3) throws ZipException {
        UnzipParameters unzipParameters;
        ZipFile zipFile = unzipParameters2;
        UnzipParameters unzipParameters2 = unzipParameters;
        unzipParameters = new UnzipParameters();
        zipFile.extractFile(fileHeader, string2, string3, unzipParameters2);
    }

    public void extractFile(String string2, String string3, String string4, UnzipParameters object) throws ZipException {
        if (Zip4jUtil.isStringNotNullAndNotEmpty(string2)) {
            if (Zip4jUtil.isStringNotNullAndNotEmpty(string3)) {
                ExtractFileTask.ExtractFileTaskParameters extractFileTaskParameters;
                if (object == null) {
                    UnzipParameters unzipParameters;
                    object = unzipParameters;
                    unzipParameters = new UnzipParameters();
                }
                ((ZipFile)((Object)zip4jConfig)).readZipInfo();
                ZipFile zipFile = zip4jConfig;
                ZipModel zipModel = zipFile.zipModel;
                char[] cArray = zipFile.password;
                AsyncZipTask.AsyncTaskParameters asyncTaskParameters = zipFile.buildAsyncParameters();
                ExtractFileTask extractFileTask = new ExtractFileTask(zipModel, cArray, (UnzipParameters)object, asyncTaskParameters);
                object = extractFileTaskParameters;
                Zip4jConfig zip4jConfig = ((ZipFile)((Object)zip4jConfig)).buildConfig();
                extractFileTaskParameters = new ExtractFileTask.ExtractFileTaskParameters(string3, string2, string4, zip4jConfig);
                extractFileTask.execute(object);
                return;
            }
            throw new ZipException("destination path is empty or null, cannot extract file");
        }
        throw new ZipException("file to extract is null or empty, cannot extract file");
    }

    public List<FileHeader> getFileHeaders() throws ZipException {
        ZipFile zipFile = this;
        zipFile.readZipInfo();
        ZipModel zipModel = zipFile.zipModel;
        if (zipModel != null && zipModel.getCentralDirectory() != null) {
            return this.zipModel.getCentralDirectory().getFileHeaders();
        }
        return Collections.emptyList();
    }

    public FileHeader getFileHeader(String string2) throws ZipException {
        if (Zip4jUtil.isStringNotNullAndNotEmpty(string2)) {
            ZipFile zipFile = this;
            zipFile.readZipInfo();
            ZipModel zipModel = zipFile.zipModel;
            if (zipModel != null && zipModel.getCentralDirectory() != null) {
                return HeaderUtil.getFileHeader(this.zipModel, string2);
            }
            return null;
        }
        throw new ZipException("input file name is emtpy or null, cannot get FileHeader");
    }

    public boolean isEncrypted() throws ZipException {
        if (this.zipModel == null) {
            ZipFile zipFile = this;
            zipFile.readZipInfo();
            if (zipFile.zipModel == null) {
                throw new ZipException("Zip Model is null");
            }
        }
        if (this.zipModel.getCentralDirectory() != null && this.zipModel.getCentralDirectory().getFileHeaders() != null) {
            for (FileHeader fileHeader : this.zipModel.getCentralDirectory().getFileHeaders()) {
                if (fileHeader == null || !fileHeader.isEncrypted()) continue;
                this.isEncrypted = true;
                break;
            }
            return this.isEncrypted;
        }
        throw new ZipException("invalid zip file");
    }

    public boolean isSplitArchive() throws ZipException {
        if (this.zipModel == null) {
            ZipFile zipFile = this;
            zipFile.readZipInfo();
            if (zipFile.zipModel == null) {
                throw new ZipException("Zip Model is null");
            }
        }
        return this.zipModel.isSplitArchive();
    }

    public void removeFile(FileHeader fileHeader) throws ZipException {
        if (fileHeader != null) {
            this.removeFile(fileHeader.getFileName());
            return;
        }
        throw new ZipException("input file header is null, cannot remove file");
    }

    public void removeFile(String string2) throws ZipException {
        if (Zip4jUtil.isStringNotNullAndNotEmpty(string2)) {
            this.removeFiles(Collections.singletonList(string2));
            return;
        }
        throw new ZipException("file name is empty or null, cannot remove file");
    }

    public void removeFiles(List<String> list) throws ZipException {
        if (list != null) {
            if (list.isEmpty()) {
                return;
            }
            if (this.zipModel == null) {
                this.readZipInfo();
            }
            if (!this.zipModel.isSplitArchive()) {
                RemoveFilesFromZipTask.RemoveFilesFromZipTaskParameters removeFilesFromZipTaskParameters;
                ZipFile zipFile = this;
                Object object = zipFile.zipModel;
                HeaderWriter headerWriter = zipFile.headerWriter;
                AsyncZipTask.AsyncTaskParameters asyncTaskParameters = zipFile.buildAsyncParameters();
                RemoveFilesFromZipTask removeFilesFromZipTask = new RemoveFilesFromZipTask((ZipModel)object, headerWriter, asyncTaskParameters);
                object = removeFilesFromZipTaskParameters;
                removeFilesFromZipTaskParameters = new RemoveFilesFromZipTask.RemoveFilesFromZipTaskParameters(list, this.buildConfig());
                removeFilesFromZipTask.execute(object);
                return;
            }
            throw new ZipException("Zip file format does not allow updating split/spanned files");
        }
        throw new ZipException("fileNames list is null");
    }

    public void renameFile(FileHeader fileHeader, String string2) throws ZipException {
        if (fileHeader != null) {
            this.renameFile(fileHeader.getFileName(), string2);
            return;
        }
        throw new ZipException("File header is null");
    }

    public void renameFile(String string2, String string3) throws ZipException {
        if (Zip4jUtil.isStringNotNullAndNotEmpty(string2)) {
            if (Zip4jUtil.isStringNotNullAndNotEmpty(string3)) {
                this.renameFiles(Collections.singletonMap(string2, string3));
                return;
            }
            throw new ZipException("newFileName is null or empty");
        }
        throw new ZipException("file name to be changed is null or empty");
    }

    public void renameFiles(Map<String, String> map) throws ZipException {
        if (map != null) {
            if (map.size() == 0) {
                return;
            }
            ZipFile zipFile = this;
            zipFile.readZipInfo();
            if (!zipFile.zipModel.isSplitArchive()) {
                RenameFilesTask.RenameFilesTaskParameters renameFilesTaskParameters;
                RawIO rawIO;
                Object object = this.buildAsyncParameters();
                ZipFile zipFile2 = this;
                ZipModel zipModel = zipFile2.zipModel;
                RawIO rawIO2 = rawIO;
                rawIO = new RawIO();
                RenameFilesTask renameFilesTask = new RenameFilesTask(zipModel, zipFile2.headerWriter, rawIO2, (AsyncZipTask.AsyncTaskParameters)object);
                object = renameFilesTaskParameters;
                renameFilesTaskParameters = new RenameFilesTask.RenameFilesTaskParameters(map, this.buildConfig());
                renameFilesTask.execute(object);
                return;
            }
            throw new ZipException("Zip file format does not allow updating split/spanned files");
        }
        throw new ZipException("fileNamesMap is null");
    }

    public void mergeSplitFiles(File file) throws ZipException {
        if (file != null) {
            if (!file.exists()) {
                ZipFile zipFile = this;
                zipFile.readZipInfo();
                Object object = zipFile.zipModel;
                if (object != null) {
                    MergeSplitZipFileTask.MergeSplitZipFileTaskParameters mergeSplitZipFileTaskParameters;
                    MergeSplitZipFileTask mergeSplitZipFileTask = new MergeSplitZipFileTask((ZipModel)object, this.buildAsyncParameters());
                    object = mergeSplitZipFileTaskParameters;
                    mergeSplitZipFileTaskParameters = new MergeSplitZipFileTask.MergeSplitZipFileTaskParameters(file, this.buildConfig());
                    mergeSplitZipFileTask.execute(object);
                    return;
                }
                throw new ZipException("zip model is null, corrupt zip file?");
            }
            throw new ZipException("output Zip File already exists");
        }
        throw new ZipException("outputZipFile is null, cannot merge split files");
    }

    public void setComment(String string2) throws ZipException {
        if (string2 != null) {
            if (this.zipFile.exists()) {
                ZipFile zipFile = this;
                zipFile.readZipInfo();
                Object object = zipFile.zipModel;
                if (object != null) {
                    if (((ZipModel)object).getEndOfCentralDirectoryRecord() != null) {
                        SetCommentTask.SetCommentTaskTaskParameters setCommentTaskTaskParameters;
                        ZipFile zipFile2 = this;
                        object = zipFile2.zipModel;
                        SetCommentTask setCommentTask = new SetCommentTask((ZipModel)object, zipFile2.buildAsyncParameters());
                        object = setCommentTaskTaskParameters;
                        setCommentTaskTaskParameters = new SetCommentTask.SetCommentTaskTaskParameters(string2, this.buildConfig());
                        setCommentTask.execute(object);
                        return;
                    }
                    throw new ZipException("end of central directory is null, cannot set comment");
                }
                throw new ZipException("zipModel is null, cannot update zip file");
            }
            throw new ZipException("zip file does not exist, cannot set comment for zip file");
        }
        throw new ZipException("input comment is null, cannot update zip file");
    }

    public String getComment() throws ZipException {
        if (this.zipFile.exists()) {
            ZipFile zipFile = this;
            zipFile.readZipInfo();
            ZipModel zipModel = zipFile.zipModel;
            if (zipModel != null) {
                if (zipModel.getEndOfCentralDirectoryRecord() != null) {
                    return this.zipModel.getEndOfCentralDirectoryRecord().getComment();
                }
                throw new ZipException("end of central directory record is null, cannot read comment");
            }
            throw new ZipException("zip model is null, cannot read comment");
        }
        throw new ZipException("zip file does not exist, cannot read comment");
    }

    public ZipInputStream getInputStream(FileHeader fileHeader) throws IOException {
        if (fileHeader != null) {
            ZipFile zipFile = this;
            zipFile.readZipInfo();
            ZipModel zipModel = zipFile.zipModel;
            if (zipModel != null) {
                ZipInputStream zipInputStream = UnzipUtil.createZipInputStream(zipModel, fileHeader, this.password);
                this.openInputStreams.add(zipInputStream);
                return zipInputStream;
            }
            throw new ZipException("zip model is null, cannot get inputstream");
        }
        throw new ZipException("FileHeader is null, cannot get InputStream");
    }

    public boolean isValidZipFile() {
        block4: {
            if (!this.zipFile.exists()) {
                return false;
            }
            try {
                ZipFile zipFile = this;
                zipFile.readZipInfo();
                if (!zipFile.zipModel.isSplitArchive()) break block4;
            }
            catch (Exception exception) {
                return false;
            }
            ZipFile zipFile = this;
            if (zipFile.verifyAllSplitFilesOfZipExists(zipFile.getSplitZipFiles())) break block4;
            return false;
        }
        return true;
    }

    public List<File> getSplitZipFiles() throws ZipException {
        ZipFile zipFile = this;
        zipFile.readZipInfo();
        return FileUtils.getSplitZipFiles(zipFile.zipModel);
    }

    @Override
    public void close() throws IOException {
        Iterator<InputStream> iterator = this.openInputStreams.iterator();
        while (iterator.hasNext()) {
            iterator.next().close();
        }
        this.openInputStreams.clear();
    }

    public void setPassword(char[] cArray) {
        this.password = cArray;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int n2) {
        if (n2 >= 512) {
            this.bufferSize = n2;
            return;
        }
        throw new IllegalArgumentException("Buffer size cannot be less than 512 bytes");
    }

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public boolean isRunInThread() {
        return this.runInThread;
    }

    public void setRunInThread(boolean bl) {
        this.runInThread = bl;
    }

    public File getFile() {
        return this.zipFile;
    }

    public Charset getCharset() {
        Charset charset = ((ZipFile)((Object)charset)).charset;
        if (charset == null) {
            return InternalZipConstants.CHARSET_UTF_8;
        }
        return charset;
    }

    public void setCharset(Charset charset) throws IllegalArgumentException {
        if (charset != null) {
            this.charset = charset;
            return;
        }
        throw new IllegalArgumentException("charset cannot be null");
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public String toString() {
        return this.zipFile.toString();
    }

    public boolean isUseUtf8CharsetForPasswords() {
        return this.useUtf8CharsetForPasswords;
    }

    public void setUseUtf8CharsetForPasswords(boolean bl) {
        this.useUtf8CharsetForPasswords = bl;
    }
}

