/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.barcode2.decoding;

import android.app.Activity;
import io.dcloud.feature.barcode2.decoding.FinishListener;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class InactivityTimer {
    private static final int INACTIVITY_DELAY_SECONDS = 300;
    private final ScheduledExecutorService inactivityTimer = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory());
    private final Activity activity;
    private ScheduledFuture<?> inactivityFuture = null;

    public InactivityTimer(Activity activity) {
        this.activity = activity;
        this.onActivity();
    }

    private void cancel() {
        ScheduledFuture<?> scheduledFuture = this.inactivityFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
            this.inactivityFuture = null;
        }
    }

    public void onActivity() {
        InactivityTimer inactivityTimer = object;
        inactivityTimer.cancel();
        Object object = TimeUnit.SECONDS;
        inactivityTimer.inactivityFuture = inactivityTimer.inactivityTimer.schedule(new FinishListener(object.activity), 300L, (TimeUnit)((Object)object));
    }

    public void shutdown() {
        InactivityTimer inactivityTimer = this;
        inactivityTimer.cancel();
        inactivityTimer.inactivityTimer.shutdown();
    }

    private static final class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    }
}

