/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.barcode2.camera;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.Build;
import android.util.Log;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.feature.barcode2.camera.CameraManager;
import io.dcloud.feature.barcode2.view.DetectorViewConfig;
import java.util.regex.Pattern;

final class CameraConfigurationManager {
    private static final String TAG = "CameraConfigurationManager";
    private static final int TEN_DESIRED_ZOOM = 27;
    private static final int DESIRED_SHARPNESS = 30;
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private final Context context;
    private Point cameraResolution;
    private int previewFormat;
    private String previewFormatString;
    private Camera.Parameters parameters;

    CameraConfigurationManager(Context context) {
        this.context = context;
    }

    public static Point getCameraResolution(Camera.Parameters parameters, Point point) {
        String string2 = parameters.get("preview-size-values");
        if (string2 == null) {
            string2 = parameters.get("preview-size-value");
        }
        parameters = null;
        if (string2 != null) {
            Logger.i(TAG, "preview-size-values parameter: " + string2);
            parameters = CameraConfigurationManager.findBestPreviewSizeValue(string2, point);
        }
        if (parameters == null) {
            Point point2;
            parameters = point2;
            point2 = new Point(point.x >> 3 << 3, point.y >> 3 << 3);
        }
        return parameters;
    }

    private static Point findBestPreviewSizeValue0(CharSequence stringArray, Point point) {
        int n2;
        int n3;
        block11: {
            int n4 = 0;
            n3 = 0;
            stringArray = COMMA_PATTERN.split((CharSequence)stringArray);
            int n5 = 0;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                block14: {
                    block13: {
                        String string2;
                        block12: {
                            string2 = (n5 != 0 && n5 != 1 ? stringArray[stringArray.length - 1 - i2] : stringArray[i2]).trim();
                            n2 = string2.indexOf(120);
                            if (n2 >= 0) break block12;
                            Log.w((String)TAG, (String)("Bad preview-size: " + string2));
                            break block13;
                        }
                        int n6 = n5;
                        String string3 = string2;
                        int n7 = n2;
                        n2 = Integer.parseInt(string2.substring(0, n2));
                        try {
                            n3 = Integer.parseInt(string3.substring(n7 + 1));
                        }
                        catch (NumberFormatException numberFormatException) {
                            Log.w((String)TAG, (String)("Bad preview-size: " + string2));
                        }
                        if (n6 != 0) {
                            if (n4 > 0 && n2 <= point.y && n3 <= point.x) {
                                break block11;
                            }
                        } else if (n4 != 0) {
                            if (n2 > n4) {
                                n5 = -1;
                                i2 = -1;
                                n2 = 0;
                                n3 = 0;
                            } else {
                                n5 = 1;
                                i2 = -1;
                                n2 = 0;
                                n3 = 0;
                            }
                        }
                        break block14;
                    }
                    n2 = n4;
                }
                n4 = n2;
            }
            n2 = n4;
        }
        if (n2 > 0 && n3 > 0) {
            return new Point(n2, n3);
        }
        return null;
    }

    private static Point findBestPreviewSizeValue(CharSequence stringArray, Point point) {
        int n2;
        int n3;
        block6: {
            int n4 = 0;
            int n5 = 0;
            int n6 = Integer.MAX_VALUE;
            stringArray = COMMA_PATTERN.split((CharSequence)stringArray);
            int n7 = stringArray.length;
            for (int i2 = 0; i2 < n7; ++i2) {
                int n8;
                block8: {
                    block5: {
                        String string2;
                        block7: {
                            string2 = stringArray[i2].trim();
                            n8 = string2.indexOf(120);
                            if (n8 >= 0) break block7;
                            Log.w((String)TAG, (String)("Bad preview-size: " + string2));
                            break block5;
                        }
                        n3 = Integer.parseInt(string2.substring(0, n8));
                        try {
                            n2 = Integer.parseInt(string2.substring(n8 + 1));
                            if (n3 < n2) break block5;
                        }
                        catch (NumberFormatException numberFormatException) {
                            Log.w((String)TAG, (String)("Bad preview-size: " + string2));
                        }
                        n8 = Math.abs(n3 - point.x) + Math.abs(n2 - point.y);
                        if (n8 == 0) break block6;
                        if (n8 >= n6) break block5;
                        break block8;
                    }
                    n2 = n5;
                    n3 = n4;
                    n8 = n6;
                }
                n5 = n2;
                n4 = n3;
                n6 = n8;
            }
            n2 = n5;
            n3 = n4;
        }
        if (n3 > 0 && n2 > 0) {
            return new Point(n3, n2);
        }
        return null;
    }

    private static int findBestMotZoomValue(CharSequence stringArray, int n2) {
        int n3 = 0;
        stringArray = COMMA_PATTERN.split((CharSequence)stringArray);
        int n4 = stringArray.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            double d2;
            try {
                d2 = Double.parseDouble(stringArray[i2].trim());
            }
            catch (NumberFormatException numberFormatException) {
                return n2;
            }
            int n5 = (int)(d2 * 10.0);
            if (!(Math.abs((double)n2 - d2) < (double)Math.abs(n2 - n3))) {
                n5 = n3;
            }
            n3 = n5;
        }
        return n3;
    }

    private void setFlash(Camera.Parameters parameters) {
        if (Build.MODEL.contains("Behold II") && CameraManager.SDK_INT == 3) {
            parameters.set("flash-value", 1);
        } else {
            parameters.set("flash-value", 2);
        }
        parameters.set("flash-mode", "off");
    }

    private void setZoom(Camera.Parameters parameters) {
        String string2;
        int n2;
        String string3;
        String string4;
        block18: {
            String string5;
            block17: {
                int n3;
                block16: {
                    block15: {
                        int n4;
                        block14: {
                            String string6 = parameters.get("zoom-supported");
                            if (string6 != null && !Boolean.parseBoolean(string6)) {
                                return;
                            }
                            n4 = 27;
                            string4 = parameters.get("max-zoom");
                            if (string4 != null) {
                                double d2 = 10.0;
                                try {
                                    n3 = (int)(Double.parseDouble(string4) * d2);
                                    if (n4 <= n3) break block14;
                                    break block15;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    Log.w((String)TAG, (String)("Bad max-zoom: " + string4));
                                }
                            }
                        }
                        n3 = n4;
                    }
                    string3 = parameters.get("taking-picture-zoom-max");
                    if (string3 != null) {
                        try {
                            n2 = Integer.parseInt(string3);
                            if (n3 <= n2) break block16;
                            break block17;
                        }
                        catch (NumberFormatException numberFormatException) {
                            Log.w((String)TAG, (String)("Bad taking-picture-zoom-max: " + string3));
                        }
                    }
                }
                n2 = n3;
            }
            string2 = parameters.get("mot-zoom-values");
            if (string2 != null) {
                n2 = CameraConfigurationManager.findBestMotZoomValue(string2, n2);
            }
            if ((string5 = parameters.get("mot-zoom-step")) != null) {
                int n5;
                try {
                    n5 = (int)(Double.parseDouble(string5.trim()) * 10.0);
                    if (n5 <= 1) break block18;
                }
                catch (NumberFormatException numberFormatException) {}
                int n6 = n2;
                n2 = n6 - n6 % n5;
            }
        }
        if (string4 != null || string2 != null) {
            parameters.set("zoom", String.valueOf((double)n2 / 10.0));
        }
        if (string3 != null) {
            parameters.set("taking-picture-zoom", n2);
        }
    }

    private void setSharpness(Camera.Parameters parameters) {
        int n2;
        block4: {
            int n3;
            block3: {
                n3 = 30;
                String string2 = parameters.get("sharpness-max");
                if (string2 != null) {
                    try {
                        n2 = Integer.parseInt(string2);
                        if (n3 <= n2) break block3;
                        break block4;
                    }
                    catch (NumberFormatException numberFormatException) {
                        Log.w((String)TAG, (String)("Bad sharpness-max: " + string2));
                    }
                }
            }
            n2 = n3;
        }
        parameters.set("sharpness", n2);
    }

    void initFromCameraParameters(Camera camera) {
        if (this.parameters == null) {
            this.parameters = camera.getParameters();
        }
        CameraConfigurationManager cameraConfigurationManager = this;
        cameraConfigurationManager.previewFormat = cameraConfigurationManager.parameters.getPreviewFormat();
        cameraConfigurationManager.previewFormatString = cameraConfigurationManager.parameters.get("preview-format");
        Log.d((String)TAG, (String)("Default preview format: " + this.previewFormat + '/' + this.previewFormatString));
        Rect rect = DetectorViewConfig.getInstance().gatherRect;
        int n2 = rect.width();
        int n3 = rect.height();
        this.cameraResolution = cameraConfigurationManager.context.getResources().getConfiguration().orientation == 1 ? CameraConfigurationManager.getCameraResolution(this.parameters, new Point(n3, n2)) : CameraConfigurationManager.getCameraResolution(this.parameters, new Point(n2, n3));
    }

    void setDesiredCameraParameters(Camera camera) {
        if (this.parameters == null) {
            this.parameters = camera.getParameters();
        }
        CameraConfigurationManager cameraConfigurationManager = this;
        Log.d((String)TAG, (String)("Setting preview size: " + this.cameraResolution));
        Point point = this.cameraResolution;
        int n2 = point.x;
        cameraConfigurationManager.parameters.setPreviewSize(n2, point.y);
        cameraConfigurationManager.setFlash(cameraConfigurationManager.parameters);
        cameraConfigurationManager.setZoom(cameraConfigurationManager.parameters);
        try {
            camera.setParameters(cameraConfigurationManager.parameters);
        }
        catch (Exception exception) {}
    }

    Point getCameraResolution() {
        return this.cameraResolution;
    }

    int getPreviewFormat() {
        return this.previewFormat;
    }

    String getPreviewFormatString() {
        return this.previewFormatString;
    }
}

