/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.audio.aac;

import android.media.MediaCodec;
import android.media.MediaFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class AacEncode {
    private static AacEncode mInstance;
    private MediaCodec mediaCodec;
    ByteBuffer[] inputBuffers = null;
    ByteBuffer[] outputBuffers = null;
    MediaCodec.BufferInfo bufferInfo;
    long presentationTimeUs = 0L;
    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private int mSampleRate;
    private int mChannelCount;
    private HashMap<Integer, Integer> freqidxs = new HashMap();

    public AacEncode(int n2, int n3) {
        MediaFormat mediaFormat;
        try {
            ((AacEncode)object).mediaCodec = MediaCodec.createEncoderByType((String)"audio/mp4a-latm");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        AacEncode aacEncode = object;
        ((AacEncode)object).mSampleRate = n2;
        aacEncode.mChannelCount = n3;
        aacEncode.initFreqidxs();
        int[] nArray = new int[3];
        Object object = nArray;
        nArray[0] = 64000;
        nArray[1] = 96000;
        nArray[2] = 128000;
        MediaFormat mediaFormat2 = mediaFormat = MediaFormat.createAudioFormat((String)"audio/mp4a-latm", (int)n2, (int)n3);
        mediaFormat2.setString("mime", "audio/mp4a-latm");
        mediaFormat2.setInteger("aac-profile", 2);
        mediaFormat.setInteger("bitrate", (int)object[1]);
        mediaFormat.setInteger("max-input-size", 0x100000);
        aacEncode.mediaCodec.configure(mediaFormat, null, null, 1);
        aacEncode.mediaCodec.start();
        aacEncode.inputBuffers = aacEncode.mediaCodec.getInputBuffers();
        aacEncode.outputBuffers = aacEncode.mediaCodec.getOutputBuffers();
        aacEncode.bufferInfo = new MediaCodec.BufferInfo();
    }

    private void addADTStoPacket(byte[] byArray, int n2) {
        AacEncode aacEncode = this;
        int n3 = aacEncode.freqidxs.get(this.mSampleRate);
        int n4 = aacEncode.mChannelCount;
        byArray[0] = -1;
        byArray[1] = -7;
        byArray[2] = (byte)(64 + (n3 << 2) + (n4 >> 2));
        byArray[3] = (byte)(((n4 & 3) << 6) + (n2 >> 11));
        byArray[4] = (byte)((n2 & 0x7FF) >> 3);
        byArray[5] = (byte)(((n2 & 7) << 5) + 31);
        byArray[6] = -4;
    }

    private long computePresentationTime(long l2) {
        return l2 * 90000L * 1024L / (long)this.mSampleRate;
    }

    public static AacEncode getAacEncode(int n2, int n3) {
        if (mInstance == null) {
            mInstance = new AacEncode(n2, n3);
        }
        return mInstance;
    }

    public static AacEncode getAacEncode() {
        return mInstance;
    }

    public void initFreqidxs() {
        AacEncode aacEncode = this;
        aacEncode.freqidxs.put(96000, 0);
        aacEncode.freqidxs.put(88200, 1);
        aacEncode.freqidxs.put(64000, 2);
        aacEncode.freqidxs.put(48000, 3);
        aacEncode.freqidxs.put(44100, 4);
        aacEncode.freqidxs.put(32000, 5);
        aacEncode.freqidxs.put(24000, 6);
        aacEncode.freqidxs.put(22050, 7);
        aacEncode.freqidxs.put(16000, 8);
        aacEncode.freqidxs.put(12000, 9);
        aacEncode.freqidxs.put(11025, 10);
        aacEncode.freqidxs.put(8000, 11);
        aacEncode.freqidxs.put(7350, 12);
    }

    public void close() {
        try {
            AacEncode aacEncode = this;
            aacEncode.mediaCodec.stop();
            aacEncode.mediaCodec.release();
            aacEncode.outputStream.flush();
            aacEncode.outputStream.close();
            mInstance = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public byte[] offerEncoder(byte[] byArray) throws Exception {
        int n2 = this.mediaCodec.dequeueInputBuffer(-1L);
        if (n2 >= 0) {
            AacEncode aacEncode = this;
            ByteBuffer byteBuffer = aacEncode.inputBuffers[n2];
            byteBuffer.clear();
            byteBuffer.put(byArray);
            byteBuffer.limit(byArray.length);
            long l2 = aacEncode.computePresentationTime(aacEncode.presentationTimeUs);
            aacEncode.mediaCodec.queueInputBuffer(n2, 0, byArray.length, l2, 0);
            ++aacEncode.presentationTimeUs;
        }
        int n3 = this.mediaCodec.dequeueOutputBuffer(this.bufferInfo, 0L);
        while (n3 >= 0) {
            AacEncode aacEncode = this;
            Object object = aacEncode.bufferInfo;
            int n4 = object.size;
            int n5 = n4 + 7;
            ByteBuffer byteBuffer = aacEncode.outputBuffers[n3];
            byteBuffer.position(object.offset);
            byteBuffer.limit(this.bufferInfo.offset + n4);
            byte[] byArray2 = new byte[n5];
            object = byArray2;
            this.addADTStoPacket(byArray2, n5);
            byteBuffer.get((byte[])object, 7, n4);
            byteBuffer.position(this.bufferInfo.offset);
            aacEncode.outputStream.write((byte[])object);
            aacEncode.mediaCodec.releaseOutputBuffer(n3, false);
            n3 = aacEncode.mediaCodec.dequeueOutputBuffer(this.bufferInfo, 0L);
        }
        byte[] byArray3 = this.outputStream.toByteArray();
        AacEncode aacEncode = this;
        aacEncode.outputStream.flush();
        aacEncode.outputStream.reset();
        return byArray3;
    }
}

