/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.audio;

import android.os.Build;
import io.dcloud.base.R;
import io.dcloud.common.adapter.util.PermissionUtil;
import io.dcloud.common.util.ErrorDialogUtil;
import io.dcloud.common.util.JSUtil;
import io.dcloud.common.util.StringUtil;
import io.dcloud.feature.audio.AbsAudio;
import io.dcloud.feature.audio.recorder.AbsRecorder;
import io.dcloud.feature.audio.recorder.AudioRecorder;
import io.dcloud.feature.audio.recorder.HighGradeRecorder;
import io.dcloud.feature.audio.recorder.RecordOption;
import io.dcloud.feature.audio.recorder.RecorderUtil;

public class AudioRecorderMgr
extends AbsAudio {
    private static AudioRecorderMgr mInstance;
    String mFunId;
    AbsRecorder mNativeRecorder;
    RecordOption mOption;

    private AudioRecorderMgr() {
    }

    static AudioRecorderMgr startRecorder(RecordOption object, String string2) {
        PermissionUtil.StreamPermissionRequest streamPermissionRequest;
        if (mInstance == null) {
            mInstance = new AudioRecorderMgr();
        }
        AudioRecorderMgr audioRecorderMgr = mInstance;
        audioRecorderMgr.mOption = object;
        audioRecorderMgr.mFunId = string2;
        object = streamPermissionRequest;
        streamPermissionRequest = new PermissionUtil.StreamPermissionRequest(AudioRecorderMgr.mInstance.mOption.mWebview.obtainApp()){

            @Override
            public void onGranted(String string2) {
                Object object;
                if (mInstance == null) {
                    return;
                }
                if (AudioRecorderMgr.isPause(mInstance.mOption.mFormat)) {
                    mInstance.mNativeRecorder = new HighGradeRecorder().setRecordOption(mInstance.mOption);
                    if (mInstance.mOption.mFormat.equalsIgnoreCase("aac") && Build.VERSION.SDK_INT < 16) {
                        mInstance.failCallback(mInstance.mOption.mWebview.getContext().getString(R.string.dcloud_audio_not_aac_recording));
                        return;
                    }
                    if (mInstance.mOption.mFormat.equalsIgnoreCase("mp3") && !RecorderUtil.isContainMp3()) {
                        mInstance.failCallback(mInstance.mOption.mWebview.getContext().getString(R.string.dcloud_audio_not_mp3_recording));
                        object = ErrorDialogUtil.getLossDialog(mInstance.mOption.mWebview, mInstance.mOption.mWebview.getContext().getString(R.string.dcloud_audio_no_mp3_module_added) + " https://ask.dcloud.net.cn/article/35058", "https://ask.dcloud.net.cn/article/35058", "audio");
                        if (object != null) {
                            object.show();
                        }
                        return;
                    }
                    try {
                        mInstance.mNativeRecorder.start();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        mInstance.failCallback(exception.getMessage());
                        mInstance.stop();
                    }
                } else {
                    mInstance.mNativeRecorder = new AudioRecorder(mInstance.mOption);
                    try {
                        mInstance.mNativeRecorder.start();
                    }
                    catch (Exception exception) {
                        object = exception;
                        exception.printStackTrace();
                        mInstance.failCallback(((Throwable)object).getMessage());
                        mInstance.stop();
                    }
                }
            }

            @Override
            public void onDenied(String string2) {
                if (mInstance != null) {
                    mInstance.failCallback("No Permission");
                }
            }
        };
        PermissionUtil.usePermission(((RecordOption)object).mWebview.getActivity(), "audio", "RECORD", 2, (PermissionUtil.Request)object);
        return mInstance;
    }

    private void failCallback(String string2) {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = 3;
        objectArray[1] = string2;
        string2 = StringUtil.format("{code:%d,message:'%s'}", objectArray2);
        JSUtil.excCallbackError(this.mOption.mWebview, this.mFunId, string2, true);
    }

    public static boolean isPause(String string2) {
        return string2.equalsIgnoreCase("mp3") || string2.equalsIgnoreCase("aac");
    }

    void successCallback() {
        AudioRecorderMgr audioRecorderMgr = this;
        RecordOption recordOption = audioRecorderMgr.mOption;
        String string2 = recordOption.mFileName;
        string2 = recordOption.mWebview.obtainFrameView().obtainApp().convert2RelPath(string2);
        JSUtil.excCallbackSuccess(audioRecorderMgr.mOption.mWebview, this.mFunId, string2);
    }

    public void pause() {
        Object object = mInstance;
        if (object != null && (object = ((AudioRecorderMgr)object).mOption) != null && AudioRecorderMgr.isPause(((RecordOption)object).mFormat)) {
            AudioRecorderMgr.mInstance.mNativeRecorder.pause();
        }
    }

    public void resume() {
        Object object = mInstance;
        if (object != null && (object = ((AudioRecorderMgr)object).mOption) != null && AudioRecorderMgr.isPause(((RecordOption)object).mFormat)) {
            AudioRecorderMgr.mInstance.mNativeRecorder.resume();
        }
    }

    public void stop() {
        Object object = mInstance;
        if (object != null && (object = ((AudioRecorderMgr)object).mNativeRecorder) != null) {
            ((AbsRecorder)object).stop();
            AudioRecorderMgr.mInstance.mNativeRecorder.release();
            AudioRecorderMgr.mInstance.mNativeRecorder = null;
        }
        mInstance = null;
    }
}

