/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.audio;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.PlaybackParams;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import io.dcloud.application.DCLoudApplicationImpl;
import io.dcloud.base.R;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.IEventCallback;
import io.dcloud.common.DHInterface.ISysEventListener;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.constant.DOMException;
import io.dcloud.common.util.FileUtil;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.JSUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.feature.audio.AbsAudio;
import java.io.File;
import java.io.FileDescriptor;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class AudioPlayer
extends AbsAudio
implements ISysEventListener,
IEventCallback {
    private IWebview mWebview;
    private IApp _app;
    String mFunId;
    private MediaPlayer mMediaPlayer;
    private Map<String, String> events;
    private JSONObject params;
    private int bufferPercent;
    private int startTime;
    private String mSrcPath;
    private float volume;
    private boolean autoplay;
    private boolean isCanMix;
    private boolean needPause;
    private AudioManager mAudioMgr;
    private AudioManager.OnAudioFocusChangeListener mAudioFocusChangeListener;
    private boolean isPrepared;
    private boolean isPlay;
    private boolean isCanplay;
    private boolean isStoped;

    private AudioPlayer(JSONObject jSONObject, IWebview iWebview) {
        AudioPlayer audioPlayer = this;
        this.bufferPercent = 0;
        this.startTime = Integer.MIN_VALUE;
        this.mSrcPath = "";
        this.volume = 1.0f;
        this.autoplay = false;
        this.isCanMix = false;
        this.needPause = false;
        this.mAudioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

            public void onAudioFocusChange(int n2) {
                if (!(n2 != -1 && n2 != -2 && n2 != -3 || AudioPlayer.this.needPause)) {
                    AudioPlayer.this.pause();
                }
            }
        };
        this.isPrepared = false;
        this.isPlay = false;
        this.isCanplay = false;
        this.isStoped = false;
        this.mMediaPlayer = new MediaPlayer();
        this.events = new HashMap<String, String>();
        this.params = jSONObject;
        this.mWebview = iWebview;
        this.addListener();
        this._app = iWebview.obtainFrameView().obtainApp();
        iWebview.obtainFrameView().addFrameViewListener(this);
        audioPlayer._app.registerSysEventListener(this, ISysEventListener.SysEventType.onStop);
        audioPlayer.setStyle(audioPlayer.params);
    }

    private void requestAudioFocus() {
        AudioManager audioManager;
        if (this.mAudioMgr == null) {
            this.mAudioMgr = (AudioManager)this.mWebview.getActivity().getSystemService("audio");
        }
        if ((audioManager = this.mAudioMgr) != null) {
            audioManager.requestAudioFocus(this.mAudioFocusChangeListener, 3, 1);
        }
    }

    private void addListener() {
        AudioPlayer audioPlayer = this;
        audioPlayer.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mediaPlayer) {
                AudioPlayer.this.execEvents("canplay", "");
            }
        });
        audioPlayer.mMediaPlayer.setOnSeekCompleteListener(new MediaPlayer.OnSeekCompleteListener(){

            public void onSeekComplete(MediaPlayer mediaPlayer) {
                AudioPlayer.this.execEvents("seeked", "");
            }
        });
        audioPlayer.mMediaPlayer.setOnBufferingUpdateListener(new MediaPlayer.OnBufferingUpdateListener(){

            public void onBufferingUpdate(MediaPlayer mediaPlayer, int n2) {
                AudioPlayer.access$102(AudioPlayer.this, n2);
            }
        });
        audioPlayer.mMediaPlayer.setOnInfoListener(new MediaPlayer.OnInfoListener(){

            public boolean onInfo(MediaPlayer mediaPlayer, int n2, int n3) {
                if (n2 != 701) {
                    if (n2 == 702 && mediaPlayer.isPlaying()) {
                        AudioPlayer.this.execEvents("play", "");
                    }
                } else {
                    AudioPlayer.this.execEvents("waiting", "");
                }
                return false;
            }
        });
        audioPlayer.mMediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mediaPlayer, int n2, int n3) {
                int n4 = 0;
                String string2 = null;
                if (n2 != 1) {
                    if (n2 == 100) {
                        n4 = 1303;
                        string2 = AudioPlayer.this.mWebview.getContext().getString(R.string.dcloud_audio_abnormal_rebuild);
                    }
                } else {
                    n4 = -99;
                    string2 = DOMException.MSG_UNKNOWN_ERROR;
                }
                if (n3 != -1010) {
                    if (n3 != -1007) {
                        if (n3 != -1004) {
                            if (n3 == -110) {
                                n4 = -1302;
                                string2 = DOMException.MSG_AUDIO_ERROR_TIMED_OUT;
                            }
                        } else {
                            n4 = -5;
                            string2 = "IO Error";
                        }
                    } else {
                        n4 = -1301;
                        string2 = DOMException.MSG_AUDIO_ERROR_MALFORMED;
                    }
                } else {
                    n4 = -3;
                    string2 = DOMException.MSG_NOT_SUPPORT;
                }
                if (n4 != 0) {
                    6 v0 = this;
                    v0.AudioPlayer.this.failCallback(n4, string2);
                    v0.AudioPlayer.this.execEvents("error", DOMException.toJSON(n4, string2));
                }
                return true;
            }
        });
        audioPlayer.mMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mediaPlayer) {
                AudioPlayer.this.execEvents("ended", "");
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private void setSrc(String var1_1) {
        block28: {
            block27: {
                block26: {
                    block25: {
                        if (!var1_1.startsWith("content://")) break block25;
                        v0 = this;
                        var1_1 = Uri.parse((String)var1_1);
                        v0.mMediaPlayer.setDataSource((Context)this.mWebview.getActivity(), (Uri)var1_1);
                        ** GOTO lbl78
                    }
                    var2_3 = false;
                    if (PdrUtil.isNetPath((String)var1_1)) ** GOTO lbl71
                    v1 = this;
                    v2 = v1;
                    var1_1 = v1._app.checkPrivateDirAndCopy2Temp((String)var1_1);
                    var1_1 = v2._app.convert2AbsFullPath(this.mWebview.obtainFullUrl(), (String)var1_1);
                    var3_5 = DCLoudApplicationImpl.self().getContext();
                    if (!FileUtil.needMediaStoreOpenFile(var3_5)) break block26;
                    if (FileUtil.checkPrivatePath(var3_5, (String)var1_1)) break block26;
                    var4_6 = v3;
                    if (!new File((String)var1_1).exists()) break block26;
                    var3_5 = FileUtil.getFileUri(var3_5, var4_6, MediaStore.Audio.Media.EXTERNAL_CONTENT_URI);
                    if (var3_5 == null) break block26;
                    this.mMediaPlayer.setDataSource((Context)this.mWebview.getActivity(), (Uri)var3_5);
                    var2_3 = true;
                }
                if (var2_3) break block28;
                if (!var1_1.startsWith("/android_asset/")) break block27;
                v4 = var1_1.replace("/android_asset/", "");
lbl40:
                // 2 sources

                while (true) {
                    var1_1 = v4;
                    ** GOTO lbl49
                    break;
                }
            }
            if (!var1_1.startsWith("android_asset/")) ** GOTO lbl49
            v4 = var1_1.replace("android_asset/", "");
            ** continue;
lbl49:
            // 2 sources

            if (PdrUtil.isDeviceRootDir((String)var1_1)) break block28;
            v5 = this;
            v6 = v5;
            v7 = v5;
            v8 = v5;
            var1_1 = v5.mWebview.getActivity().getAssets().openFd((String)var1_1);
            v9 = v6.mMediaPlayer;
            v10 = var1_1;
            v11 = v10;
            v12 = v10;
            var1_1 = v10.getFileDescriptor();
            var2_4 = v12.getStartOffset();
            var4_7 = v11.getLength();
            v9.setDataSource((FileDescriptor)var1_1, var2_4, var4_7);
            v7.isCanplay = false;
            v8.mMediaPlayer.prepareAsync();
            return;
lbl71:
            // 1 sources

            var1_1 = URLDecoder.decode((String)var1_1, "utf-8");
        }
        if (var2_3) ** GOTO lbl78
        try {
            v13 = this;
            v13.mMediaPlayer.reset();
            v13.mMediaPlayer.setDataSource((String)var1_1);
lbl78:
            // 3 sources

            this.isCanplay = false;
            this.mMediaPlayer.prepareAsync();
        }
        catch (Exception var1_2) {
            this.stop();
            this.failCallback(-5, var1_2.getMessage());
            this.execEvents("error", DOMException.toJSON(-5, var1_2.getMessage()));
        }
    }

    static AudioPlayer createAudioPlayer(JSONObject jSONObject, IWebview iWebview) {
        return new AudioPlayer(jSONObject, iWebview);
    }

    private void successCallback() {
        JSUtil.excCallbackSuccess(this.mWebview, this.mFunId, "");
    }

    private void startPlay() {
        AudioPlayer audioPlayer = this;
        audioPlayer.requestAudioFocus();
        audioPlayer.isPrepared = true;
        audioPlayer.mMediaPlayer.start();
        audioPlayer.setSpeed();
        audioPlayer.execEvents("play", "");
        audioPlayer.isPlay = false;
    }

    private void setSpeed() {
        block8: {
            float f2;
            float f3;
            JSONObject jSONObject = audioPlayer2.params;
            if (jSONObject == null) {
                return;
            }
            try {
                f3 = Float.parseFloat(jSONObject.optString("playbackRate"));
            }
            catch (Exception exception) {}
            if (!(f2 > 0.0f)) break block8;
            MediaPlayer mediaPlayer = audioPlayer2.mMediaPlayer;
            if (mediaPlayer == null) break block8;
            if (Build.VERSION.SDK_INT < 23) break block8;
            AudioPlayer audioPlayer = audioPlayer2;
            AudioPlayer audioPlayer2 = mediaPlayer.getPlaybackParams();
            audioPlayer2.setSpeed(f3);
            audioPlayer.mMediaPlayer.setPlaybackParams((PlaybackParams)audioPlayer2);
        }
    }

    static /* synthetic */ int access$102(AudioPlayer audioPlayer, int n2) {
        audioPlayer.bufferPercent = n2;
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    void setStyle(JSONObject var1_1) {
        block15: {
            block14: {
                var2_4 = var1_1.optString("src");
                if (!PdrUtil.isEmpty(var2_4)) {
                    if (PdrUtil.isEmpty(this.mSrcPath)) {
                        this.mMediaPlayer.reset();
                        this.setSrc(var2_4);
                    } else if (!var2_4.equals(this.mSrcPath)) {
                        this.mMediaPlayer.reset();
                        this.setSrc(var2_4);
                    }
                }
                v0 = this;
                JSONUtil.combinJSONObject(this.params, var1_1);
                v0.mSrcPath = var1_1.optString("src");
                v0.mMediaPlayer.setLooping(this.params.optBoolean("loop"));
                try {
                    var1_2 = Float.parseFloat(v0.params.optString("volume", "1"));
                }
                catch (Exception v1) {}
                this.volume = var1_2;
                if (!(v2 < 0.0f)) break block14;
                this.volume = 0.0f;
                ** GOTO lbl28
            }
            if (!(var1_2 > 1.0f)) ** GOTO lbl28
            this.volume = 1.0f;
lbl28:
            // 3 sources

            v3 = this;
            v4 = this.volume;
            v3.mMediaPlayer.setVolume(v4, v4);
            if (!v3.params.has("startTime")) ** GOTO lbl38
            v5 = this;
            v6 = v5;
            v7 = v5.params.optInt("startTime");
            v6.startTime = v7 * 1000;
lbl38:
            // 2 sources

            this.autoplay = this.params.optBoolean("autoplay", false);
            try {
                var1_3 = Float.parseFloat(this.params.optString("playbackRate"));
            }
            catch (Exception v8) {}
            if (!(v9 > 0.0f)) break block15;
            this.playbackRate(var1_3);
        }
    }

    String getStyles(String string2) {
        if (PdrUtil.isEmpty(string2)) {
            return JSUtil.wrapJsVar(((AudioPlayer)object).params);
        }
        String string3 = string2;
        string3.hashCode();
        int n2 = -1;
        switch (string3.hashCode()) {
            default: {
                break;
            }
            case 1439562083: {
                if (!string2.equals("autoplay")) break;
                n2 = 5;
                break;
            }
            case 1355420059: {
                if (!string2.equals("playbackRate")) break;
                n2 = 4;
                break;
            }
            case 3327652: {
                if (!string2.equals("loop")) break;
                n2 = 3;
                break;
            }
            case 114148: {
                if (!string2.equals("src")) break;
                n2 = 2;
                break;
            }
            case -810883302: {
                if (!string2.equals("volume")) break;
                n2 = 1;
                break;
            }
            case -2129294769: {
                if (!string2.equals("startTime")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                if (((AudioPlayer)object).params.has(string2)) {
                    return JSUtil.wrapJsVar(((AudioPlayer)object).params.optString(string2));
                }
                return JSUtil.wrapJsVar("undefined", false);
            }
            case 5: {
                Object object = ((AudioPlayer)object).params.optBoolean("autoplay", false);
                break;
            }
            case 4: {
                Object object;
                if (Build.VERSION.SDK_INT >= 23) {
                    object = Float.valueOf(((AudioPlayer)object).mMediaPlayer.getPlaybackParams().getSpeed());
                    break;
                }
                object = 1;
                break;
            }
            case 3: {
                Object object = ((AudioPlayer)object).mMediaPlayer.isLooping();
                break;
            }
            case 2: {
                Object object = ((AudioPlayer)object).mSrcPath;
                break;
            }
            case 1: {
                Object object = Float.valueOf(((AudioPlayer)object).volume);
                break;
            }
            case 0: {
                int n3 = ((AudioPlayer)object).startTime;
                Object object = n3 < 0 ? (((AudioPlayer)object).params.has("startTime") ? ((AudioPlayer)object).params.optInt("startTime") : 0) : n3 / 1000;
            }
        }
        if (object != null) {
            return JSUtil.wrapJsVar(object.toString());
        }
        return JSUtil.wrapJsVar("undefined", false);
    }

    public void setParams(JSONObject jSONObject) {
        this.params = jSONObject;
    }

    void failCallback(int n2, String string2) {
        String string3 = DOMException.toJSON(n2, string2);
        JSUtil.excCallbackError(this.mWebview, this.mFunId, string3, true);
    }

    void play() {
        block7: {
            if (this.isStoped && !this.mMediaPlayer.isPlaying()) {
                try {
                    this.mMediaPlayer.prepareAsync();
                    this.isStoped = false;
                }
                catch (Exception exception) {
                    AudioPlayer audioPlayer = this;
                    audioPlayer.mSrcPath = "";
                    audioPlayer.setStyle(audioPlayer.params);
                    audioPlayer.isStoped = false;
                }
            }
            this.isPrepared = false;
            this.isPlay = true;
            if (!this.isCanplay) break block7;
            try {
                this.startPlay();
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IllegalStateException illegalStateException) {
                illegalStateException.printStackTrace();
                this.destory();
                this.failCallback(-1, illegalStateException.toString());
                this.execEvents("error", DOMException.toJSON(-1, illegalStateException.getMessage()));
            }
        }
    }

    void pause() {
        this.autoplay = false;
        try {
            this.mMediaPlayer.pause();
        }
        catch (Exception exception) {}
        this.execEvents("pause", "");
    }

    void resume() {
        AudioPlayer audioPlayer = this;
        audioPlayer.requestAudioFocus();
        audioPlayer.mMediaPlayer.start();
        audioPlayer.setSpeed();
    }

    void stop() {
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        if (mediaPlayer != null) {
            mediaPlayer.stop();
            this.isStoped = true;
            this.isCanplay = false;
            this.execEvents("stop", "");
        }
    }

    void destory() {
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        if (mediaPlayer != null) {
            AudioPlayer audioPlayer = this;
            mediaPlayer.stop();
            audioPlayer.mMediaPlayer.release();
            audioPlayer.mWebview.obtainFrameView().removeFrameViewListener(this);
            audioPlayer.mWebview.obtainFrameView().obtainApp().unregisterSysEventListener(this, ISysEventListener.SysEventType.onStop);
            audioPlayer.mMediaPlayer = null;
            mediaPlayer = audioPlayer.mAudioMgr;
            if (mediaPlayer != null) {
                mediaPlayer.abandonAudioFocus(this.mAudioFocusChangeListener);
            }
            this.mAudioMgr = null;
        }
    }

    void seekTo(int n2) {
        AudioPlayer audioPlayer = this;
        audioPlayer.mMediaPlayer.seekTo(n2);
        audioPlayer.execEvents("seeking", "");
    }

    String getBuffer() {
        int n2 = -1;
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        if (mediaPlayer != null) {
            n2 = this.bufferPercent * mediaPlayer.getDuration() / 100;
        }
        return JSUtil.wrapJsVar(PdrUtil.int2DecimalStr(n2, 1000), false);
    }

    String isPause() {
        boolean bl = true;
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        if (mediaPlayer != null) {
            bl = mediaPlayer.isPlaying() ^ true;
        }
        return JSUtil.wrapJsVar(bl);
    }

    String getVolume() {
        return JSUtil.wrapJsVar(this.volume);
    }

    String getDuration() {
        AudioPlayer audioPlayer = audioPlayer.mMediaPlayer;
        if (audioPlayer != null) {
            int n2 = audioPlayer.getDuration();
            if (n2 < 0) {
                return JSUtil.wrapJsVar("undefined", false);
            }
            return JSUtil.wrapJsVar(PdrUtil.int2DecimalStr(n2, 1000), false);
        }
        return JSUtil.wrapJsVar("undefined", false);
    }

    String getPosition() {
        return JSUtil.wrapJsVar(PdrUtil.int2DecimalStr(this.mMediaPlayer.getCurrentPosition(), 1000), false);
    }

    public boolean isCanMix() {
        return this.isCanMix;
    }

    public void setCanMix(boolean bl) {
        this.needPause = bl;
    }

    void setSessionCategory(String string2) {
        MediaPlayer mediaPlayer;
        if (!PdrUtil.isEmpty(string2) && (mediaPlayer = this.mMediaPlayer) != null && !mediaPlayer.isPlaying()) {
            this.isCanMix = string2.equals("ambient");
        }
    }

    void addEventListener(String string2, String string3) {
        this.events.put(string2, string3);
    }

    void removeEventListener(String string2) {
        this.events.remove(string2);
    }

    void execEvents(String string2, String string3) {
        String string4 = this.events.get(string2);
        if (!PdrUtil.isEmpty(string4)) {
            int n2 = JSUtil.OK;
            boolean bl = PdrUtil.isEmpty(string3) ^ true;
            JSUtil.execCallback(this.mWebview, string4, string3, n2, bl, true);
        }
        String string5 = string2;
        string5.hashCode();
        if (!string5.equals("ended")) {
            if (string2.equals("canplay")) {
                int n3;
                this.isCanplay = true;
                if (this.autoplay) {
                    this.play();
                }
                if (this.isPlay) {
                    this.startPlay();
                }
                if ((n3 = this.startTime) != Integer.MIN_VALUE) {
                    this.mMediaPlayer.seekTo(n3);
                }
            }
        } else {
            AudioPlayer audioPlayer = this;
            audioPlayer.pause();
            audioPlayer.successCallback();
        }
    }

    @Override
    public Object onCallBack(String string2, Object object) {
        if ((PdrUtil.isEquals(string2, "window_close") || PdrUtil.isEquals(string2, "close")) && object instanceof IWebview) {
            this.destory();
        }
        return null;
    }

    @Override
    public boolean onExecute(ISysEventListener.SysEventType sysEventType, Object object) {
        if (sysEventType == ISysEventListener.SysEventType.onStop) {
            this.destory();
        }
        return false;
    }

    public void playbackRate(float f2) {
        JSONObject jSONObject;
        if (this.params == null) {
            JSONObject jSONObject2;
            JSONObject jSONObject3 = jSONObject2;
            jSONObject2 = new JSONObject();
            this.params = jSONObject3;
        }
        try {
            jSONObject = this.params;
        }
        catch (JSONException jSONException) {}
        double d2 = f2;
        jSONObject.put("playbackRate", d2);
        MediaPlayer mediaPlayer = this.mMediaPlayer;
        if (mediaPlayer != null && mediaPlayer.isPlaying()) {
            this.setSpeed();
        }
    }
}

