/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.util.net;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.dcloud.common.DHInterface.AbsMgr;
import io.dcloud.common.DHInterface.ICore;
import io.dcloud.common.DHInterface.IMgr;
import io.dcloud.common.DHInterface.ISysEventListener;
import io.dcloud.common.adapter.io.DHFile;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.PlatformUtil;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.net.DownloadMgr;
import io.dcloud.common.util.net.NetCheckReceiver;
import io.dcloud.common.util.net.UploadMgr;
import io.dcloud.common.util.net.http.IServer;
import io.dcloud.feature.internal.sdk.SDK;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

public class NetMgr
extends AbsMgr
implements IMgr.NetEvent {
    DownloadMgr mDownloadMgr;
    UploadMgr mUploadMgr;
    NetCheckReceiver mNetCheckReceiver;
    IServer mLocalServer;

    public NetMgr(ICore iCore) {
        IntentFilter intentFilter;
        NetMgr netMgr = this;
        super(iCore, "netmgr", IMgr.MgrType.NetMgr);
        netMgr.mNetCheckReceiver = null;
        netMgr.mLocalServer = null;
        netMgr.startMiniServer();
        netMgr.mUploadMgr = UploadMgr.getUploadMgr();
        netMgr.mDownloadMgr = DownloadMgr.getDownloadMgr();
        netMgr.mNetCheckReceiver = new NetCheckReceiver(this);
        iCore = intentFilter;
        new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE").addAction("android.intent.action.SIM_STATE_CHANGED");
        netMgr.getContext().registerReceiver((BroadcastReceiver)this.mNetCheckReceiver, (IntentFilter)iCore);
    }

    private IServer initLocalServer() {
        Object object;
        Object object2;
        ArrayList<IServer> arrayList;
        final ArrayList<IServer> arrayList2 = arrayList;
        arrayList = new ArrayList<IServer>();
        if (BaseInfo.SyncDebug) {
            Activity activity = new Class[2];
            object2 = activity;
            activity[0] = AbsMgr.class;
            activity[1] = Integer.TYPE;
            Object[] objectArray = new Object[2];
            object = objectArray;
            objectArray[0] = this;
            objectArray[1] = 13131;
            if ((object2 = PlatformUtil.newInstance("io.dcloud.common.util.net.http.LocalServer", (Class[])object2, object)) != null && object2 instanceof IServer) {
                arrayList2.add((IServer)object2);
            }
        }
        if (Build.VERSION.SDK_INT >= 21 && BaseInfo.SyncDebug) {
            Class[] classArray;
            object2 = (Activity)this.mCore.obtainActivityContext();
            Intent intent = object2.getIntent();
            object = intent.getStringExtra("ip");
            String string2 = intent.getStringExtra("port");
            if (PdrUtil.isEmpty(object) || PdrUtil.isEmpty(string2)) {
                byte[] byArray = DHFile.readAll(object2.getExternalCacheDir().getPath() + File.separator + "debug_info");
                classArray = (Class[])byArray;
                if (byArray != null) {
                    JSONObject jSONObject = JSON.parseObject((String)new String((byte[])classArray));
                    object = (String)jSONObject.get((Object)"ip");
                    string2 = (String)jSONObject.get((Object)"port");
                }
            }
            if (!PdrUtil.isEmpty(object) && !PdrUtil.isEmpty(string2)) {
                Class[] classArray2 = new Class[4];
                classArray = classArray2;
                classArray2[0] = AbsMgr.class;
                classArray2[1] = Activity.class;
                classArray2[2] = String.class;
                classArray2[3] = String.class;
                Object[] objectArray = new Object[4];
                Object[] objectArray2 = objectArray;
                objectArray[0] = this;
                objectArray[1] = object2;
                objectArray[2] = object;
                objectArray[3] = string2;
                object2 = PlatformUtil.newInstance("io.dcloud.common.util.net.http.LocalServer2", classArray, objectArray2);
                if (object2 != null && object2 instanceof IServer) {
                    arrayList2.add((IServer)object2);
                }
            }
        }
        return new IServer(){

            @Override
            public void start() {
                Iterator iterator = iterator.arrayList2.iterator();
                while (iterator.hasNext()) {
                    ((IServer)iterator.next()).start();
                }
            }

            @Override
            public void stop() {
                Iterator iterator = iterator.arrayList2.iterator();
                while (iterator.hasNext()) {
                    ((IServer)iterator.next()).stop();
                }
            }
        };
    }

    protected void startMiniServer() {
        if (BaseInfo.ISDEBUG && !SDK.isUniMPSDK()) {
            this.mLocalServer = this.initLocalServer();
            this.mLocalServer.start();
            return;
        }
    }

    @Override
    public Object processEvent(IMgr.MgrType mgrType, int n2, Object object) {
        Object object2;
        block3: {
            object2 = null;
            if (this.checkMgrId(mgrType)) break block3;
            try {
                object2 = this.mCore.dispatchEvent(mgrType, n2, object);
            }
            catch (Throwable throwable) {
                Logger.w("NetMgr.processEvent", throwable);
            }
        }
        return object2;
    }

    @Override
    public void onExecute(ISysEventListener.SysEventType object, Object object2) {
        if (object == ISysEventListener.SysEventType.onStop) {
            object = this.mLocalServer;
            if (object != null) {
                object.stop();
                this.mLocalServer = null;
            }
        } else if ((object == ISysEventListener.SysEventType.onResume || object == ISysEventListener.SysEventType.onNewIntent) && this.mLocalServer == null) {
            this.startMiniServer();
        }
    }

    @Override
    public void dispose() {
        Object object = this.mLocalServer;
        if (object != null) {
            object.stop();
        }
        if ((object = this.mUploadMgr) != null) {
            ((UploadMgr)object).dispose();
        }
        this.getContext().unregisterReceiver((BroadcastReceiver)this.mNetCheckReceiver);
    }
}

