/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import com.nostra13.dcloudimageloader.cache.disc.impl.UnlimitedDiscCache;
import com.nostra13.dcloudimageloader.cache.memory.impl.LruMemoryCache;
import com.nostra13.dcloudimageloader.core.DisplayImageOptions;
import com.nostra13.dcloudimageloader.core.ImageLoader;
import com.nostra13.dcloudimageloader.core.ImageLoaderConfiguration;
import com.nostra13.dcloudimageloader.core.ImageLoaderL;
import com.nostra13.dcloudimageloader.core.assist.ImageScaleType;
import com.nostra13.dcloudimageloader.core.assist.QueueProcessingType;
import com.nostra13.dcloudimageloader.core.decode.BaseImageDecoder;
import com.nostra13.dcloudimageloader.core.download.BaseImageDownloader;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.util.PdrUtil;
import io.src.dcloud.adapter.DCloudAdapterUtil;
import java.io.File;
import java.util.ArrayList;

public class ImageLoaderUtil {
    private static ArrayList<String> downloadUrls = new ArrayList();

    public static void initImageLoader(Context context) {
        File file;
        if (ImageLoader.getInstance().isInited()) {
            return;
        }
        File file2 = file;
        if (!new File(ImageLoaderUtil.getIconLoaclfolder()).exists()) {
            file2.mkdirs();
        }
        ImageLoader.getInstance().init(new ImageLoaderConfiguration.Builder(context).memoryCacheExtraOptions(400, 400).tasksProcessingOrder(QueueProcessingType.FIFO).denyCacheImageMultipleSizesInMemory().memoryCache(new LruMemoryCache(0x200000)).memoryCacheSize(0x200000).threadPriority(3).threadPoolSize(3).denyCacheImageMultipleSizesInMemory().defaultDisplayImageOptions(ImageLoaderUtil.getIconDisplayOptions(context)).discCache(new UnlimitedDiscCache(file2)).imageDownloader(new BaseImageDownloader(context)).imageDecoder(new BaseImageDecoder(false)).build());
    }

    public static void initImageLoaderL(Context context) {
        File file;
        if (ImageLoaderL.getInstance().isInited()) {
            return;
        }
        File file2 = file;
        if (!new File(ImageLoaderUtil.getOtherImageLoaclfolder()).exists()) {
            file2.mkdirs();
        }
        ImageLoaderL.getInstance().init(new ImageLoaderConfiguration.Builder(context).memoryCacheExtraOptions(400, 400).tasksProcessingOrder(QueueProcessingType.LIFO).denyCacheImageMultipleSizesInMemory().memoryCache(new LruMemoryCache(0x200000)).memoryCacheSize(0x200000).threadPriority(3).threadPoolSize(3).discCacheFileCount(100).denyCacheImageMultipleSizesInMemory().defaultDisplayImageOptions(ImageLoaderUtil.getIconDisplayOptions(context)).discCache(new UnlimitedDiscCache(file2)).imageDownloader(new BaseImageDownloader(context)).imageDecoder(new BaseImageDecoder(false)).build());
    }

    public static String getIconLoaclfolder() {
        return DeviceInfo.sBaseFsRootPath + "icons/";
    }

    public static String getOtherImageLoaclfolder() {
        return DeviceInfo.sBaseFsRootPath + "images/";
    }

    public static void updateIcon(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        File file = ImageLoader.getInstance().getDiscCache().get(string2);
        if (file.exists()) {
            file.delete();
        }
        ImageLoader.getInstance().loadImage(string2, null);
    }

    public static DisplayImageOptions getIconDisplayOptions(Context context) {
        return new DisplayImageOptions.Builder().cacheOnDisc(true).cacheInMemory(true).imageScaleType(ImageScaleType.IN_SAMPLE_INT).bitmapConfig(Bitmap.Config.RGB_565).showImageOnLoading((Drawable)new ColorDrawable(0)).build();
    }

    public static DisplayImageOptions getStreamIconDisplayOptions(Context context) {
        return new DisplayImageOptions.Builder().cacheOnDisc(true).cacheInMemory(true).imageScaleType(ImageScaleType.IN_SAMPLE_INT).bitmapConfig(Bitmap.Config.RGB_565).showImageOnLoading(DCloudAdapterUtil.getImageOnLoadingId(context)).build();
    }

    public static boolean isDownload(String string2) {
        return downloadUrls.contains(string2);
    }

    public static void addNetIconDownloadUrl(String string2) {
        if (PdrUtil.isNetPath(string2) && !downloadUrls.contains(string2)) {
            downloadUrls.add(string2);
        }
    }

    public static void clearCache() {
        downloadUrls.clear();
        ImageLoaderL.getInstance().clearMemoryCache();
        ImageLoader.getInstance().clearMemoryCache();
    }
}

