/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.adapter.ui;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import io.dcloud.base.R;
import io.dcloud.common.adapter.ui.AdaFrameView;
import io.dcloud.common.adapter.ui.AdaWebview;
import io.dcloud.common.adapter.ui.fresh.ILoadingLayout;
import io.dcloud.common.adapter.ui.fresh.PullToRefreshBase;
import io.dcloud.common.adapter.util.CanvasHelper;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.PlatformUtil;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.PdrUtil;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONException;
import org.json.JSONObject;

public class RefreshView
implements PullToRefreshBase.OnStateChangeListener {
    public static final String TAG = "RefreshView";
    private Rect src;
    private RectF dst;
    Bitmap mIcon = null;
    float mFontScale = 1.2f;
    int changeStateHeight = 100;
    int maxPullHeight = 100;
    float startX;
    float startY;
    AdaFrameView mFrameView;
    AdaWebview mWebview;
    private float mWebviewScale;
    JSONObject mJSONObject;
    Paint paint = new Paint();
    int index = 0;
    int MAX_FRAME_COUNT = 9;
    int HEIGHT = 25;
    Timer mUpdateProgressBar = null;
    private int contentLeft = 0;
    private int contentTop = 0;
    int icon_x;
    int icon_y;
    int fontSize;
    String mContent_down;
    String mContent_over;
    String mContent_refresh;
    String mShowContent = null;
    ILoadingLayout.State mState = ILoadingLayout.State.RESET;

    public RefreshView(AdaFrameView adaFrameView, AdaWebview adaWebview) {
        this.mFrameView = adaFrameView;
        this.mContent_down = adaFrameView.getContext().getString(R.string.dcloud_drop_down_refresh1);
        this.mContent_over = adaFrameView.getContext().getString(R.string.dcloud_drop_down_refresh2);
        this.mContent_refresh = adaFrameView.getContext().getString(R.string.dcloud_drop_down_refresh3);
        this.mWebview = adaWebview;
        this.mWebviewScale = adaWebview.getScale();
        this.paint.setAntiAlias(true);
    }

    private void stopUpdateScreenTimer() {
        Timer timer = this.mUpdateProgressBar;
        if (timer != null) {
            timer.cancel();
            this.mUpdateProgressBar = null;
        }
    }

    private void startUpdateScreenTimer() {
        RefreshView refreshView = this;
        refreshView.stopUpdateScreenTimer();
        if (refreshView.mFrameView.obtainMainView() != null) {
            TimerTask timerTask;
            Timer timer;
            Object object = timer;
            ((Timer)object)();
            this.mUpdateProgressBar = object;
            object = timerTask;
            timerTask = new TimerTask(){

                @Override
                public void run() {
                    if (RefreshView.this.mFrameView.obtainMainView() == null) {
                        this.cancel();
                    }
                    1 v0 = this;
                    v0.RefreshView.this.updateScreen();
                    View view = v0.RefreshView.this.mFrameView.obtainMainView();
                    1 v2 = this;
                    int n2 = 0;
                    int n3 = v2.RefreshView.this.mFrameView.obtainFrameOptions().width;
                    int n4 = v2.RefreshView.this.maxPullHeight;
                    try {
                        view.postInvalidate(0, n2, n3, n4);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            timer.schedule((TimerTask)object, 0L, 100L);
        }
    }

    private void updateScreen() {
        int n2;
        this.index = n2 = this.index + 1;
        if (n2 >= this.MAX_FRAME_COUNT) {
            this.index = 0;
        }
        n2 = this.HEIGHT;
        int n3 = this.index;
        int n4 = n2 * n3;
        int n5 = n2 * (n3 + 1);
        this.src.set(n4, 0, n5, n2);
    }

    private void computePosition(Paint paint) {
        int n2;
        int n3;
        RefreshView refreshView = this;
        Paint.FontMetricsInt fontMetricsInt = paint.getFontMetricsInt();
        int n4 = this.HEIGHT;
        this.icon_y = n3 = refreshView.changeStateHeight - n4 >> 1;
        refreshView.contentTop = n3 + (n4 - (fontMetricsInt.bottom - fontMetricsInt.top)) / 2;
        float f2 = paint.measureText(this.mShowContent);
        float f3 = refreshView.mFrameView.obtainApp().getInt(0);
        float f4 = f3 * 0.02f;
        int n5 = this.HEIGHT;
        refreshView.icon_x = n2 = (int)(f3 - f4 - (float)n5 - f2) / 2;
        refreshView.contentLeft = (int)((float)n2 + f4 + (float)n5);
    }

    protected void paint(Canvas object, int n2, int n3) {
        RefreshView refreshView = this;
        object.drawColor(-1907998);
        refreshView.paint.setColor(-16777216);
        refreshView.paint.setTextSize((float)this.fontSize);
        if (refreshView.mShowContent != null && this.mIcon != null) {
            Canvas canvas = object;
            RefreshView refreshView2 = this;
            Canvas canvas2 = object;
            RefreshView refreshView3 = this;
            refreshView3.computePosition(refreshView3.paint);
            object = refreshView3.mShowContent;
            int n4 = refreshView3.contentLeft + n2;
            int n5 = refreshView3.contentTop + n3;
            Paint paint = refreshView3.paint;
            CanvasHelper.drawString(canvas2, (String)object, n4, n5, 17, paint);
            int n6 = n3;
            int n7 = n3;
            int n8 = this.icon_x;
            float f2 = n2 + n8;
            n3 = this.icon_y;
            float f3 = n7 + n3;
            int n9 = this.HEIGHT;
            float f4 = n2 + n8 + n9;
            float f5 = n6 + n3 + n9;
            refreshView2.dst.set(f2, f3, f4, f5);
            Bitmap bitmap = refreshView2.mIcon;
            Rect rect = refreshView2.src;
            RectF rectF = refreshView2.dst;
            Paint paint2 = refreshView2.paint;
            canvas.drawBitmap(bitmap, rect, rectF, paint2);
        }
    }

    public void init(String string2) {
        int n2;
        BitmapFactory.Options options;
        this.fontSize = (int)(DeviceInfo.DEFAULT_FONT_SIZE * DeviceInfo.sDensity * this.mFontScale);
        this.paint.setAntiAlias(true);
        string2 = options;
        new BitmapFactory.Options().inScaled = false;
        string2 = BitmapFactory.decodeStream((InputStream)PlatformUtil.getResInputStream("res/dcloud_prograss_snow1.png"), null, (BitmapFactory.Options)string2);
        this.mIcon = string2;
        int n3 = n2 = (this.HEIGHT = string2.getHeight());
        this.src = new Rect(0, 0, n3, n3);
        int n4 = this.HEIGHT;
        float f2 = n4;
        float f3 = n4;
        this.dst = new RectF(0.0f, 150.0f, f2, f3);
        Logger.d(TAG, "height=" + this.changeStateHeight + ";range=" + this.maxPullHeight + ";contentdown=" + this.mShowContent);
        this.MAX_FRAME_COUNT = string2.getWidth() / this.HEIGHT;
    }

    void onResize() {
        RefreshView refreshView = this;
        refreshView.parseJsonOption(refreshView.mJSONObject);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseJsonOption(JSONObject jSONObject) {
        try {
            jSONObject = JSONUtil.combinJSONObject(this.mJSONObject, jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return;
        }
        {
            float f2;
            int n2;
            int n3;
            this.mJSONObject = jSONObject;
            if (!jSONObject.isNull("height")) {
                RefreshView refreshView = this;
                n3 = refreshView.mWebview.mFrameView.mViewOptions.height;
                n2 = refreshView.changeStateHeight;
                f2 = refreshView.mWebviewScale;
                this.changeStateHeight = PdrUtil.convertToScreenInt(JSONUtil.getString(jSONObject, "height"), n3, n2, f2);
            }
            if (!jSONObject.isNull("range")) {
                RefreshView refreshView = this;
                n3 = refreshView.mWebview.mFrameView.mViewOptions.height;
                n2 = refreshView.maxPullHeight;
                f2 = refreshView.mWebviewScale;
                this.maxPullHeight = PdrUtil.convertToScreenInt(jSONObject.getString("range"), n3, n2, f2);
            }
            if (!jSONObject.isNull("contentdown")) {
                this.mContent_down = JSONUtil.getString(jSONObject.getJSONObject("contentdown"), "caption");
            }
            if (!jSONObject.isNull("contentover")) {
                this.mContent_over = JSONUtil.getString(jSONObject.getJSONObject("contentover"), "caption");
            }
            if (!jSONObject.isNull("contentrefresh")) {
                this.mContent_refresh = JSONUtil.getString(jSONObject.getJSONObject("contentrefresh"), "caption");
            }
            this.init(null);
            return;
        }
    }

    public void changeStringInfo(String string2) {
        int n2;
        this.mShowContent = string2;
        int n3 = string2.length();
        float[] fArray = new float[n3];
        this.paint.getTextWidths(string2, fArray);
        for (n2 = 0; n2 < n3; ++n2) {
            float cfr_ignored_0 = fArray[n2];
        }
        RefreshView refreshView = this;
        int n4 = refreshView.mFrameView.obtainFrameOptions().width;
        n2 = refreshView.maxPullHeight;
        this.mFrameView.obtainMainView().postInvalidate(0, 0, n4, n2);
    }

    @Override
    public void onStateChanged(ILoadingLayout.State state, boolean bl) {
        ((RefreshView)object).mState = state;
        if (((RefreshView)object).mState != state) {
            if (state == ILoadingLayout.State.RESET) {
                RefreshView refreshView = object;
                Logger.d("refresh", "RefreshView RESET");
                refreshView.changeStringInfo(refreshView.mContent_down);
                refreshView.stopUpdateScreenTimer();
            } else if (state == ILoadingLayout.State.PULL_TO_REFRESH) {
                RefreshView refreshView = object;
                Logger.d("refresh", "RefreshView PULL_TO_REFRESH");
                refreshView.changeStringInfo(refreshView.mContent_down);
            } else if (state == ILoadingLayout.State.RELEASE_TO_REFRESH) {
                RefreshView refreshView = object;
                Logger.d("refresh", "RefreshView RELEASE_TO_REFRESH");
                refreshView.changeStringInfo(refreshView.mContent_over);
            } else if (state == ILoadingLayout.State.REFRESHING) {
                RefreshView refreshView = object;
                Logger.d("refresh", "RefreshView REFRESHING");
                refreshView.changeStringInfo(refreshView.mContent_refresh);
                refreshView.startUpdateScreenTimer();
                Object object = refreshView.mWebview;
                if (object != null && (object = ((AdaWebview)object).mWebViewImpl) != null) {
                    object.onRefresh(3);
                }
            }
        }
    }
}

