/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import androidx.annotation.Nullable;
import dc.squareup.okio.SegmentPool;

final class Segment {
    static final int SIZE = 8192;
    static final int SHARE_MINIMUM = 1024;
    final byte[] data;
    int pos;
    int limit;
    boolean shared;
    boolean owner;
    Segment next;
    Segment prev;

    Segment() {
        this.data = new byte[8192];
        this.owner = true;
        this.shared = false;
    }

    Segment(byte[] byArray, int n2, int n3, boolean bl, boolean bl2) {
        this.data = byArray;
        this.pos = n2;
        this.limit = n3;
        this.shared = bl;
        this.owner = bl2;
    }

    final Segment sharedCopy() {
        ((Segment)object).shared = true;
        Segment segment = object;
        Object object = segment.data;
        int n2 = segment.pos;
        int n3 = segment.limit;
        return new Segment((byte[])object, n2, n3, true, false);
    }

    final Segment unsharedCopy() {
        Segment segment = object;
        Object object = (byte[])segment.data.clone();
        int n2 = segment.pos;
        int n3 = segment.limit;
        return new Segment((byte[])object, n2, n3, false, true);
    }

    @Nullable
    public final Segment pop() {
        Segment segment = segment3.next;
        Segment segment2 = segment != segment3 ? segment : null;
        Segment segment3 = segment3.prev;
        segment3.prev.next = segment;
        v0.next.prev = segment3;
        v0.next = null;
        v0.prev = null;
        return segment2;
    }

    public final Segment push(Segment segment) {
        segment.prev = this;
        segment.next = this.next;
        this.next.prev = segment;
        this.next = segment;
        return segment;
    }

    public final Segment split(int n2) {
        if (n2 > 0 && n2 <= this.limit - this.pos) {
            Segment segment;
            if (n2 >= 1024) {
                segment = this.sharedCopy();
            } else {
                segment = SegmentPool.take();
                int n3 = this.pos;
                System.arraycopy(this.data, n3, segment.data, 0, n2);
            }
            Segment segment2 = this;
            segment.limit = segment.pos + n2;
            segment2.pos += n2;
            segment2.prev.push(segment);
            return segment;
        }
        throw new IllegalArgumentException();
    }

    public final void compact() {
        Segment segment = this.prev;
        if (segment != this) {
            if (!segment.owner) {
                return;
            }
            Segment segment2 = segment;
            int n2 = this.limit - this.pos;
            int n3 = 8192 - segment2.limit;
            int n4 = segment2.shared ? 0 : segment.pos;
            if (n2 > n3 + n4) {
                return;
            }
            Segment segment3 = this;
            segment3.writeTo(segment, n2);
            segment3.pop();
            SegmentPool.recycle(segment3);
            return;
        }
        throw new IllegalStateException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void writeTo(Segment object, int n2) {
        if (!((Segment)object).owner) throw new IllegalArgumentException();
        int n3 = ((Segment)object).limit;
        if (n3 + n2 > 8192) {
            if (((Segment)object).shared) throw new IllegalArgumentException();
            int n4 = ((Segment)object).pos;
            if (n3 + n2 - n4 > 8192) throw new IllegalArgumentException();
            Object object2 = object;
            byte[] byArray = ((Segment)object2).data;
            System.arraycopy(((Segment)object2).data, n4, byArray, 0, n3 -= n4);
            ((Segment)object2).limit -= ((Segment)object).pos;
            ((Segment)object2).pos = 0;
        }
        Object object3 = object;
        Object object4 = object;
        int n5 = this.pos;
        object = ((Segment)object4).data;
        n3 = ((Segment)object4).limit;
        System.arraycopy(this.data, n5, object, n3, n2);
        ((Segment)object3).limit += n2;
        this.pos += n2;
    }
}

