/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.ws;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.Call;
import dc.squareup.okhttp3.Callback;
import dc.squareup.okhttp3.EventListener;
import dc.squareup.okhttp3.OkHttpClient;
import dc.squareup.okhttp3.Protocol;
import dc.squareup.okhttp3.Request;
import dc.squareup.okhttp3.Response;
import dc.squareup.okhttp3.WebSocket;
import dc.squareup.okhttp3.WebSocketListener;
import dc.squareup.okhttp3.internal.Internal;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.connection.StreamAllocation;
import dc.squareup.okhttp3.internal.ws.WebSocketProtocol;
import dc.squareup.okhttp3.internal.ws.WebSocketReader;
import dc.squareup.okhttp3.internal.ws.WebSocketWriter;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.Okio;
import java.io.Closeable;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class RealWebSocket
implements WebSocket,
WebSocketReader.FrameCallback {
    private static final List<Protocol> ONLY_HTTP1;
    private static final long MAX_QUEUE_SIZE = 0x1000000L;
    private static final long CANCEL_AFTER_CLOSE_MILLIS = 60000L;
    static final /* synthetic */ boolean $assertionsDisabled;
    private final Request originalRequest;
    final WebSocketListener listener;
    private final Random random;
    private final long pingIntervalMillis;
    private final String key;
    private Call call;
    private final Runnable writerRunnable;
    private WebSocketReader reader;
    private WebSocketWriter writer;
    private ScheduledExecutorService executor;
    private Streams streams;
    private final ArrayDeque<ByteString> pongQueue = new ArrayDeque();
    private final ArrayDeque<Object> messageAndCloseQueue = new ArrayDeque();
    private long queueSize;
    private boolean enqueuedClose;
    private ScheduledFuture<?> cancelFuture;
    private int receivedCloseCode = -1;
    private String receivedCloseReason;
    private boolean failed;
    private int sentPingCount;
    private int receivedPingCount;
    private int receivedPongCount;
    private boolean awaitingPong;

    public RealWebSocket(Request object, WebSocketListener webSocketListener, Random random, long l2) {
        if ("GET".equals(((Request)object).method())) {
            RealWebSocket realWebSocket = this;
            this.originalRequest = object;
            this.listener = webSocketListener;
            this.random = random;
            this.pingIntervalMillis = l2;
            byte[] byArray = new byte[16];
            object = byArray;
            random.nextBytes(byArray);
            realWebSocket.key = ByteString.of((byte[])object).base64();
            realWebSocket.writerRunnable = new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            if (!RealWebSocket.this.writeOneFrame()) break;
                        }
                        catch (IOException iOException) {
                            RealWebSocket.this.failWebSocket(iOException, null);
                            break;
                        }
                    }
                }
            };
            return;
        }
        throw new IllegalArgumentException("Request must be GET: " + ((Request)object).method());
    }

    private synchronized boolean send(ByteString byteString, int n2) {
        if (!this.failed && !this.enqueuedClose) {
            if (this.queueSize + (long)byteString.size() > 0x1000000L) {
                this.close(1001, null);
                return false;
            }
            RealWebSocket realWebSocket = this;
            realWebSocket.queueSize += (long)byteString.size();
            realWebSocket.messageAndCloseQueue.add(new Message(n2, byteString));
            realWebSocket.runWriter();
            return true;
        }
        return false;
    }

    private void runWriter() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        ScheduledExecutorService scheduledExecutorService = this.executor;
        if (scheduledExecutorService != null) {
            scheduledExecutorService.execute(this.writerRunnable);
        }
    }

    static {
        $assertionsDisabled = RealWebSocket.class.desiredAssertionStatus() ^ true;
        ONLY_HTTP1 = Collections.singletonList(Protocol.HTTP_1_1);
    }

    @Override
    public Request request() {
        return this.originalRequest;
    }

    @Override
    public synchronized long queueSize() {
        return this.queueSize;
    }

    @Override
    public void cancel() {
        this.call.cancel();
    }

    public void connect(OkHttpClient cloneable) {
        RealWebSocket realWebSocket = this;
        cloneable = ((OkHttpClient)cloneable).newBuilder().eventListener(EventListener.NONE).protocols(ONLY_HTTP1).build();
        final Request request = realWebSocket.originalRequest.newBuilder().header("Upgrade", "websocket").header("Connection", "Upgrade").header("Sec-WebSocket-Key", this.key).header("Sec-WebSocket-Version", "13").build();
        cloneable = Internal.instance.newWebSocketCall((OkHttpClient)cloneable, request);
        realWebSocket.call = cloneable;
        cloneable.timeout().clearTimeout();
        realWebSocket.call.enqueue(new Callback(){

            @Override
            public void onResponse(Call object, Response response) {
                Streams streams;
                2 v2;
                2 v1;
                try {
                    2 v0 = this;
                    v1 = v0;
                    v2 = v0;
                    v0.RealWebSocket.this.checkResponse(response);
                    object = Internal.instance.streamAllocation((Call)object);
                    ((StreamAllocation)object).noNewStreams();
                    streams = ((StreamAllocation)object).connection().newWebSocketStreams((StreamAllocation)object);
                }
                catch (ProtocolException protocolException) {
                    RealWebSocket.this.failWebSocket(protocolException, response);
                    Util.closeQuietly(response);
                    return;
                }
                RealWebSocket realWebSocket = v2.RealWebSocket.this;
                Object object2 = object;
                2 v4 = this;
                realWebSocket.listener.onOpen(realWebSocket, response);
                object = "OkHttp WebSocket " + request.url().redact();
                try {
                    v4.RealWebSocket.this.initReaderAndWriter((String)object, streams);
                    ((StreamAllocation)object2).connection().socket().setSoTimeout(0);
                    v1.RealWebSocket.this.loopReader();
                }
                catch (Exception exception) {
                    RealWebSocket.this.failWebSocket(exception, null);
                }
            }

            @Override
            public void onFailure(Call call, IOException iOException) {
                RealWebSocket.this.failWebSocket(iOException, null);
            }
        });
    }

    void checkResponse(Response object) throws ProtocolException {
        if (((Response)object).code() == 101) {
            String string2 = ((Response)object).header("Connection");
            if ("Upgrade".equalsIgnoreCase(string2)) {
                string2 = ((Response)object).header("Upgrade");
                if ("websocket".equalsIgnoreCase(string2)) {
                    object = ((Response)object).header("Sec-WebSocket-Accept");
                    String string3 = ByteString.encodeUtf8(((RealWebSocket)((Object)string3)).key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").sha1().base64();
                    if (string3.equals(object)) {
                        return;
                    }
                    throw new ProtocolException("Expected 'Sec-WebSocket-Accept' header value '" + (String)string3 + "' but was '" + (String)object + "'");
                }
                throw new ProtocolException("Expected 'Upgrade' header value 'websocket' but was '" + string2 + "'");
            }
            throw new ProtocolException("Expected 'Connection' header value 'Upgrade' but was '" + string2 + "'");
        }
        throw new ProtocolException("Expected HTTP 101 response but was '" + ((Response)object).code() + " " + ((Response)object).message() + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initReaderAndWriter(String string2, Streams streams) throws IOException {
        synchronized (this) {
            WebSocketReader webSocketReader;
            block7: {
                long l2;
                PingRunnable pingRunnable;
                ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
                this.streams = streams;
                Streams streams2 = streams;
                boolean bl = streams2.client;
                BufferedSink bufferedSink = streams2.sink;
                Random random = this.random;
                this.writer = new WebSocketWriter(bl, bufferedSink, random);
                ScheduledThreadPoolExecutor scheduledThreadPoolExecutor2 = scheduledThreadPoolExecutor;
                int n2 = 1;
                this.executor = new ScheduledThreadPoolExecutor(n2, Util.threadFactory(string2, false));
                if (this.pingIntervalMillis == 0L) break block7;
                ScheduledThreadPoolExecutor scheduledThreadPoolExecutor3 = scheduledThreadPoolExecutor2;
                RealWebSocket realWebSocket = this;
                PingRunnable pingRunnable2 = pingRunnable;
                pingRunnable = new PingRunnable();
                long l3 = l2 = realWebSocket.pingIntervalMillis;
                scheduledThreadPoolExecutor3.scheduleAtFixedRate(pingRunnable2, l3, l3, TimeUnit.MILLISECONDS);
            }
            if (!this.messageAndCloseQueue.isEmpty()) {
                this.runWriter();
            }
            RealWebSocket realWebSocket = this;
            RealWebSocket realWebSocket2 = realWebSocket;
            // ** MonitorExit[v7] (shouldn't be in output)
            WebSocketReader webSocketReader2 = webSocketReader;
            Streams streams3 = streams;
            boolean bl = streams3.client;
            webSocketReader = new WebSocketReader(bl, streams3.source, this);
            realWebSocket2.reader = webSocketReader2;
            return;
        }
    }

    public void loopReader() throws IOException {
        while (this.receivedCloseCode == -1) {
            this.reader.processNextFrame();
        }
    }

    boolean processNextFrame() throws IOException {
        try {
            RealWebSocket realWebSocket = this;
            realWebSocket.reader.processNextFrame();
            return realWebSocket.receivedCloseCode == -1;
        }
        catch (Exception exception) {
            this.failWebSocket(exception, null);
            return false;
        }
    }

    void awaitTermination(int n2, TimeUnit timeUnit) throws InterruptedException {
        this.executor.awaitTermination(n2, timeUnit);
    }

    void tearDown() throws InterruptedException {
        ScheduledFuture<?> scheduledFuture = object.cancelFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        RealWebSocket realWebSocket = object;
        realWebSocket.executor.shutdown();
        Object object = TimeUnit.SECONDS;
        realWebSocket.executor.awaitTermination(10L, (TimeUnit)((Object)object));
    }

    synchronized int sentPingCount() {
        return this.sentPingCount;
    }

    synchronized int receivedPingCount() {
        return this.receivedPingCount;
    }

    synchronized int receivedPongCount() {
        return this.receivedPongCount;
    }

    @Override
    public void onReadMessage(String string2) throws IOException {
        this.listener.onMessage((WebSocket)this, string2);
    }

    @Override
    public void onReadMessage(ByteString byteString) throws IOException {
        this.listener.onMessage((WebSocket)this, byteString);
    }

    @Override
    public synchronized void onReadPing(ByteString byteString) {
        if (!(this.failed || this.enqueuedClose && this.messageAndCloseQueue.isEmpty())) {
            RealWebSocket realWebSocket = this;
            realWebSocket.pongQueue.add(byteString);
            realWebSocket.runWriter();
            ++realWebSocket.receivedPingCount;
            return;
        }
    }

    @Override
    public synchronized void onReadPong(ByteString byteString) {
        ++this.receivedPongCount;
        this.awaitingPong = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void onReadClose(int var1_1, String var2_2) {
        block16: {
            if (var1_1 == -1) break block16;
            v0 = this;
            var3_3 = null;
            synchronized (v0) {
                block14: {
                    block15: {
                        if (v0.receivedCloseCode != -1) break block14;
                        this.receivedCloseCode = var1_1;
                        this.receivedCloseReason = var2_2;
                        if (!this.enqueuedClose) ** GOTO lbl28
                        if (!this.messageAndCloseQueue.isEmpty()) ** GOTO lbl28
                        v1 = this;
                        v2 = v1;
                        v3 = v1;
                        var3_3 = v1.streams;
                        v3.streams = null;
                        var4_4 = v2.cancelFuture;
                        if (var4_4 == null) break block15;
                        var4_4.cancel(false);
                    }
                    this.executor.shutdown();
lbl28:
                    // 3 sources

                    v4 = var3_3;
                    v5 = this;
                    v6 = v5;
                    // ** MonitorExit[v5] (shouldn't be in output)
                    try {
                        v6.listener.onClosing(this, var1_1, var2_2);
                    }
                    catch (Throwable v7) {
                        Util.closeQuietly(var3_3);
                        throw v7;
                    }
                    if (v4 != null) {
                        this.listener.onClosed(this, var1_1, var2_2);
                    }
                    Util.closeQuietly(var3_3);
                    return;
                }
                throw new IllegalStateException("already closed");
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean send(String string2) {
        if (string2 != null) {
            return this.send(ByteString.encodeUtf8(string2), 1);
        }
        throw new NullPointerException("text == null");
    }

    @Override
    public boolean send(ByteString byteString) {
        if (byteString != null) {
            return this.send(byteString, 2);
        }
        throw new NullPointerException("bytes == null");
    }

    synchronized boolean pong(ByteString byteString) {
        if (!(this.failed || this.enqueuedClose && this.messageAndCloseQueue.isEmpty())) {
            RealWebSocket realWebSocket = this;
            realWebSocket.pongQueue.add(byteString);
            realWebSocket.runWriter();
            return true;
        }
        return false;
    }

    @Override
    public boolean close(int n2, String string2) {
        return this.close(n2, string2, 60000L);
    }

    synchronized boolean close(int n2, String string2, long l2) {
        WebSocketProtocol.validateCloseCode(n2);
        ByteString byteString = null;
        if (string2 != null && (long)(byteString = ByteString.encodeUtf8(string2)).size() > 123L) {
            throw new IllegalArgumentException("reason.size() > 123: " + string2);
        }
        if (!this.failed && !this.enqueuedClose) {
            RealWebSocket realWebSocket = this;
            realWebSocket.enqueuedClose = true;
            realWebSocket.messageAndCloseQueue.add(new Close(n2, byteString, l2));
            realWebSocket.runWriter();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    boolean writeOneFrame() throws IOException {
        block21: {
            block20: {
                v0 = this;
                var1_1 = null;
                var2_3 = -1;
                var3_4 = null;
                var4_5 = null;
                // MONITORENTER : v0
                if (v0.failed) {
                    // MONITOREXIT : this
                    return false;
                }
                v1 = this;
                var5_6 = v1.writer;
                var6_7 = v1.pongQueue.poll();
                if (var6_7 != null) ** GOTO lbl36
                var1_1 = this.messageAndCloseQueue.poll();
                if (!(var1_1 instanceof Close)) ** GOTO lbl33
                var2_3 = this.receivedCloseCode;
                var3_4 = this.receivedCloseReason;
                if (var2_3 == -1) break block20;
                v2 = this;
                var4_5 = v2.streams;
                v2.streams = null;
                v2.executor.shutdown();
                ** GOTO lbl36
            }
            v3 = this;
            v4 = v3;
            v5 = v3.executor;
            v4.cancelFuture = v5.schedule(new CancelRunnable(), ((Close)var1_1).cancelAfterCloseMillis, TimeUnit.MILLISECONDS);
            break block21;
lbl33:
            // 1 sources

            if (var1_1 == null) {
                // MONITOREXIT : this
                return false;
            }
        }
        // MONITOREXIT : this
        if (var6_7 == null) ** GOTO lbl42
        var5_6.writePong(var6_7);
        ** GOTO lbl74
lbl42:
        // 1 sources

        if (!(var1_1 instanceof Message)) ** GOTO lbl68
        v6 = this;
        v7 = v6;
        v8 = v6;
        v9 = v6;
        v10 = v6;
        v11 = var1_1;
        var1_1 = ((Message)v11).data;
        v12 = Okio.buffer(var5_6.newMessageSink(((Message)v11).formatOpcode, var1_1.size()));
        v13 = v12;
        v12.write((ByteString)var1_1);
        v13.close();
        // MONITORENTER : v7
        {
            catch (Throwable v14) {
                Util.closeQuietly(var4_5);
                throw v14;
            }
        }
        try {
            v9.queueSize = v8.queueSize - (long)var1_1.size();
            // MONITOREXIT : v10
            ** GOTO lbl74
        }
        catch (Throwable v15) {
            block18: {
                block19: {
                    // MONITOREXIT : this
                    throw v15;
lbl68:
                    // 1 sources

                    if (!(var1_1 instanceof Close)) break block18;
                    v16 = (Close)var1_1;
                    var1_2 = v16.code;
                    var5_6.writeClose(var1_2, v16.reason);
                    if (var4_5 == null) break block19;
                    this.listener.onClosed(this, var2_3, var3_4);
                }
                Util.closeQuietly(var4_5);
                return true;
            }
            throw new AssertionError();
        }
        catch (Throwable v17) {
            // MONITOREXIT : this
            throw v17;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void writePingFrame() {
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            if (realWebSocket.failed) {
                // ** MonitorExit[this] (shouldn't be in output)
                return;
            }
            RealWebSocket realWebSocket2 = this;
            WebSocketWriter webSocketWriter = realWebSocket2.writer;
            int n2 = realWebSocket2.awaitingPong ? this.sentPingCount : -1;
            RealWebSocket realWebSocket3 = this;
            ++realWebSocket3.sentPingCount;
            realWebSocket3.awaitingPong = true;
            // ** MonitorExit[v2] (shouldn't be in output)
            if (n2 != -1) {
                this.failWebSocket(new SocketTimeoutException("sent ping but didn't receive pong within " + this.pingIntervalMillis + "ms (after " + (n2 - 1) + " successful ping/pongs)"), null);
                return;
            }
            try {
                webSocketWriter.writePing(ByteString.EMPTY);
                return;
            }
            catch (IOException iOException) {
                this.failWebSocket(iOException, null);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void failWebSocket(Exception var1_1, @Nullable Response var2_2) {
        v0 = this;
        synchronized (v0) {
            block10: {
                if (!v0.failed) ** GOTO lbl11
                // ** MonitorExit[this] (shouldn't be in output)
                return;
lbl11:
                // 1 sources

                v2 = this;
                v3 = v2;
                v4 = v2;
                v2.failed = true;
                var3_3 = v2.streams;
                v3.streams = null;
                var4_4 = v4.cancelFuture;
                if (var4_4 == null) break block10;
                var4_4.cancel(false);
            }
            var4_4 = this.executor;
            if (var4_4 == null) ** GOTO lbl29
            var4_4.shutdown();
lbl29:
            // 2 sources

            v5 = var3_3;
            v6 = this;
            v7 = v6;
            // ** MonitorExit[v6] (shouldn't be in output)
            try {
                v7.listener.onFailure(this, var1_1, var2_2);
            }
            catch (Throwable v8) {
                Util.closeQuietly(var3_3);
                throw v8;
            }
            Util.closeQuietly(v5);
            return;
        }
    }

    final class CancelRunnable
    implements Runnable {
        CancelRunnable() {
        }

        @Override
        public void run() {
            RealWebSocket.this.cancel();
        }
    }

    public static abstract class Streams
    implements Closeable {
        public final boolean client;
        public final BufferedSource source;
        public final BufferedSink sink;

        public Streams(boolean bl, BufferedSource bufferedSource, BufferedSink bufferedSink) {
            this.client = bl;
            this.source = bufferedSource;
            this.sink = bufferedSink;
        }
    }

    static final class Close {
        final int code;
        final ByteString reason;
        final long cancelAfterCloseMillis;

        Close(int n2, ByteString byteString, long l2) {
            this.code = n2;
            this.reason = byteString;
            this.cancelAfterCloseMillis = l2;
        }
    }

    static final class Message {
        final int formatOpcode;
        final ByteString data;

        Message(int n2, ByteString byteString) {
            this.formatOpcode = n2;
            this.data = byteString;
        }
    }

    private final class PingRunnable
    implements Runnable {
        PingRunnable() {
        }

        @Override
        public void run() {
            RealWebSocket.this.writePingFrame();
        }
    }
}

