/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.platform;

import android.os.Build;
import android.util.Log;
import androidx.annotation.Nullable;
import dc.squareup.okhttp3.Protocol;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.platform.OptionalMethod;
import dc.squareup.okhttp3.internal.platform.Platform;
import dc.squareup.okhttp3.internal.tls.CertificateChainCleaner;
import dc.squareup.okhttp3.internal.tls.TrustRootIndex;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

class AndroidPlatform
extends Platform {
    private static final int MAX_LOG_LENGTH = 4000;
    private final Class<?> sslParametersClass;
    private final OptionalMethod<Socket> setUseSessionTickets;
    private final OptionalMethod<Socket> setHostname;
    private final OptionalMethod<Socket> getAlpnSelectedProtocol;
    private final OptionalMethod<Socket> setAlpnProtocols;
    private final CloseGuard closeGuard = CloseGuard.get();

    AndroidPlatform(Class<?> clazz, OptionalMethod<Socket> optionalMethod, OptionalMethod<Socket> optionalMethod2, OptionalMethod<Socket> optionalMethod3, OptionalMethod<Socket> optionalMethod4) {
        this.sslParametersClass = clazz;
        this.setUseSessionTickets = optionalMethod;
        this.setHostname = optionalMethod2;
        this.getAlpnSelectedProtocol = optionalMethod3;
        this.setAlpnProtocols = optionalMethod4;
    }

    private boolean api24IsCleartextTrafficPermitted(String string2, Class<?> clazz, Object object) throws InvocationTargetException, IllegalAccessException {
        Class[] classArray;
        try {
            classArray = new Class[1];
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return this.api23IsCleartextTrafficPermitted(string2, clazz, object);
        }
        classArray[0] = String.class;
        return (Boolean)clazz.getMethod("isCleartextTrafficPermitted", classArray).invoke(object, string2);
    }

    private boolean api23IsCleartextTrafficPermitted(String string2, Class<?> clazz, Object object) throws InvocationTargetException, IllegalAccessException {
        try {
            return (Boolean)clazz.getMethod("isCleartextTrafficPermitted", new Class[0]).invoke(object, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return super.isCleartextTrafficPermitted(string2);
        }
    }

    private static boolean supportsAlpn() {
        if (Security.getProvider("GMSCore_OpenSSL") != null) {
            return true;
        }
        try {
            Class.forName("android.net.Network");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static Platform buildIfSupported() {
        if (AndroidPlatform.getSdkInt() == 0) {
            return null;
        }
        try {
            v0 = Class.forName("com.android.org.conscrypt.SSLParametersImpl");
        }
        catch (ClassNotFoundException v1) {
            v0 = Class.forName("org.apache.harmony.xnet.provider.jsse.SSLParametersImpl");
            ** continue;
        }
lbl5:
        // 2 sources

        while (true) {
            continue;
            break;
        }
        var0 = v0;
        var1_1 = v2;
        v3 = new Class[1];
        {
            catch (ClassNotFoundException v4) {
                return null;
            }
        }
        v3[0] = Boolean.TYPE;
        v2 = new OptionalMethod<Socket>(null, "setUseSessionTickets", v3);
        var2_2 = v5;
        v6 = new Class[1];
        v6[0] = String.class;
        v5 = new OptionalMethod<Socket>(null, "setHostname", v6);
        var3_3 = null;
        var4_4 = null;
        if (!AndroidPlatform.supportsAlpn()) ** GOTO lbl41
        var3_3 = v7;
        v8 = byte[].class;
        v7 = new OptionalMethod<T>(v8, "getAlpnSelectedProtocol", new Class[0]);
        var4_4 = v9;
        v10 = new Class[1];
        v10[0] = byte[].class;
        v9 = new OptionalMethod<T>(null, "setAlpnProtocols", v10);
lbl41:
        // 2 sources

        return new AndroidPlatform(var0, var1_1, var2_2, (OptionalMethod<Socket>)var3_3, var4_4);
    }

    static int getSdkInt() {
        try {
            return Build.VERSION.SDK_INT;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return 0;
        }
    }

    @Override
    public void connectSocket(Socket socket, InetSocketAddress inetSocketAddress, int n2) throws IOException {
        try {
            socket.connect(inetSocketAddress, n2);
            return;
        }
        catch (ClassCastException classCastException) {
            if (Build.VERSION.SDK_INT == 26) {
                IOException iOException = new IOException("Exception in connect");
                iOException.initCause(classCastException);
                throw iOException;
            }
            throw classCastException;
        }
        catch (SecurityException securityException) {
            IOException iOException = new IOException("Exception in connect");
            iOException.initCause(securityException);
            throw iOException;
        }
        catch (AssertionError assertionError) {
            AssertionError assertionError2 = assertionError;
            if (Util.isAndroidGetsocknameError(assertionError)) {
                throw new IOException((Throwable)((Object)assertionError2));
            }
            throw assertionError2;
        }
    }

    @Override
    @Nullable
    protected X509TrustManager trustManager(SSLSocketFactory sSLSocketFactory) {
        Object obj = Platform.readFieldOrNull(sSLSocketFactory, ((AndroidPlatform)this).sslParametersClass, "sslParameters");
        if (obj == null) {
            try {
                obj = Platform.readFieldOrNull(sSLSocketFactory, Class.forName("com.google.android.gms.org.conscrypt.SSLParametersImpl", false, sSLSocketFactory.getClass().getClassLoader()), "sslParameters");
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.trustManager(sSLSocketFactory);
            }
        }
        if ((this = Platform.readFieldOrNull(obj, X509TrustManager.class, "x509TrustManager")) != null) {
            return this;
        }
        return Platform.readFieldOrNull(obj, X509TrustManager.class, "trustManager");
    }

    @Override
    public void configureTlsExtensions(SSLSocket sSLSocket, String object, List<Protocol> list) throws IOException {
        if (object != null) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = Boolean.TRUE;
            objectArray5.setUseSessionTickets.invokeOptionalWithoutCheckedException(sSLSocket, objectArray2);
            Object[] objectArray3 = new Object[1];
            objectArray2 = objectArray3;
            objectArray3[0] = object;
            objectArray5.setHostname.invokeOptionalWithoutCheckedException(sSLSocket, objectArray2);
        }
        if ((object = objectArray5.setAlpnProtocols) != null && ((OptionalMethod)object).isSupported(sSLSocket)) {
            Object[] objectArray = objectArray5;
            Object[] objectArray4 = new Object[1];
            Object[] objectArray5 = objectArray4;
            objectArray4[0] = Platform.concatLengthPrefixed(list);
            objectArray.setAlpnProtocols.invokeWithoutCheckedException(sSLSocket, objectArray5);
        }
    }

    @Override
    @Nullable
    public String getSelectedProtocol(SSLSocket object) {
        OptionalMethod<Socket> optionalMethod = ((AndroidPlatform)object2).getAlpnSelectedProtocol;
        if (optionalMethod == null) {
            return null;
        }
        if (!optionalMethod.isSupported((Socket)object)) {
            return null;
        }
        byte[] byArray = (byte[])((AndroidPlatform)object2).getAlpnSelectedProtocol.invokeWithoutCheckedException((Socket)object, new Object[0]);
        Object object2 = byArray;
        if (byArray != null) {
            String string2;
            object = string2;
            string2 = new String((byte[])object2, Util.UTF_8);
        } else {
            object = null;
        }
        return object;
    }

    @Override
    public void log(int n2, String string2, @Nullable Throwable throwable) {
        int n3 = n2 == 5 ? 5 : 3;
        if (throwable != null) {
            string2 = string2 + '\n' + Log.getStackTraceString((Throwable)throwable);
        }
        n2 = 0;
        int n4 = string2.length();
        block0: while (n2 < n4) {
            int n5 = string2.indexOf(10, n2);
            if (n5 == -1) {
                n5 = n4;
            }
            while (true) {
                int n6 = Math.min(n5, n2 + 4000);
                Log.println((int)n3, (String)"OkHttp", (String)string2.substring(n2, n6));
                if (n6 >= n5) {
                    n2 = n6 + 1;
                    continue block0;
                }
                n2 = n6;
            }
        }
    }

    @Override
    public Object getStackTraceForCloseable(String string2) {
        return this.closeGuard.createAndOpen(string2);
    }

    @Override
    public void logCloseableLeak(String string2, Object object) {
        if (!this.closeGuard.warnIfOpen(object)) {
            this.log(5, string2, null);
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    @Override
    public boolean isCleartextTrafficPermitted(String string2) {
        block10: {
            void var0_4;
            if (Build.VERSION.SDK_INT < 23) {
                return super.isCleartextTrafficPermitted(string2);
            }
            AndroidPlatform androidPlatform = this;
            String string3 = string2;
            Class<?> clazz = Class.forName("android.security.NetworkSecurityPolicy");
            Method method = clazz.getMethod("getInstance", new Class[0]);
            try {
                return androidPlatform.api24IsCleartextTrafficPermitted(string3, clazz, method.invoke(null, new Object[0]));
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            throw Util.assertionError("unable to determine cleartext support", (Exception)var0_4);
            catch (NoSuchMethodException noSuchMethodException) {
                break block10;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return super.isCleartextTrafficPermitted(string2);
    }

    @Override
    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager x509TrustManager) {
        Class[] classArray;
        Class<?> clazz;
        Class<?> clazz2;
        try {
            Class<?> clazz3 = Class.forName("android.net.http.X509TrustManagerExtensions");
            clazz2 = clazz3;
            clazz = clazz3;
            classArray = new Class[1];
        }
        catch (Exception exception) {
            return super.buildCertificateChainCleaner(x509TrustManager);
        }
        classArray[0] = X509TrustManager.class;
        Object obj = clazz2.getConstructor(classArray).newInstance(x509TrustManager);
        Class[] classArray2 = new Class[3];
        classArray2[0] = X509Certificate[].class;
        classArray2[1] = String.class;
        classArray2[2] = String.class;
        Method method = clazz.getMethod("checkServerTrusted", classArray2);
        return new AndroidCertificateChainCleaner(obj, method);
    }

    @Override
    public TrustRootIndex buildTrustRootIndex(X509TrustManager x509TrustManager) {
        Class<?> clazz;
        try {
            clazz = x509TrustManager.getClass();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return super.buildTrustRootIndex(x509TrustManager);
        }
        Class[] classArray = new Class[1];
        classArray[0] = X509Certificate.class;
        Method method = clazz.getDeclaredMethod("findTrustAnchorByIssuerAndSignature", classArray);
        method.setAccessible(true);
        return new AndroidTrustRootIndex(x509TrustManager, method);
    }

    @Override
    public SSLContext getSSLContext() {
        int n2;
        block7: {
            try {
                n2 = Build.VERSION.SDK_INT;
                if (n2 >= 16 && n2 < 22) break block7;
                n2 = 0;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
        n2 = 1;
        if (n2 != 0) {
            try {
                return SSLContext.getInstance("TLSv1.2");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        try {
            return SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("No TLS provider", noSuchAlgorithmException);
        }
    }

    static final class AndroidTrustRootIndex
    implements TrustRootIndex {
        private final X509TrustManager trustManager;
        private final Method findByIssuerAndSignatureMethod;

        AndroidTrustRootIndex(X509TrustManager x509TrustManager, Method method) {
            this.findByIssuerAndSignatureMethod = method;
            this.trustManager = x509TrustManager;
        }

        @Override
        public X509Certificate findByIssuerAndSignature(X509Certificate x509Certificate) {
            block5: {
                Object object;
                block4: {
                    object = (TrustAnchor)((AndroidTrustRootIndex)object).findByIssuerAndSignatureMethod.invoke((Object)((AndroidTrustRootIndex)object).trustManager, x509Certificate);
                    if (object == null) break block4;
                    try {
                        object = ((TrustAnchor)object).getTrustedCert();
                        break block5;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        return null;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw Util.assertionError("unable to get issues and signature", illegalAccessException);
                    }
                }
                object = null;
            }
            return object;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof AndroidTrustRootIndex)) {
                return false;
            }
            object = (AndroidTrustRootIndex)object;
            return this.trustManager.equals(((AndroidTrustRootIndex)object).trustManager) && this.findByIssuerAndSignatureMethod.equals(((AndroidTrustRootIndex)object).findByIssuerAndSignatureMethod);
        }

        public int hashCode() {
            return this.trustManager.hashCode() + this.findByIssuerAndSignatureMethod.hashCode() * 31;
        }
    }

    static final class CloseGuard {
        private final Method getMethod;
        private final Method openMethod;
        private final Method warnIfOpenMethod;

        CloseGuard(Method method, Method method2, Method method3) {
            this.getMethod = method;
            this.openMethod = method2;
            this.warnIfOpenMethod = method3;
        }

        static CloseGuard get() {
            Method method;
            Class<?> clazz = Class.forName("dalvik.system.CloseGuard");
            Method method2 = clazz.getMethod("get", new Class[0]);
            Class[] classArray = new Class[1];
            classArray[0] = String.class;
            Method method3 = clazz.getMethod("open", classArray);
            try {
                method = clazz.getMethod("warnIfOpen", new Class[0]);
            }
            catch (Exception exception) {
                method2 = null;
                method3 = null;
                method = null;
            }
            return new CloseGuard(method2, method3, method);
        }

        Object createAndOpen(String string2) {
            Method method = this.getMethod;
            if (method != null) {
                Object object;
                try {
                    object = method.invoke(null, new Object[0]);
                }
                catch (Exception exception) {}
                this.openMethod.invoke(object, string2);
                return object;
            }
            return null;
        }

        boolean warnIfOpen(Object object) {
            boolean bl = false;
            if (object != null) {
                try {
                    this.warnIfOpenMethod.invoke(object, new Object[0]);
                }
                catch (Exception exception) {}
                bl = true;
            }
            return bl;
        }
    }

    static final class AndroidCertificateChainCleaner
    extends CertificateChainCleaner {
        private final Object x509TrustManagerExtensions;
        private final Method checkServerTrusted;

        AndroidCertificateChainCleaner(Object object, Method method) {
            this.x509TrustManagerExtensions = object;
            this.checkServerTrusted = method;
        }

        @Override
        public List<Certificate> clean(List<Certificate> x509CertificateArray, String string2) throws SSLPeerUnverifiedException {
            AndroidCertificateChainCleaner androidCertificateChainCleaner = this;
            x509CertificateArray = x509CertificateArray.toArray(new X509Certificate[x509CertificateArray.size()]);
            try {
                return (List)androidCertificateChainCleaner.checkServerTrusted.invoke(this.x509TrustManagerExtensions, x509CertificateArray, "RSA", string2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                SSLPeerUnverifiedException sSLPeerUnverifiedException = new SSLPeerUnverifiedException(invocationTargetException.getMessage());
                sSLPeerUnverifiedException.initCause(invocationTargetException);
                throw sSLPeerUnverifiedException;
            }
        }

        public boolean equals(Object object) {
            return object instanceof AndroidCertificateChainCleaner;
        }

        public int hashCode() {
            return 0;
        }
    }
}

