/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.http;

import dc.squareup.okhttp3.Call;
import dc.squareup.okhttp3.Interceptor;
import dc.squareup.okhttp3.Request;
import dc.squareup.okhttp3.Response;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.connection.RealConnection;
import dc.squareup.okhttp3.internal.connection.StreamAllocation;
import dc.squareup.okhttp3.internal.http.HttpCodec;
import dc.squareup.okhttp3.internal.http.HttpMethod;
import dc.squareup.okhttp3.internal.http.RealInterceptorChain;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.ForwardingSink;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Sink;
import java.io.IOException;
import java.net.ProtocolException;

public final class CallServerInterceptor
implements Interceptor {
    private final boolean forWebSocket;

    public CallServerInterceptor(boolean bl) {
        this.forWebSocket = bl;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        int n2;
        chain = (RealInterceptorChain)chain;
        HttpCodec httpCodec = ((RealInterceptorChain)chain).httpStream();
        Interceptor.Chain chain2 = chain;
        StreamAllocation streamAllocation = ((RealInterceptorChain)chain2).streamAllocation();
        Object object = (RealConnection)((RealInterceptorChain)chain2).connection();
        Request request = ((RealInterceptorChain)chain2).request();
        long l2 = System.currentTimeMillis();
        ((RealInterceptorChain)chain).eventListener().requestHeadersStart(((RealInterceptorChain)chain).call());
        httpCodec.writeRequestHeaders(request);
        ((RealInterceptorChain)chain).eventListener().requestHeadersEnd(((RealInterceptorChain)chain).call(), request);
        Response.Builder builder = null;
        if (HttpMethod.permitsRequestBody(request.method()) && request.body() != null) {
            if ("100-continue".equalsIgnoreCase(request.header("Expect"))) {
                httpCodec.flushRequest();
                ((RealInterceptorChain)chain).eventListener().responseHeadersStart(((RealInterceptorChain)chain).call());
                builder = httpCodec.readResponseHeaders(true);
            }
            if (builder == null) {
                CountingSink countingSink;
                ((RealInterceptorChain)chain).eventListener().requestBodyStart(((RealInterceptorChain)chain).call());
                long l3 = request.body().contentLength();
                object = countingSink;
                BufferedSink bufferedSink = Okio.buffer(new CountingSink(httpCodec.createRequestBody(request, l3)));
                request.body().writeTo(bufferedSink);
                bufferedSink.close();
                Object object2 = object;
                object = ((RealInterceptorChain)chain).call();
                l3 = ((CountingSink)object2).successfulCount;
                ((RealInterceptorChain)chain).eventListener().requestBodyEnd((Call)object, l3);
            } else if (!((RealConnection)object).isMultiplexed()) {
                streamAllocation.noNewStreams();
            }
        }
        httpCodec.finishRequest();
        if (builder == null) {
            ((RealInterceptorChain)chain).eventListener().responseHeadersStart(((RealInterceptorChain)chain).call());
            builder = httpCodec.readResponseHeaders(false);
        }
        if ((n2 = ((Response)(object = builder.request(request).handshake(streamAllocation.connection().handshake()).sentRequestAtMillis(l2).receivedResponseAtMillis(System.currentTimeMillis()).build())).code()) == 100) {
            object = httpCodec.readResponseHeaders(false).request(request).handshake(streamAllocation.connection().handshake()).sentRequestAtMillis(l2).receivedResponseAtMillis(System.currentTimeMillis()).build();
            n2 = ((Response)object).code();
        }
        ((RealInterceptorChain)chain).eventListener().responseHeadersEnd(((RealInterceptorChain)chain).call(), (Response)object);
        Response response = ((CallServerInterceptor)((Object)response)).forWebSocket && n2 == 101 ? ((Response)object).newBuilder().body(Util.EMPTY_RESPONSE).build() : ((Response)object).newBuilder().body(httpCodec.openResponseBody((Response)object)).build();
        if ("close".equalsIgnoreCase(response.request().header("Connection")) || "close".equalsIgnoreCase(response.header("Connection"))) {
            streamAllocation.noNewStreams();
        }
        if (n2 != 204 && n2 != 205 || response.body().contentLength() <= 0L) {
            return response;
        }
        throw new ProtocolException("HTTP " + n2 + " had non-zero Content-Length: " + response.body().contentLength());
    }

    static final class CountingSink
    extends ForwardingSink {
        long successfulCount;

        CountingSink(Sink sink) {
            super(sink);
        }

        @Override
        public void write(Buffer buffer, long l2) throws IOException {
            CountingSink countingSink = this;
            super.write(buffer, l2);
            countingSink.successfulCount += l2;
        }
    }
}

