/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.cache;

import dc.squareup.okio.Buffer;
import dc.squareup.okio.ForwardingSink;
import dc.squareup.okio.Sink;
import java.io.IOException;

class FaultHidingSink
extends ForwardingSink {
    private boolean hasErrors;

    FaultHidingSink(Sink sink) {
        super(sink);
    }

    @Override
    public void write(Buffer buffer, long l2) throws IOException {
        if (this.hasErrors) {
            buffer.skip(l2);
            return;
        }
        try {
            super.write(buffer, l2);
        }
        catch (IOException iOException) {
            this.hasErrors = true;
            this.onException(iOException);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.hasErrors) {
            return;
        }
        try {
            super.flush();
        }
        catch (IOException iOException) {
            this.hasErrors = true;
            this.onException(iOException);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.hasErrors) {
            return;
        }
        try {
            super.close();
        }
        catch (IOException iOException) {
            this.hasErrors = true;
            this.onException(iOException);
        }
    }

    protected void onException(IOException iOException) {
    }
}

