/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.HttpUrl;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.tls.CertificateChainCleaner;
import dc.squareup.okio.ByteString;
import java.io.Serializable;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;

public final class CertificatePinner {
    public static final CertificatePinner DEFAULT = new Builder().build();
    private final Set<Pin> pins;
    @Nullable
    private final CertificateChainCleaner certificateChainCleaner;

    CertificatePinner(Set<Pin> set, @Nullable CertificateChainCleaner certificateChainCleaner) {
        this.pins = set;
        this.certificateChainCleaner = certificateChainCleaner;
    }

    public static String pin(Certificate certificate) {
        if (certificate instanceof X509Certificate) {
            return "sha256/" + CertificatePinner.sha256((X509Certificate)certificate).base64();
        }
        throw new IllegalArgumentException("Certificate pinning requires X509 certificates");
    }

    static ByteString sha1(X509Certificate x509Certificate) {
        return ByteString.of(x509Certificate.getPublicKey().getEncoded()).sha1();
    }

    static ByteString sha256(X509Certificate x509Certificate) {
        return ByteString.of(x509Certificate.getPublicKey().getEncoded()).sha256();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CertificatePinner)) return false;
        object = (CertificatePinner)object;
        if (!Util.equal(this.certificateChainCleaner, ((CertificatePinner)object).certificateChainCleaner)) return false;
        if (!this.pins.equals(((CertificatePinner)object).pins)) return false;
        return true;
    }

    public int hashCode() {
        CertificateChainCleaner certificateChainCleaner = this.certificateChainCleaner;
        return (certificateChainCleaner != null ? certificateChainCleaner.hashCode() : 0) * 31 + this.pins.hashCode();
    }

    public void check(String string2, List<Certificate> list) throws SSLPeerUnverifiedException {
        Serializable serializable;
        List<Pin> list2 = ((CertificatePinner)((Object)certificateChainCleaner)).findMatchingPins(string2);
        if (list2.isEmpty()) {
            return;
        }
        CertificateChainCleaner certificateChainCleaner = ((CertificatePinner)((Object)certificateChainCleaner)).certificateChainCleaner;
        if (certificateChainCleaner != null) {
            list = certificateChainCleaner.clean(list, string2);
        }
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            X509Certificate x509Certificate = (X509Certificate)list.get(i2);
            serializable = null;
            ByteString byteString = null;
            int n3 = list2.size();
            for (int i3 = 0; i3 < n3; ++i3) {
                Pin pin = list2.get(i3);
                if (pin.hashAlgorithm.equals("sha256/")) {
                    if (byteString == null) {
                        byteString = CertificatePinner.sha256(x509Certificate);
                    }
                    if (!pin.hash.equals(byteString)) continue;
                    return;
                }
                if (pin.hashAlgorithm.equals("sha1/")) {
                    if (serializable == null) {
                        serializable = CertificatePinner.sha1(x509Certificate);
                    }
                    if (!pin.hash.equals(serializable)) continue;
                    return;
                }
                throw new AssertionError((Object)("unsupported hashAlgorithm: " + pin.hashAlgorithm));
            }
        }
        StringBuilder stringBuilder = new StringBuilder().append("Certificate pinning failure!").append("\n  Peer certificate chain:");
        int n4 = list.size();
        for (n2 = 0; n2 < n4; ++n2) {
            serializable = (X509Certificate)list.get(n2);
            stringBuilder.append("\n    ").append(CertificatePinner.pin(serializable)).append(": ").append(serializable.getSubjectDN().getName());
        }
        stringBuilder.append("\n  Pinned certificates for ").append(string2).append(":");
        int n5 = list2.size();
        for (int i4 = 0; i4 < n5; ++i4) {
            Pin pin = list2.get(i4);
            stringBuilder.append("\n    ").append(pin);
        }
        throw new SSLPeerUnverifiedException(stringBuilder.toString());
    }

    public void check(String string2, Certificate ... certificateArray) throws SSLPeerUnverifiedException {
        this.check(string2, Arrays.asList(certificateArray));
    }

    List<Pin> findMatchingPins(String string2) {
        CertificatePinner certificatePinner = object;
        Object object = Collections.emptyList();
        for (Pin pin : certificatePinner.pins) {
            if (!pin.matches(string2)) continue;
            if (object.isEmpty()) {
                ArrayList arrayList;
                object = arrayList;
                arrayList = new ArrayList();
            }
            object.add(pin);
        }
        return object;
    }

    CertificatePinner withCertificateChainCleaner(@Nullable CertificateChainCleaner certificateChainCleaner) {
        CertificatePinner certificatePinner;
        if (Util.equal(this.certificateChainCleaner, certificateChainCleaner)) {
            certificatePinner = this;
        } else {
            CertificatePinner certificatePinner2;
            certificatePinner = certificatePinner2;
            certificatePinner2 = new CertificatePinner(this.pins, certificateChainCleaner);
        }
        return certificatePinner;
    }

    public static final class Builder {
        private final List<Pin> pins;

        public Builder() {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            v1.pins = arrayList2;
        }

        public Builder add(String string2, String ... stringArray) {
            if (string2 != null) {
                for (String string3 : stringArray) {
                    this.pins.add(new Pin(string2, string3));
                }
                return this;
            }
            throw new NullPointerException("pattern == null");
        }

        public CertificatePinner build() {
            return new CertificatePinner(new LinkedHashSet<Pin>(this.pins), null);
        }
    }

    static final class Pin {
        private static final String WILDCARD = "*.";
        final String pattern;
        final String canonicalHostname;
        final String hashAlgorithm;
        final ByteString hash;

        Pin(String string2, String string3) {
            block6: {
                block5: {
                    block4: {
                        this.pattern = string2;
                        string2 = string2.startsWith(WILDCARD) ? HttpUrl.get("http://" + string2.substring(2)).host() : HttpUrl.get("http://" + string2).host();
                        this.canonicalHostname = string2;
                        if (!string3.startsWith("sha1/")) break block4;
                        this.hashAlgorithm = "sha1/";
                        this.hash = ByteString.decodeBase64(string3.substring(5));
                        break block5;
                    }
                    if (!string3.startsWith("sha256/")) break block6;
                    this.hashAlgorithm = "sha256/";
                    this.hash = ByteString.decodeBase64(string3.substring(7));
                }
                if (this.hash != null) {
                    return;
                }
                throw new IllegalArgumentException("pins must be base64: " + string3);
            }
            throw new IllegalArgumentException("pins must start with 'sha256/' or 'sha1/': " + string3);
        }

        boolean matches(String string2) {
            if (this.pattern.startsWith(WILDCARD)) {
                int n2;
                String string3 = string2;
                int n3 = string3.indexOf(46);
                return string3.length() - n3 - 1 == this.canonicalHostname.length() && string2.regionMatches(false, n2 = n3 + 1, string2 = this.canonicalHostname, 0, n3 = string2.length());
            }
            return string2.equals(this.canonicalHostname);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof Pin)) return false;
            object = (Pin)object;
            if (!this.pattern.equals(((Pin)object).pattern)) return false;
            if (!this.hashAlgorithm.equals(((Pin)object).hashAlgorithm)) return false;
            if (!this.hash.equals(((Pin)object).hash)) return false;
            return true;
        }

        public int hashCode() {
            return ((527 + this.pattern.hashCode()) * 31 + this.hashAlgorithm.hashCode()) * 31 + this.hash.hashCode();
        }

        public String toString() {
            return this.hashAlgorithm + this.hash.base64();
        }
    }
}

