/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.CipherSuite;
import dc.squareup.okhttp3.Handshake;
import dc.squareup.okhttp3.Headers;
import dc.squareup.okhttp3.HttpUrl;
import dc.squareup.okhttp3.MediaType;
import dc.squareup.okhttp3.Protocol;
import dc.squareup.okhttp3.Request;
import dc.squareup.okhttp3.Response;
import dc.squareup.okhttp3.ResponseBody;
import dc.squareup.okhttp3.TlsVersion;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.cache.CacheRequest;
import dc.squareup.okhttp3.internal.cache.CacheStrategy;
import dc.squareup.okhttp3.internal.cache.DiskLruCache;
import dc.squareup.okhttp3.internal.cache.InternalCache;
import dc.squareup.okhttp3.internal.http.HttpHeaders;
import dc.squareup.okhttp3.internal.http.HttpMethod;
import dc.squareup.okhttp3.internal.http.StatusLine;
import dc.squareup.okhttp3.internal.io.FileSystem;
import dc.squareup.okhttp3.internal.platform.Platform;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.ForwardingSink;
import dc.squareup.okio.ForwardingSource;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Sink;
import dc.squareup.okio.Source;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class Cache
implements Closeable,
Flushable {
    private static final int VERSION = 201105;
    private static final int ENTRY_METADATA = 0;
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;
    final InternalCache internalCache;
    final DiskLruCache cache;
    int writeSuccessCount;
    int writeAbortCount;
    private int networkCount;
    private int hitCount;
    private int requestCount;

    public Cache(File file, long l2) {
        Cache cache = fileSystem;
        FileSystem fileSystem = FileSystem.SYSTEM;
        cache(file, l2, fileSystem);
    }

    Cache(File file, long l2, FileSystem fileSystem) {
        this.internalCache = new InternalCache(){

            @Override
            public Response get(Request request) throws IOException {
                return Cache.this.get(request);
            }

            @Override
            public CacheRequest put(Response response) throws IOException {
                return Cache.this.put(response);
            }

            @Override
            public void remove(Request request) throws IOException {
                Cache.this.remove(request);
            }

            @Override
            public void update(Response response, Response response2) {
                Cache.this.update(response, response2);
            }

            @Override
            public void trackConditionalCacheHit() {
                Cache.this.trackConditionalCacheHit();
            }

            @Override
            public void trackResponse(CacheStrategy cacheStrategy) {
                Cache.this.trackResponse(cacheStrategy);
            }
        };
        this.cache = DiskLruCache.create(fileSystem, file, 201105, 2, l2);
    }

    public static String key(HttpUrl httpUrl) {
        return ByteString.encodeUtf8(httpUrl.toString()).md5().hex();
    }

    private void abortQuietly(@Nullable DiskLruCache.Editor editor) {
        if (editor != null) {
            try {
                editor.abort();
            }
            catch (IOException iOException) {}
        }
    }

    static int readInt(BufferedSource object) throws IOException {
        long l2;
        block5: {
            try {
                l2 = object.readDecimalLong();
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(numberFormatException.getMessage());
            }
            object = object.readUtf8LineStrict();
            if (l2 < 0L || l2 > Integer.MAX_VALUE) break block5;
            if (!((String)object).isEmpty()) break block5;
            return (int)l2;
        }
        throw new IOException("expected an int but was \"" + l2 + (String)object + "\"");
    }

    @Nullable
    Response get(Request request) {
        block6: {
            Entry entry;
            Object object;
            block5: {
                Cache cache = object;
                object = Cache.key(request.url());
                try {
                    object = cache.cache.get((String)object);
                    if (object != null) break block5;
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            Entry entry2 = entry;
            try {
                entry2(((DiskLruCache.Snapshot)object).getSource(0));
                object = entry2.response((DiskLruCache.Snapshot)object);
                if (entry.matches(request, (Response)object)) break block6;
            }
            catch (IOException iOException) {
                Util.closeQuietly((Closeable)object);
                return null;
            }
            Util.closeQuietly(((Response)object).body());
            return null;
        }
        return object;
    }

    @Nullable
    CacheRequest put(Response response) {
        DiskLruCache.Editor editor;
        Object object;
        block8: {
            Entry entry;
            Response response2 = response;
            object = response2.request().method();
            if (HttpMethod.invalidatesCache(response2.request().method())) {
                try {
                    this.remove(response.request());
                }
                catch (IOException iOException) {}
                return null;
            }
            if (!((String)object).equals("GET")) {
                return null;
            }
            if (HttpHeaders.hasVaryAll(response)) {
                return null;
            }
            object = entry;
            entry = new Entry(response);
            editor = null;
            try {
                editor = this.cache.edit(Cache.key(response.request().url()));
                if (editor != null) break block8;
                return null;
            }
            catch (IOException iOException) {
                this.abortQuietly(editor);
                return null;
            }
        }
        ((Entry)object).writeTo(editor);
        return new CacheRequestImpl(this, editor);
    }

    void remove(Request request) throws IOException {
        this.cache.remove(Cache.key(request.url()));
    }

    void update(Response object, Response object2) {
        block3: {
            Entry entry;
            Response response = object;
            object = entry;
            entry = new Entry((Response)object2);
            object2 = null;
            object2 = ((CacheResponseBody)response.body()).snapshot.edit();
            if (object2 == null) break block3;
            try {
                ((Entry)object).writeTo((DiskLruCache.Editor)object2);
                ((DiskLruCache.Editor)object2).commit();
            }
            catch (IOException iOException) {
                this.abortQuietly((DiskLruCache.Editor)object2);
            }
        }
    }

    public void initialize() throws IOException {
        this.cache.initialize();
    }

    public void delete() throws IOException {
        this.cache.delete();
    }

    public void evictAll() throws IOException {
        this.cache.evictAll();
    }

    public Iterator<String> urls() throws IOException {
        return new Iterator<String>(){
            final Iterator<DiskLruCache.Snapshot> delegate;
            @Nullable
            String nextUrl;
            boolean canRemove;
            {
                this.delegate = Cache.this.cache.snapshots();
            }

            @Override
            public boolean hasNext() {
                if (this.nextUrl != null) {
                    return true;
                }
                this.canRemove = false;
                while (this.delegate.hasNext()) {
                    DiskLruCache.Snapshot snapshot = this.delegate.next();
                    try {
                        this.nextUrl = Okio.buffer(snapshot.getSource(0)).readUtf8LineStrict();
                        snapshot.close();
                        return true;
                    }
                    catch (Throwable throwable) {
                        snapshot.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        snapshot.close();
                    }
                }
                return false;
            }

            @Override
            public String next() {
                if (this.hasNext()) {
                    2 v0 = this;
                    v0.nextUrl = null;
                    v0.canRemove = true;
                    return this.nextUrl;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (this.canRemove) {
                    this.delegate.remove();
                    return;
                }
                throw new IllegalStateException("remove() before next()");
            }
        };
    }

    public synchronized int writeAbortCount() {
        return this.writeAbortCount;
    }

    public synchronized int writeSuccessCount() {
        return this.writeSuccessCount;
    }

    public long size() throws IOException {
        return this.cache.size();
    }

    public long maxSize() {
        return this.cache.getMaxSize();
    }

    @Override
    public void flush() throws IOException {
        this.cache.flush();
    }

    @Override
    public void close() throws IOException {
        this.cache.close();
    }

    public File directory() {
        return this.cache.getDirectory();
    }

    public boolean isClosed() {
        return this.cache.isClosed();
    }

    synchronized void trackResponse(CacheStrategy cacheStrategy) {
        ++this.requestCount;
        if (cacheStrategy.networkRequest != null) {
            ++this.networkCount;
        } else if (cacheStrategy.cacheResponse != null) {
            ++this.hitCount;
        }
    }

    synchronized void trackConditionalCacheHit() {
        ++this.hitCount;
    }

    public synchronized int networkCount() {
        return this.networkCount;
    }

    public synchronized int hitCount() {
        return this.hitCount;
    }

    public synchronized int requestCount() {
        return this.requestCount;
    }

    private static class CacheResponseBody
    extends ResponseBody {
        final DiskLruCache.Snapshot snapshot;
        private final BufferedSource bodySource;
        @Nullable
        private final String contentType;
        @Nullable
        private final String contentLength;

        CacheResponseBody(final DiskLruCache.Snapshot snapshot, String object, String string2) {
            this.snapshot = snapshot;
            this.contentType = object;
            this.contentLength = string2;
            object = snapshot.getSource(1);
            this.bodySource = Okio.buffer(new ForwardingSource((Source)object){

                @Override
                public void close() throws IOException {
                    1 v0 = this;
                    v0.snapshot.close();
                    super.close();
                }
            });
        }

        @Override
        public MediaType contentType() {
            String string2 = ((CacheResponseBody)((Object)string2)).contentType;
            return string2 != null ? MediaType.parse(string2) : null;
        }

        @Override
        public long contentLength() {
            long l2;
            block4: {
                block3: {
                    try {
                        String string2 = ((CacheResponseBody)((Object)string2)).contentLength;
                        if (string2 == null) break block3;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return -1L;
                    }
                    l2 = Long.parseLong(string2);
                    break block4;
                }
                l2 = -1L;
            }
            return l2;
        }

        @Override
        public BufferedSource source() {
            return this.bodySource;
        }
    }

    private static final class Entry {
        private static final String SENT_MILLIS = Platform.get().getPrefix() + "-Sent-Millis";
        private static final String RECEIVED_MILLIS = Platform.get().getPrefix() + "-Received-Millis";
        private final String url;
        private final Headers varyHeaders;
        private final String requestMethod;
        private final Protocol protocol;
        private final int code;
        private final String message;
        private final Headers responseHeaders;
        @Nullable
        private final Handshake handshake;
        private final long sentRequestMillis;
        private final long receivedResponseMillis;

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        Entry(Source var1_1) throws IOException {
            block35: {
                block34: {
                    block33: {
                        block32: {
                            super();
                            var2_2 /* !! */  = Okio.buffer(var1_1);
                            this.url = var2_2 /* !! */ .readUtf8LineStrict();
                            this.requestMethod = var2_2 /* !! */ .readUtf8LineStrict();
                            var3_3 = v0;
                            v0 = new Headers.Builder();
                            var4_4 = Cache.readInt(var2_2 /* !! */ );
                            for (var5_8 = 0; var5_8 < var4_4; ++var5_8) {
                                var3_3.addLenient(var2_2 /* !! */ .readUtf8LineStrict());
                            }
                            v1 = var2_2 /* !! */ ;
                            v2 = this;
                            v3 = v2;
                            v4 = v2;
                            v5 = v2;
                            this.varyHeaders = var3_3.build();
                            var3_3 = StatusLine.parse(var2_2 /* !! */ .readUtf8LineStrict());
                            v4.protocol = var3_3.protocol;
                            v5.code = var3_3.code;
                            v3.message = var3_3.message;
                            var3_3 = v6;
                            v6 = new Headers.Builder();
                            var4_4 = Cache.readInt(v1);
                            for (var5_8 = 0; var5_8 < var4_4; ++var5_8) {
                                var3_3.addLenient(var2_2 /* !! */ .readUtf8LineStrict());
                            }
                            v7 = var3_3;
                            var4_5 = Entry.SENT_MILLIS;
                            var5_9 = v7.get(var4_5);
                            v8 = var3_3;
                            v9 = v8;
                            v10 = v8;
                            v11 = var4_5;
                            v12 = var3_3;
                            var4_5 = Entry.RECEIVED_MILLIS;
                            var6_10 = v12.get(var4_5);
                            v9.removeAll(v11);
                            v10.removeAll(var4_5);
                            if (var5_9 != null) {
                                var4_6 = Long.parseLong((String)var5_9);
                            } else {
                                var4_6 = 0L;
                            }
                            this.sentRequestMillis = var4_6;
                            if (var6_10 == null) break block32;
                            var4_6 = Long.parseLong(var6_10);
                            break block33;
                        }
                        var4_6 = 0L;
                    }
                    this.receivedResponseMillis = var4_6;
                    this.responseHeaders = var3_3.build();
                    if (!this.isHttps()) ** GOTO lbl105
                    var3_3 = var2_2 /* !! */ .readUtf8LineStrict();
                    if (var3_3.length() > 0) ** GOTO lbl104
                    v13 = var2_2 /* !! */ ;
                    v14 = this;
                    v15 = var2_2 /* !! */ ;
                    v16 = this;
                    v17 = var2_2 /* !! */ ;
                    v18 = v17;
                    var3_3 = CipherSuite.forJavaName(v17.readUtf8LineStrict());
                    var4_7 = v16.readCertificateList(v18);
                    var5_9 = v14.readCertificateList(v15);
                    if (v13.exhausted()) break block34;
                    v19 = TlsVersion.forJavaName(var2_2 /* !! */ .readUtf8LineStrict());
lbl95:
                    // 2 sources

                    while (true) {
                        var2_2 /* !! */  = v19;
                        ** GOTO lbl102
                        break;
                    }
                }
                try {
                    v19 = TlsVersion.SSL_3_0;
                    ** continue;
lbl102:
                    // 1 sources

                    this.handshake = Handshake.get((TlsVersion)var2_2 /* !! */ , (CipherSuite)var3_3, var4_7, (List<Certificate>)var5_9);
                    break block35;
lbl104:
                    // 1 sources

                    throw new IOException("expected \"\" but was \"" + (String)var3_3 + "\"");
lbl105:
                    // 1 sources

                    this.handshake = null;
                }
                catch (Throwable v20) {
                    var1_1.close();
                    throw v20;
                }
            }
            var1_1.close();
            return;
        }

        Entry(Response response) {
            this.url = response.request().url().toString();
            this.varyHeaders = HttpHeaders.varyHeaders(response);
            this.requestMethod = response.request().method();
            this.protocol = response.protocol();
            this.code = response.code();
            this.message = response.message();
            this.responseHeaders = response.headers();
            this.handshake = response.handshake();
            this.sentRequestMillis = response.sentRequestAtMillis();
            this.receivedResponseMillis = response.receivedResponseAtMillis();
        }

        private boolean isHttps() {
            return this.url.startsWith("https://");
        }

        private List<Certificate> readCertificateList(BufferedSource bufferedSource) throws IOException {
            ArrayList<Certificate> arrayList;
            int n2 = Cache.readInt(bufferedSource);
            if (n2 == -1) {
                return Collections.emptyList();
            }
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ArrayList<Certificate> arrayList2 = arrayList;
            try {
                arrayList = new ArrayList<Certificate>(n2);
            }
            catch (CertificateException certificateException) {
                throw new IOException(certificateException.getMessage());
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                ArrayList<Certificate> arrayList3 = arrayList2;
                CertificateFactory certificateFactory2 = certificateFactory;
                String string2 = bufferedSource.readUtf8LineStrict();
                Buffer buffer = new Buffer();
                buffer.write(ByteString.decodeBase64(string2));
                arrayList3.add(certificateFactory2.generateCertificate(buffer.inputStream()));
            }
            return arrayList2;
        }

        private void writeCertList(BufferedSink bufferedSink, List<Certificate> list) throws IOException {
            int n2;
            List<Certificate> list2 = list;
            BufferedSink bufferedSink2 = bufferedSink;
            long l2 = list.size();
            bufferedSink2.writeDecimalLong(l2).writeByte(10);
            try {
                n2 = list2.size();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException(certificateEncodingException.getMessage());
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                bufferedSink.writeUtf8(ByteString.of(list.get(i2).getEncoded()).base64()).writeByte(10);
            }
            return;
        }

        public void writeTo(DiskLruCache.Editor object) throws IOException {
            object = Okio.buffer(((DiskLruCache.Editor)object).newSink(0));
            object.writeUtf8(this.url).writeByte(10);
            object.writeUtf8(this.requestMethod).writeByte(10);
            object.writeDecimalLong(this.varyHeaders.size()).writeByte(10);
            int n2 = this.varyHeaders.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                object.writeUtf8(this.varyHeaders.name(i2)).writeUtf8(": ").writeUtf8(this.varyHeaders.value(i2)).writeByte(10);
            }
            Entry entry = this;
            Protocol protocol = entry.protocol;
            n2 = entry.code;
            String string2 = entry.message;
            object.writeUtf8(new StatusLine(protocol, n2, string2).toString()).writeByte(10);
            object.writeDecimalLong(this.responseHeaders.size() + 2).writeByte(10);
            n2 = this.responseHeaders.size();
            for (int i3 = 0; i3 < n2; ++i3) {
                object.writeUtf8(this.responseHeaders.name(i3)).writeUtf8(": ").writeUtf8(this.responseHeaders.value(i3)).writeByte(10);
            }
            Object object2 = object;
            object2.writeUtf8(SENT_MILLIS).writeUtf8(": ").writeDecimalLong(this.sentRequestMillis).writeByte(10);
            object2.writeUtf8(RECEIVED_MILLIS).writeUtf8(": ").writeDecimalLong(this.receivedResponseMillis).writeByte(10);
            if (this.isHttps()) {
                Entry entry2 = this;
                Entry entry3 = this;
                object.writeByte(10);
                object.writeUtf8(this.handshake.cipherSuite().javaName()).writeByte(10);
                entry3.writeCertList((BufferedSink)object, this.handshake.peerCertificates());
                entry2.writeCertList((BufferedSink)object, entry3.handshake.localCertificates());
                object.writeUtf8(entry2.handshake.tlsVersion().javaName()).writeByte(10);
            }
            object.close();
        }

        public boolean matches(Request request, Response response) {
            return this.url.equals(request.url().toString()) && this.requestMethod.equals(request.method()) && HttpHeaders.varyMatches(response, this.varyHeaders, request);
        }

        public Response response(DiskLruCache.Snapshot snapshot) {
            Entry entry = this;
            String string2 = entry.responseHeaders.get("Content-Type");
            String string3 = entry.responseHeaders.get("Content-Length");
            Request request = new Request.Builder().url(this.url).method(this.requestMethod, null).headers(this.varyHeaders).build();
            return new Response.Builder().request(request).protocol(this.protocol).code(this.code).message(this.message).headers(this.responseHeaders).body(new CacheResponseBody(snapshot, string2, string3)).handshake(this.handshake).sentRequestAtMillis(this.sentRequestMillis).receivedResponseAtMillis(this.receivedResponseMillis).build();
        }
    }

    private final class CacheRequestImpl
    implements CacheRequest {
        private final DiskLruCache.Editor editor;
        private Sink cacheOut;
        private Sink body;
        boolean done;
        final /* synthetic */ Cache this$0;

        CacheRequestImpl(final Cache cache, final DiskLruCache.Editor editor) {
            ForwardingSink forwardingSink;
            Sink sink;
            CacheRequestImpl cacheRequestImpl = this;
            this.this$0 = cache;
            this.editor = editor;
            cacheRequestImpl.cacheOut = sink = editor.newSink(1);
            ForwardingSink forwardingSink2 = forwardingSink;
            forwardingSink = new ForwardingSink(sink){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void close() throws IOException {
                    1 v0 = this;
                    Cache cache2 = v0.CacheRequestImpl.this.this$0;
                    synchronized (cache2) {
                        CacheRequestImpl cacheRequestImpl = v0.CacheRequestImpl.this;
                        {
                            if (cacheRequestImpl.done) {
                                return;
                            }
                            1 v2 = this;
                            cacheRequestImpl.done = true;
                            ++cacheRequestImpl.this$0.writeSuccessCount;
                            // MONITOREXIT @DISABLED, blocks:[1, 2] lbl16 : MonitorExitStatement: MONITOREXIT : var1_1
                            super.close();
                            v2.editor.commit();
                            return;
                        }
                    }
                }
            };
            cacheRequestImpl.body = forwardingSink2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void abort() {
            CacheRequestImpl cacheRequestImpl;
            CacheRequestImpl cacheRequestImpl2 = this;
            Cache cache = cacheRequestImpl2.this$0;
            synchronized (cache) {
                if (cacheRequestImpl2.done) {
                    return;
                }
                CacheRequestImpl cacheRequestImpl3 = this;
                cacheRequestImpl = cacheRequestImpl3;
                this.done = true;
                ++this.this$0.writeAbortCount;
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var1_1
                Util.closeQuietly(cacheRequestImpl3.cacheOut);
            }
            try {
                cacheRequestImpl.editor.abort();
                return;
            }
            catch (IOException iOException) {}
        }

        @Override
        public Sink body() {
            return this.body;
        }
    }
}

