/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.dcloudimageloader.core.download;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

public interface ImageDownloader {
    public InputStream getStream(String var1, Object var2) throws IOException;

    public static final class Scheme
    extends Enum<Scheme> {
        public static final /* enum */ Scheme HTTP;
        public static final /* enum */ Scheme HTTPS;
        public static final /* enum */ Scheme FILE;
        public static final /* enum */ Scheme CONTENT;
        public static final /* enum */ Scheme ASSETS;
        public static final /* enum */ Scheme DRAWABLE;
        public static final /* enum */ Scheme UNKNOWN;
        private static final /* synthetic */ Scheme[] $VALUES;
        private String scheme;
        private String uriPrefix;

        public static Scheme[] values() {
            return (Scheme[])$VALUES.clone();
        }

        public static Scheme valueOf(String string2) {
            return Enum.valueOf(Scheme.class, string2);
        }

        private Scheme(String string3) {
            Scheme scheme = this;
            scheme.scheme = string3;
            scheme.uriPrefix = string3 + "://";
        }

        public static Scheme ofUri(String string2) {
            if (string2 != null) {
                for (Scheme scheme : Scheme.values()) {
                    if (!scheme.belongsTo(string2)) continue;
                    return scheme;
                }
            }
            return UNKNOWN;
        }

        private boolean belongsTo(String string2) {
            return string2.toLowerCase(Locale.US).startsWith(this.uriPrefix);
        }

        static {
            Scheme scheme;
            Scheme scheme2;
            Scheme scheme3;
            Scheme scheme4;
            Scheme scheme5;
            Scheme scheme6;
            Scheme scheme7;
            Scheme scheme8 = scheme7;
            HTTP = new Scheme("http");
            Scheme scheme9 = scheme6;
            HTTPS = new Scheme("https");
            Scheme scheme10 = scheme5;
            FILE = new Scheme("file");
            Scheme scheme11 = scheme4;
            CONTENT = new Scheme("content");
            Scheme scheme12 = scheme3;
            ASSETS = new Scheme("assets");
            Scheme scheme13 = scheme2;
            DRAWABLE = new Scheme("drawable");
            Scheme scheme14 = scheme;
            UNKNOWN = new Scheme("");
            $VALUES = new Scheme[]{scheme8, scheme9, scheme10, scheme11, scheme12, scheme13, scheme14};
        }

        public String wrap(String string2) {
            return this.uriPrefix + string2;
        }

        public String crop(String string2) {
            if (this.belongsTo(string2)) {
                return string2.substring(this.uriPrefix.length());
            }
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = string2;
            objectArray[1] = this.scheme;
            throw new IllegalArgumentException(String.format("URI [%1$s] doesn't have expected scheme [%2$s]", objectArray2));
        }
    }
}

