/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.dcloudimageloader.core.decode;

import android.annotation.TargetApi;
import android.graphics.BitmapFactory;
import android.os.Build;
import com.nostra13.dcloudimageloader.core.DisplayImageOptions;
import com.nostra13.dcloudimageloader.core.assist.ImageScaleType;
import com.nostra13.dcloudimageloader.core.assist.ImageSize;
import com.nostra13.dcloudimageloader.core.assist.ViewScaleType;
import com.nostra13.dcloudimageloader.core.download.ImageDownloader;

public class ImageDecodingInfo {
    private final String imageKey;
    private final String imageUri;
    private final ImageSize targetSize;
    private final ImageScaleType imageScaleType;
    private final ViewScaleType viewScaleType;
    private final ImageDownloader downloader;
    private final Object extraForDownloader;
    private final boolean considerExifParams;
    private final BitmapFactory.Options decodingOptions;

    public ImageDecodingInfo(String string2, String string3, ImageSize imageSize, ViewScaleType viewScaleType, ImageDownloader imageDownloader, DisplayImageOptions displayImageOptions) {
        BitmapFactory.Options options;
        ImageDecodingInfo imageDecodingInfo = imageDecodingInfo3;
        ImageDecodingInfo imageDecodingInfo2 = imageDecodingInfo3;
        imageDecodingInfo3.imageKey = string2;
        imageDecodingInfo3.imageUri = string3;
        imageDecodingInfo3.targetSize = imageSize;
        imageDecodingInfo3.imageScaleType = displayImageOptions.getImageScaleType();
        imageDecodingInfo3.viewScaleType = viewScaleType;
        imageDecodingInfo3.downloader = imageDownloader;
        imageDecodingInfo3.extraForDownloader = displayImageOptions.getExtraForDownloader();
        imageDecodingInfo2.considerExifParams = displayImageOptions.isConsiderExifParams();
        ImageDecodingInfo imageDecodingInfo3 = options;
        imageDecodingInfo2.decodingOptions = new BitmapFactory.Options();
        imageDecodingInfo.copyOptions(displayImageOptions.getDecodingOptions(), (BitmapFactory.Options)imageDecodingInfo3);
    }

    private void copyOptions(BitmapFactory.Options options, BitmapFactory.Options options2) {
        options2.inDensity = options.inDensity;
        options2.inDither = options.inDither;
        options2.inInputShareable = options.inInputShareable;
        options2.inJustDecodeBounds = options.inJustDecodeBounds;
        options2.inPreferredConfig = options.inPreferredConfig;
        options2.inPurgeable = options.inPurgeable;
        options2.inSampleSize = options.inSampleSize;
        options2.inScaled = options.inScaled;
        options2.inScreenDensity = options.inScreenDensity;
        options2.inTargetDensity = options.inTargetDensity;
        options2.inTempStorage = options.inTempStorage;
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 10) {
            this.copyOptions10(options, options2);
        }
        if (n2 >= 11) {
            this.copyOptions11(options, options2);
        }
    }

    @TargetApi(value=10)
    private void copyOptions10(BitmapFactory.Options options, BitmapFactory.Options options2) {
        options2.inPreferQualityOverSpeed = options.inPreferQualityOverSpeed;
    }

    @TargetApi(value=11)
    private void copyOptions11(BitmapFactory.Options options, BitmapFactory.Options options2) {
        options2.inBitmap = options.inBitmap;
        options2.inMutable = options.inMutable;
    }

    public String getImageKey() {
        return this.imageKey;
    }

    public String getImageUri() {
        return this.imageUri;
    }

    public ImageSize getTargetSize() {
        return this.targetSize;
    }

    public ImageScaleType getImageScaleType() {
        return this.imageScaleType;
    }

    public ViewScaleType getViewScaleType() {
        return this.viewScaleType;
    }

    public ImageDownloader getDownloader() {
        return this.downloader;
    }

    public Object getExtraForDownloader() {
        return this.extraForDownloader;
    }

    public boolean shouldConsiderExifParams() {
        return this.considerExifParams;
    }

    public BitmapFactory.Options getDecodingOptions() {
        return this.decodingOptions;
    }
}

