/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.dcloudimageloader.core.assist.deque;

import com.nostra13.dcloudimageloader.core.assist.deque.BlockingDeque;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class LinkedBlockingDeque<E>
extends AbstractQueue<E>
implements BlockingDeque<E>,
Serializable {
    private static final long serialVersionUID = -387911632671998426L;
    transient Node<E> first;
    transient Node<E> last;
    private transient int count;
    private final int capacity;
    final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;

    public LinkedBlockingDeque() {
        this(Integer.MAX_VALUE);
    }

    public LinkedBlockingDeque(int n2) {
        ReentrantLock reentrantLock;
        ReentrantLock reentrantLock2 = reentrantLock;
        this.lock = new ReentrantLock();
        this.notEmpty = reentrantLock2.newCondition();
        this.notFull = reentrantLock2.newCondition();
        if (n2 > 0) {
            this.capacity = n2;
            return;
        }
        throw new IllegalArgumentException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LinkedBlockingDeque(Collection<? extends E> object) {
        block7: {
            Object object2 = object;
            LinkedBlockingDeque<E> linkedBlockingDeque = this;
            linkedBlockingDeque(Integer.MAX_VALUE);
            object = linkedBlockingDeque.lock;
            ((ReentrantLock)object).lock();
            Iterator iterator = object2.iterator();
            while (true) {
                if (!iterator.hasNext()) break block7;
                Object e2 = iterator.next();
                if (e2 == null) throw new NullPointerException();
                if (super.linkLast(new Node(e2))) continue;
                break;
            }
            try {
                throw new IllegalStateException("Deque full");
            }
            catch (Throwable throwable) {
                ((ReentrantLock)object).unlock();
                throw throwable;
            }
        }
        ((ReentrantLock)object).unlock();
    }

    private boolean linkFirst(Node<E> node) {
        int n2 = this.count;
        if (n2 >= this.capacity) {
            return false;
        }
        Node<E> node2 = this.first;
        node.next = node2;
        this.first = node;
        if (this.last == null) {
            this.last = node;
        } else {
            node2.prev = node;
        }
        this.count = n2 + 1;
        this.notEmpty.signal();
        return true;
    }

    private boolean linkLast(Node<E> node) {
        int n2 = this.count;
        if (n2 >= this.capacity) {
            return false;
        }
        Node<E> node2 = this.last;
        node.prev = node2;
        this.last = node;
        if (this.first == null) {
            this.first = node;
        } else {
            node2.next = node;
        }
        this.count = n2 + 1;
        this.notEmpty.signal();
        return true;
    }

    private E unlinkFirst() {
        Node<E> node = this.first;
        if (node == null) {
            return null;
        }
        Node node2 = node.next;
        Object e2 = node.item;
        node.item = null;
        node.next = node;
        this.first = node2;
        if (node2 == null) {
            this.last = null;
        } else {
            node2.prev = null;
        }
        LinkedBlockingDeque linkedBlockingDeque = this;
        --linkedBlockingDeque.count;
        linkedBlockingDeque.notFull.signal();
        return e2;
    }

    private E unlinkLast() {
        Node<E> node = this.last;
        if (node == null) {
            return null;
        }
        Node node2 = node.prev;
        Object e2 = node.item;
        node.item = null;
        node.prev = node;
        this.last = node2;
        if (node2 == null) {
            this.first = null;
        } else {
            node2.next = null;
        }
        LinkedBlockingDeque linkedBlockingDeque = this;
        --linkedBlockingDeque.count;
        linkedBlockingDeque.notFull.signal();
        return e2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        LinkedBlockingDeque linkedBlockingDeque = serializable;
        Serializable serializable = ((LinkedBlockingDeque)serializable).lock;
        ((ReentrantLock)serializable).lock();
        try {
            objectOutputStream.defaultWriteObject();
            Node<E> node = linkedBlockingDeque.first;
            while (true) {
                Node<E> node2;
                if ((node2 = node) == null) {
                    objectOutputStream.writeObject(null);
                    ((ReentrantLock)serializable).unlock();
                    return;
                }
                objectOutputStream.writeObject(node2.item);
                node = node2.next;
            }
        }
        catch (Throwable throwable) {
            ((ReentrantLock)serializable).unlock();
            throw throwable;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        LinkedBlockingDeque linkedBlockingDeque = this;
        objectInputStream.defaultReadObject();
        linkedBlockingDeque.count = 0;
        linkedBlockingDeque.first = null;
        linkedBlockingDeque.last = null;
        Object object;
        while ((object = objectInputStream.readObject()) != null) {
            this.add(object);
        }
        return;
    }

    void unlink(Node<E> node) {
        Node node2 = node.prev;
        Node node3 = node.next;
        if (node2 == null) {
            this.unlinkFirst();
        } else if (node3 == null) {
            this.unlinkLast();
        } else {
            LinkedBlockingDeque linkedBlockingDeque = this;
            node2.next = node3;
            node3.prev = node2;
            node.item = null;
            --linkedBlockingDeque.count;
            linkedBlockingDeque.notFull.signal();
        }
    }

    @Override
    public void addFirst(E e2) {
        if (this.offerFirst(e2)) {
            return;
        }
        throw new IllegalStateException("Deque full");
    }

    @Override
    public void addLast(E e2) {
        if (this.offerLast(e2)) {
            return;
        }
        throw new IllegalStateException("Deque full");
    }

    @Override
    public boolean offerFirst(E object) {
        boolean bl;
        Node<E> node;
        LinkedBlockingDeque linkedBlockingDeque = node2;
        object.getClass();
        Node<E> node2 = node;
        node = new Node<E>(object);
        object = linkedBlockingDeque.lock;
        ((ReentrantLock)object).lock();
        try {
            bl = linkedBlockingDeque.linkFirst(node2);
            ((ReentrantLock)object).unlock();
        }
        catch (Throwable throwable) {
            ((ReentrantLock)object).unlock();
            throw throwable;
        }
        return bl;
    }

    @Override
    public boolean offerLast(E object) {
        boolean bl;
        Node<E> node;
        LinkedBlockingDeque linkedBlockingDeque = node2;
        object.getClass();
        Node<E> node2 = node;
        node = new Node<E>(object);
        object = linkedBlockingDeque.lock;
        ((ReentrantLock)object).lock();
        try {
            bl = linkedBlockingDeque.linkLast(node2);
            ((ReentrantLock)object).unlock();
        }
        catch (Throwable throwable) {
            ((ReentrantLock)object).unlock();
            throw throwable;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void putFirst(E object) throws InterruptedException {
        Node<Object> node;
        object.getClass();
        Node<Object> node2 = node;
        node = new Node<Object>(object);
        object = this.lock;
        ((ReentrantLock)object).lock();
        try {
            while (true) {
                if (this.linkFirst(node2)) {
                    ((ReentrantLock)object).unlock();
                    return;
                }
                this.notFull.await();
            }
        }
        catch (Throwable throwable) {
            ((ReentrantLock)object).unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void putLast(E object) throws InterruptedException {
        Node<Object> node;
        object.getClass();
        Node<Object> node2 = node;
        node = new Node<Object>(object);
        object = this.lock;
        ((ReentrantLock)object).lock();
        try {
            while (true) {
                if (this.linkLast(node2)) {
                    ((ReentrantLock)object).unlock();
                    return;
                }
                this.notFull.await();
            }
        }
        catch (Throwable throwable) {
            ((ReentrantLock)object).unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean offerFirst(E object, long l2, TimeUnit timeUnit) throws InterruptedException {
        Node<Object> node;
        object.getClass();
        Node<Object> node2 = node;
        node = new Node<Object>(object);
        long l3 = timeUnit.toNanos(l2);
        object = this.lock;
        ((ReentrantLock)object).lockInterruptibly();
        while (true) {
            try {
                if (this.linkFirst(node2)) break;
                if (l3 <= 0L) {
                    ((ReentrantLock)object).unlock();
                    return false;
                }
            }
            catch (Throwable throwable) {
                ((ReentrantLock)object).unlock();
                throw throwable;
            }
            {
                l3 = this.notFull.awaitNanos(l3);
                continue;
            }
            break;
        }
        ((ReentrantLock)object).unlock();
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean offerLast(E object, long l2, TimeUnit timeUnit) throws InterruptedException {
        Node<Object> node;
        object.getClass();
        Node<Object> node2 = node;
        node = new Node<Object>(object);
        long l3 = timeUnit.toNanos(l2);
        object = this.lock;
        ((ReentrantLock)object).lockInterruptibly();
        while (true) {
            try {
                if (this.linkLast(node2)) break;
                if (l3 <= 0L) {
                    ((ReentrantLock)object).unlock();
                    return false;
                }
            }
            catch (Throwable throwable) {
                ((ReentrantLock)object).unlock();
                throw throwable;
            }
            {
                l3 = this.notFull.awaitNanos(l3);
                continue;
            }
            break;
        }
        ((ReentrantLock)object).unlock();
        return true;
    }

    @Override
    public E removeFirst() {
        E e2 = this.pollFirst();
        if (e2 != null) {
            return e2;
        }
        throw new NoSuchElementException();
    }

    @Override
    public E removeLast() {
        E e2 = this.pollLast();
        if (e2 != null) {
            return e2;
        }
        throw new NoSuchElementException();
    }

    @Override
    public E pollFirst() {
        E e2;
        LinkedBlockingDeque linkedBlockingDeque = serializable;
        Serializable serializable = linkedBlockingDeque.lock;
        ((ReentrantLock)serializable).lock();
        try {
            e2 = linkedBlockingDeque.unlinkFirst();
            ((ReentrantLock)serializable).unlock();
        }
        catch (Throwable throwable) {
            ((ReentrantLock)serializable).unlock();
            throw throwable;
        }
        return e2;
    }

    @Override
    public E pollLast() {
        E e2;
        LinkedBlockingDeque linkedBlockingDeque = serializable;
        Serializable serializable = linkedBlockingDeque.lock;
        ((ReentrantLock)serializable).lock();
        try {
            e2 = linkedBlockingDeque.unlinkLast();
            ((ReentrantLock)serializable).unlock();
        }
        catch (Throwable throwable) {
            ((ReentrantLock)serializable).unlock();
            throw throwable;
        }
        return e2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E takeFirst() throws InterruptedException {
        E e2;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        while (true) {
            try {
                e2 = this.unlinkFirst();
                if (e2 != null) break;
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw throwable;
            }
            {
                this.notEmpty.await();
                continue;
            }
            break;
        }
        reentrantLock.unlock();
        return e2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E takeLast() throws InterruptedException {
        E e2;
        ReentrantLock reentrantLock = this.lock;
        reentrantLock.lock();
        while (true) {
            try {
                e2 = this.unlinkLast();
                if (e2 != null) break;
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw throwable;
            }
            {
                this.notEmpty.await();
                continue;
            }
            break;
        }
        reentrantLock.unlock();
        return e2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E pollFirst(long l2, TimeUnit object) throws InterruptedException {
        E e2;
        l2 = ((TimeUnit)((Object)object)).toNanos(l2);
        object = this.lock;
        ((ReentrantLock)object).lockInterruptibly();
        while (true) {
            try {
                e2 = this.unlinkFirst();
                if (e2 != null) break;
                if (l2 <= 0L) {
                    ((ReentrantLock)object).unlock();
                    return null;
                }
            }
            catch (Throwable throwable) {
                ((ReentrantLock)object).unlock();
                throw throwable;
            }
            {
                l2 = this.notEmpty.awaitNanos(l2);
                continue;
            }
            break;
        }
        ((ReentrantLock)object).unlock();
        return e2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E pollLast(long l2, TimeUnit object) throws InterruptedException {
        E e2;
        l2 = ((TimeUnit)((Object)object)).toNanos(l2);
        object = this.lock;
        ((ReentrantLock)object).lockInterruptibly();
        while (true) {
            try {
                e2 = this.unlinkLast();
                if (e2 != null) break;
                if (l2 <= 0L) {
                    ((ReentrantLock)object).unlock();
                    return null;
                }
            }
            catch (Throwable throwable) {
                ((ReentrantLock)object).unlock();
                throw throwable;
            }
            {
                l2 = this.notEmpty.awaitNanos(l2);
                continue;
            }
            break;
        }
        ((ReentrantLock)object).unlock();
        return e2;
    }

    @Override
    public E getFirst() {
        E e2 = this.peekFirst();
        if (e2 != null) {
            return e2;
        }
        throw new NoSuchElementException();
    }

    @Override
    public E getLast() {
        E e2 = this.peekLast();
        if (e2 != null) {
            return e2;
        }
        throw new NoSuchElementException();
    }

    @Override
    public E peekFirst() {
        Node<E> node;
        block4: {
            block3: {
                LinkedBlockingDeque linkedBlockingDeque = serializable;
                Serializable serializable = linkedBlockingDeque.lock;
                ((ReentrantLock)serializable).lock();
                try {
                    node = linkedBlockingDeque.first;
                    if (node != null) break block3;
                    node = null;
                    break block4;
                }
                catch (Throwable throwable) {
                    ((ReentrantLock)serializable).unlock();
                    throw throwable;
                }
            }
            node = node.item;
        }
        ((ReentrantLock)serializable).unlock();
        return (E)node;
    }

    @Override
    public E peekLast() {
        Node<E> node;
        block4: {
            block3: {
                LinkedBlockingDeque linkedBlockingDeque = serializable;
                Serializable serializable = linkedBlockingDeque.lock;
                ((ReentrantLock)serializable).lock();
                try {
                    node = linkedBlockingDeque.last;
                    if (node != null) break block3;
                    node = null;
                    break block4;
                }
                catch (Throwable throwable) {
                    ((ReentrantLock)serializable).unlock();
                    throw throwable;
                }
            }
            node = node.item;
        }
        ((ReentrantLock)serializable).unlock();
        return (E)node;
    }

    @Override
    public boolean removeFirstOccurrence(Object object) {
        Node<E> node;
        Node<E> node2;
        if (object == null) {
            return false;
        }
        LinkedBlockingDeque linkedBlockingDeque = this;
        ReentrantLock reentrantLock = linkedBlockingDeque.lock;
        reentrantLock.lock();
        try {
            node2 = linkedBlockingDeque.first;
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw throwable;
        }
        while ((node = node2) != null) {
            block7: {
                if (!object.equals(node.item)) break block7;
                this.unlink(node);
                reentrantLock.unlock();
                return true;
            }
            node2 = node.next;
        }
        reentrantLock.unlock();
        return false;
    }

    @Override
    public boolean removeLastOccurrence(Object object) {
        Node<E> node;
        Node<E> node2;
        if (object == null) {
            return false;
        }
        LinkedBlockingDeque linkedBlockingDeque = this;
        ReentrantLock reentrantLock = linkedBlockingDeque.lock;
        reentrantLock.lock();
        try {
            node2 = linkedBlockingDeque.last;
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw throwable;
        }
        while ((node = node2) != null) {
            block7: {
                if (!object.equals(node.item)) break block7;
                this.unlink(node);
                reentrantLock.unlock();
                return true;
            }
            node2 = node.prev;
        }
        reentrantLock.unlock();
        return false;
    }

    @Override
    public boolean add(E e2) {
        this.addLast(e2);
        return true;
    }

    @Override
    public boolean offer(E e2) {
        return this.offerLast(e2);
    }

    @Override
    public void put(E e2) throws InterruptedException {
        this.putLast(e2);
    }

    @Override
    public boolean offer(E e2, long l2, TimeUnit timeUnit) throws InterruptedException {
        return this.offerLast(e2, l2, timeUnit);
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E take() throws InterruptedException {
        return this.takeFirst();
    }

    @Override
    public E poll(long l2, TimeUnit timeUnit) throws InterruptedException {
        return this.pollFirst(l2, timeUnit);
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public int remainingCapacity() {
        int n2;
        LinkedBlockingDeque linkedBlockingDeque = this;
        ReentrantLock reentrantLock = linkedBlockingDeque.lock;
        reentrantLock.lock();
        try {
            n2 = linkedBlockingDeque.capacity - this.count;
            reentrantLock.unlock();
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw throwable;
        }
        return n2;
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        return this.drainTo(collection, Integer.MAX_VALUE);
    }

    @Override
    public int drainTo(Collection<? super E> collection, int n2) {
        collection.getClass();
        if (collection != this) {
            int n3;
            LinkedBlockingDeque linkedBlockingDeque = this;
            ReentrantLock reentrantLock = linkedBlockingDeque.lock;
            reentrantLock.lock();
            try {
                n3 = Math.min(n2, linkedBlockingDeque.count);
            }
            catch (Throwable throwable) {
                reentrantLock.unlock();
                throw throwable;
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                LinkedBlockingDeque linkedBlockingDeque2 = this;
                collection.add(this.first.item);
                linkedBlockingDeque2.unlinkFirst();
            }
            reentrantLock.unlock();
            return n3;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void push(E e2) {
        this.addFirst(e2);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public boolean remove(Object object) {
        return this.removeFirstOccurrence(object);
    }

    @Override
    public int size() {
        int n2;
        LinkedBlockingDeque linkedBlockingDeque = serializable;
        Serializable serializable = linkedBlockingDeque.lock;
        ((ReentrantLock)serializable).lock();
        try {
            n2 = linkedBlockingDeque.count;
            ((ReentrantLock)serializable).unlock();
        }
        catch (Throwable throwable) {
            ((ReentrantLock)serializable).unlock();
            throw throwable;
        }
        return n2;
    }

    @Override
    public boolean contains(Object object) {
        Node<E> node;
        Node<E> node2;
        if (object == null) {
            return false;
        }
        LinkedBlockingDeque linkedBlockingDeque = serializable;
        Serializable serializable = linkedBlockingDeque.lock;
        ((ReentrantLock)serializable).lock();
        try {
            node2 = linkedBlockingDeque.first;
        }
        catch (Throwable throwable) {
            ((ReentrantLock)serializable).unlock();
            throw throwable;
        }
        while ((node = node2) != null) {
            block6: {
                if (!object.equals(node.item)) break block6;
                ((ReentrantLock)serializable).unlock();
                return true;
            }
            node2 = node.next;
        }
        ((ReentrantLock)serializable).unlock();
        return false;
    }

    @Override
    public Object[] toArray() {
        Node<E> node;
        Node<E> node2;
        LinkedBlockingDeque linkedBlockingDeque = serializable;
        Serializable serializable = linkedBlockingDeque.lock;
        ((ReentrantLock)serializable).lock();
        Object[] objectArray = new Object[linkedBlockingDeque.count];
        int n2 = 0;
        try {
            node2 = linkedBlockingDeque.first;
        }
        catch (Throwable throwable) {
            ((ReentrantLock)serializable).unlock();
            throw throwable;
        }
        while ((node = node2) != null) {
            int n3 = n2++;
            objectArray[n3] = node.item;
            node2 = node.next;
        }
        ((ReentrantLock)serializable).unlock();
        return objectArray;
    }

    /*
     * Exception decompiling
     */
    @Override
    public <T> T[] toArray(T[] var1_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public String toString() {
        block10: {
            v0 = this;
            var1_1 = v0.lock;
            var1_1.lock();
            var2_2 = v0.first;
            if (var2_2 != null) break block10;
            var1_1.unlock();
            return "[]";
        }
        var3_3 = v1;
        try {
            v2 = new StringBuilder().append('[');
        }
        catch (Throwable v3) {
            var1_1.unlock();
            throw v3;
        }
        while (true) {
            var4_4 /* !! */  = var2_2.item;
            if (var4_4 /* !! */  != this) ** break block11
            var4_4 /* !! */  = "(this Collection)";
            break;
        }
        {
            block12: {
                v4 = var2_2;
                var3_3.append(var4_4 /* !! */ );
                var2_2 = v4.next;
                if (var2_2 != null) break block12;
                v5 = var3_3.append(']').toString();
                var1_1.unlock();
                return v5;
            }
            v2 = var3_3.append(',').append(' ');
            continue;
        }
    }

    @Override
    public void clear() {
        LinkedBlockingDeque linkedBlockingDeque = linkedBlockingDeque3;
        ReentrantLock reentrantLock = linkedBlockingDeque.lock;
        reentrantLock.lock();
        Node<E> node = linkedBlockingDeque.first;
        while (node != null) {
            Node<E> node2 = node;
            Node<E> node3 = node2;
            Node<E> node4 = node2;
            node2.item = null;
            node = node2.next;
            node3.prev = null;
            node4.next = null;
        }
        LinkedBlockingDeque linkedBlockingDeque2 = linkedBlockingDeque3;
        LinkedBlockingDeque linkedBlockingDeque3 = null;
        try {
            linkedBlockingDeque2.last = null;
            linkedBlockingDeque2.first = linkedBlockingDeque3;
            linkedBlockingDeque2.count = 0;
            linkedBlockingDeque2.notFull.signalAll();
            reentrantLock.unlock();
            return;
        }
        catch (Throwable throwable) {
            reentrantLock.unlock();
            throw throwable;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingItr();
    }

    private class DescendingItr
    extends AbstractItr {
        private DescendingItr() {
        }

        @Override
        Node<E> firstNode() {
            return LinkedBlockingDeque.this.last;
        }

        @Override
        Node<E> nextNode(Node<E> node) {
            return node.prev;
        }
    }

    private class Itr
    extends AbstractItr {
        private Itr() {
        }

        @Override
        Node<E> firstNode() {
            return LinkedBlockingDeque.this.first;
        }

        @Override
        Node<E> nextNode(Node<E> node) {
            return node.next;
        }
    }

    private abstract class AbstractItr
    implements Iterator<E> {
        Node<E> next;
        E nextItem;
        private Node<E> lastRet;

        AbstractItr() {
            Node node;
            block6: {
                block5: {
                    LinkedBlockingDeque.this = ((LinkedBlockingDeque)LinkedBlockingDeque.this).lock;
                    ((ReentrantLock)LinkedBlockingDeque.this).lock();
                    try {
                        node = this.firstNode();
                    }
                    catch (Throwable throwable) {
                        ((ReentrantLock)LinkedBlockingDeque.this).unlock();
                        throw throwable;
                    }
                    this.next = node;
                    if (node != null) break block5;
                    node = null;
                    break block6;
                }
                node = node.item;
            }
            this.nextItem = node;
            ((ReentrantLock)LinkedBlockingDeque.this).unlock();
        }

        private Node<E> succ(Node<E> node) {
            Node node2;
            while ((node2 = this.nextNode(node)) != null) {
                if (node2.item != null) {
                    return node2;
                }
                if (node2 == node) {
                    return this.firstNode();
                }
                node = node2;
            }
            return null;
        }

        abstract Node<E> firstNode();

        abstract Node<E> nextNode(Node<E> var1);

        void advance() {
            Node node;
            ReentrantLock reentrantLock;
            block6: {
                block5: {
                    AbstractItr abstractItr = this;
                    reentrantLock = abstractItr.LinkedBlockingDeque.this.lock;
                    reentrantLock.lock();
                    try {
                        node = abstractItr.succ(abstractItr.next);
                    }
                    catch (Throwable throwable) {
                        reentrantLock.unlock();
                        throw throwable;
                    }
                    this.next = node;
                    if (node != null) break block5;
                    node = null;
                    break block6;
                }
                node = node.item;
            }
            this.nextItem = node;
            reentrantLock.unlock();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            Node node = this.next;
            if (node != null) {
                this.lastRet = node;
                this.advance();
                return this.nextItem;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            Node node = this.lastRet;
            if (node != null) {
                ReentrantLock reentrantLock;
                block4: {
                    this.lastRet = null;
                    reentrantLock = LinkedBlockingDeque.this.lock;
                    reentrantLock.lock();
                    try {
                        if (node.item == null) break block4;
                    }
                    catch (Throwable throwable) {
                        reentrantLock.unlock();
                        throw throwable;
                    }
                    LinkedBlockingDeque.this.unlink(node);
                }
                reentrantLock.unlock();
                return;
            }
            throw new IllegalStateException();
        }
    }

    static final class Node<E> {
        E item;
        Node<E> prev;
        Node<E> next;

        Node(E e2) {
            this.item = e2;
        }
    }
}

