/*
 * Decompiled with CFR 0.152.
 */
package com.dmcbig.mediapicker.view;

import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.bumptech.glide.Glide;
import com.dcloud.android.widget.photoview.OnPhotoTapListener;
import com.dcloud.android.widget.photoview.PhotoView;
import com.dcloud.android.widget.toast.ToastCompat;
import com.dmcbig.mediapicker.MediaPickerR;
import com.dmcbig.mediapicker.PreviewActivity;
import com.dmcbig.mediapicker.entity.Media;
import io.dcloud.common.util.LoadAppUtils;

public class PreviewFragment
extends Fragment {
    private PhotoView mPhotoView;
    ImageView play_view;

    public static PreviewFragment newInstance(Media media, String string2) {
        Bundle bundle;
        PreviewFragment previewFragment = new PreviewFragment();
        string2 = bundle;
        new Bundle().putParcelable("media", (Parcelable)media);
        previewFragment.setArguments((Bundle)string2);
        return previewFragment;
    }

    private boolean isIntentAvailable(Context context, Intent intent) {
        return context.getPackageManager().queryIntentActivities(intent, 0).size() > 0;
    }

    public void onCreate(@Nullable Bundle bundle) {
        PreviewFragment previewFragment = this;
        previewFragment.setRetainInstance(true);
        super.onCreate(bundle);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return layoutInflater.inflate(MediaPickerR.MP_LAYOUT_PREVIEW_FRAGMENT_ITEM, viewGroup, false);
    }

    public void onViewCreated(View view, Bundle object) {
        PreviewFragment previewFragment = this;
        super.onViewCreated(view, object);
        object = (Media)previewFragment.getArguments().getParcelable("media");
        this.play_view = (ImageView)view.findViewById(MediaPickerR.MP_ID_PLAY_VIEW);
        this.mPhotoView = (PhotoView)view.findViewById(MediaPickerR.MP_ID_PHOTOVIEW);
        this.mPhotoView.setMaximumScale(5.0f);
        this.mPhotoView.setOnPhotoTapListener(new OnPhotoTapListener(){

            @Override
            public void onPhotoTap(ImageView imageView, float f2, float f3) {
                ((PreviewActivity)PreviewFragment.this.getActivity()).setBarStatus();
            }
        });
        this.setPlayView((Media)object);
        view = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        int n2 = object.mediaType;
        if (n2 != 1 && n2 == 3) {
            view = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
        }
        view = ContentUris.withAppendedId((Uri)view, (long)object.id);
        Glide.with((FragmentActivity)this.getActivity()).load((Uri)view).into((ImageView)this.mPhotoView);
    }

    void setPlayView(final Media media) {
        if (media.mediaType == 3) {
            PreviewFragment previewFragment = this;
            previewFragment.play_view.setVisibility(0);
            previewFragment.play_view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    2 v0 = this;
                    view = LoadAppUtils.getDataAndTypeIntent(v0.PreviewFragment.this.getContext(), media.path, "video/*");
                    PreviewFragment previewFragment = v0.PreviewFragment.this;
                    if (previewFragment.isIntentAvailable(previewFragment.getContext(), (Intent)view)) {
                        PreviewFragment.this.startActivity((Intent)view);
                    } else {
                        ToastCompat.makeText(PreviewFragment.this.getContext(), PreviewFragment.this.getString(MediaPickerR.MP_STRING_CANT_PLAY_VIDEO), 0).show();
                    }
                }
            });
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
    }
}

