/*
 * Decompiled with CFR 0.152.
 */
package com.dmcbig.mediapicker.utils;

import android.content.Context;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Locale;

public class FileUtils {
    private static final String JPEG_FILE_PREFIX = "IMG_";
    private static final String JPEG_FILE_SUFFIX = ".jpg";
    private static final String EXTERNAL_STORAGE_PERMISSION = "android.permission.WRITE_EXTERNAL_STORAGE";
    private static final long MB = 0x100000L;

    public static File createTmpFile(Context context) throws IOException {
        File file;
        if (TextUtils.equals((CharSequence)Environment.getExternalStorageState(), (CharSequence)"mounted")) {
            file = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM);
            if (!file.exists() && !(file = Environment.getExternalStoragePublicDirectory((String)(Environment.DIRECTORY_DCIM + "/Camera"))).exists()) {
                file = FileUtils.getCacheDirectory(context, true);
            }
        } else {
            file = FileUtils.getCacheDirectory(context, true);
        }
        return File.createTempFile(JPEG_FILE_PREFIX, JPEG_FILE_SUFFIX, file);
    }

    public static File getCacheDirectory(Context context) {
        return FileUtils.getCacheDirectory(context, true);
    }

    public static String getRealPathFromURI(Context object, Uri uri) {
        if ((object = object.getContentResolver().query(uri, null, null, null, null)) == null) {
            object = uri.getPath();
        } else {
            Context context = object;
            context.moveToFirst();
            object = context.getString(context.getColumnIndex("_data"));
            context.close();
        }
        return object;
    }

    public static File getCacheDirectory(Context object, boolean bl) {
        String string2;
        File file;
        block6: {
            file = null;
            try {
                string2 = Environment.getExternalStorageState();
                break block6;
            }
            catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            }
            catch (NullPointerException nullPointerException) {}
            string2 = "";
        }
        if (bl && "mounted".equals(string2) && FileUtils.hasExternalStoragePermission(object)) {
            file = FileUtils.getExternalCacheDir(object);
        }
        if (file == null) {
            file = object.getCacheDir();
        }
        if (file == null) {
            File file2;
            object = "/data/data/" + object.getPackageName() + "/cache/";
            file = file2;
            file2 = new File((String)object);
        }
        return file;
    }

    public static File getIndividualCacheDirectory(Context object, String string2) {
        File file;
        object = FileUtils.getCacheDirectory(object);
        File file2 = file;
        if (!new File((File)object, string2).exists() && !file2.mkdir()) {
            file2 = object;
        }
        return file2;
    }

    private static File getExternalCacheDir(Context context) {
        File file;
        File file2;
        File file3 = file2;
        file2 = new File(new File(Environment.getExternalStorageDirectory(), "Android"), "data");
        File file4 = file;
        if (!new File(new File(file3, context.getPackageName()), "cache").exists()) {
            if (!file4.mkdirs()) {
                return null;
            }
            try {
                new File(file4, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {}
        }
        return file4;
    }

    private static boolean hasExternalStoragePermission(Context context) {
        return context.checkCallingOrSelfPermission(EXTERNAL_STORAGE_PERMISSION) == 0;
    }

    public static String fileSize(long l2) {
        DecimalFormat decimalFormat;
        if (l2 <= 0L) {
            return "0";
        }
        String[] stringArray = new String[5];
        String[] stringArray2 = stringArray;
        stringArray[0] = "B";
        stringArray[1] = "kB";
        stringArray[2] = "MB";
        stringArray[3] = "GB";
        stringArray[4] = "TB";
        double d2 = l2;
        int n2 = (int)(Math.log10(d2) / Math.log10(1024.0));
        DecimalFormat decimalFormat2 = decimalFormat;
        double d3 = d2;
        decimalFormat2("#,##0.#");
        d2 = n2;
        return decimalFormat.format(d3 / Math.pow(1024.0, d2)) + " " + stringArray2[n2];
    }

    public static String getMimeType(Context object, Uri uri) {
        String string2;
        if ("content".equals(uri.getScheme())) {
            object = MimeTypeMap.getSingleton().getExtensionFromMimeType(object.getContentResolver().getType(uri));
            if (TextUtils.isEmpty((CharSequence)object)) {
                object = MimeTypeMap.getFileExtensionFromUrl((String)Uri.fromFile((File)new File(uri.getPath())).toString());
                string2 = object;
            } else {
                string2 = object;
            }
        } else {
            string2 = MimeTypeMap.getFileExtensionFromUrl((String)Uri.fromFile((File)new File(uri.getPath())).toString());
            if (TextUtils.isEmpty((CharSequence)string2)) {
                string2 = MimeTypeMap.getSingleton().getExtensionFromMimeType(object.getContentResolver().getType(uri));
            }
        }
        return string2;
    }

    public static String getMimeTypeByFileName(String string2) {
        String string3 = string2;
        int n2 = string3.lastIndexOf(".");
        return string3.substring(n2, string3.length());
    }

    public String getSizeByUnit(double d2) {
        if (d2 == 0.0) {
            return "0K";
        }
        if (d2 >= 1048576.0) {
            double d3 = d2 / 1048576.0;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = d3;
            return String.format(Locale.US, "%.1f", objectArray2) + "M";
        }
        double d4 = d2 / 1024.0;
        Object[] objectArray = new Object[1];
        Object[] objectArray3 = objectArray;
        objectArray[0] = d4;
        return String.format(Locale.US, "%.1f", objectArray3) + "K";
    }
}

