/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.qrcode.detector;

import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.ResultPointCallback;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.qrcode.detector.AlignmentPattern;
import java.util.ArrayList;
import java.util.List;

final class AlignmentPatternFinder {
    private final BitMatrix image;
    private final List<AlignmentPattern> possibleCenters;
    private final int startX;
    private final int startY;
    private final int width;
    private final int height;
    private final float moduleSize;
    private final int[] crossCheckStateCount;
    private final ResultPointCallback resultPointCallback;

    AlignmentPatternFinder(BitMatrix bitMatrix, int n2, int n3, int n4, int n5, float f2, ResultPointCallback resultPointCallback) {
        AlignmentPatternFinder alignmentPatternFinder = this;
        AlignmentPatternFinder alignmentPatternFinder2 = this;
        alignmentPatternFinder2.image = bitMatrix;
        alignmentPatternFinder2.possibleCenters = new ArrayList<AlignmentPattern>(5);
        this.startX = n2;
        this.startY = n3;
        this.width = n4;
        this.height = n5;
        alignmentPatternFinder.moduleSize = f2;
        alignmentPatternFinder.crossCheckStateCount = new int[3];
        this.resultPointCallback = resultPointCallback;
    }

    private static float centerFromEnd(int[] nArray, int n2) {
        return (float)(n2 - nArray[2]) - (float)nArray[1] / 2.0f;
    }

    private boolean foundPatternCross(int[] nArray) {
        float f2 = this.moduleSize;
        float f3 = f2 / 2.0f;
        for (int i2 = 0; i2 < 3; ++i2) {
            if (!(Math.abs(f2 - (float)nArray[i2]) >= f3)) continue;
            return false;
        }
        return true;
    }

    private float crossCheckVertical(int n2, int n3, int n4, int n5) {
        int n6;
        AlignmentPatternFinder alignmentPatternFinder = this;
        BitMatrix bitMatrix = alignmentPatternFinder.image;
        int n7 = bitMatrix.getHeight();
        int[] nArray = alignmentPatternFinder.crossCheckStateCount;
        int[] nArray2 = alignmentPatternFinder.crossCheckStateCount;
        int[] nArray3 = nArray;
        nArray2[0] = 0;
        nArray[1] = 0;
        nArray2[2] = 0;
        for (n6 = n2; n6 >= 0 && bitMatrix.get(n3, n6) && nArray3[1] <= n4; --n6) {
            nArray3[1] = nArray3[1] + 1;
        }
        if (n6 >= 0 && nArray3[1] <= n4) {
            while (n6 >= 0 && !bitMatrix.get(n3, n6) && nArray3[0] <= n4) {
                nArray3[0] = nArray3[0] + 1;
                --n6;
            }
            if (nArray3[0] > n4) {
                return Float.NaN;
            }
            ++n2;
            while (n2 < n7 && bitMatrix.get(n3, n2) && nArray3[1] <= n4) {
                nArray3[1] = nArray3[1] + 1;
                ++n2;
            }
            if (n2 != n7 && nArray3[1] <= n4) {
                while (n2 < n7 && !bitMatrix.get(n3, n2) && nArray3[2] <= n4) {
                    nArray3[2] = nArray3[2] + 1;
                    ++n2;
                }
                if (nArray3[2] > n4) {
                    return Float.NaN;
                }
                if (Math.abs(nArray3[0] + nArray3[1] + nArray3[2] - n5) * 5 >= n5 * 2) {
                    return Float.NaN;
                }
                return this.foundPatternCross(nArray3) ? AlignmentPatternFinder.centerFromEnd(nArray3, n2) : Float.NaN;
            }
            return Float.NaN;
        }
        return Float.NaN;
    }

    private AlignmentPattern handlePossibleCenter(int[] nArray, int n2, int n3) {
        int n4 = n2;
        n2 = nArray[0] + nArray[1] + nArray[2];
        float f2 = AlignmentPatternFinder.centerFromEnd(nArray, n3);
        int n5 = (int)f2;
        float f3 = ((AlignmentPatternFinder)((Object)alignmentPattern3)).crossCheckVertical(n4, n5, nArray[1] * 2, n2);
        if (!Float.isNaN(f3)) {
            AlignmentPattern alignmentPattern;
            float f4 = (float)(nArray[0] + nArray[1] + nArray[2]) / 3.0f;
            for (AlignmentPattern alignmentPattern2 : ((AlignmentPatternFinder)((Object)alignmentPattern3)).possibleCenters) {
                if (!alignmentPattern2.aboutEquals(f4, f3, f2)) continue;
                return alignmentPattern2.combineEstimate(f3, f2, f4);
            }
            AlignmentPatternFinder alignmentPatternFinder = alignmentPattern3;
            AlignmentPattern alignmentPattern3 = alignmentPattern;
            alignmentPattern = new AlignmentPattern(f2, f3, f4);
            alignmentPatternFinder.possibleCenters.add(alignmentPattern3);
            ResultPointCallback resultPointCallback = alignmentPatternFinder.resultPointCallback;
            if (resultPointCallback != null) {
                resultPointCallback.foundPossibleResultPoint(alignmentPattern3);
            }
        }
        return null;
    }

    AlignmentPattern find() throws NotFoundException {
        AlignmentPatternFinder alignmentPatternFinder = this;
        int n2 = alignmentPatternFinder.startX;
        AlignmentPatternFinder alignmentPatternFinder2 = this;
        int n3 = alignmentPatternFinder2.height;
        int n4 = n2 + alignmentPatternFinder2.width;
        int n5 = alignmentPatternFinder.startY + n3 / 2;
        int[] nArray = new int[3];
        for (int i2 = 0; i2 < n3; ++i2) {
            AlignmentPattern alignmentPattern;
            int n6;
            int n7 = (i2 & 1) == 0 ? (i2 + 1) / 2 : -((i2 + 1) / 2);
            int[] nArray2 = nArray;
            n7 = n5 + n7;
            nArray2[0] = 0;
            nArray2[1] = 0;
            nArray[2] = 0;
            for (n6 = n2; n6 < n4 && !this.image.get(n6, n7); ++n6) {
            }
            int n8 = 0;
            while (n6 < n4) {
                if (this.image.get(n6, n7)) {
                    if (n8 == 1) {
                        nArray[n8] = nArray[n8] + 1;
                    } else if (n8 == 2) {
                        AlignmentPattern alignmentPattern2;
                        if (this.foundPatternCross(nArray) && (alignmentPattern2 = this.handlePossibleCenter(nArray, n7, n6)) != null) {
                            return alignmentPattern2;
                        }
                        int[] nArray3 = nArray;
                        int[] nArray4 = nArray;
                        nArray4[0] = nArray3[2];
                        nArray3[1] = 1;
                        nArray4[2] = 0;
                        n8 = 1;
                    } else {
                        nArray[++n8] = nArray[n8] + 1;
                    }
                } else {
                    if (n8 == 1) {
                        ++n8;
                    }
                    nArray[n8] = nArray[n8] + 1;
                }
                ++n6;
            }
            if (!this.foundPatternCross(nArray) || (alignmentPattern = this.handlePossibleCenter(nArray, n7, n4)) == null) continue;
            return alignmentPattern;
        }
        if (!this.possibleCenters.isEmpty()) {
            return this.possibleCenters.get(0);
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

