/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.qrcode.decoder;

import com.dcloud.zxing2.ChecksumException;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.common.DecoderResult;
import com.dcloud.zxing2.common.reedsolomon.GenericGF;
import com.dcloud.zxing2.common.reedsolomon.ReedSolomonDecoder;
import com.dcloud.zxing2.common.reedsolomon.ReedSolomonException;
import com.dcloud.zxing2.qrcode.decoder.BitMatrixParser;
import com.dcloud.zxing2.qrcode.decoder.DataBlock;
import com.dcloud.zxing2.qrcode.decoder.DecodedBitStreamParser;
import com.dcloud.zxing2.qrcode.decoder.ErrorCorrectionLevel;
import com.dcloud.zxing2.qrcode.decoder.QRCodeDecoderMetaData;
import com.dcloud.zxing2.qrcode.decoder.Version;
import java.util.Map;

public final class Decoder {
    private final ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(GenericGF.QR_CODE_FIELD_256);

    private DecoderResult decode(BitMatrixParser object, Map<DecodeHintType, ?> map) throws FormatException, ChecksumException {
        BitMatrixParser bitMatrixParser = object;
        object = bitMatrixParser.readVersion();
        ErrorCorrectionLevel errorCorrectionLevel = bitMatrixParser.readFormatInformation().getErrorCorrectionLevel();
        DataBlock[] dataBlockArray = DataBlock.getDataBlocks(bitMatrixParser.readCodewords(), (Version)object, errorCorrectionLevel);
        int n2 = 0;
        int n3 = dataBlockArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += dataBlockArray[i2].getNumDataCodewords();
        }
        byte[] byArray = new byte[n2];
        n3 = 0;
        for (DataBlock dataBlock : dataBlockArray) {
            byte[] byArray2 = dataBlock.getCodewords();
            int n4 = dataBlock.getNumDataCodewords();
            this.correctErrors(byArray2, n4);
            for (int i3 = 0; i3 < n4; ++i3) {
                int n5 = n3 + 1;
                byArray[n3] = byArray2[i3];
                n3 = n5;
            }
        }
        return DecodedBitStreamParser.decode(byArray, (Version)object, errorCorrectionLevel, map);
    }

    private void correctErrors(byte[] byArray, int n2) throws ChecksumException {
        int n3 = byArray.length;
        int[] nArray = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = byArray[i2] & 0xFF;
        }
        int n4 = byArray.length - n2;
        try {
            this.rsDecoder.decode(nArray, n4);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw ChecksumException.getChecksumInstance();
        }
        for (n4 = 0; n4 < n2; ++n4) {
            byArray[n4] = (byte)nArray[n4];
        }
        return;
    }

    public DecoderResult decode(boolean[][] blArray) throws ChecksumException, FormatException {
        return this.decode(blArray, null);
    }

    public DecoderResult decode(boolean[][] blArray, Map<DecodeHintType, ?> map) throws ChecksumException, FormatException {
        BitMatrix bitMatrix;
        int n2 = blArray.length;
        BitMatrix bitMatrix2 = bitMatrix;
        bitMatrix = new BitMatrix(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                if (!blArray[i2][i3]) continue;
                bitMatrix2.set(i3, i2);
            }
        }
        return this.decode(bitMatrix2, map);
    }

    public DecoderResult decode(BitMatrix bitMatrix) throws ChecksumException, FormatException {
        return this.decode(bitMatrix, null);
    }

    /*
     * WARNING - void declaration
     */
    public DecoderResult decode(BitMatrix bitMatrix, Map<DecodeHintType, ?> map) throws FormatException, ChecksumException {
        BitMatrixParser bitMatrixParser;
        BitMatrixParser bitMatrixParser2 = bitMatrixParser;
        bitMatrixParser2(bitMatrix);
        bitMatrix = null;
        Object var4_8 = null;
        try {
            return this.decode(bitMatrixParser, map);
        }
        catch (ChecksumException checksumException) {
        }
        catch (FormatException formatException) {
            // empty catch block
        }
        Decoder decoder = this;
        BitMatrixParser bitMatrixParser3 = bitMatrixParser2;
        Map<DecodeHintType, ?> map2 = map;
        BitMatrixParser bitMatrixParser4 = bitMatrixParser2;
        BitMatrixParser bitMatrixParser5 = bitMatrixParser4;
        BitMatrixParser bitMatrixParser6 = bitMatrixParser4;
        bitMatrixParser4.remask();
        bitMatrixParser4.setMirror(true);
        bitMatrixParser4.readVersion();
        bitMatrixParser6.readFormatInformation();
        try {
            bitMatrixParser5.mirror();
            DecoderResult decoderResult = decoder.decode(bitMatrixParser3, map2);
            decoderResult.setOther(new QRCodeDecoderMetaData(true));
            return decoderResult;
        }
        catch (ChecksumException checksumException) {
        }
        catch (FormatException formatException) {
            // empty catch block
        }
        if (bitMatrix == null) {
            void var0_3;
            if (var4_8 != null) {
                throw var4_8;
            }
            throw var0_3;
        }
        throw bitMatrix;
    }
}

