/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.EncodeHintType;
import com.dcloud.zxing2.WriterException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.oned.OneDimensionalCodeWriter;
import com.dcloud.zxing2.oned.UPCEANReader;
import com.dcloud.zxing2.oned.UPCEANWriter;
import com.dcloud.zxing2.oned.UPCEReader;
import java.util.Map;

public final class UPCEWriter
extends UPCEANWriter {
    private static final int CODE_WIDTH = 51;

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat == BarcodeFormat.UPC_E) {
            return super.encode(string2, barcodeFormat, n2, n3, map);
        }
        throw new IllegalArgumentException("Can only encode UPC_E, but got " + (Object)((Object)barcodeFormat));
    }

    @Override
    public boolean[] encode(String string2) {
        if (string2.length() == 8) {
            int n2 = UPCEReader.CHECK_DIGIT_ENCODINGS[Integer.parseInt(string2.substring(7, 8))];
            boolean[] blArray = new boolean[51];
            int n3 = OneDimensionalCodeWriter.appendPattern(blArray, 0, UPCEANReader.START_END_PATTERN, true) + 0;
            int n4 = 1;
            while (n4 <= 6) {
                int n5 = n4;
                int n6 = n5 + 1;
                int n7 = Integer.parseInt(string2.substring(n5, n6));
                if ((n2 >> 6 - n4 & 1) == 1) {
                    n7 += 10;
                }
                n3 += OneDimensionalCodeWriter.appendPattern(blArray, n3, UPCEANReader.L_AND_G_PATTERNS[n7], false);
                n4 = n6;
            }
            OneDimensionalCodeWriter.appendPattern(blArray, n3, UPCEANReader.END_PATTERN, false);
            return blArray;
        }
        throw new IllegalArgumentException("Requested contents should be 8 digits long, but got " + string2.length());
    }
}

