/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.ChecksumException;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.oned.OneDReader;
import java.util.Arrays;
import java.util.Map;

public final class Code39Reader
extends OneDReader {
    static final String ALPHABET_STRING = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%";
    private static final String CHECK_DIGIT_STRING = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";
    static final int[] CHARACTER_ENCODINGS = new int[]{52, 289, 97, 352, 49, 304, 112, 37, 292, 100, 265, 73, 328, 25, 280, 88, 13, 268, 76, 28, 259, 67, 322, 19, 274, 82, 7, 262, 70, 22, 385, 193, 448, 145, 400, 208, 133, 388, 196, 148, 168, 162, 138, 42};
    static final int ASTERISK_ENCODING = CHARACTER_ENCODINGS[39];
    private final boolean usingCheckDigit;
    private final boolean extendedMode;
    private final StringBuilder decodeRowResult;
    private final int[] counters;

    public Code39Reader() {
        this(false);
    }

    public Code39Reader(boolean bl) {
        this(bl, false);
    }

    public Code39Reader(boolean bl, boolean bl2) {
        Code39Reader code39Reader = this;
        this.usingCheckDigit = bl;
        code39Reader.extendedMode = bl2;
        code39Reader.decodeRowResult = new StringBuilder(20);
        code39Reader.counters = new int[9];
    }

    private static int[] findAsteriskPattern(BitArray bitArray, int[] nArray) throws NotFoundException {
        int n2;
        int n3 = bitArray.getSize();
        int n4 = 0;
        int n5 = 0;
        int n6 = nArray.length;
        int n7 = n5;
        int n8 = n4;
        n4 = n2;
        n5 = n8;
        int n9 = n7;
        for (n2 = (v102853).getNextSet(0); n2 < n3; ++n2) {
            if ((bitArray.get(n2) ^ n9) != 0) {
                nArray[n5] = nArray[n5] + 1;
                continue;
            }
            int n10 = n6 - 1;
            if (n5 == n10) {
                if (Code39Reader.toNarrowWidePattern(nArray) == ASTERISK_ENCODING && bitArray.isRange(Math.max(0, n4 - (n2 - n4) / 2), n4, false)) {
                    return new int[]{n4, n2};
                }
                int n11 = n10;
                n4 += nArray[0] + nArray[1];
                n10 = n6 - 2;
                System.arraycopy(nArray, 2, nArray, 0, n10);
                nArray[n10] = 0;
                nArray[n11] = 0;
                --n5;
            } else {
                ++n5;
            }
            nArray[n5] = 1;
            n9 ^= 1;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int toNarrowWidePattern(int[] nArray) {
        int n2 = nArray.length;
        int n3 = 0;
        while (true) {
            int n4;
            int n52;
            int n6 = Integer.MAX_VALUE;
            for (int n52 : nArray) {
                if (n52 >= n6 || n52 <= n3) {
                    n52 = n6;
                }
                n6 = n52;
            }
            n3 = 0;
            int n7 = 0;
            int n8 = 0;
            for (n52 = 0; n52 < n2; ++n52) {
                n4 = nArray[n52];
                if (n4 <= n6) continue;
                n8 |= 1 << n2 - 1 - n52;
                ++n3;
                n7 += n4;
            }
            if (n3 == 3) {
                for (n52 = 0; n52 < n2 && n3 > 0; ++n52) {
                    n4 = nArray[n52];
                    if (n4 <= n6) continue;
                    --n3;
                    if (n4 * 2 < n7) continue;
                    return -1;
                }
                return n8;
            }
            if (n3 <= 3) {
                return -1;
            }
            n3 = n6;
        }
    }

    private static char patternToChar(int n2) throws NotFoundException {
        int n3 = 0;
        while (true) {
            int[] nArray = CHARACTER_ENCODINGS;
            if (n3 >= CHARACTER_ENCODINGS.length) break;
            if (nArray[n3] == n2) {
                return ALPHABET_STRING.charAt(n3);
            }
            ++n3;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static String decodeExtended(CharSequence charSequence) throws FormatException {
        StringBuilder stringBuilder;
        int n2 = charSequence.length();
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            block14: {
                char c2;
                block8: {
                    char c3;
                    block5: {
                        block13: {
                            block12: {
                                block6: {
                                    block11: {
                                        block7: {
                                            block10: {
                                                block9: {
                                                    char c4 = charSequence.charAt(i2);
                                                    if (c4 != '+' && c4 != '$' && c4 != '%' && c4 != '/') {
                                                        stringBuilder2.append(c4);
                                                        continue;
                                                    }
                                                    c3 = charSequence.charAt(++i2);
                                                    c2 = '\u0000';
                                                    if (c4 == '$') break block5;
                                                    if (c4 == '%') break block6;
                                                    if (c4 == '+') break block7;
                                                    if (c4 != '/') break block8;
                                                    if (c3 < 'A' || c3 > 'O') break block9;
                                                    c2 = (char)(c3 - 32);
                                                    break block8;
                                                }
                                                if (c3 != 'Z') break block10;
                                                c2 = (char)58;
                                                break block8;
                                            }
                                            throw FormatException.getFormatInstance();
                                        }
                                        if (c3 < 'A' || c3 > 'Z') break block11;
                                        c2 = (char)(c3 + 32);
                                        break block8;
                                    }
                                    throw FormatException.getFormatInstance();
                                }
                                if (c3 < 'A' || c3 > 'E') break block12;
                                c2 = (char)(c3 - 38);
                                break block8;
                            }
                            if (c3 < 'F' || c3 > 'W') break block13;
                            c2 = (char)(c3 - 11);
                            break block8;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    if (c3 < 'A' || c3 > 'Z') break block14;
                    c2 = (char)(c3 - 64);
                }
                stringBuilder2.append(c2);
                continue;
            }
            throw FormatException.getFormatInstance();
        }
        return stringBuilder2.toString();
    }

    @Override
    public Result decodeRow(int n2, BitArray bitArray, Map<DecodeHintType, ?> object) throws NotFoundException, ChecksumException, FormatException {
        BitArray bitArray2 = bitArray;
        Code39Reader code39Reader = object3;
        object = code39Reader.counters;
        Arrays.fill(code39Reader.counters, 0);
        Object object2 = code39Reader.decodeRowResult;
        ((StringBuilder)object2).setLength(0);
        int[] nArray = Code39Reader.findAsteriskPattern(bitArray2, (int[])object);
        int n3 = bitArray2.getNextSet(nArray[1]);
        int n4 = bitArray2.getSize();
        while (true) {
            int n5;
            OneDReader.recordPattern(bitArray, n3, (int[])object);
            int n6 = Code39Reader.toNarrowWidePattern((int[])object);
            if (n6 < 0) break;
            char c2 = Code39Reader.patternToChar(n6);
            n6 = c2;
            ((StringBuilder)object2).append(c2);
            int n7 = ((Object)object).length;
            int n8 = n3;
            for (n5 = 0; n5 < n7; ++n5) {
                n8 += object[n5];
            }
            int n9 = n6;
            n6 = bitArray.getNextSet(n8);
            if (n9 == 42) {
                StringBuilder stringBuilder = object2;
                stringBuilder.setLength(stringBuilder.length() - 1);
                int n10 = 0;
                n7 = ((Object)object).length;
                for (n5 = 0; n5 < n7; ++n5) {
                    n10 += object[n5];
                }
                int n11 = n6 - n3 - n10;
                if (n6 != n4 && n11 * 2 < n10) {
                    throw NotFoundException.getNotFoundInstance();
                }
                if (object3.usingCheckDigit) {
                    n11 = ((StringBuilder)object2).length() - 1;
                    n4 = 0;
                    for (n6 = 0; n6 < n11; ++n6) {
                        n4 += CHECK_DIGIT_STRING.indexOf(object3.decodeRowResult.charAt(n6));
                    }
                    if (((StringBuilder)object2).charAt(n11) == CHECK_DIGIT_STRING.charAt(n4 % 43)) {
                        ((StringBuilder)object2).setLength(n11);
                    } else {
                        throw ChecksumException.getChecksumInstance();
                    }
                }
                if (((StringBuilder)object2).length() != 0) {
                    ResultPoint resultPoint;
                    ResultPoint resultPoint2;
                    Object object3 = object3.extendedMode ? Code39Reader.decodeExtended((CharSequence)object2) : ((StringBuilder)object2).toString();
                    float f2 = (float)(nArray[1] + nArray[0]) / 2.0f;
                    float f3 = (float)n3 + (float)n10 / 2.0f;
                    ResultPoint[] resultPointArray = object3;
                    ResultPoint[] resultPointArray2 = new ResultPoint[2];
                    object3 = resultPointArray2;
                    object2 = resultPoint2;
                    float f4 = n2;
                    resultPoint2 = new ResultPoint(f2, f4);
                    resultPointArray2[0] = object2;
                    ResultPoint resultPoint3 = resultPoint;
                    resultPoint = new ResultPoint(f3, f4);
                    resultPointArray2[1] = resultPoint3;
                    BarcodeFormat barcodeFormat = BarcodeFormat.CODE_39;
                    return new Result((String)resultPointArray, null, (ResultPoint[])object3, barcodeFormat);
                }
                throw NotFoundException.getNotFoundInstance();
            }
            n3 = n6;
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

