/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.EncodeHintType;
import com.dcloud.zxing2.WriterException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.oned.Code128Reader;
import com.dcloud.zxing2.oned.OneDimensionalCodeWriter;
import java.util.ArrayList;
import java.util.Map;

public final class Code128Writer
extends OneDimensionalCodeWriter {
    private static final int CODE_START_B = 104;
    private static final int CODE_START_C = 105;
    private static final int CODE_CODE_B = 100;
    private static final int CODE_CODE_C = 99;
    private static final int CODE_STOP = 106;
    private static final char ESCAPE_FNC_1 = '\u00f1';
    private static final char ESCAPE_FNC_2 = '\u00f2';
    private static final char ESCAPE_FNC_3 = '\u00f3';
    private static final char ESCAPE_FNC_4 = '\u00f4';
    private static final int CODE_FNC_1 = 102;
    private static final int CODE_FNC_2 = 97;
    private static final int CODE_FNC_3 = 96;
    private static final int CODE_FNC_4_B = 100;

    private static boolean isDigits(CharSequence charSequence, int n2, int n3) {
        n3 = n2 + n3;
        int n4 = charSequence.length();
        while (n2 < n3 && n2 < n4) {
            char c2 = charSequence.charAt(n2);
            if (c2 < '0' || c2 > '9') {
                if (c2 != '\u00f1') {
                    return false;
                }
                ++n3;
            }
            ++n2;
        }
        return n3 <= n4;
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat == BarcodeFormat.CODE_128) {
            return super.encode(string2, barcodeFormat, n2, n3, map);
        }
        throw new IllegalArgumentException("Can only encode CODE_128, but got " + (Object)((Object)barcodeFormat));
    }

    @Override
    public boolean[] encode(String object) {
        int n2;
        block15: {
            ArrayList<int[]> arrayList;
            int n3;
            n2 = ((String)object).length();
            if (n2 < 1 || n2 > 80) break block15;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 = ((String)object).charAt(i2);
                if (n3 >= 32 && n3 <= 126) continue;
                switch (n3) {
                    default: {
                        throw new IllegalArgumentException("Bad character in input: " + (char)n3);
                    }
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                }
            }
            Object object2 = arrayList;
            arrayList = new ArrayList<int[]>();
            n3 = 0;
            int n4 = 1;
            int n5 = 0;
            int n6 = 0;
            while (n6 < n2) {
                int n7;
                block18: {
                    block16: {
                        block17: {
                            n7 = n5 == 99 ? 2 : 4;
                            if ((n7 = Code128Writer.isDigits((CharSequence)object, n6, n7) ? 99 : 100) != n5) break block16;
                            switch (((String)object).charAt(n6)) {
                                default: {
                                    if (n5 != 100) break;
                                    n7 = ((String)object).charAt(n6) - 32;
                                    break block17;
                                }
                                case '\u00f4': {
                                    n7 = 100;
                                    break block17;
                                }
                                case '\u00f3': {
                                    n7 = 96;
                                    break block17;
                                }
                                case '\u00f2': {
                                    n7 = 97;
                                    break block17;
                                }
                                case '\u00f1': {
                                    n7 = 102;
                                    break block17;
                                }
                            }
                            int n8 = n6++;
                            n7 = Integer.parseInt(((String)object).substring(n8, n8 + 2));
                        }
                        ++n6;
                        int n9 = n7;
                        n7 = n5;
                        n5 = n9;
                        break block18;
                    }
                    n5 = n5 == 0 ? (n7 == 100 ? 104 : 105) : n7;
                }
                object2.add(Code128Reader.CODE_PATTERNS[n5]);
                n3 += n5 * n4;
                if (n6 != 0) {
                    ++n4;
                }
                n5 = n7;
            }
            ArrayList<int[]> arrayList2 = object2;
            n2 = n3 % 103;
            object2.add(Code128Reader.CODE_PATTERNS[n2]);
            arrayList2.add(Code128Reader.CODE_PATTERNS[106]);
            n2 = 0;
            for (int[] nArray : arrayList2) {
                n4 = nArray.length;
                for (n5 = 0; n5 < n4; ++n5) {
                    n2 += nArray[n5];
                }
            }
            boolean[] blArray = new boolean[n2];
            int n10 = 0;
            object2 = object2.iterator();
            while (object2.hasNext()) {
                n10 += OneDimensionalCodeWriter.appendPattern(blArray, n10, (int[])object2.next(), true);
            }
            return blArray;
        }
        throw new IllegalArgumentException("Contents length should be between 1 and 80 characters, but got " + n2);
    }
}

