/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.datamatrix.encoder;

import com.dcloud.zxing2.Dimension;
import com.dcloud.zxing2.datamatrix.encoder.ASCIIEncoder;
import com.dcloud.zxing2.datamatrix.encoder.Base256Encoder;
import com.dcloud.zxing2.datamatrix.encoder.C40Encoder;
import com.dcloud.zxing2.datamatrix.encoder.EdifactEncoder;
import com.dcloud.zxing2.datamatrix.encoder.Encoder;
import com.dcloud.zxing2.datamatrix.encoder.EncoderContext;
import com.dcloud.zxing2.datamatrix.encoder.SymbolShapeHint;
import com.dcloud.zxing2.datamatrix.encoder.TextEncoder;
import com.dcloud.zxing2.datamatrix.encoder.X12Encoder;
import java.util.Arrays;

public final class HighLevelEncoder {
    private static final char PAD = '\u0081';
    static final char LATCH_TO_C40 = '\u00e6';
    static final char LATCH_TO_BASE256 = '\u00e7';
    static final char UPPER_SHIFT = '\u00eb';
    private static final char MACRO_05 = '\u00ec';
    private static final char MACRO_06 = '\u00ed';
    static final char LATCH_TO_ANSIX12 = '\u00ee';
    static final char LATCH_TO_TEXT = '\u00ef';
    static final char LATCH_TO_EDIFACT = '\u00f0';
    static final char C40_UNLATCH = '\u00fe';
    static final char X12_UNLATCH = '\u00fe';
    private static final String MACRO_05_HEADER = "[)>\u001e05\u001d";
    private static final String MACRO_06_HEADER = "[)>\u001e06\u001d";
    private static final String MACRO_TRAILER = "\u001e\u0004";
    static final int ASCII_ENCODATION = 0;
    static final int C40_ENCODATION = 1;
    static final int TEXT_ENCODATION = 2;
    static final int X12_ENCODATION = 3;
    static final int EDIFACT_ENCODATION = 4;
    static final int BASE256_ENCODATION = 5;

    private HighLevelEncoder() {
    }

    private static char randomize253State(char c2, int n2) {
        int n3 = c2 + (n2 * 149 % 253 + 1);
        c2 = (char)n3;
        return n3 <= 254 ? (char)c2 : (char)(c2 - 254);
    }

    public static String encodeHighLevel(String string2) {
        return HighLevelEncoder.encodeHighLevel(string2, SymbolShapeHint.FORCE_NONE, null, null);
    }

    public static String encodeHighLevel(String string2, SymbolShapeHint symbolShapeHint, Dimension dimension, Dimension dimension2) {
        StringBuilder stringBuilder;
        EncoderContext encoderContext;
        Base256Encoder base256Encoder;
        EdifactEncoder edifactEncoder;
        X12Encoder x12Encoder;
        TextEncoder textEncoder;
        C40Encoder c40Encoder;
        ASCIIEncoder aSCIIEncoder;
        Encoder[] encoderArray = new Encoder[6];
        Encoder[] encoderArray2 = encoderArray;
        Object object = aSCIIEncoder;
        aSCIIEncoder = new ASCIIEncoder();
        encoderArray[0] = object;
        object = c40Encoder;
        c40Encoder = new C40Encoder();
        encoderArray[1] = object;
        object = textEncoder;
        textEncoder = new TextEncoder();
        encoderArray[2] = object;
        object = x12Encoder;
        x12Encoder = new X12Encoder();
        encoderArray[3] = object;
        object = edifactEncoder;
        edifactEncoder = new EdifactEncoder();
        encoderArray[4] = object;
        object = base256Encoder;
        base256Encoder = new Base256Encoder();
        encoderArray[5] = object;
        object = encoderContext;
        ((EncoderContext)object)(string2);
        ((EncoderContext)object).setSymbolShape(symbolShapeHint);
        encoderContext.setSizeConstraints(dimension, dimension2);
        if (string2.startsWith(MACRO_05_HEADER) && string2.endsWith(MACRO_TRAILER)) {
            Object object2 = object;
            ((EncoderContext)object2).writeCodeword('\u00ec');
            ((EncoderContext)object2).setSkipAtEnd(2);
            ((EncoderContext)object2).pos += 7;
        } else if (string2.startsWith(MACRO_06_HEADER) && string2.endsWith(MACRO_TRAILER)) {
            Object object3 = object;
            ((EncoderContext)object3).writeCodeword('\u00ed');
            ((EncoderContext)object3).setSkipAtEnd(2);
            ((EncoderContext)object3).pos += 7;
        }
        int n2 = 0;
        while (((EncoderContext)object).hasMoreCharacters()) {
            encoderArray2[n2].encode((EncoderContext)object);
            if (((EncoderContext)object).getNewEncoding() < 0) continue;
            Object object4 = object;
            n2 = ((EncoderContext)object4).getNewEncoding();
            ((EncoderContext)object4).resetEncoderSignal();
        }
        int n3 = ((EncoderContext)object).getCodewordCount();
        Object object5 = object;
        ((EncoderContext)object5).updateSymbolInfo();
        int n4 = ((EncoderContext)object5).getSymbolInfo().getDataCapacity();
        if (n3 < n4 && n2 != 0 && n2 != 5) {
            ((EncoderContext)object).writeCodeword('\u00fe');
        }
        if ((stringBuilder = ((EncoderContext)object).getCodewords()).length() < n4) {
            stringBuilder.append('\u0081');
        }
        while (stringBuilder.length() < n4) {
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.append(HighLevelEncoder.randomize253State('\u0081', stringBuilder2.length() + 1));
        }
        return ((EncoderContext)object).getCodewords().toString();
    }

    static int lookAheadTest(CharSequence object, int n2, int n3) {
        block21: {
            float[] fArray;
            if (n2 >= object.length()) {
                return n3;
            }
            if (n3 == 0) {
                float[] fArray2 = new float[6];
                float[] fArray3 = fArray2;
                fArray2[0] = 0.0f;
                fArray2[1] = 1.0f;
                fArray2[2] = 1.0f;
                fArray2[3] = 1.0f;
                fArray2[4] = 1.0f;
                fArray2[5] = 1.25f;
                fArray = fArray3;
            } else {
                float[] fArray4 = new float[6];
                fArray = fArray4;
                fArray4[0] = 1.0f;
                fArray4[1] = 2.0f;
                fArray4[2] = 2.0f;
                fArray4[3] = 2.0f;
                fArray4[4] = 2.0f;
                fArray4[5] = 2.25f;
                fArray4[n3] = 0.0f;
            }
            char c2 = '\u0000';
            while (true) {
                char c3;
                if ((c3 = n2 + c2) == object.length()) {
                    object = new byte[6];
                    int[] nArray = new int[6];
                    int n4 = HighLevelEncoder.findMinimums(fArray, nArray, Integer.MAX_VALUE, (byte[])object);
                    c2 = HighLevelEncoder.getMinimumCount((byte[])object);
                    if (nArray[0] == n4) {
                        return 0;
                    }
                    if (c2 == '\u0001' && object[5] > 0) {
                        return 5;
                    }
                    if (c2 == '\u0001' && object[4] > 0) {
                        return 4;
                    }
                    if (c2 == '\u0001' && object[2] > 0) {
                        return 2;
                    }
                    if (c2 == '\u0001' && object[3] > 0) {
                        return 3;
                    }
                    return 1;
                }
                char c4 = object.charAt(c3);
                c3 = c4;
                ++c2;
                if (HighLevelEncoder.isDigit(c4)) {
                    fArray[0] = (float)((double)fArray[0] + 0.5);
                } else if (HighLevelEncoder.isExtendedASCII(c3)) {
                    float[] fArray5 = fArray;
                    fArray5[0] = (int)Math.ceil(fArray[0]);
                    fArray5[0] = fArray[0] + 2.0f;
                } else {
                    float[] fArray6 = fArray;
                    fArray6[0] = (int)Math.ceil(fArray[0]);
                    fArray6[0] = fArray[0] + 1.0f;
                }
                fArray[1] = HighLevelEncoder.isNativeC40(c3) ? fArray[1] + 0.6666667f : (HighLevelEncoder.isExtendedASCII(c3) ? fArray[1] + 2.6666667f : fArray[1] + 1.3333334f);
                fArray[2] = HighLevelEncoder.isNativeText(c3) ? fArray[2] + 0.6666667f : (HighLevelEncoder.isExtendedASCII(c3) ? fArray[2] + 2.6666667f : fArray[2] + 1.3333334f);
                fArray[3] = HighLevelEncoder.isNativeX12(c3) ? fArray[3] + 0.6666667f : (HighLevelEncoder.isExtendedASCII(c3) ? fArray[3] + 4.3333335f : fArray[3] + 3.3333333f);
                fArray[4] = HighLevelEncoder.isNativeEDIFACT(c3) ? fArray[4] + 0.75f : (HighLevelEncoder.isExtendedASCII(c3) ? fArray[4] + 4.25f : fArray[4] + 3.25f);
                fArray[5] = HighLevelEncoder.isSpecialB256(c3) ? fArray[5] + 4.0f : fArray[5] + 1.0f;
                if (c2 < 4) continue;
                int[] nArray = new int[6];
                byte[] byArray = new byte[6];
                HighLevelEncoder.findMinimums(fArray, nArray, Integer.MAX_VALUE, byArray);
                int n5 = HighLevelEncoder.getMinimumCount(byArray);
                if (nArray[0] < nArray[5] && nArray[0] < nArray[1] && nArray[0] < nArray[2] && nArray[0] < nArray[3] && nArray[0] < nArray[4]) {
                    return 0;
                }
                if (nArray[5] < nArray[0] || byArray[1] + byArray[2] + byArray[3] + byArray[4] == 0) break block21;
                if (n5 == 1 && byArray[4] > 0) {
                    return 4;
                }
                if (n5 == 1 && byArray[2] > 0) {
                    return 2;
                }
                if (n5 == 1 && byArray[3] > 0) {
                    return 3;
                }
                if (nArray[1] + 1 >= nArray[0] || nArray[1] + 1 >= nArray[5] || nArray[1] + 1 >= nArray[4] || nArray[1] + 1 >= nArray[2]) continue;
                if (nArray[1] < nArray[3]) {
                    return 1;
                }
                if (nArray[1] == nArray[3]) break;
            }
            for (n2 = n2 + c2 + 1; n2 < object.length(); ++n2) {
                char c5 = object.charAt(n2);
                c2 = c5;
                if (HighLevelEncoder.isX12TermSep(c5)) {
                    return 3;
                }
                if (!HighLevelEncoder.isNativeX12(c2)) break;
            }
            return 1;
        }
        return 5;
    }

    private static int findMinimums(float[] fArray, int[] nArray, int n2, byte[] byArray) {
        Arrays.fill(byArray, (byte)0);
        for (int i2 = 0; i2 < 6; ++i2) {
            nArray[i2] = (int)Math.ceil(fArray[i2]);
            int n3 = nArray[i2];
            if (n2 > n3) {
                Arrays.fill(byArray, (byte)0);
                n2 = n3;
            }
            if (n2 != n3) continue;
            byArray[i2] = (byte)(byArray[i2] + 1);
        }
        return n2;
    }

    private static int getMinimumCount(byte[] byArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < 6; ++i2) {
            n2 += byArray[i2];
        }
        return n2;
    }

    static boolean isDigit(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    static boolean isExtendedASCII(char c2) {
        return c2 >= '\u0080' && c2 <= '\u00ff';
    }

    private static boolean isNativeC40(char c2) {
        return c2 == ' ' || c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z';
    }

    private static boolean isNativeText(char c2) {
        return c2 == ' ' || c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z';
    }

    private static boolean isNativeX12(char c2) {
        return HighLevelEncoder.isX12TermSep(c2) || c2 == ' ' || c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z';
    }

    private static boolean isX12TermSep(char c2) {
        return c2 == '\r' || c2 == '*' || c2 == '>';
    }

    private static boolean isNativeEDIFACT(char c2) {
        return c2 >= ' ' && c2 <= '^';
    }

    private static boolean isSpecialB256(char c2) {
        return false;
    }

    public static int determineConsecutiveDigitCount(CharSequence charSequence, int n2) {
        int n3 = 0;
        int n4 = charSequence.length();
        if (n2 < n4) {
            char c2 = charSequence.charAt(n2);
            while (HighLevelEncoder.isDigit(c2) && n2 < n4) {
                ++n3;
                if (++n2 >= n4) continue;
                c2 = charSequence.charAt(n2);
            }
        }
        return n3;
    }

    static void illegalCharacter(char c2) {
        String string2 = Integer.toHexString(c2);
        int n2 = 4 - string2.length();
        string2 = "0000".substring(0, n2) + string2;
        throw new IllegalArgumentException("Illegal character: " + c2 + " (0x" + string2 + ')');
    }
}

