/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.datamatrix.decoder;

import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.common.BitSource;
import com.dcloud.zxing2.common.DecoderResult;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;

final class DecodedBitStreamParser {
    private static final char[] C40_BASIC_SET_CHARS = new char[]{'*', '*', '*', ' ', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] C40_SHIFT2_SET_CHARS = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '_'};
    private static final char[] TEXT_BASIC_SET_CHARS = new char[]{'*', '*', '*', ' ', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] TEXT_SHIFT2_SET_CHARS = C40_SHIFT2_SET_CHARS;
    private static final char[] TEXT_SHIFT3_SET_CHARS = new char[]{'`', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '{', '|', '}', '~', '\u007f'};

    private DecodedBitStreamParser() {
    }

    static DecoderResult decode(byte[] byArray) throws FormatException {
        ArrayList<byte[]> arrayList;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        BitSource bitSource;
        BitSource bitSource2 = bitSource;
        bitSource = new BitSource(byArray);
        CharSequence charSequence = stringBuilder2;
        stringBuilder2 = new StringBuilder(100);
        StringBuilder stringBuilder3 = stringBuilder;
        stringBuilder = new StringBuilder(0);
        ArrayList<byte[]> arrayList2 = arrayList;
        arrayList = new ArrayList<byte[]>(1);
        Mode mode = Mode.ASCII_ENCODE;
        while (true) {
            Mode mode2;
            if (mode == (mode2 = Mode.ASCII_ENCODE)) {
                mode2 = DecodedBitStreamParser.decodeAsciiSegment(bitSource2, charSequence, stringBuilder3);
            } else {
                switch (1.$SwitchMap$com$dcloud$zxing2$datamatrix$decoder$DecodedBitStreamParser$Mode[mode.ordinal()]) {
                    default: {
                        throw FormatException.getFormatInstance();
                    }
                    case 5: {
                        DecodedBitStreamParser.decodeBase256Segment(bitSource2, charSequence, arrayList2);
                        break;
                    }
                    case 4: {
                        DecodedBitStreamParser.decodeEdifactSegment(bitSource2, charSequence);
                        break;
                    }
                    case 3: {
                        DecodedBitStreamParser.decodeAnsiX12Segment(bitSource2, charSequence);
                        break;
                    }
                    case 2: {
                        DecodedBitStreamParser.decodeTextSegment(bitSource2, charSequence);
                        break;
                    }
                    case 1: {
                        DecodedBitStreamParser.decodeC40Segment(bitSource2, charSequence);
                    }
                }
            }
            if (mode2 == Mode.PAD_ENCODE || bitSource2.available() <= 0) break;
            mode = mode2;
        }
        if (stringBuilder3.length() > 0) {
            charSequence.append(stringBuilder3);
        }
        charSequence = charSequence.toString();
        if (arrayList2.isEmpty()) {
            arrayList2 = null;
        }
        Object object = bitSource2;
        ((DecoderResult)object)(byArray, (String)charSequence, arrayList2, null);
        return object;
    }

    private static Mode decodeAsciiSegment(BitSource bitSource, StringBuilder stringBuilder, StringBuilder stringBuilder2) throws FormatException {
        int n2;
        boolean bl = false;
        while ((n2 = bitSource.readBits(8)) != 0) {
            if (n2 <= 128) {
                if (bl) {
                    n2 += 128;
                }
                stringBuilder.append((char)(n2 - 1));
                return Mode.ASCII_ENCODE;
            }
            if (n2 == 129) {
                return Mode.PAD_ENCODE;
            }
            if (n2 <= 229) {
                if ((n2 -= 130) < 10) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(n2);
            } else {
                if (n2 == 230) {
                    return Mode.C40_ENCODE;
                }
                if (n2 == 231) {
                    return Mode.BASE256_ENCODE;
                }
                if (n2 == 232) {
                    stringBuilder.append('\u001d');
                } else if (n2 != 233 && n2 != 234) {
                    if (n2 == 235) {
                        bl = true;
                    } else if (n2 == 236) {
                        stringBuilder.append("[)>\u001e05\u001d");
                        stringBuilder2.insert(0, "\u001e\u0004");
                    } else if (n2 == 237) {
                        stringBuilder.append("[)>\u001e06\u001d");
                        stringBuilder2.insert(0, "\u001e\u0004");
                    } else {
                        if (n2 == 238) {
                            return Mode.ANSIX12_ENCODE;
                        }
                        if (n2 == 239) {
                            return Mode.TEXT_ENCODE;
                        }
                        if (n2 == 240) {
                            return Mode.EDIFACT_ENCODE;
                        }
                        if (n2 != 241 && n2 >= 242 && (n2 != 254 || bitSource.available() != 0)) {
                            throw FormatException.getFormatInstance();
                        }
                    }
                }
            }
            if (bitSource.available() > 0) continue;
            return Mode.ASCII_ENCODE;
        }
        throw FormatException.getFormatInstance();
    }

    /*
     * Unable to fully structure code
     */
    private static void decodeC40Segment(BitSource var0, StringBuilder var1_1) throws FormatException {
        var2_2 = false;
        var3_3 = new int[3];
        var4_4 = 0;
        do {
            if (var0.available() == 8) {
                return;
            }
            var5_7 = var0.readBits(8);
            if (var5_7 == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(var5_7, var0.readBits(8), var3_3);
            block7: for (var5_7 = 0; var5_7 < 3; ++var5_7) {
                var6_8 = var3_3[var5_7];
                switch (var4_4) {
                    default: {
                        throw FormatException.getFormatInstance();
                    }
                    case 3: {
                        if (var2_2) {
                            var1_1.append((char)(var6_8 + 224));
                            var2_2 = false;
                        } else {
                            var1_1.append((char)(var6_8 + 96));
                        }
                        ** GOTO lbl53
                    }
                    case 2: {
                        var4_5 = DecodedBitStreamParser.C40_SHIFT2_SET_CHARS;
                        if (var6_8 >= DecodedBitStreamParser.C40_SHIFT2_SET_CHARS.length) ** GOTO lbl37
                        var4_6 = var4_5[var6_8];
                        if (var2_2) {
                            var1_1.append((char)(var4_6 + 128));
                            var2_2 = false;
                        } else {
                            var1_1.append(var4_6);
                        }
                        ** GOTO lbl53
lbl37:
                        // 1 sources

                        if (var6_8 != '\u001b') ** GOTO lbl41
                        var1_1.append('\u001d');
                        ** GOTO lbl53
lbl41:
                        // 1 sources

                        if (var6_8 != '\u001e') ** GOTO lbl44
                        var2_2 = true;
                        ** GOTO lbl53
lbl44:
                        // 1 sources

                        throw FormatException.getFormatInstance();
                    }
                    case 1: {
                        if (var2_2) {
                            var1_1.append((char)(var6_8 + 128));
                            var2_2 = false;
                        } else {
                            var1_1.append(var6_8);
                        }
lbl53:
                        // 8 sources

                        var4_4 = 0;
                        continue block7;
                    }
                    case 0: 
                }
                if (var6_8 < '\u0003') {
                    var4_4 = var6_8 + 1;
                    continue;
                }
                var7_9 = DecodedBitStreamParser.C40_BASIC_SET_CHARS;
                if (var6_8 < DecodedBitStreamParser.C40_BASIC_SET_CHARS.length) {
                    var6_8 = var7_9[var6_8];
                    if (var2_2) {
                        var1_1.append((char)(var6_8 + 128));
                        var2_2 = false;
                        continue;
                    }
                    var1_1.append(var6_8);
                    continue;
                }
                throw FormatException.getFormatInstance();
            }
        } while (var0.available() > 0);
    }

    /*
     * Unable to fully structure code
     */
    private static void decodeTextSegment(BitSource var0, StringBuilder var1_1) throws FormatException {
        var2_2 = false;
        var3_3 = new int[3];
        var4_4 = 0;
        do {
            if (var0.available() == 8) {
                return;
            }
            var5_9 = var0.readBits(8);
            if (var5_9 == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(var5_9, var0.readBits(8), var3_3);
            block7: for (var5_9 = 0; var5_9 < 3; ++var5_9) {
                var6_10 = var3_3[var5_9];
                switch (var4_4) {
                    default: {
                        throw FormatException.getFormatInstance();
                    }
                    case 3: {
                        var4_5 = DecodedBitStreamParser.TEXT_SHIFT3_SET_CHARS;
                        if (var6_10 >= DecodedBitStreamParser.TEXT_SHIFT3_SET_CHARS.length) ** GOTO lbl28
                        var4_6 = var4_5[var6_10];
                        if (var2_2) {
                            var1_1.append((char)(var4_6 + 128));
                            var2_2 = false;
                        } else {
                            var1_1.append(var4_6);
                        }
                        ** GOTO lbl57
lbl28:
                        // 1 sources

                        throw FormatException.getFormatInstance();
                    }
                    case 2: {
                        var4_7 = DecodedBitStreamParser.TEXT_SHIFT2_SET_CHARS;
                        if (var6_10 >= DecodedBitStreamParser.TEXT_SHIFT2_SET_CHARS.length) ** GOTO lbl41
                        var4_8 = var4_7[var6_10];
                        if (var2_2) {
                            var1_1.append((char)(var4_8 + 128));
                            var2_2 = false;
                        } else {
                            var1_1.append(var4_8);
                        }
                        ** GOTO lbl57
lbl41:
                        // 1 sources

                        if (var6_10 != '\u001b') ** GOTO lbl45
                        var1_1.append('\u001d');
                        ** GOTO lbl57
lbl45:
                        // 1 sources

                        if (var6_10 != '\u001e') ** GOTO lbl48
                        var2_2 = true;
                        ** GOTO lbl57
lbl48:
                        // 1 sources

                        throw FormatException.getFormatInstance();
                    }
                    case 1: {
                        if (var2_2) {
                            var1_1.append((char)(var6_10 + 128));
                            var2_2 = false;
                        } else {
                            var1_1.append(var6_10);
                        }
lbl57:
                        // 8 sources

                        var4_4 = 0;
                        continue block7;
                    }
                    case 0: 
                }
                if (var6_10 < '\u0003') {
                    var4_4 = var6_10 + 1;
                    continue;
                }
                var7_11 = DecodedBitStreamParser.TEXT_BASIC_SET_CHARS;
                if (var6_10 < DecodedBitStreamParser.TEXT_BASIC_SET_CHARS.length) {
                    var6_10 = var7_11[var6_10];
                    if (var2_2) {
                        var1_1.append((char)(var6_10 + 128));
                        var2_2 = false;
                        continue;
                    }
                    var1_1.append(var6_10);
                    continue;
                }
                throw FormatException.getFormatInstance();
            }
        } while (var0.available() > 0);
    }

    private static void decodeAnsiX12Segment(BitSource bitSource, StringBuilder stringBuilder) throws FormatException {
        int[] nArray = new int[3];
        do {
            if (bitSource.available() == 8) {
                return;
            }
            int n2 = bitSource.readBits(8);
            if (n2 == 254) {
                return;
            }
            DecodedBitStreamParser.parseTwoBytes(n2, bitSource.readBits(8), nArray);
            for (n2 = 0; n2 < 3; ++n2) {
                int n3 = nArray[n2];
                if (n3 == 0) {
                    stringBuilder.append('\r');
                    continue;
                }
                if (n3 == 1) {
                    stringBuilder.append('*');
                    continue;
                }
                if (n3 == 2) {
                    stringBuilder.append('>');
                    continue;
                }
                if (n3 == 3) {
                    stringBuilder.append(' ');
                    continue;
                }
                if (n3 < 14) {
                    stringBuilder.append((char)(n3 + 44));
                    continue;
                }
                if (n3 < 40) {
                    stringBuilder.append((char)(n3 + 51));
                    continue;
                }
                throw FormatException.getFormatInstance();
            }
        } while (bitSource.available() > 0);
    }

    private static void parseTwoBytes(int n2, int n3, int[] nArray) {
        int n4 = (n2 << 8) + n3 - 1;
        nArray[0] = n2 = n4 / 1600;
        int n5 = n4 - n2 * 1600;
        nArray[1] = n2 = n5 / 40;
        nArray[2] = n5 - n2 * 40;
    }

    private static void decodeEdifactSegment(BitSource bitSource, StringBuilder stringBuilder) {
        do {
            if (bitSource.available() <= 16) {
                return;
            }
            for (int i2 = 0; i2 < 4; ++i2) {
                int n2 = bitSource.readBits(6);
                if (n2 == 31) {
                    int n3 = 8 - bitSource.getBitOffset();
                    if (n3 != 8) {
                        bitSource.readBits(n3);
                    }
                    return;
                }
                if ((n2 & 0x20) == 0) {
                    n2 |= 0x40;
                }
                stringBuilder.append((char)n2);
            }
        } while (bitSource.available() > 0);
    }

    private static void decodeBase256Segment(BitSource bitSource, StringBuilder stringBuilder, Collection<byte[]> collection) throws FormatException {
        BitSource bitSource2 = bitSource;
        int n2 = bitSource2.getByteOffset() + 1;
        int n3 = DecodedBitStreamParser.unrandomize255State(bitSource2.readBits(8), n2++);
        if (n3 == 0) {
            n3 = bitSource.available() / 8;
        } else if (n3 >= 250) {
            n3 = (n3 - 249) * 250 + DecodedBitStreamParser.unrandomize255State(bitSource.readBits(8), n2++);
        }
        if (n3 >= 0) {
            byte[] byArray = new byte[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                if (bitSource.available() >= 8) {
                    byArray[i2] = (byte)DecodedBitStreamParser.unrandomize255State(bitSource.readBits(8), n2++);
                    continue;
                }
                throw FormatException.getFormatInstance();
            }
            collection.add(byArray);
            try {
                stringBuilder.append(new String(byArray, "ISO8859_1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalStateException("Platform does not support required encoding: " + unsupportedEncodingException);
            }
            return;
        }
        throw FormatException.getFormatInstance();
    }

    private static int unrandomize255State(int n2, int n3) {
        if ((n2 -= n3 * 149 % 255 + 1) < 0) {
            n2 += 256;
        }
        return n2;
    }

    private static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode PAD_ENCODE;
        public static final /* enum */ Mode ASCII_ENCODE;
        public static final /* enum */ Mode C40_ENCODE;
        public static final /* enum */ Mode TEXT_ENCODE;
        public static final /* enum */ Mode ANSIX12_ENCODE;
        public static final /* enum */ Mode EDIFACT_ENCODE;
        public static final /* enum */ Mode BASE256_ENCODE;
        private static final /* synthetic */ Mode[] $VALUES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String string2) {
            return Enum.valueOf(Mode.class, string2);
        }

        static {
            Mode mode;
            Mode mode2;
            Mode mode3;
            Mode mode4;
            Mode mode5;
            Mode mode6;
            Mode mode7;
            Mode mode8 = mode7;
            PAD_ENCODE = new Mode();
            Mode mode9 = mode6;
            ASCII_ENCODE = new Mode();
            Mode mode10 = mode5;
            C40_ENCODE = new Mode();
            Mode mode11 = mode4;
            TEXT_ENCODE = new Mode();
            Mode mode12 = mode3;
            ANSIX12_ENCODE = new Mode();
            Mode mode13 = mode2;
            EDIFACT_ENCODE = new Mode();
            Mode mode14 = mode;
            BASE256_ENCODE = new Mode();
            $VALUES = new Mode[]{mode8, mode9, mode10, mode11, mode12, mode13, mode14};
        }
    }
}

