/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.common.detector;

import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitMatrix;

public final class MonochromeRectangleDetector {
    private static final int MAX_MODULES = 32;
    private final BitMatrix image;

    public MonochromeRectangleDetector(BitMatrix bitMatrix) {
        this.image = bitMatrix;
    }

    private ResultPoint findCornerFromCenter(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) throws NotFoundException {
        int[] nArray = null;
        int n11 = n2;
        int n12 = n6;
        while (n12 < n9 && n12 >= n8 && n11 < n5 && n11 >= n4) {
            int[] nArray2 = n3 == 0 ? this.blackWhiteRange(n12, n10, n4, n5, true) : this.blackWhiteRange(n11, n10, n8, n9, false);
            if (nArray2 == null) {
                if (nArray != null) {
                    if (n3 == 0) {
                        int n13 = n12 - n7;
                        if (nArray[0] < n2) {
                            if (nArray[1] > n2) {
                                ResultPoint resultPoint;
                                float f2 = n7 > 0 ? (float)nArray[0] : (float)nArray[1];
                                ResultPoint resultPoint2 = resultPoint;
                                resultPoint2(f2, n13);
                                return resultPoint2;
                            }
                            float f3 = nArray[0];
                            return new ResultPoint(f3, n13);
                        }
                        float f4 = nArray[1];
                        return new ResultPoint(f4, n13);
                    }
                    int n14 = n11 - n3;
                    if (nArray[0] < n6) {
                        if (nArray[1] > n6) {
                            ResultPoint resultPoint;
                            float f5 = n14;
                            float f6 = n3 < 0 ? (float)nArray[0] : (float)nArray[1];
                            ResultPoint resultPoint3 = resultPoint;
                            resultPoint3(f5, f6);
                            return resultPoint3;
                        }
                        float f7 = n14;
                        return new ResultPoint(f7, nArray[0]);
                    }
                    float f8 = n14;
                    return new ResultPoint(f8, nArray[1]);
                }
                throw NotFoundException.getNotFoundInstance();
            }
            int n15 = n12 + n7;
            n12 = n11 + n3;
            nArray = nArray2;
            n11 = n12;
            n12 = n15;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private int[] blackWhiteRange(int n2, int n3, int n4, int n5, boolean bl) {
        int[] nArray;
        int n6;
        int n7;
        int n8;
        int n9 = n8 = (n4 + n5) / 2;
        while (n9 >= n4) {
            if (bl ? this.image.get(n9, n2) : this.image.get(n2, n9)) {
                --n9;
                continue;
            }
            n7 = n9;
            while ((n7 += -1) >= n4 && !(bl ? this.image.get(n7, n2) : this.image.get(n2, n7))) {
            }
            int n10 = n9 - n7;
            if (n7 < n4 || n10 > n3) break;
            n9 = n7;
        }
        n4 = n9 + 1;
        while (n8 < n5) {
            if (bl ? this.image.get(n8, n2) : this.image.get(n2, n8)) {
                ++n8;
                continue;
            }
            n9 = n8;
            while (++n9 < n5 && !(bl ? this.image.get(n9, n2) : this.image.get(n2, n9))) {
            }
            int n11 = n9;
            n7 = n11 - n8;
            if (n11 >= n5 || n7 > n3) break;
            n8 = n9;
        }
        if ((n6 = n8 + -1) > n4) {
            int[] nArray2 = new int[2];
            nArray = nArray2;
            nArray2[0] = n4;
            nArray2[1] = n6;
        } else {
            nArray = null;
        }
        return nArray;
    }

    public ResultPoint[] detect() throws NotFoundException {
        int n2;
        MonochromeRectangleDetector monochromeRectangleDetector = this;
        int n3 = monochromeRectangleDetector.image.getHeight();
        int n4 = monochromeRectangleDetector.image.getWidth();
        int n5 = n3 / 2;
        int n6 = n4 / 2;
        int n7 = n2 = n6;
        int n8 = n2;
        int n9 = n2;
        int n10 = Math.max(1, n3 / 256);
        int n11 = Math.max(1, n4 / 256);
        int n12 = n2;
        int n13 = -n10;
        n2 = n12 / 2;
        int n14 = (int)this.findCornerFromCenter(n12, 0, 0, n4, n5, n13, 0, n3, n2).getY() - 1;
        int n15 = -n11;
        int n16 = n5 / 2;
        ResultPoint resultPoint = this.findCornerFromCenter(n9, n15, 0, n4, n5, 0, n14, n3, n16);
        int n17 = (int)resultPoint.getX() - 1;
        ResultPoint resultPoint2 = this.findCornerFromCenter(n8, n11, n17, n4, n5, 0, n14, n3, n16);
        n11 = (int)resultPoint2.getX() + 1;
        ResultPoint resultPoint3 = this.findCornerFromCenter(n7, 0, n17, n11, n5, n10, n14, n3, n2);
        n2 = (int)resultPoint3.getY() + 1;
        n10 = n6 / 4;
        ResultPoint resultPoint4 = monochromeRectangleDetector.findCornerFromCenter(n6, 0, n17, n11, n5, n13, n14, n2, n10);
        return new ResultPoint[]{resultPoint4, resultPoint, resultPoint2, resultPoint3};
    }
}

