/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.common;

import com.dcloud.zxing2.common.BitArray;
import java.util.Arrays;

public final class BitMatrix
implements Cloneable {
    private final int width;
    private final int height;
    private final int rowSize;
    private final int[] bits;

    public BitMatrix(int n2) {
        int n3 = n2;
        this(n3, n3);
    }

    public BitMatrix(int n2, int n3) {
        if (n2 >= 1 && n3 >= 1) {
            this.width = n2;
            this.height = n3;
            this.rowSize = n2 = (n2 + 31) / 32;
            this.bits = new int[n2 * n3];
            return;
        }
        throw new IllegalArgumentException("Both dimensions must be greater than 0");
    }

    private BitMatrix(int n2, int n3, int n4, int[] nArray) {
        this.width = n2;
        this.height = n3;
        this.rowSize = n4;
        this.bits = nArray;
    }

    public static BitMatrix parse(String object, String string2, String string3) {
        if (object != null) {
            BitMatrix bitMatrix;
            boolean[] blArray = new boolean[((String)object).length()];
            int n2 = 0;
            int n3 = 0;
            int n4 = -1;
            int n5 = 0;
            int n6 = 0;
            while (n6 < ((String)object).length()) {
                if (((String)object).charAt(n6) != '\n' && ((String)object).charAt(n6) != '\r') {
                    int n7 = n6;
                    if (((String)object).substring(n7, n7 + string2.length()).equals(string2)) {
                        n6 += string2.length();
                        blArray[n2] = true;
                        ++n2;
                        continue;
                    }
                    int n8 = n6;
                    if (((String)object).substring(n8, n8 + string3.length()).equals(string3)) {
                        n6 += string3.length();
                        blArray[n2] = false;
                        ++n2;
                        continue;
                    }
                    throw new IllegalArgumentException("illegal character encountered: " + ((String)object).substring(n6));
                }
                if (n2 > n3) {
                    if (n4 == -1) {
                        n4 = n2 - n3;
                    } else if (n2 - n3 != n4) {
                        throw new IllegalArgumentException("row lengths do not match");
                    }
                    ++n5;
                    n3 = n2;
                }
                ++n6;
            }
            if (n2 > n3) {
                if (n4 == -1) {
                    n4 = n2 - n3;
                } else if (n2 - n3 != n4) {
                    throw new IllegalArgumentException("row lengths do not match");
                }
                ++n5;
            }
            object = bitMatrix;
            bitMatrix = new BitMatrix(n4, n5);
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!blArray[i2]) continue;
                int n9 = i2;
                int n10 = n9 % n4;
                ((BitMatrix)object).set(n10, n9 / n4);
            }
            return object;
        }
        throw new IllegalArgumentException();
    }

    public boolean get(int n2, int n3) {
        int n4 = n3 * this.rowSize + n2 / 32;
        return (this.bits[n4] >>> (n2 & 0x1F) & 1) != 0;
    }

    public void set(int n2, int n3) {
        int n4 = n3 * this.rowSize + n2 / 32;
        this.bits[n4] = this.bits[n4] | 1 << (n2 & 0x1F);
    }

    public void unset(int n2, int n3) {
        int n4 = n3 * this.rowSize + n2 / 32;
        this.bits[n4] = this.bits[n4] & ~(1 << (n2 & 0x1F));
    }

    public void flip(int n2, int n3) {
        int n4 = n3 * this.rowSize + n2 / 32;
        this.bits[n4] = this.bits[n4] ^ 1 << (n2 & 0x1F);
    }

    public void xor(BitMatrix bitMatrix) {
        if (this.width == bitMatrix.getWidth() && this.height == bitMatrix.getHeight() && this.rowSize == bitMatrix.getRowSize()) {
            BitArray bitArray;
            BitArray bitArray2 = bitArray;
            bitArray = new BitArray(this.width / 32 + 1);
            for (int i2 = 0; i2 < this.height; ++i2) {
                int n2 = i2;
                int n3 = n2 * this.rowSize;
                int[] nArray = bitMatrix.getRow(n2, bitArray2).getBitArray();
                for (int i3 = 0; i3 < this.rowSize; ++i3) {
                    int n4 = n3 + i3;
                    this.bits[n4] = this.bits[n4] ^ nArray[i3];
                }
            }
            return;
        }
        throw new IllegalArgumentException("input matrix dimensions do not match");
    }

    public void clear() {
        int n2 = this.bits.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.bits[i2] = 0;
        }
    }

    public void setRegion(int n2, int n3, int n4, int n5) {
        if (n3 >= 0 && n2 >= 0) {
            if (n5 >= 1 && n4 >= 1) {
                n4 = n2 + n4;
                if ((n5 = n3 + n5) <= this.height && n4 <= this.width) {
                    while (n3 < n5) {
                        int n6 = n3 * this.rowSize;
                        for (int i2 = n2; i2 < n4; ++i2) {
                            int n7 = n6 + i2 / 32;
                            this.bits[n7] = this.bits[n7] | 1 << (i2 & 0x1F);
                        }
                        ++n3;
                    }
                    return;
                }
                throw new IllegalArgumentException("The region must fit inside the matrix");
            }
            throw new IllegalArgumentException("Height and width must be at least 1");
        }
        throw new IllegalArgumentException("Left and top must be nonnegative");
    }

    public BitArray getRow(int n2, BitArray bitArray) {
        if (bitArray != null && bitArray.getSize() >= this.width) {
            bitArray.clear();
        } else {
            BitArray bitArray2;
            bitArray = bitArray2;
            bitArray2 = new BitArray(this.width);
        }
        n2 *= this.rowSize;
        for (int i2 = 0; i2 < this.rowSize; ++i2) {
            bitArray.setBulk(i2 * 32, this.bits[n2 + i2]);
        }
        return bitArray;
    }

    public void setRow(int n2, BitArray bitArray) {
        int n3 = n2;
        BitMatrix bitMatrix = object;
        Object object = bitMatrix.bits;
        n2 = bitMatrix.rowSize;
        int n4 = n3 * n2;
        System.arraycopy(bitArray.getBitArray(), 0, object, n4, n2);
    }

    public void rotate180() {
        BitArray bitArray;
        BitArray bitArray2;
        BitMatrix bitMatrix = this;
        int n2 = bitMatrix.getWidth();
        int n3 = bitMatrix.getHeight();
        BitArray bitArray3 = bitArray2;
        bitArray2 = new BitArray(n2);
        BitArray bitArray4 = bitArray;
        bitArray = new BitArray(n2);
        for (n2 = 0; n2 < (n3 + 1) / 2; ++n2) {
            BitMatrix bitMatrix2 = this;
            bitArray3 = this.getRow(n2, bitArray3);
            int n4 = n3 - 1 - n2;
            bitArray4 = this.getRow(n4, bitArray4);
            bitArray3.reverse();
            bitArray4.reverse();
            bitMatrix2.setRow(n2, bitArray4);
            bitMatrix2.setRow(n4, bitArray3);
        }
    }

    public BitMatrix rotate90() {
        BitMatrix bitMatrix;
        BitMatrix bitMatrix2 = this;
        int n2 = bitMatrix2.getHeight();
        int n3 = bitMatrix2.getWidth();
        BitMatrix bitMatrix3 = bitMatrix;
        bitMatrix = new BitMatrix(n2, n3);
        if (bitMatrix2.width > 0 && this.height > 0) {
            for (n2 = 0; n2 < this.width; ++n2) {
                BitArray bitArray;
                BitArray bitArray2 = bitArray;
                bitArray = new BitArray(this.height);
                for (int i2 = 0; i2 < this.height; ++i2) {
                    if (!this.get(n2, i2)) continue;
                    bitArray2.set(i2);
                }
                bitMatrix3.setRow(this.width - n2 - 1, bitArray2);
            }
            return bitMatrix3;
        }
        return this;
    }

    public int[] getEnclosingRectangle() {
        BitMatrix bitMatrix = this;
        int n2 = bitMatrix.width;
        int n3 = bitMatrix.height;
        int n4 = -1;
        int n5 = -1;
        for (int i2 = 0; i2 < this.height; ++i2) {
            int n6;
            for (int i3 = 0; i3 < (n6 = this.rowSize); ++i3) {
                int n7;
                block17: {
                    block13: {
                        block16: {
                            int n8;
                            block15: {
                                block14: {
                                    if ((n6 = this.bits[i2 * n6 + i3]) == 0) break block13;
                                    if (i2 < n3) {
                                        n3 = i2;
                                    }
                                    if (i2 > n5) {
                                        n5 = i2;
                                    }
                                    if ((n8 = i3 * 32) >= n2) break block14;
                                    n7 = 0;
                                    while (n6 << 31 - n7 == 0) {
                                        ++n7;
                                    }
                                    if ((n7 = n8 + n7) < n2) break block15;
                                }
                                n7 = n2;
                            }
                            if (n8 + 31 <= n4) break block16;
                            n2 = 31;
                            while (n6 >>> n2 == 0) {
                                --n2;
                            }
                            if ((n2 = n8 + n2) > n4) break block17;
                        }
                        n2 = n4;
                        break block17;
                    }
                    int n9 = n2;
                    n2 = n4;
                    n7 = n9;
                }
                n4 = n2;
                n2 = n7;
            }
        }
        int n10 = n4 - n2;
        n4 = n5 - n3;
        if (n10 >= 0 && n4 >= 0) {
            return new int[]{n2, n3, n10, n4};
        }
        return null;
    }

    public int[] getTopLeftOnBit() {
        int[] nArray;
        int n2 = 0;
        while (true) {
            nArray = this.bits;
            if (n2 >= this.bits.length || nArray[n2] != 0) break;
            ++n2;
        }
        if (n2 == nArray.length) {
            return null;
        }
        int n3 = n2;
        int n4 = this.rowSize;
        n2 = n3 / n4;
        n4 = n3 % n4 * 32;
        int n5 = nArray[n3];
        int n6 = 0;
        while (n5 << 31 - n6 == 0) {
            ++n6;
        }
        return new int[]{n4 += n6, n2};
    }

    public int[] getBottomRightOnBit() {
        int n2;
        for (n2 = this.bits.length - 1; n2 >= 0 && this.bits[n2] == 0; --n2) {
        }
        if (n2 < 0) {
            return null;
        }
        int n3 = n2;
        int n4 = this.rowSize;
        int n5 = n3 / n4;
        n4 = n3 % n4 * 32;
        n2 = this.bits[n2];
        int n6 = 31;
        while (n2 >>> n6 == 0) {
            --n6;
        }
        return new int[]{n4 += n6, n5};
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BitMatrix)) {
            return false;
        }
        object = (BitMatrix)object;
        return this.width == ((BitMatrix)object).width && this.height == ((BitMatrix)object).height && this.rowSize == ((BitMatrix)object).rowSize && Arrays.equals(this.bits, ((BitMatrix)object).bits);
    }

    public int hashCode() {
        int n2 = this.width;
        return (((n2 * 31 + n2) * 31 + this.height) * 31 + this.rowSize) * 31 + Arrays.hashCode(this.bits);
    }

    public String toString() {
        return this.toString("X ", "  ");
    }

    public String toString(String string2, String string3) {
        return this.toString(string2, string3, "\n");
    }

    @Deprecated
    public String toString(String string2, String string3, String string4) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(this.height * (this.width + 1));
        for (int i2 = 0; i2 < this.height; ++i2) {
            for (int i3 = 0; i3 < this.width; ++i3) {
                String string5 = this.get(i3, i2) ? string2 : string3;
                stringBuilder2.append(string5);
            }
            stringBuilder2.append(string4);
        }
        return stringBuilder2.toString();
    }

    public BitMatrix clone() {
        BitMatrix bitMatrix = object;
        int n2 = bitMatrix.width;
        int n3 = bitMatrix.height;
        int n4 = bitMatrix.rowSize;
        Object object = (int[])((BitMatrix)object).bits.clone();
        return new BitMatrix(n2, n3, n4, (int[])object);
    }
}

