/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.common;

import java.util.Arrays;

public final class BitArray
implements Cloneable {
    private int[] bits;
    private int size;

    public BitArray() {
        this.size = 0;
        this.bits = new int[1];
    }

    public BitArray(int n2) {
        this.size = n2;
        this.bits = BitArray.makeArray(n2);
    }

    BitArray(int[] nArray, int n2) {
        this.bits = nArray;
        this.size = n2;
    }

    private void ensureCapacity(int n2) {
        if (n2 > ((BitArray)object).bits.length * 32) {
            BitArray bitArray = object;
            Object object = BitArray.makeArray(n2);
            n2 = bitArray.bits.length;
            System.arraycopy(bitArray.bits, 0, object, 0, n2);
            bitArray.bits = (int[])object;
        }
    }

    private static int[] makeArray(int n2) {
        return new int[(n2 + 31) / 32];
    }

    public int getSize() {
        return this.size;
    }

    public int getSizeInBytes() {
        return (this.size + 7) / 8;
    }

    public boolean get(int n2) {
        return (this.bits[n2 / 32] & 1 << (n2 & 0x1F)) != 0;
    }

    public void set(int n2) {
        int n3 = n2 / 32;
        this.bits[n3] = this.bits[n3] | 1 << (n2 & 0x1F);
    }

    public void flip(int n2) {
        int n3 = n2 / 32;
        this.bits[n3] = this.bits[n3] ^ 1 << (n2 & 0x1F);
    }

    public int getNextSet(int n2) {
        int n3;
        int n4 = this.size;
        if (n2 >= n4) {
            return n4;
        }
        n4 = n2 / 32;
        n2 = this.bits[n4] & ~((1 << (n2 & 0x1F)) - 1);
        while (n2 == 0) {
            int[] nArray = this.bits;
            if (++n4 == this.bits.length) {
                return this.size;
            }
            n2 = nArray[n4];
        }
        if ((n2 = n4 * 32 + Integer.numberOfTrailingZeros(n2)) <= (n3 = this.size)) {
            n3 = n2;
        }
        return n3;
    }

    public int getNextUnset(int n2) {
        int n3;
        int n4 = this.size;
        if (n2 >= n4) {
            return n4;
        }
        n4 = n2 / 32;
        n2 = ~this.bits[n4] & ~((1 << (n2 & 0x1F)) - 1);
        while (n2 == 0) {
            int[] nArray = this.bits;
            if (++n4 == this.bits.length) {
                return this.size;
            }
            n2 = ~nArray[n4];
        }
        if ((n2 = n4 * 32 + Integer.numberOfTrailingZeros(n2)) <= (n3 = this.size)) {
            n3 = n2;
        }
        return n3;
    }

    public void setBulk(int n2, int n3) {
        this.bits[n2 / 32] = n3;
    }

    public void setRange(int n2, int n3) {
        if (n3 >= n2) {
            if (n3 == n2) {
                return;
            }
            int n4 = n2 / 32;
            int n5 = (n3 += -1) / 32;
            for (int i2 = n4; i2 <= n5; ++i2) {
                int n6;
                int n7;
                int n8 = i2 < n5 ? 31 : n3 & 0x1F;
                if (n7 == 0 && n8 == 31) {
                    n6 = n7 = -1;
                } else {
                    n6 = 0;
                    for (n7 = i2 > n4 ? 0 : n2 & 0x1F; n7 <= n8; ++n7) {
                        n6 |= 1 << n7;
                    }
                }
                this.bits[i2] = this.bits[i2] | n6;
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    public void clear() {
        int n2 = this.bits.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.bits[i2] = 0;
        }
    }

    public boolean isRange(int n2, int n3, boolean bl) {
        if (n3 >= n2) {
            if (n3 == n2) {
                return true;
            }
            int n4 = n2 / 32;
            int n5 = (n3 += -1) / 32;
            for (int i2 = n4; i2 <= n5; ++i2) {
                int n6;
                int n7;
                int n8 = i2 < n5 ? 31 : n3 & 0x1F;
                if (n7 == 0 && n8 == 31) {
                    n6 = n7 = -1;
                } else {
                    n6 = 0;
                    for (n7 = i2 > n4 ? 0 : n2 & 0x1F; n7 <= n8; ++n7) {
                        n6 |= 1 << n7;
                    }
                }
                n7 = this.bits[i2] & n6;
                if (!bl) {
                    n6 = 0;
                }
                if (n7 == n6) continue;
                return false;
            }
            return true;
        }
        throw new IllegalArgumentException();
    }

    public void appendBit(boolean bl) {
        BitArray bitArray = this;
        bitArray.ensureCapacity(bitArray.size + 1);
        if (bl) {
            int n2 = this.size;
            int n3 = n2 / 32;
            this.bits[n3] = this.bits[n3] | 1 << (n2 & 0x1F);
        }
        ++this.size;
    }

    public void appendBits(int n2, int n3) {
        if (n3 >= 0 && n3 <= 32) {
            BitArray bitArray = this;
            bitArray.ensureCapacity(bitArray.size + n3);
            while (n3 > 0) {
                boolean bl = (n2 >> n3 - 1 & 1) == 1;
                this.appendBit(bl);
                --n3;
            }
            return;
        }
        throw new IllegalArgumentException("Num bits must be between 0 and 32");
    }

    public void appendBitArray(BitArray bitArray) {
        BitArray bitArray2 = this;
        int n2 = bitArray.size;
        bitArray2.ensureCapacity(bitArray2.size + n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.appendBit(bitArray.get(i2));
        }
    }

    public void xor(BitArray bitArray) {
        if (this.bits.length == bitArray.bits.length) {
            int n2 = 0;
            while (true) {
                int[] nArray = this.bits;
                if (n2 >= this.bits.length) break;
                nArray[n2] = nArray[n2] ^ bitArray.bits[n2];
                ++n2;
            }
            return;
        }
        throw new IllegalArgumentException("Sizes don't match");
    }

    public void toBytes(int n2, byte[] byArray, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = 0;
            for (int i3 = 0; i3 < 8; ++i3) {
                if (this.get(n2)) {
                    n5 |= 1 << 7 - i3;
                }
                ++n2;
            }
            int n6 = n5;
            n5 = n3 + i2;
            byArray[n5] = (byte)n6;
        }
    }

    public int[] getBitArray() {
        return this.bits;
    }

    public void reverse() {
        int n2;
        int n3;
        BitArray bitArray = this;
        int[] nArray = new int[bitArray.bits.length];
        int n4 = (bitArray.size - 1) / 32;
        int n5 = n4 + 1;
        for (n3 = 0; n3 < n5; ++n3) {
            long l2 = this.bits[n3];
            l2 = l2 >> 1 & 0x55555555L | (l2 & 0x55555555L) << 1;
            l2 = l2 >> 2 & 0x33333333L | (l2 & 0x33333333L) << 2;
            l2 = l2 >> 4 & 0xF0F0F0FL | (l2 & 0xF0F0F0FL) << 4;
            l2 = l2 >> 8 & 0xFF00FFL | (l2 & 0xFF00FFL) << 8;
            n2 = n4 - n3;
            nArray[n2] = (int)(l2 >> 16 & 0xFFFFL | (l2 & 0xFFFFL) << 16);
        }
        n4 = this.size;
        n3 = n5 * 32;
        if (n4 != n3) {
            n4 = n3 - n4;
            n3 = 1;
            for (n2 = 0; n2 < 31 - n4; ++n2) {
                n3 = n3 << 1 | 1;
            }
            n2 = nArray[0] >> n4 & n3;
            for (int i2 = 1; i2 < n5; ++i2) {
                int n6 = nArray[i2];
                nArray[i2 - 1] = n2 |= n6 << 32 - n4;
                n2 = n6 >> n4 & n3;
            }
            nArray[n5 - 1] = n2;
        }
        this.bits = nArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BitArray)) {
            return false;
        }
        object = (BitArray)object;
        return this.size == ((BitArray)object).size && Arrays.equals(this.bits, ((BitArray)object).bits);
    }

    public int hashCode() {
        return this.size * 31 + Arrays.hashCode(this.bits);
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(this.size);
        for (int i2 = 0; i2 < this.size; ++i2) {
            if ((i2 & 7) == 0) {
                stringBuilder2.append(' ');
            }
            char c2 = this.get(i2) ? (char)'X' : '.';
            stringBuilder2.append(c2);
        }
        return stringBuilder2.toString();
    }

    public BitArray clone() {
        BitArray bitArray = object;
        Object object = (int[])bitArray.bits.clone();
        return new BitArray((int[])object, bitArray.size);
    }
}

