/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.aztec.encoder;

import com.dcloud.zxing2.aztec.encoder.HighLevelEncoder;
import com.dcloud.zxing2.aztec.encoder.Token;
import com.dcloud.zxing2.common.BitArray;
import io.dcloud.common.util.StringUtil;
import java.util.LinkedList;

final class State {
    static final State INITIAL_STATE = new State(Token.EMPTY, 0, 0, 0);
    private final int mode;
    private final Token token;
    private final int binaryShiftByteCount;
    private final int bitCount;

    private State(Token token, int n2, int n3, int n4) {
        this.token = token;
        this.mode = n2;
        this.binaryShiftByteCount = n3;
        this.bitCount = n4;
    }

    int getMode() {
        return this.mode;
    }

    Token getToken() {
        return this.token;
    }

    int getBinaryShiftByteCount() {
        return this.binaryShiftByteCount;
    }

    int getBitCount() {
        return this.bitCount;
    }

    State latchAndAppend(int n2, int n3) {
        Token token;
        int n4;
        State state = this;
        int n5 = state.bitCount;
        Token token2 = state.token;
        int n6 = state.mode;
        if (n2 != n6) {
            int n7 = n5;
            int n8 = HighLevelEncoder.LATCH_TABLE[n6][n2];
            n5 = n8 & 0xFFFF;
            n4 = n8 >> 16;
            token = token2.add(n5, n4);
            n4 = n7 + n4;
        } else {
            n4 = n5;
            token = token2;
        }
        n6 = n2 == 2 ? 4 : 5;
        token = token.add(n3, n6);
        n3 = n4 + n6;
        return new State(token, n2, 0, n3);
    }

    State shiftAndAppend(int n2, int n3) {
        State state = this;
        Token token = state.token;
        int n4 = state.mode;
        int n5 = n4 == 2 ? 4 : 5;
        Token token2 = token.add(HighLevelEncoder.SHIFT_TABLE[n4][n2], n5).add(n3, 5);
        State state2 = this;
        int n6 = state2.mode;
        int n7 = state2.bitCount + n5 + 5;
        return new State(token2, n6, 0, n7);
    }

    State addBinaryShiftChar(int n2) {
        State state;
        int n3;
        State state2 = this;
        Token token = state2.token;
        int n4 = state2.mode;
        int n5 = this.bitCount;
        if (n4 == 4 || n4 == 2) {
            int n6 = HighLevelEncoder.LATCH_TABLE[n4][0];
            int n7 = n6 & 0xFFFF;
            n4 = n6 >> 16;
            token = token.add(n7, n4);
            n5 += n4;
            n4 = 0;
        }
        int n8 = (n3 = this.binaryShiftByteCount) != 0 && n3 != 31 ? (n3 == 62 ? 9 : 8) : 18;
        State state3 = state;
        int n9 = n5 + n8;
        if (new State((Token)token, (int)n4, (int)(++n3), (int)n9).binaryShiftByteCount == 2078) {
            state3 = state3.endBinaryShift(n2 + 1);
        }
        return state3;
    }

    State endBinaryShift(int n2) {
        int n3 = this.binaryShiftByteCount;
        if (n3 == 0) {
            return this;
        }
        Token token = this.token.addBinaryShift(n2 - n3, n3);
        State state = this;
        int n4 = state.mode;
        int n5 = state.bitCount;
        return new State(token, n4, 0, n5);
    }

    boolean isBetterThanOrEqualTo(State state) {
        int n2;
        int n3 = this.bitCount + (HighLevelEncoder.LATCH_TABLE[this.mode][state.mode] >> 16);
        int n4 = state.binaryShiftByteCount;
        if (n4 > 0 && ((n2 = this.binaryShiftByteCount) == 0 || n2 > n4)) {
            n3 += 10;
        }
        return n3 <= state.bitCount;
    }

    BitArray toBitArray(byte[] byArray) {
        BitArray bitArray;
        Object object;
        LinkedList linkedList;
        State state = object2;
        Object object2 = linkedList;
        linkedList = new LinkedList();
        for (object = (v52307).endBinaryShift((int)byArray.length).token; object != null; object = ((Token)object).getPrevious()) {
            object2.addFirst(object);
        }
        Object object3 = object2;
        object2 = bitArray;
        bitArray = new BitArray();
        object = object3.iterator();
        while (object.hasNext()) {
            ((Token)object.next()).appendTo((BitArray)object2, byArray);
        }
        return object2;
    }

    public String toString() {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = HighLevelEncoder.MODE_NAMES[this.mode];
        objectArray2[1] = this.bitCount;
        objectArray[2] = this.binaryShiftByteCount;
        return StringUtil.format("%s bits=%d bytes=%d", objectArray2);
    }
}

