/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2;

import com.dcloud.zxing2.LuminanceSource;

public final class RGBLuminanceSource
extends LuminanceSource {
    private final byte[] luminances;
    private final int dataWidth;
    private final int dataHeight;
    private final int left;
    private final int top;

    public RGBLuminanceSource(int n2, int n3, int[] nArray) {
        RGBLuminanceSource rGBLuminanceSource = this;
        super(n2, n3);
        this.dataWidth = n2;
        rGBLuminanceSource.dataHeight = n3;
        rGBLuminanceSource.left = 0;
        rGBLuminanceSource.top = 0;
        this.luminances = new byte[n2 * n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = i2 * n2;
            for (int i3 = 0; i3 < n2; ++i3) {
                int n5 = n4 + i3;
                int n6 = nArray[n5];
                int n7 = n6 >> 16 & 0xFF;
                int n8 = n6;
                n6 = n8 >> 8 & 0xFF;
                int n9 = n8 & 0xFF;
                this.luminances[n5] = n7 == n6 && n6 == n9 ? (byte)n7 : (byte)((n7 + n6 * 2 + n9) / 4);
            }
        }
    }

    private RGBLuminanceSource(byte[] byArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n6, n7);
        if (n4 + n6 <= n2 && n5 + n7 <= n3) {
            RGBLuminanceSource rGBLuminanceSource = this;
            rGBLuminanceSource.luminances = byArray;
            rGBLuminanceSource.dataWidth = n2;
            rGBLuminanceSource.dataHeight = n3;
            rGBLuminanceSource.left = n4;
            rGBLuminanceSource.top = n5;
            return;
        }
        throw new IllegalArgumentException("Crop rectangle does not fit within image data.");
    }

    @Override
    public byte[] getRow(int n2, byte[] byArray) {
        if (n2 >= 0 && n2 < this.getHeight()) {
            int n3 = this.getWidth();
            if (byArray == null || byArray.length < n3) {
                byArray = new byte[n3];
            }
            int n4 = (n2 + this.top) * this.dataWidth + this.left;
            System.arraycopy(this.luminances, n4, byArray, 0, n3);
            return byArray;
        }
        throw new IllegalArgumentException("Requested row is outside the image: " + n2);
    }

    @Override
    public byte[] getMatrix() {
        int n2 = this.getWidth();
        RGBLuminanceSource rGBLuminanceSource = this;
        int n3 = rGBLuminanceSource.getHeight();
        int n4 = rGBLuminanceSource.dataWidth;
        if (n2 == n4 && n3 == this.dataHeight) {
            return this.luminances;
        }
        int n5 = n4;
        int n6 = n2 * n3;
        byte[] byArray = new byte[n6];
        n4 = this.top * n4 + this.left;
        if (n2 == n5) {
            System.arraycopy(this.luminances, n4, byArray, 0, n6);
            return byArray;
        }
        byte[] byArray2 = this.luminances;
        for (int i2 = 0; i2 < n3; ++i2) {
            System.arraycopy(byArray2, n4, byArray, i2 * n2, n2);
            n4 += this.dataWidth;
        }
        return byArray;
    }

    @Override
    public boolean isCropSupported() {
        return true;
    }

    @Override
    public LuminanceSource crop(int n2, int n3, int n4, int n5) {
        RGBLuminanceSource rGBLuminanceSource = this;
        byte[] byArray = rGBLuminanceSource.luminances;
        int n6 = rGBLuminanceSource.dataWidth;
        int n7 = rGBLuminanceSource.dataHeight;
        RGBLuminanceSource rGBLuminanceSource2 = this;
        int n8 = rGBLuminanceSource2.left + n2;
        n2 = rGBLuminanceSource2.top + n3;
        return new RGBLuminanceSource(byArray, n6, n7, n8, n2, n4, n5);
    }
}

