/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.widget;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.NinePatchDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import io.dcloud.base.R;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.ICallBack;
import io.dcloud.common.ui.blur.DCBlurDraweeView;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.language.LanguageUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import pl.droidsonroids.gif.AnimationListener;
import pl.droidsonroids.gif.GifDrawable;

public class TabView
extends FrameLayout {
    private Context mContext;
    private LinearLayout mTabBar;
    private JSONObject mStyleJson;
    private String mTextColor;
    private String mDefaultTextColor;
    private String mDefaultSelectedTextColor;
    private String mDefaultBorderColor;
    private String mDefaultBackgroundColor;
    private String mDefaultMaskBackgroundColor;
    private String mSelectedColor;
    private String mBackgroundColor;
    private String mBackgroundImage;
    private String mBorderStyle;
    private JSONArray mCommonList;
    private String mCommonSelectedIndex;
    private int mTabHeight;
    private JSONObject mMidButton;
    private ArrayList<RelativeLayout> mTabItemViews;
    private RelativeLayout mMidButtonView;
    private ICallBack mISingleCallback;
    private ICallBack mIMaskCallback;
    private ICallBack mIDoubleCallback;
    private ICallBack mIMidCallback;
    private float mScale;
    private IApp mWebApp;
    private String mImageSize;
    private String mTextTop;
    private String mTextSize;
    private String mTabHeightStr;
    private LinearLayout mMask;
    private View mBorderView;
    private int redDotColor;
    private String repeatType;
    private String mBlurEffect;
    private DCBlurDraweeView mBlurDraweeView;
    private String mIconfontPath;
    private View.OnTouchListener mMidTouchListener;
    private View.OnClickListener mOnClickListener;
    private View.OnClickListener mOnMaskClickListener;
    private int mMidIndex;

    public TabView(Context context, View view, JSONObject object, float f2, IApp iApp) {
        FrameLayout.LayoutParams layoutParams;
        View.OnClickListener onClickListener;
        View.OnClickListener onClickListener2;
        View.OnTouchListener onTouchListener;
        TabView tabView = this;
        super(context);
        tabView.mDefaultTextColor = "#7A7E83";
        tabView.mDefaultSelectedTextColor = "#3cc51f";
        tabView.mDefaultBorderColor = "#000000";
        tabView.mDefaultBackgroundColor = "#FFFFFF";
        tabView.mDefaultMaskBackgroundColor = "#00000000";
        tabView.mImageSize = "24px";
        tabView.mTextTop = "3px";
        tabView.mTextSize = "10px";
        tabView.redDotColor = -65536;
        tabView.mBlurEffect = "none";
        Object object2 = onTouchListener;
        onTouchListener = new View.OnTouchListener(){
            long downTime = 0L;
            float X = 0.0f;
            float Y = 0.0f;
            boolean downInMid = false;

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (TabView.this.mMidButtonView != null && TabView.this.mMidButtonView.getParent() != null) {
                    int n2 = motionEvent.getAction();
                    if (n2 != 0) {
                        if (n2 == 1 && this.downInMid && System.currentTimeMillis() - this.downTime < 500L && Math.abs(motionEvent.getY() - this.Y) < 70.0f && Math.abs(motionEvent.getX() - this.X) < 70.0f && TabView.this.mIMidCallback != null) {
                            TabView.this.mIMidCallback.onCallBack(0, null);
                        }
                    } else {
                        RelativeLayout relativeLayout = TabView.this.mMidButtonView;
                        if (relativeLayout != null && relativeLayout.getVisibility() == 0) {
                            RelativeLayout relativeLayout2 = relativeLayout;
                            int n3 = relativeLayout2.getLeft();
                            int n4 = relativeLayout2.getTop() + TabView.this.mTabBar.getTop();
                            int n5 = relativeLayout2.getRight();
                            this.downInMid = new Rect(n3, n4, n5, relativeLayout.getBottom() + TabView.this.mTabBar.getTop()).contains((int)motionEvent.getX(), (int)motionEvent.getY());
                        } else {
                            this.downInMid = false;
                        }
                        this.downTime = System.currentTimeMillis();
                        this.X = motionEvent.getX();
                        this.Y = motionEvent.getY();
                    }
                } else {
                    this.downInMid = false;
                }
                return this.downInMid;
            }
        };
        tabView.mMidTouchListener = object2;
        object2 = onClickListener2;
        onClickListener2 = new View.OnClickListener(){

            public void onClick(View view) {
                4 v0 = this;
                int n2 = (Integer)view.getTag();
                v0.TabView.this.switchTab(n2);
                if (v0.TabView.this.mISingleCallback != null) {
                    TabView.this.mISingleCallback.onCallBack(n2, null);
                }
            }
        };
        tabView.mOnClickListener = object2;
        object2 = onClickListener;
        onClickListener = new View.OnClickListener(){

            public void onClick(View view) {
                if (TabView.this.mIMaskCallback != null) {
                    TabView.this.mIMaskCallback.onCallBack(0, null);
                }
            }
        };
        tabView.mOnMaskClickListener = object2;
        tabView.mMidIndex = 0;
        tabView.mContext = context;
        tabView.mScale = f2;
        tabView.mWebApp = iApp;
        tabView.setClipChildren(false);
        tabView.mStyleJson = object;
        if (object == null) {
            JSONObject jSONObject;
            object2 = jSONObject;
            jSONObject = new JSONObject();
            this.mStyleJson = object2;
        }
        if (object.containsKey((Object)"iconfontSrc") && !PdrUtil.isNetPath((String)(object = object.getString("iconfontSrc")))) {
            this.mIconfontPath = this.mWebApp.convert2AbsFullPath((String)object);
        }
        TabView tabView2 = this;
        tabView2.mTextColor = tabView2.mStyleJson.getString("color");
        tabView2.mSelectedColor = tabView2.mStyleJson.getString("selectedColor");
        tabView2.mBackgroundColor = tabView2.mStyleJson.getString("backgroundColor");
        tabView2.mBackgroundImage = tabView2.mStyleJson.getString("backgroundImage");
        tabView2.repeatType = tabView2.mStyleJson.getString("backgroundRepeat");
        if (tabView2.mStyleJson.containsKey((Object)"blurEffect")) {
            this.mBlurEffect = this.mStyleJson.getString("blurEffect");
        }
        if (this.mStyleJson.containsKey((Object)"redDotColor") && !PdrUtil.isEmpty(object = this.mStyleJson.getString("redDotColor"))) {
            this.redDotColor = PdrUtil.stringToColor((String)object);
        }
        TabView tabView3 = this;
        tabView3.mBorderStyle = tabView3.mStyleJson.getString("borderStyle");
        if (tabView3.mStyleJson.containsKey((Object)"fontSize")) {
            this.mTextSize = this.mStyleJson.getString("fontSize");
        }
        if (this.mStyleJson.containsKey((Object)"iconWidth")) {
            this.mImageSize = this.mStyleJson.getString("iconWidth");
        }
        TabView tabView4 = this;
        object = tabView4.getResources().getDisplayMetrics();
        float f3 = TypedValue.applyDimension((int)1, (float)72.0f, (DisplayMetrics)object);
        object2 = !tabView4.mStyleJson.containsKey((Object)"height") ? "50px" : this.mStyleJson.getString("height");
        this.mTabHeightStr = object2;
        if (this.mStyleJson.containsKey((Object)"spacing")) {
            this.mTextTop = this.mStyleJson.getString("spacing");
        }
        TabView tabView5 = this;
        tabView5.mTabHeight = (int)PdrUtil.parseFloat(tabView5.mTabHeightStr, 0.0f, f3, f2);
        String string2 = tabView5.mStyleJson.getString("selected") == null ? "0" : this.mStyleJson.getString("selected");
        TabView tabView6 = this;
        tabView6.mCommonSelectedIndex = string2;
        tabView6.mCommonList = tabView6.mStyleJson.getJSONArray("list");
        tabView6.mMidButton = tabView6.mStyleJson.getJSONObject("midButton");
        tabView6.mTabItemViews = new ArrayList();
        tabView6.mBorderView = new View(context);
        string2 = layoutParams;
        super(-1, 1);
        layoutParams.bottomMargin = this.mTabHeight;
        layoutParams.gravity = 80;
        tabView6.addView(tabView6.mBorderView, (ViewGroup.LayoutParams)string2);
        this.mTabBar = new LinearLayout(context);
        this.mTabBar.setOrientation(0);
        tabView6.mTabBar.setGravity(80);
        tabView6.mTabBar.setClipChildren(false);
        if (tabView6.mBlurEffect.equals("light") || this.mBlurEffect.equals("dark") || this.mBlurEffect.equals("extralight")) {
            FrameLayout.LayoutParams layoutParams2;
            TabView tabView7 = this;
            tabView7.mDefaultBackgroundColor = "#00FFFFFF";
            tabView7.mBlurDraweeView = new DCBlurDraweeView((Context)iApp.getActivity(), true, "semi-automatic");
            context = layoutParams2;
            new FrameLayout.LayoutParams((int)-1, (int)this.mTabHeight).gravity = 80;
            tabView7.mBlurDraweeView.setDownscaleFactor(0.3f);
            tabView7.mBlurDraweeView.setBlurRadius(20);
            tabView7.mBlurDraweeView.setBlurEffect(this.mBlurEffect);
            tabView7.mBlurDraweeView.setGravityType(80);
            tabView7.addView((View)tabView7.mBlurDraweeView, (ViewGroup.LayoutParams)context);
            tabView7.mBlurDraweeView.setBlur(true);
            tabView7.mBlurDraweeView.setRootView(view);
            tabView7.mBlurDraweeView.setBlurLayoutChangeCallBack(new DCBlurDraweeView.BlurLayoutChangeCallBack(){

                @Override
                public void setVisibility(int n2) {
                    if (TabView.this.mTabBar != null) {
                        TabView.this.mTabBar.setVisibility(n2);
                    }
                }
            });
        }
        TabView tabView8 = this;
        tabView8.addView((View)tabView8.mTabBar, new ViewGroup.LayoutParams(-1, this.mTabHeight));
        tabView8.initTabStyle();
        tabView8.initTabItemStyle();
        tabView8.setSelectedStyle();
        tabView8.setOnTouchListener(tabView8.mMidTouchListener);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setDotBadgeMarginTop(ViewGroup viewGroup, View view) {
        float f2;
        View view2 = viewGroup.findViewById(R.id.tabIV);
        float f3 = (float)view.getHeight() / this.mScale;
        float f4 = ((float)viewGroup.getHeight() / this.mScale - (float)viewGroup.findViewById(R.id.contentWrapper).getHeight() / this.mScale) / 2.0f;
        float f5 = 2.0f;
        if (view2.getVisibility() == 0) {
            f3 /= 2.0f;
        }
        float f6 = f4 - f3;
        if (!(f2 > f5)) {
            f3 = f4 > f3 && f6 < f5 || f4 < f3 && f4 > f5 ? f4 - f5 : 0.0f;
        }
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)view.getLayoutParams();
        ((RelativeLayout.LayoutParams)view.getLayoutParams()).topMargin = (int)(-f3 * this.mScale);
        if (view2.getVisibility() == 0) {
            f3 = 0.0f;
            if (view.getId() == R.id.itemDot) {
                f3 = this.mScale * -5.0f;
            } else if (view.getId() == R.id.itemBadge) {
                f3 = this.mScale * -9.0f;
            }
            layoutParams.leftMargin = (int)(f3 - (float)((viewGroup.findViewById(R.id.contentWrapper).getWidth() - view2.getWidth()) / 2));
        }
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    /*
     * Unable to fully structure code
     */
    private void setSelectedStyle() {
        for (var1_1 = 0; var1_1 < this.mTabItemViews.size(); ++var1_1) {
            block14: {
                block13: {
                    var2_2 = this.mCommonSelectedIndex;
                    if (var2_2 == null) continue;
                    v0 = Integer.parseInt(var2_2);
                    v1 = (ViewGroup)this.mTabItemViews.get(var1_1);
                    var2_2 = (TextView)v1.findViewById(R.id.tabTV);
                    var3_3 = (ImageView)v1.findViewById(R.id.tabIV);
                    var4_4 = (TextView)v1.findViewById(R.id.iconfontTV);
                    var5_5 = (JSONObject)var2_2.getTag();
                    var6_6 = var5_5.getJSONObject("iconfont");
                    if (v0 != var1_1) break block14;
                    var2_2.setTextColor(TabView.optColor(this.mSelectedColor, this.mDefaultSelectedTextColor));
                    if (var6_6 != null) {
                        if (var6_6.containsKey((Object)"selectedText")) {
                            var4_4.setText((CharSequence)var6_6.getString("selectedText"));
                        }
                        if (!var6_6.containsKey((Object)"selectedColor")) continue;
                        var4_4.setTextColor(PdrUtil.stringToColor(var6_6.getString("selectedColor")));
                        continue;
                    }
                    var2_2 = var5_5.getString("selectedIconPath");
                    var4_4 = this.getIconPath(var2_2);
                    if (!var4_4.startsWith("file:///android_asset/")) break block13;
                    var4_4 = var4_4.replace("file:///android_asset/", "");
                    var5_5 = v2;
                    v2 = new GifDrawable(this.mContext.getAssets(), (String)var4_4);
                    ** GOTO lbl37
                }
                var5_5 = v3;
                v4 = var4_4;
                var4_4 = this.getContext().getContentResolver();
                try {
                    v3 = new GifDrawable((ContentResolver)var4_4, Uri.parse((String)v4));
lbl37:
                    // 2 sources

                    v5 = var5_5;
                    v5.setLoopCount(1);
                    v5.addAnimationListener(new AnimationListener(){

                        public void onAnimationCompleted(int n2) {
                            Drawable drawable = var3_3.getDrawable();
                            if (drawable instanceof GifDrawable) {
                                GifDrawable gifDrawable = (GifDrawable)drawable;
                                gifDrawable.seekToFrame(gifDrawable.getNumberOfFrames());
                                gifDrawable.removeAnimationListener((AnimationListener)this);
                            }
                        }
                    });
                    var3_3.setImageDrawable((Drawable)v5);
                }
                catch (Exception v6) {
                    this.placeholder(var2_2, var3_3);
                }
                continue;
            }
            var2_2.setTextColor(TabView.optColor(this.mTextColor, this.mDefaultTextColor));
            if (var6_6 != null) {
                if (var6_6.containsKey((Object)"text")) {
                    var4_4.setText((CharSequence)var6_6.getString("text"));
                }
                if (!var6_6.containsKey((Object)"color")) continue;
                var4_4.setTextColor(TabView.optColor(var6_6.getString("color"), this.mDefaultTextColor));
                continue;
            }
            this.placeholder(var5_5.getString("iconPath"), var3_3);
        }
    }

    private void initTabStyle() {
        Object object;
        if (this.mTabBar.getBackground() instanceof BackGroundDrawable) {
            object = (BackGroundDrawable)this.mTabBar.getBackground();
        } else {
            BackGroundDrawable backGroundDrawable;
            object = backGroundDrawable;
            backGroundDrawable = new BackGroundDrawable();
            this.mTabBar.setBackground((Drawable)object);
        }
        TabView tabView = this;
        BackGroundDrawable backGroundDrawable = object;
        BackGroundDrawable backGroundDrawable2 = object;
        BackGroundDrawable backGroundDrawable3 = object;
        TabView tabView2 = this;
        object = tabView2.repeatType;
        backGroundDrawable3.setBackgroundRepeat((String)object, tabView2.mBackgroundImage);
        int n2 = TabView.optColor(this.mBackgroundColor, this.mDefaultBackgroundColor);
        backGroundDrawable2.setBackgroundColor(n2);
        backGroundDrawable.setBackgroundImage(this.mBackgroundImage);
        tabView.changeNavigationBarColor(n2);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)tabView.mTabBar.getLayoutParams();
        layoutParams.gravity = 80;
        ((FrameLayout.LayoutParams)tabView.mTabBar.getLayoutParams()).height = this.mTabHeight;
        tabView.mTabBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        tabView.mBorderView.setBackgroundColor(TabView.optColor(this.mBorderStyle, this.mDefaultBorderColor));
    }

    private void initTabItemStyle() {
        for (int i2 = 0; i2 < this.mCommonList.size(); ++i2) {
            this.setCommonItemStyle(i2, (JSONObject)this.mCommonList.get(i2));
        }
        this.updateMidItemStyle();
    }

    private void setTabItemStyle() {
        this.initTabItemStyle();
    }

    private void updateMidItemStyle() {
        LinearLayout.LayoutParams layoutParams;
        float f2;
        float f3;
        float f4;
        boolean bl = true;
        JSONObject jSONObject = tabView5.mMidButton;
        if (jSONObject != null && jSONObject.containsKey((Object)"visible")) {
            bl = tabView5.mMidButton.getBooleanValue("visible");
        }
        if (bl) {
            bl = tabView5.canMidButtonShowDisplayed();
        }
        if (!bl) {
            RelativeLayout relativeLayout = tabView5.mMidButtonView;
            if (relativeLayout != null && relativeLayout.getParent() != null) {
                tabView5.mTabBar.removeView((View)tabView5.mMidButtonView);
            }
            return;
        }
        JSONObject jSONObject2 = tabView5.mMidButton;
        if (jSONObject2 == null) {
            return;
        }
        if (jSONObject2.getString("height") != null) {
            f4 = tabView5.mScale;
            f4 = PdrUtil.parseFloat(tabView5.mMidButton.getString("height"), 0.0f, 0.0f, f4);
        } else {
            f4 = -1.0f;
        }
        if (tabView5.mMidButton.getString("width") != null) {
            f3 = tabView5.mScale;
            f3 = PdrUtil.parseFloat(tabView5.mMidButton.getString("width"), 0.0f, 0.0f, f3);
        } else {
            f3 = -1.0f;
        }
        TabView tabView = tabView5;
        String string2 = tabView.mMidButton.getString("text");
        JSONObject jSONObject3 = tabView.mMidButton.getJSONObject("textLocales");
        if (jSONObject3 != null) {
            string2 = LanguageUtil.getString(jSONObject3, string2);
        }
        if (tabView5.mMidButton.getString("iconWidth") != null) {
            f2 = tabView5.mScale;
            f2 = PdrUtil.parseFloat(tabView5.mMidButton.getString("iconWidth"), 0.0f, 0.0f, f2);
        } else {
            f2 = tabView5.mScale;
            f2 = PdrUtil.parseFloat(tabView5.mImageSize, 0.0f, 0.0f, f2);
        }
        TabView tabView2 = tabView5;
        String string3 = tabView2.mMidButton.getString("iconPath");
        String string4 = tabView2.mMidButton.getString("backgroundImage");
        JSONObject jSONObject4 = tabView2.mMidButton.getJSONObject("iconfont");
        RelativeLayout relativeLayout = tabView2.mMidButtonView;
        if (relativeLayout == null) {
            tabView5.mMidButtonView = relativeLayout = (RelativeLayout)LayoutInflater.from((Context)tabView5.mContext).inflate(R.layout.dcloud_tabbar_mid, null);
        }
        RelativeLayout relativeLayout2 = relativeLayout;
        TabView tabView3 = tabView5;
        ((GradientDrawable)((ImageView)relativeLayout.findViewById(R.id.itemDot)).getDrawable()).setColor(tabView5.redDotColor);
        float f5 = tabView5.mScale;
        f5 = (int)PdrUtil.parseFloat(tabView3.mImageSize, 0.0f, 0.0f, f5);
        float f6 = tabView5.mScale;
        f6 = (int)PdrUtil.parseFloat(tabView3.mTextTop, 0.0f, 0.0f, f6);
        float f7 = tabView5.mScale;
        f7 = (int)PdrUtil.parseFloat(tabView3.mTextSize, 0.0f, 0.0f, f7);
        ImageView imageView = (ImageView)relativeLayout2.findViewById(R.id.tabIV);
        TextView textView = (TextView)relativeLayout2.findViewById(R.id.tabIconTV);
        if (jSONObject4 != null) {
            imageView.setVisibility(8);
            tabView5.updateIconfont(textView, jSONObject4, f2, false);
        } else if (!TextUtils.isEmpty((CharSequence)string3)) {
            int n2;
            ImageView imageView2 = imageView;
            textView.setVisibility(8);
            ((RelativeLayout.LayoutParams)imageView2.getLayoutParams()).height = n2 = (int)f2;
            ((RelativeLayout.LayoutParams)imageView2.getLayoutParams()).width = n2;
            imageView2.setLayoutParams((ViewGroup.LayoutParams)((RelativeLayout.LayoutParams)imageView2.getLayoutParams()));
            tabView5.placeholder(string3, imageView);
            imageView.setVisibility(0);
        } else {
            textView.setVisibility(8);
            imageView.setVisibility(8);
        }
        TextView textView2 = (TextView)relativeLayout.findViewById(R.id.tabTV);
        float f8 = tabView5.mScale;
        textView2.setTextSize(0, PdrUtil.parseFloat(tabView5.mTextSize, 0.0f, 0.0f, f8));
        textView2.setTextColor(TabView.optColor(tabView5.mTextColor, tabView5.mDefaultTextColor));
        textView2.setText((CharSequence)string2);
        ((RelativeLayout.LayoutParams)textView2.getLayoutParams()).bottomMargin = (int)(((float)tabView5.mTabHeight - (f5 + f6 + f7)) / 2.0f);
        textView2.setLayoutParams((ViewGroup.LayoutParams)((RelativeLayout.LayoutParams)textView2.getLayoutParams()));
        if (TextUtils.isEmpty((CharSequence)string2)) {
            textView2.setVisibility(8);
        } else {
            textView2.setVisibility(0);
        }
        tabView5.placeholder(string4, (ImageView)relativeLayout.findViewById(R.id.bgImg));
        LinearLayout.LayoutParams layoutParams2 = layoutParams;
        int n3 = (int)f3;
        layoutParams = new LinearLayout.LayoutParams(n3, (int)f4);
        if (f3 == -1.0f) {
            layoutParams2.weight = 1.0f;
        }
        if (tabView5.mMidButtonView.getParent() != null) {
            tabView5.mTabBar.removeView((View)tabView5.mMidButtonView);
        }
        TabView tabView4 = tabView5;
        TabView tabView5 = tabView4.mMidButtonView;
        tabView5.mTabBar.addView((View)tabView5, tabView4.mMidIndex, (ViewGroup.LayoutParams)layoutParams2);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void setCommonItemStyle(int var1_1, JSONObject var2_3) {
        block21: {
            block24: {
                block23: {
                    block19: {
                        block22: {
                            block20: {
                                v0 = var2_3;
                                v0.getString("pagePath");
                                var3_4 = v0.getString("text");
                                var4_5 /* !! */  = v0.getJSONObject("textLocales");
                                if (var4_5 /* !! */  != null) {
                                    var3_4 = LanguageUtil.getString(var4_5 /* !! */ , var3_4);
                                }
                                v1 = var2_3;
                                var4_5 /* !! */  = v1.getString("iconPath");
                                var5_11 = v1.getString("selectedIconPath");
                                var6_13 = v1.getJSONObject("iconfont");
                                var7_14 = Integer.parseInt(this.mCommonSelectedIndex);
                                var8_15 = true;
                                if (var2_3.containsKey((Object)"visible")) {
                                    var8_15 = var2_3.getBooleanValue("visible");
                                }
                                if (this.mTabItemViews.size() - 1 < var1_1) {
                                    v2 = this;
                                    var9_16 = (RelativeLayout)LayoutInflater.from((Context)v2.mContext).inflate(R.layout.dcloud_tabbar_item, null);
                                    var9_16.setTag((Object)var1_1);
                                    var9_16.setOnClickListener(this.mOnClickListener);
                                    var10_17 = v3;
                                    new LinearLayout.LayoutParams((int)-1, (int)-1).weight = 1.0f;
                                    v2.mTabBar.addView((View)var9_16, (ViewGroup.LayoutParams)var10_17);
                                    v2.mTabItemViews.add(var9_16);
                                } else {
                                    var9_16 = this.mTabItemViews.get(var1_1);
                                }
                                v4 = var9_16;
                                var10_17 = (ImageView)v4.findViewById(R.id.tabIV);
                                var11_18 = (TextView)v4.findViewById(R.id.iconfontTV);
                                if (var6_13 == null) break block20;
                                var10_17.setVisibility(8);
                                var4_6 = this.mScale;
                                var4_6 = PdrUtil.parseFloat(this.mImageSize, 0.0f, 0.0f, var4_6);
                                var5_12 = var7_14 == var1_1;
                                this.updateIconfont(var11_18, var6_13, var4_6, var5_12);
                                break block21;
                            }
                            if (!PdrUtil.isEmpty(var4_5 /* !! */ ) || !PdrUtil.isEmpty(var5_11)) break block22;
                            var10_17.setVisibility(8);
                            var11_18.setVisibility(8);
                            break block21;
                        }
                        if (PdrUtil.isEmpty(var5_11) || var7_14 != var1_1) break block23;
                        v5 = var10_17;
                        v5.setVisibility(0);
                        var4_7 = this.mScale;
                        ((LinearLayout.LayoutParams)v5.getLayoutParams()).height = (int)PdrUtil.parseFloat(this.mImageSize, 0.0f, 0.0f, var4_7);
                        var4_7 = this.mScale;
                        ((LinearLayout.LayoutParams)v5.getLayoutParams()).width = (int)PdrUtil.parseFloat(this.mImageSize, 0.0f, 0.0f, var4_7);
                        v5.setLayoutParams((ViewGroup.LayoutParams)((LinearLayout.LayoutParams)v5.getLayoutParams()));
                        var4_8 = this.getIconPath(var5_11);
                        if (!var4_8.startsWith("file:///android_asset/")) break block19;
                        var4_8 = var4_8.replace("file:///android_asset/", "");
                        var6_13 = v6;
                        v6 = new GifDrawable(this.mContext.getAssets(), var4_8);
                        ** GOTO lbl68
                    }
                    var6_13 = v7;
                    v8 = var4_8;
                    var4_8 = this.getContext().getContentResolver();
                    try {
                        v7 = new GifDrawable((ContentResolver)var4_8, Uri.parse((String)v8));
lbl68:
                        // 2 sources

                        v9 = var6_13;
                        v9.setLoopCount(1);
                        var10_17.setImageDrawable((Drawable)v9);
                    }
                    catch (Exception v10) {
                        this.placeholder(var5_11, var10_17);
                    }
                    break block24;
                }
                if (!PdrUtil.isEmpty(var4_5 /* !! */ )) {
                    v11 = var10_17;
                    v11.setVisibility(0);
                    var4_9 = this.mScale;
                    ((LinearLayout.LayoutParams)v11.getLayoutParams()).height = (int)PdrUtil.parseFloat(this.mImageSize, 0.0f, 0.0f, var4_9);
                    var4_9 = this.mScale;
                    ((LinearLayout.LayoutParams)v11.getLayoutParams()).width = (int)PdrUtil.parseFloat(this.mImageSize, 0.0f, 0.0f, var4_9);
                    v11.setLayoutParams((ViewGroup.LayoutParams)((LinearLayout.LayoutParams)v11.getLayoutParams()));
                    this.placeholder((String)var4_5 /* !! */ , var10_17);
                } else {
                    var10_17.setVisibility(8);
                }
            }
            var11_18.setVisibility(8);
        }
        v12 = var9_16;
        var4_10 = (TextView)v12.findViewById(R.id.tabTV);
        var4_10.setTag((Object)var2_3);
        ((GradientDrawable)((ImageView)v12.findViewById(R.id.itemDot)).getDrawable()).setColor(this.redDotColor);
        if (!PdrUtil.isEmpty(var3_4)) {
            v13 = var4_10;
            v13.setVisibility(0);
            var1_2 = this.mScale;
            ((LinearLayout.LayoutParams)v13.getLayoutParams()).topMargin = (int)PdrUtil.parseFloat(this.mTextTop, 0.0f, 0.0f, var1_2);
            v13.setLayoutParams((ViewGroup.LayoutParams)((LinearLayout.LayoutParams)v13.getLayoutParams()));
            var1_2 = this.mScale;
            var4_10.setTextSize(0, PdrUtil.parseFloat(this.mTextSize, 0.0f, 0.0f, var1_2));
            if (var7_14 != var1_1) {
                var4_10.setTextColor(TabView.optColor(this.mTextColor, this.mDefaultTextColor));
            } else {
                var4_10.setTextColor(TabView.optColor(this.mSelectedColor, this.mDefaultSelectedTextColor));
            }
            var4_10.setText((CharSequence)var3_4);
        } else {
            var4_10.setVisibility(8);
        }
        if (var8_15) {
            var9_16.setVisibility(0);
        } else {
            var9_16.setVisibility(8);
        }
    }

    private String getIconPath(String string2) {
        Object object = ((TabView)((Object)object)).mWebApp.convert2AbsFullPath(string2);
        if (object != null && PdrUtil.isDeviceRootDir((String)object)) {
            return "file://" + (String)object;
        }
        if (object != null && ((String)object).startsWith("/") && ((String)object).length() > 1) {
            object = ((String)object).substring(1);
        }
        if (object != null && ((String)object).startsWith("android_asset/")) {
            object = ((String)object).replace("android_asset/", "");
        }
        return "file:///android_asset/" + (String)object;
    }

    private void setCommonItemJson(int n2, String string2, String object, String string3, JSONObject jSONObject, boolean bl) {
        if (n2 >= this.mCommonList.size()) {
            return;
        }
        JSONObject jSONObject2 = this.mCommonList.getJSONObject(n2);
        if (string2 != null) {
            jSONObject2.put("text", (Object)string2);
        }
        if (object != null) {
            jSONObject2.put("iconPath", object);
        }
        if (string3 != null) {
            jSONObject2.put("selectedIconPath", (Object)string3);
        }
        if (jSONObject != null) {
            if (jSONObject2.containsKey((Object)"iconfont")) {
                string2 = jSONObject2.getJSONObject("iconfont");
                if (string2 != null && (object = jSONObject.keySet().iterator()) != null) {
                    while (object.hasNext()) {
                        string3 = (String)object.next();
                        string2.put(string3, (Object)jSONObject.getString(string3));
                    }
                }
            } else {
                jSONObject2.put("iconfont", (Object)jSONObject);
            }
        }
        jSONObject2.put("visible", (Object)bl);
        this.setCommonItemStyle(n2, jSONObject2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int optColor(String string2, String string3) {
        if (string2 != null) return PdrUtil.stringToColor(string2);
        try {
            return PdrUtil.stringToColor(string3);
        }
        catch (Exception exception) {
            return PdrUtil.stringToColor(string3);
        }
    }

    private ViewGroup getCommonItemByIndex(int n2) {
        if (this.mTabItemViews.size() - 1 >= n2) {
            return (ViewGroup)this.mTabItemViews.get(n2);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void placeholder(String string2, ImageView imageView) {
        if (TextUtils.isEmpty((CharSequence)string2)) return;
        try {
            ((RequestBuilder)((RequestBuilder)Glide.with((Context)this.getContext()).load(this.getIconPath(string2)).dontAnimate()).placeholder(imageView.getDrawable())).into(imageView);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return;
    }

    private void changeNavigationBarColor(final int n2) {
        if (Build.VERSION.SDK_INT >= 26 && this.mContext != null) {
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    6 v0 = this;
                    Window window = ((Activity)v0.TabView.this.mContext).getWindow();
                    window.setNavigationBarColor(n2);
                    int n22 = window.getDecorView().getSystemUiVisibility();
                    n22 = PdrUtil.isLightColor(v0.n2) ? (n22 |= 0x10) : (n22 &= 0xFFFFFFEF);
                    window.getDecorView().setSystemUiVisibility(n22);
                }
            }, 400L);
        }
    }

    public void setSingleCallbackListener(ICallBack iCallBack) {
        this.mISingleCallback = iCallBack;
    }

    public void setMaskCallbackListener(ICallBack iCallBack) {
        this.mIMaskCallback = iCallBack;
    }

    public void setDoubleCallbackListener(ICallBack iCallBack) {
        this.mIDoubleCallback = iCallBack;
    }

    public void setMidCallbackListener(ICallBack iCallBack) {
        this.mIMidCallback = iCallBack;
    }

    public void switchTab(int n2) {
        TabView tabView = frameLayout;
        tabView.mCommonSelectedIndex = String.valueOf(n2);
        tabView.setSelectedStyle();
        FrameLayout frameLayout = tabView.mBlurDraweeView;
        if (frameLayout != null) {
            frameLayout.postInvalidate(1000L);
        }
    }

    public void showTabBarRedDot(JSONObject jSONObject) {
        if ((jSONObject = this.getCommonItemByIndex(jSONObject.getInteger("index"))) != null) {
            ImageView imageView = (ImageView)jSONObject.findViewById(R.id.itemDot);
            JSONObject jSONObject2 = jSONObject;
            ((TextView)jSONObject2.findViewById(R.id.itemBadge)).setVisibility(4);
            this.setDotBadgeMarginTop((ViewGroup)jSONObject2, (View)imageView);
            imageView.setVisibility(0);
        }
    }

    public void hideTabBarRedDot(JSONObject jSONObject) {
        if ((this = this.getCommonItemByIndex(jSONObject.getInteger("index"))) != null) {
            ((ImageView)this.findViewById(R.id.itemDot)).setVisibility(4);
        }
    }

    public void setTabBarBadge(JSONObject jSONObject) {
        JSONObject jSONObject2 = jSONObject;
        int n2 = jSONObject2.getInteger("index");
        String string2 = jSONObject2.getString("text");
        ViewGroup viewGroup = this.getCommonItemByIndex(n2);
        if (viewGroup != null) {
            ViewGroup viewGroup2 = viewGroup;
            ImageView imageView = (ImageView)viewGroup2.findViewById(R.id.itemDot);
            TextView textView = (TextView)viewGroup2.findViewById(R.id.itemBadge);
            imageView.setVisibility(4);
            textView.setText((CharSequence)string2);
            this.setDotBadgeMarginTop(viewGroup, (View)textView);
            textView.setVisibility(0);
        }
    }

    public void removeTabBarBadge(JSONObject jSONObject) {
        if ((this = this.getCommonItemByIndex(jSONObject.getInteger("index"))) != null) {
            ((TextView)this.findViewById(R.id.itemBadge)).setVisibility(4);
        }
    }

    public void setTabBarStyle(JSONObject object) {
        int n2;
        if (object.containsKey((Object)"color")) {
            this.mTextColor = object.getString("color");
        }
        if (object.containsKey((Object)"selectedColor")) {
            this.mSelectedColor = object.getString("selectedColor");
        }
        if (object.containsKey((Object)"backgroundColor")) {
            this.mBackgroundColor = object.getString("backgroundColor");
        }
        if (object.containsKey((Object)"backgroundImage")) {
            this.mBackgroundImage = object.getString("backgroundImage");
        }
        if (object.containsKey((Object)"borderStyle")) {
            this.mBorderStyle = object.getString("borderStyle");
        }
        if (object.containsKey((Object)"height")) {
            String string2;
            this.mTabHeightStr = string2 = object.getString("height");
            float f2 = this.mScale;
            this.mTabHeight = (int)PdrUtil.parseFloat(string2, 0.0f, 0.0f, f2);
        }
        if (object.containsKey((Object)"midButton")) {
            this.mMidButton = object.getJSONObject("midButton");
        }
        if (object.containsKey((Object)"fontSize")) {
            this.mTextSize = object.getString("fontSize");
        }
        if (object.containsKey((Object)"iconWidth")) {
            this.mImageSize = object.getString("iconWidth");
        }
        if (object.containsKey((Object)"backgroundRepeat")) {
            this.repeatType = object.getString("backgroundRepeat");
        }
        TabView tabView = this;
        tabView.initTabStyle();
        tabView.setTabItemStyle();
        tabView.setSelectedStyle();
        if (object.containsKey((Object)"redDotColor") && !PdrUtil.isEmpty(object = object.getString("redDotColor")) && this.redDotColor != (n2 = PdrUtil.stringToColor((String)object))) {
            this.redDotColor = PdrUtil.stringToColor((String)object);
            for (int i2 = 0; i2 < this.mTabItemViews.size(); ++i2) {
                ViewGroup viewGroup = (ViewGroup)this.mTabItemViews.get(i2);
                if (viewGroup == null) continue;
                ((GradientDrawable)((ImageView)viewGroup.findViewById(R.id.itemDot)).getDrawable()).setColor(this.redDotColor);
            }
        }
    }

    public void setTabBarItem(JSONObject jSONObject) {
        JSONObject jSONObject2 = jSONObject;
        int n2 = jSONObject2.getInteger("index");
        String string2 = jSONObject2.getString("text");
        String string3 = jSONObject2.getString("iconPath");
        String string4 = jSONObject2.getString("selectedIconPath");
        boolean bl = true;
        if (jSONObject2.containsKey((Object)"visible")) {
            bl = jSONObject.getBooleanValue("visible");
        }
        JSONObject jSONObject3 = null;
        if (jSONObject.containsKey((Object)"iconfont")) {
            jSONObject3 = jSONObject.getJSONObject("iconfont");
        }
        this.setCommonItemJson(n2, string2, string3, string4, jSONObject3, bl);
    }

    public int getTabHeight() {
        DCBlurDraweeView dCBlurDraweeView = this.mBlurDraweeView;
        if (dCBlurDraweeView != null && dCBlurDraweeView.checkBlurEffect(this.mBlurEffect)) {
            return 0;
        }
        return this.mTabHeight;
    }

    public String getTabHeightStr() {
        DCBlurDraweeView dCBlurDraweeView = this.mBlurDraweeView;
        if (dCBlurDraweeView != null && dCBlurDraweeView.checkBlurEffect(this.mBlurEffect)) {
            return "0";
        }
        return this.mTabHeightStr;
    }

    public int getMidHeight() {
        JSONObject jSONObject = this.mMidButton;
        if (jSONObject == null) {
            return 0;
        }
        float f2 = this.mScale;
        return (int)PdrUtil.parseFloat(jSONObject.getString("height"), 0.0f, 0.0f, f2);
    }

    public void setMask(JSONObject jSONObject) {
        String string2 = null;
        if (jSONObject != null && jSONObject.containsKey((Object)"color")) {
            string2 = jSONObject.getString("color");
        }
        if (!"none".equals(string2)) {
            if (this.mMask == null) {
                LinearLayout linearLayout;
                TabView tabView = this;
                JSONObject jSONObject2 = jSONObject = linearLayout;
                jSONObject2(this.mContext);
                this.mMask = jSONObject2;
                linearLayout.setOnClickListener(this.mOnMaskClickListener);
                tabView.mMask.setBackgroundColor(TabView.optColor(string2, this.mDefaultMaskBackgroundColor));
                ((FrameLayout)tabView.getParent()).addView((View)this.mMask, new ViewGroup.LayoutParams(-1, -1));
            }
        } else if (this.mMask != null) {
            ((FrameLayout)this.getParent()).removeView((View)this.mMask);
            this.mMask = null;
        }
    }

    public void bringMaskToFront() {
        TabView tabView = tabView.mMask;
        if (tabView != null) {
            tabView.bringToFront();
        }
    }

    public void updateIconfont(TextView textView, JSONObject object, float f2, boolean bl) {
        if (tabView.mWebApp != null && textView != null && object != null && !TextUtils.isEmpty((CharSequence)tabView.mIconfontPath)) {
            int n2;
            JSONObject jSONObject = object;
            textView.setVisibility(0);
            byte by = tabView.mWebApp.obtainRunningAppMode();
            String string2 = jSONObject.getString("text");
            if (jSONObject.containsKey((Object)"fontSize")) {
                float f3 = tabView.mScale;
                textView.setTextSize(0, (float)((int)PdrUtil.parseFloat(object.getString("fontSize"), 0.0f, 0.0f, f3)));
            }
            if (bl && object.containsKey((Object)"selectedColor")) {
                textView.setTextColor(PdrUtil.stringToColor(object.getString("selectedColor")));
            } else if (object.containsKey((Object)"color")) {
                textView.setTextColor(PdrUtil.stringToColor(object.getString("color")));
            }
            if (!tabView.mIconfontPath.startsWith("/storage") && by == 1) {
                try {
                    textView.setTypeface(Typeface.createFromAsset((AssetManager)tabView.getContext().getAssets(), (String)tabView.mIconfontPath));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                File file;
                object = file;
                if (new File(tabView.mIconfontPath).exists()) {
                    textView.setTypeface(Typeface.createFromFile((File)object));
                }
            }
            TextView textView2 = textView;
            TabView tabView = textView2.getLayoutParams();
            textView2.getLayoutParams().height = n2 = (int)f2;
            textView2.getLayoutParams().width = n2;
            textView2.setLayoutParams((ViewGroup.LayoutParams)tabView);
            textView2.setText((CharSequence)string2);
            textView2.setVisibility(0);
            return;
        }
    }

    public void updateMidButton(JSONObject jSONObject) {
        if (jSONObject != null) {
            this.mMidButton = jSONObject;
        }
        this.updateMidItemStyle();
    }

    public int getTabItemDisplayedSize() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.mCommonList.size(); ++i2) {
            JSONObject jSONObject = this.mCommonList.getJSONObject(i2);
            if (jSONObject == null || jSONObject.containsKey((Object)"visible") && !jSONObject.getBoolean("visible").booleanValue()) continue;
            ++n2;
        }
        return n2;
    }

    public boolean canMidButtonShowDisplayed() {
        int n2 = this.getTabItemDisplayedSize();
        boolean bl = n2 % 2 == 0;
        if (bl) {
            int n3 = n2;
            n2 = 0;
            int n4 = n3 / 2;
            for (int i2 = 0; i2 < this.mCommonList.size(); ++i2) {
                JSONObject jSONObject = this.mCommonList.getJSONObject(i2);
                if (jSONObject == null) continue;
                if (!jSONObject.containsKey((Object)"visible") || jSONObject.getBoolean("visible").booleanValue()) {
                    ++n2;
                }
                if (n2 != n4) continue;
                this.mMidIndex = i2 + 1;
            }
        }
        return bl;
    }

    public void dispose() {
        this.mTabItemViews.clear();
        this.mMidButtonView = null;
    }

    public void setIWebViewFocusable(boolean bl) {
        DCBlurDraweeView dCBlurDraweeView = this.mBlurDraweeView;
        if (dCBlurDraweeView != null && dCBlurDraweeView.checkBlurEffect(this.mBlurEffect)) {
            this.mBlurDraweeView.setContentFocusable(bl);
        }
    }

    class BackGroundDrawable
    extends Drawable {
        private Shader mBackgroundBitmap = null;
        private String bitmapPath = null;
        private String repeat = "no-repeat";
        private int mBackgroundColor = 0;
        private Rect bound;
        private Paint colorPaint;
        private Paint mPaint;

        BackGroundDrawable() {
        }

        private Bitmap scaleBitmap(Bitmap bitmap, int n2, int n3) {
            Matrix matrix;
            if (bitmap == null) {
                return null;
            }
            if (this.repeat.equals("repeat")) {
                return bitmap;
            }
            int n4 = n3;
            int n5 = n2;
            Bitmap bitmap2 = bitmap;
            n2 = bitmap2.getHeight();
            n3 = bitmap2.getWidth();
            float f2 = (float)n5 / (float)n3;
            float f3 = (float)n4 / (float)n2;
            Matrix matrix2 = matrix;
            matrix = new Matrix();
            if (this.repeat.equals("repeat-x")) {
                matrix2.preScale(1.0f, f3);
            } else if (this.repeat.equals("repeat-y")) {
                matrix2.preScale(f2, 1.0f);
            } else {
                matrix2.preScale(f2, f3);
            }
            return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n3, (int)n2, (Matrix)matrix2, (boolean)false);
        }

        private Shader getShader(List<String> list, float object, float object2) {
            float[] fArray = object3.parseGradientDirection(list.get(0).trim(), (float)object, (float)object2);
            Object object3 = fArray;
            if (fArray == null) {
                return null;
            }
            List<String> list2 = list;
            Object object4 = object3;
            BackGroundDrawable backGroundDrawable = object4[0];
            BackGroundDrawable backGroundDrawable2 = object4[1];
            object = (Object)object4[2];
            object2 = (Object)object4[3];
            int n2 = PdrUtil.stringToColor(list2.get(1).trim());
            int n3 = PdrUtil.stringToColor(list2.get(2).trim());
            Shader.TileMode tileMode = Shader.TileMode.CLAMP;
            return new LinearGradient((float)backGroundDrawable, (float)backGroundDrawable2, object, object2, n2, n3, tileMode);
        }

        private float[] parseGradientDirection(String string2, float f2, float f3) {
            int n2 = 0;
            int n3 = 1;
            int n4 = 2;
            int n5 = 3;
            float[] fArray = new float[4];
            float[] fArray2 = fArray;
            fArray[0] = 0.0f;
            fArray[1] = 0.0f;
            fArray[2] = 0.0f;
            fArray[3] = 0.0f;
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                string2 = string2.replaceAll("\\s*", "").toLowerCase(Locale.ENGLISH);
            }
            String string3 = string2;
            string3.hashCode();
            int n6 = -1;
            switch (string3.hashCode()) {
                default: {
                    break;
                }
                case 1176531318: {
                    if (!string2.equals("tobottomright")) break;
                    n6 = 5;
                    break;
                }
                case 110550266: {
                    if (!string2.equals("totop")) break;
                    n6 = 4;
                    break;
                }
                case -172068863: {
                    if (!string2.equals("totopleft")) break;
                    n6 = 3;
                    break;
                }
                case -868157182: {
                    if (!string2.equals("toleft")) break;
                    n6 = 2;
                    break;
                }
                case -1137407871: {
                    if (!string2.equals("toright")) break;
                    n6 = 1;
                    break;
                }
                case -1352032154: {
                    if (!string2.equals("tobottom")) break;
                    n6 = 0;
                }
            }
            switch (n6) {
                default: {
                    return null;
                }
                case 5: {
                    fArray2[n4] = f2;
                    fArray2[n5] = f3;
                    break;
                }
                case 4: {
                    fArray2[n3] = f3;
                    break;
                }
                case 3: {
                    fArray2[n2] = f2;
                    fArray2[n3] = f3;
                    break;
                }
                case 2: {
                    fArray2[n2] = f2;
                    break;
                }
                case 1: {
                    fArray2[n4] = f2;
                    break;
                }
                case 0: {
                    fArray2[n5] = f3;
                }
            }
            return fArray2;
        }

        /*
         * Unable to fully structure code
         */
        private List<String> parseGradientValues(String var1_3) {
            block19: {
                if (TextUtils.isEmpty((CharSequence)var1_3)) {
                    return null;
                }
                v0 = var1_3;
                v0.trim();
                if (!v0.startsWith("linear-gradient")) break block19;
                v1 = var1_3;
                v2 = v1;
                v3 = v1;
                var0_1 = v1.indexOf("(") + 1;
                var0_2 = v2.substring(var0_1, v3.lastIndexOf(")"));
                var1_3 = v4;
                v4 = new StringTokenizer((String)var0_2, ",");
                var0_2 = v5;
                try {
                    v5 = new ArrayList<E>();
                    ** GOTO lbl40
                    ** while (var1_3.hasMoreTokens())
                }
                catch (Exception v8) {
                    return null;
                }
lbl-1000:
                // 1 sources

                {
                    block21: {
                        block20: {
                            var3_5 = var1_3.nextToken();
                            if (!var3_5.contains("(")) break block20;
                            v6 = var3_5 + ",";
lbl29:
                            // 2 sources

                            while (true) {
                                var2_4 = v6;
                                continue block16;
                                break;
                            }
                        }
                        if (!var3_5.contains(")")) break block21;
                        v7 = var0_2;
                        v7.add(var2_4 + var3_5);
lbl40:
                        // 2 sources

                        var2_4 = null;
                        continue;
                    }
                    if (var2_4 == null) ** GOTO lbl47
                    v6 = var2_4 + var3_5 + ",";
                    ** continue;
lbl47:
                    // 1 sources

                    var0_2.add(var3_5);
                    continue;
                }
lbl50:
                // 1 sources

                return var0_2;
            }
            return null;
        }

        public void setBackgroundColor(int n2) {
            if (this.mBackgroundBitmap != null) {
                this.setAlpha(Color.alpha((int)n2));
            } else {
                this.mBackgroundColor = n2;
            }
            this.invalidateSelf();
        }

        public void setBackgroundRepeat(String string2, String string3) {
            if (!(PdrUtil.isEmpty(string2) || string2.equals(this.repeat) || TextUtils.isEmpty((CharSequence)string3))) {
                this.repeat = string2;
                this.mBackgroundBitmap = null;
                this.setBackgroundImage(string3);
            }
        }

        public void setBackgroundImage(String object) {
            Object object2 = this.bound;
            if (object2 != null && object2.width() != 0) {
                if (object == null) {
                    return;
                }
                object2 = this.parseGradientValues((String)object);
                if (object2 != null && object2.size() == 3) {
                    BackGroundDrawable backGroundDrawable = this;
                    float f2 = backGroundDrawable.bound.width();
                    this.mBackgroundBitmap = this.getShader((List<String>)object2, f2, backGroundDrawable.bound.height());
                } else {
                    object = TabView.this.getIconPath((String)object);
                    object2 = null;
                    if (((String)object).startsWith("file:///android_asset/")) {
                        object = ((String)object).replace("file:///android_asset/", "");
                        try {
                            object2 = BitmapFactory.decodeStream((InputStream)TabView.this.getContext().getAssets().open((String)object));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else if (((String)object).startsWith("file://")) {
                        object2 = BitmapFactory.decodeFile((String)((String)object).replace("file://", ""));
                    }
                    if (object2 == null) {
                        this.mBackgroundBitmap = null;
                        this.bitmapPath = null;
                        this.invalidateSelf();
                        return;
                    }
                    byte[] byArray = object2.getNinePatchChunk();
                    object = byArray;
                    if (byArray != null && NinePatch.isNinePatchChunk((byte[])object)) {
                        Canvas canvas;
                        Rect rect;
                        Object object3 = object;
                        object = rect;
                        rect = new Rect();
                        NinePatchDrawable ninePatchDrawable = new NinePatchDrawable((Bitmap)object2, (byte[])object3, (Rect)object, null);
                        object = Bitmap.createBitmap((int)this.bound.width(), (int)this.bound.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        object2 = canvas;
                        int n2 = new Canvas((Bitmap)object).getWidth();
                        int n3 = object2.getHeight();
                        ninePatchDrawable.setBounds(0, 0, n2, n3);
                        ninePatchDrawable.draw((Canvas)object2);
                    } else {
                        BackGroundDrawable backGroundDrawable = this;
                        int n4 = backGroundDrawable.bound.width();
                        object = this.scaleBitmap((Bitmap)object2, n4, backGroundDrawable.bound.height());
                    }
                    if (object == null) {
                        this.mBackgroundBitmap = null;
                    } else {
                        BitmapShader bitmapShader;
                        object2 = bitmapShader;
                        Shader.TileMode tileMode = Shader.TileMode.REPEAT;
                        bitmapShader = new BitmapShader((Bitmap)object, tileMode, tileMode);
                        this.mBackgroundBitmap = object2;
                    }
                }
                this.invalidateSelf();
                return;
            }
            this.bitmapPath = object;
        }

        public void draw(Canvas canvas) {
            if (this.bound == null) {
                this.bound = this.getBounds();
            }
            if (this.mBackgroundBitmap != null) {
                BackGroundDrawable backGroundDrawable = this;
                backGroundDrawable.getPaint().setShader(this.mBackgroundBitmap);
                backGroundDrawable.getBackgroundColorPaint().setColor(Color.argb((int)this.getBackgroundColorPaint().getAlpha(), (int)255, (int)255, (int)255));
                Rect rect = backGroundDrawable.bound;
                canvas.drawRect(rect, backGroundDrawable.getBackgroundColorPaint());
            } else {
                String string2 = this.bitmapPath;
                if (string2 != null) {
                    BackGroundDrawable backGroundDrawable = this;
                    backGroundDrawable.setBackgroundImage(string2);
                    backGroundDrawable.bitmapPath = null;
                    backGroundDrawable.getBackgroundColorPaint().setColor(Color.argb((int)this.getBackgroundColorPaint().getAlpha(), (int)255, (int)255, (int)255));
                    string2 = backGroundDrawable.bound;
                    canvas.drawRect((Rect)string2, backGroundDrawable.getBackgroundColorPaint());
                    this.getPaint().setShader(this.mBackgroundBitmap);
                } else {
                    this.getPaint().setColor(this.mBackgroundColor);
                }
            }
            Canvas canvas2 = canvas;
            BackGroundDrawable backGroundDrawable = this;
            canvas = backGroundDrawable.bound;
            canvas2.drawRect((Rect)canvas, backGroundDrawable.getPaint());
            if (this.mBackgroundBitmap != null) {
                this.getPaint().setShader(null);
            }
        }

        public void setAlpha(int n2) {
            if (this.mBackgroundBitmap != null || this.bitmapPath != null) {
                BackGroundDrawable backGroundDrawable = this;
                backGroundDrawable.getPaint().setAlpha(n2);
                backGroundDrawable.getBackgroundColorPaint().setAlpha(n2);
            }
        }

        public void setColorFilter(ColorFilter colorFilter) {
        }

        public Paint getBackgroundColorPaint() {
            if (this.colorPaint == null) {
                Paint paint;
                Paint paint2 = paint;
                paint = new Paint();
                this.colorPaint = paint2;
            }
            return this.colorPaint;
        }

        public int getOpacity() {
            return 0;
        }

        public Paint getPaint() {
            if (this.mPaint == null) {
                Paint paint;
                Paint paint2 = paint;
                paint = new Paint(1);
                this.mPaint = paint2;
            }
            return this.mPaint;
        }
    }
}

