/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.widget;

import android.content.Context;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AbsoluteLayout;
import android.widget.Scroller;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.PdrUtil;
import org.json.JSONObject;

public class SlideLayout
extends AbsoluteLayout {
    private static final int SNAP_VELOCITY = 1000;
    private static final int SCROLL_DURATION = 150;
    private static String LEFT = "left";
    private static String RIGHT = "right";
    private static String BEFORE_SLIDE = "beforeSlide";
    private static String AFTER_SLIDE = "afterSlide";
    private boolean mInterceptEventEnable = true;
    private boolean mIsHandledTouchEvent = false;
    private int mTouchSlop;
    private float mLastMotionX = -1.0f;
    private VelocityTracker mVelocityTracker;
    private boolean mCanDoSlideTransverseEvent = false;
    private int mSlideTransverseLeftMaxWitch = 0;
    private int mSlideTransverseRightMaxWitch = 0;
    private int mSlideLeftPosition = -1;
    private int mSlideRightPosition = -1;
    boolean isRightSlide = false;
    boolean isLeftSlide = false;
    boolean isSlideOpen = false;
    private Scroller mScroller = new Scroller(this.getContext());
    private float mFirstX = 0.0f;
    private OnStateChangeListener mChangeListener;

    public SlideLayout(Context context) {
        super(context);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
    }

    private void setState(final String string2, final String string3) {
        if (this.mChangeListener != null) {
            Runnable runnable;
            Runnable runnable2 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    1 v0 = string22;
                    String string22 = v0.string3;
                    string22.SlideLayout.this.mChangeListener.onStateChanged(string22, v0.string2);
                }
            };
            this.postDelayed(runnable2, 150L);
        }
    }

    private void smoothScrollTo(int n2, int n3) {
        SlideLayout slideLayout = this;
        slideLayout.enableChildrenCache();
        int n4 = Math.abs(n2) * 2;
        slideLayout.mScroller.startScroll(this.getScrollX(), 0, n2, 0, n4);
        slideLayout.invalidate();
    }

    public void setOnStateChangeListener(OnStateChangeListener onStateChangeListener) {
        this.mChangeListener = onStateChangeListener;
    }

    public void setWidth(int n2) {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams != null) {
            layoutParams.width = n2;
            this.requestLayout();
        }
    }

    public void setHeight(int n2) {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams != null) {
            layoutParams.height = n2;
            this.requestLayout();
        }
    }

    public void initSlideInfo(JSONObject object, float f2, int n2) {
        JSONObject jSONObject = JSONUtil.getJSONObject(object, "slideoffset");
        if (jSONObject != null) {
            Object object2 = JSONUtil.getJSONObject(object, "position");
            if (object2 != null) {
                JSONObject jSONObject2 = object2;
                object2 = jSONObject2.optString(LEFT);
                String string2 = jSONObject2.optString(RIGHT);
                if (!TextUtils.isEmpty((CharSequence)object2)) {
                    int n3 = n2;
                    this.mSlideLeftPosition = PdrUtil.convertToScreenInt((String)object2, n3, n3 / 2, f2);
                }
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    int n4 = n2;
                    this.mSlideRightPosition = PdrUtil.convertToScreenInt(string2, n4, n4 / 2, f2);
                }
            }
            this.mInterceptEventEnable = object.optBoolean("preventTouchEvent", true);
            object = JSONUtil.getString(jSONObject, LEFT);
            if (!TextUtils.isEmpty((CharSequence)object)) {
                boolean bl = this.mSlideLeftPosition > 0;
                int n5 = n2;
                this.isLeftSlide = bl;
                this.mSlideTransverseLeftMaxWitch = PdrUtil.convertToScreenInt((String)object, n5, n5 / 2, f2);
            }
            if (!TextUtils.isEmpty((CharSequence)(object = JSONUtil.getString(jSONObject, RIGHT)))) {
                boolean bl = this.mSlideRightPosition > 0;
                int n6 = n2;
                this.isRightSlide = bl;
                this.mSlideTransverseRightMaxWitch = PdrUtil.convertToScreenInt((String)object, n6, n6 / 2, f2);
            }
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int n2 = motionEvent.getAction();
        if (!this.mInterceptEventEnable) {
            return false;
        }
        if (!this.isLeftSlide && !this.isRightSlide) {
            return false;
        }
        if (n2 != 3 && n2 != 1) {
            if (n2 != 0 && this.mIsHandledTouchEvent) {
                return true;
            }
            if (n2 != 0) {
                if (n2 == 2 && (int)Math.abs(motionEvent.getX() - this.mFirstX) > this.mTouchSlop) {
                    SlideLayout slideLayout = this;
                    slideLayout.enableChildrenCache();
                    slideLayout.mIsHandledTouchEvent = true;
                    slideLayout.mCanDoSlideTransverseEvent = true;
                    slideLayout.requestDisallowInterceptTouchEvent(true);
                }
            } else {
                SlideLayout slideLayout = this;
                this.mLastMotionX = motionEvent.getX();
                slideLayout.mFirstX = motionEvent.getX();
                slideLayout.mIsHandledTouchEvent = false;
                slideLayout.mCanDoSlideTransverseEvent = false;
            }
            return this.mIsHandledTouchEvent;
        }
        SlideLayout slideLayout = this;
        slideLayout.mIsHandledTouchEvent = false;
        slideLayout.clearChildrenCache();
        return slideLayout.mIsHandledTouchEvent;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mCanDoSlideTransverseEvent && this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        switch (motionEvent.getAction()) {
            default: {
                break;
            }
            case 2: {
                VelocityTracker velocityTracker = this.mVelocityTracker;
                if (velocityTracker != null) {
                    velocityTracker.addMovement(motionEvent);
                }
                float f2 = motionEvent.getX();
                if (!this.mCanDoSlideTransverseEvent) break;
                int n2 = (int)(this.mLastMotionX - f2);
                this.mLastMotionX = f2;
                int n3 = this.getScrollX();
                SlideLayout slideLayout = this;
                int n4 = slideLayout.getChildAt(slideLayout.getChildCount() - 1).getRight() - n3 - this.getWidth();
                if (n3 == 0) {
                    if (this.isRightSlide && n2 > 0) {
                        this.scrollBy(n2, 0);
                        break;
                    }
                    if (!this.isLeftSlide || n2 >= 0) break;
                    this.scrollBy(n2, 0);
                    break;
                }
                if (n3 > 0 && n4 < 0 && this.isRightSlide) {
                    if (Math.abs(n3 = n2 + n3) > this.mSlideRightPosition) break;
                    if (n3 < 0) {
                        this.scrollBy(0, 0);
                        break;
                    }
                    if (Math.abs(n3) >= this.mSlideTransverseRightMaxWitch) {
                        this.scrollBy((int)((double)n2 / 1.5), 0);
                        break;
                    }
                    this.scrollBy(n2, 0);
                    break;
                }
                if (n3 >= 0 || n4 <= 0 || !this.isLeftSlide || Math.abs(n3 = n2 + n3) > this.mSlideLeftPosition) break;
                if (n3 > 0) {
                    this.scrollBy(0, 0);
                    break;
                }
                if (Math.abs(n3) >= this.mSlideTransverseLeftMaxWitch) {
                    this.scrollBy((int)((double)n2 / 1.5), 0);
                    break;
                }
                this.scrollBy(n2, 0);
                break;
            }
            case 1: 
            case 3: {
                VelocityTracker velocityTracker;
                if (this.mIsHandledTouchEvent) {
                    this.mIsHandledTouchEvent = false;
                    if (this.mCanDoSlideTransverseEvent) {
                        SlideLayout slideLayout = this;
                        slideLayout.requestDisallowInterceptTouchEvent(false);
                        VelocityTracker velocityTracker2 = slideLayout.mVelocityTracker;
                        velocityTracker2.computeCurrentVelocity(1000);
                        int n5 = (int)velocityTracker2.getXVelocity();
                        int n6 = this.getScrollX();
                        if (n5 > 1000) {
                            if (n6 < 0 && this.isLeftSlide && this.mSlideLeftPosition >= (n5 = this.mSlideTransverseLeftMaxWitch)) {
                                SlideLayout slideLayout2 = this;
                                slideLayout2.smoothScrollTo(-(n5 - Math.abs(n6)), 0);
                                slideLayout2.isSlideOpen = true;
                                slideLayout2.setState(LEFT, AFTER_SLIDE);
                            } else if (n6 > 0 && this.isRightSlide) {
                                SlideLayout slideLayout3 = this;
                                slideLayout3.smoothScrollTo(-n6, 0);
                                slideLayout3.isSlideOpen = false;
                                slideLayout3.setState(RIGHT, BEFORE_SLIDE);
                            } else {
                                this.upSlideTo(n6);
                            }
                        } else if (n5 < -1000) {
                            if (n6 < 0 && this.isLeftSlide) {
                                SlideLayout slideLayout4 = this;
                                slideLayout4.smoothScrollTo(-n6, 0);
                                slideLayout4.isSlideOpen = false;
                                slideLayout4.setState(LEFT, BEFORE_SLIDE);
                            } else if (n6 > 0 && this.isRightSlide && this.mSlideRightPosition >= (n5 = this.mSlideTransverseRightMaxWitch)) {
                                SlideLayout slideLayout5 = this;
                                slideLayout5.smoothScrollTo(n5 - Math.abs(n6), 0);
                                slideLayout5.isSlideOpen = true;
                                slideLayout5.setState(RIGHT, AFTER_SLIDE);
                            } else {
                                this.upSlideTo(n6);
                            }
                        } else {
                            this.upSlideTo(n6);
                        }
                        velocityTracker = this.mVelocityTracker;
                        if (velocityTracker != null) {
                            velocityTracker.recycle();
                            this.mVelocityTracker = null;
                        }
                    }
                }
                if ((velocityTracker = this.mVelocityTracker) == null) break;
                velocityTracker.recycle();
                this.mVelocityTracker = null;
                break;
            }
            case 0: {
                this.mIsHandledTouchEvent = false;
                if (this.mScroller.isFinished()) break;
                this.mScroller.abortAnimation();
            }
        }
        return super.onTouchEvent(motionEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void upSlideTo(int n2) {
        int n3;
        if (n2 < 0) {
            n3 = this.mSlideTransverseLeftMaxWitch;
            if (Math.abs(n2) >= n3 / 2 && this.mSlideLeftPosition >= n3) {
                SlideLayout slideLayout = this;
                slideLayout.smoothScrollTo(-(n3 - Math.abs(n2)), 0);
                slideLayout.isSlideOpen = true;
                slideLayout.setState(LEFT, AFTER_SLIDE);
                return;
            }
        }
        if (n2 > 0) {
            n3 = this.mSlideTransverseRightMaxWitch;
            if (Math.abs(n2) >= n3 / 2 && this.mSlideRightPosition >= n3) {
                SlideLayout slideLayout = this;
                slideLayout.smoothScrollTo(n3 - Math.abs(n2), 0);
                slideLayout.isSlideOpen = true;
                slideLayout.setState(RIGHT, AFTER_SLIDE);
                return;
            }
        }
        if (n2 > 0) {
            SlideLayout slideLayout = this;
            slideLayout.smoothScrollTo(-n2, 0);
            slideLayout.setState(RIGHT, BEFORE_SLIDE);
        } else {
            SlideLayout slideLayout = this;
            slideLayout.smoothScrollTo(-n2, 0);
            slideLayout.setState(LEFT, BEFORE_SLIDE);
        }
        this.isSlideOpen = false;
    }

    public void setOffset(String string2, String string3, float f2) {
        int n2 = PdrUtil.convertToScreenInt(string3, this.getWidth(), 0, f2);
        int n3 = this.getScrollX();
        if (string2.equals(LEFT)) {
            if (n2 == 0) {
                if (n3 != 0) {
                    SlideLayout slideLayout = this;
                    slideLayout.smoothScrollTo(-n3, 0);
                    slideLayout.setState(LEFT, BEFORE_SLIDE);
                }
            } else {
                Runnable runnable;
                int n4 = this.mSlideLeftPosition;
                if (n2 <= n4) {
                    n4 = n2;
                }
                int n5 = n4 - Math.abs(n3);
                this.smoothScrollTo(-n5, 0);
                Runnable runnable2 = runnable;
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        SlideLayout slideLayout = SlideLayout.this;
                        slideLayout.upSlideTo(slideLayout.getScrollX());
                    }
                };
                long l2 = n5 * 2 + 200;
                this.postDelayed(runnable2, l2);
            }
        } else if (n2 == 0) {
            if (n3 != 0) {
                SlideLayout slideLayout = this;
                slideLayout.smoothScrollTo(-n3, 0);
                slideLayout.setState(RIGHT, BEFORE_SLIDE);
            }
        } else {
            Runnable runnable;
            int n6 = this.mSlideRightPosition;
            if (n2 <= n6) {
                n6 = n2;
            }
            int n7 = n6 - Math.abs(n3);
            this.smoothScrollTo(n7, 0);
            Runnable runnable3 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    SlideLayout slideLayout = SlideLayout.this;
                    slideLayout.upSlideTo(slideLayout.getScrollX());
                }
            };
            long l3 = n7 * 2 + 200;
            this.postDelayed(runnable3, l3);
        }
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            SlideLayout slideLayout = this;
            slideLayout.scrollTo(slideLayout.mScroller.getCurrX(), this.mScroller.getCurrY());
            slideLayout.postInvalidate();
        } else {
            this.clearChildrenCache();
        }
        super.computeScroll();
    }

    void enableChildrenCache() {
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.getChildAt(i2).setDrawingCacheEnabled(true);
        }
    }

    void clearChildrenCache() {
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.getChildAt(i2).setDrawingCacheEnabled(false);
        }
    }

    public void setInterceptTouchEventEnabled(boolean bl) {
        this.mIsHandledTouchEvent = bl;
    }

    public void reset() {
        int n2 = this.getScrollX();
        if (n2 == 0) {
            return;
        }
        this.smoothScrollTo(-n2, 0);
        if (n2 < 0) {
            this.setState(LEFT, BEFORE_SLIDE);
        } else {
            this.setState(RIGHT, BEFORE_SLIDE);
        }
    }

    public static interface OnStateChangeListener {
        public void onStateChanged(String var1, String var2);
    }
}

