/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.v4.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import android.widget.AbsListView;
import com.dcloud.android.annotation.ColorInt;
import com.dcloud.android.annotation.ColorRes;
import com.dcloud.android.v4.view.MotionEventCompat;
import com.dcloud.android.v4.view.NestedScrollingChild;
import com.dcloud.android.v4.view.NestedScrollingChildHelper;
import com.dcloud.android.v4.view.NestedScrollingParent;
import com.dcloud.android.v4.view.NestedScrollingParentHelper;
import com.dcloud.android.v4.view.ViewCompat;
import com.dcloud.android.v4.widget.CircleImageView;
import com.dcloud.android.v4.widget.IRefreshAble;
import com.dcloud.android.v4.widget.MaterialProgressDrawable;
import io.dcloud.common.util.PdrUtil;
import org.json.JSONObject;

public class SwipeRefreshLayout
extends ViewGroup
implements NestedScrollingParent,
NestedScrollingChild,
IRefreshAble {
    public static final int LARGE = 0;
    public static final int DEFAULT = 1;
    private static final String LOG_TAG = SwipeRefreshLayout.class.getSimpleName();
    private static final int MAX_ALPHA = 255;
    private static final int STARTING_PROGRESS_ALPHA = 76;
    private static final int CIRCLE_DIAMETER = 40;
    private static final int CIRCLE_DIAMETER_LARGE = 56;
    private static final float DECELERATE_INTERPOLATION_FACTOR = 2.0f;
    private static final int INVALID_POINTER = -1;
    private static final float DRAG_RATE = 0.5f;
    private static final float MAX_PROGRESS_ANGLE = 0.8f;
    private static final int SCALE_DOWN_DURATION = 150;
    private static final int ALPHA_ANIMATION_DURATION = 300;
    private static final int ANIMATE_TO_TRIGGER_DURATION = 200;
    private static final int ANIMATE_TO_START_DURATION = 200;
    private static final int CIRCLE_BG_LIGHT = -328966;
    private static final int DEFAULT_CIRCLE_TARGET = 64;
    private static final int[] LAYOUT_ATTRS = new int[]{0x101000E};
    static final int PULL_BOTTOM = -1;
    static final int PULL_DEGREE_GAP = 40;
    private View mTarget;
    private IRefreshAble.OnRefreshListener mListener;
    private boolean mRefreshing;
    private int mTouchSlop;
    private float mTotalDragDistance;
    private float mTotalUnconsumed;
    private final NestedScrollingParentHelper mNestedScrollingParentHelper;
    private final NestedScrollingChildHelper mNestedScrollingChildHelper;
    private final int[] mParentScrollConsumed;
    private int mMediumAnimationDuration;
    private int mCurrentTargetOffsetTop;
    private boolean mOriginalOffsetCalculated;
    private float mInitialMotionY;
    private float mInitialDownY;
    private float mInitialDownX;
    private boolean mIsBeingDragged;
    private boolean mScale;
    private boolean mReturningToStart;
    private final DecelerateInterpolator mDecelerateInterpolator;
    private CircleImageView mCircleView;
    private int mCircleViewIndex;
    protected int mFrom;
    private float mStartingScale;
    protected int mOriginalOffsetTop;
    private MaterialProgressDrawable mProgress;
    private Animation mScaleAnimation;
    private Animation mScaleDownAnimation;
    private Animation mAlphaStartAnimation;
    private Animation mAlphaMaxAnimation;
    private Animation mScaleDownToStartAnimation;
    private float mSpinnerFinalOffset;
    private boolean mNotify;
    private int mCircleWidth;
    private int mCircleHeight;
    private boolean mUsingCustomStart;
    private boolean mPlusRefreshing;
    private int F_OriginalOffsetTop;
    private float F_SpinnerFinalOffset;
    private float F_TotalDragDistance;
    private Animation.AnimationListener mRefreshListener;
    boolean mUseSys;
    boolean mBeginRefresh;
    private boolean isSetOffset;
    JSONObject mJsonData;
    View mDrawParentView;
    View mParentView;
    int mPullDirect;
    private boolean mRefreshEnable;
    boolean mHandledDown;
    private final Animation mAnimateToCorrectPosition;
    private final Animation mPeek;
    private final Animation mAnimateToStartPosition;

    private void setColorViewAlpha(int n2) {
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mCircleView.getBackground().setAlpha(n2);
        swipeRefreshLayout.mProgress.setAlpha(n2);
    }

    public SwipeRefreshLayout(Context context, AttributeSet attributeSet, boolean bl) {
        float f2;
        SwipeRefreshLayout swipeRefreshLayout = this;
        super(context);
        this.mRefreshing = false;
        this.mTotalDragDistance = -1.0f;
        this.mParentScrollConsumed = new int[2];
        this.mOriginalOffsetCalculated = false;
        this.mIsBeingDragged = false;
        this.mCircleViewIndex = -1;
        this.mPlusRefreshing = false;
        this.mRefreshListener = new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
                SwipeRefreshLayout.this.parentInvalidate();
            }

            public void onAnimationEnd(Animation object) {
                if (SwipeRefreshLayout.this.mRefreshing) {
                    1 v0 = this;
                    v0.SwipeRefreshLayout.this.mProgress.setAlpha(255);
                    v0.SwipeRefreshLayout.this.mProgress.start();
                    SwipeRefreshLayout.access$302(v0.SwipeRefreshLayout.this, true);
                    if (v0.SwipeRefreshLayout.this.mNotify && SwipeRefreshLayout.this.mListener != null) {
                        SwipeRefreshLayout.this.mListener.onRefresh(3);
                    }
                } else {
                    1 v1 = this;
                    v1.SwipeRefreshLayout.this.mProgress.stop();
                    SwipeRefreshLayout.access$302(v1.SwipeRefreshLayout.this, false);
                    v1.SwipeRefreshLayout.this.mCircleView.setVisibility(8);
                    v1.SwipeRefreshLayout.this.setColorViewAlpha(255);
                    if (v1.SwipeRefreshLayout.this.mScale) {
                        SwipeRefreshLayout.this.setAnimationProgress(0.0f);
                    } else {
                        object = SwipeRefreshLayout.this;
                        ((SwipeRefreshLayout)object).setTargetOffsetTopAndBottom(object.mOriginalOffsetTop - ((SwipeRefreshLayout)object).mCurrentTargetOffsetTop, true);
                    }
                }
                SwipeRefreshLayout swipeRefreshLayout = SwipeRefreshLayout.this;
                SwipeRefreshLayout.access$1002(swipeRefreshLayout, swipeRefreshLayout.mCircleView.getTop());
            }
        };
        this.mUseSys = false;
        this.mBeginRefresh = false;
        this.isSetOffset = false;
        this.mJsonData = null;
        this.mDrawParentView = null;
        this.mParentView = null;
        this.mPullDirect = -1;
        this.mRefreshEnable = true;
        this.mHandledDown = false;
        this.mAnimateToCorrectPosition = new Animation(){

            public void applyTransformation(float f2, Transformation transformation) {
                int n2 = !object.SwipeRefreshLayout.this.mUsingCustomStart ? (int)(object.SwipeRefreshLayout.this.mSpinnerFinalOffset - (float)Math.abs(object.SwipeRefreshLayout.this.mOriginalOffsetTop)) : (int)object.SwipeRefreshLayout.this.mSpinnerFinalOffset;
                7 v0 = object;
                Object object = v0.SwipeRefreshLayout.this;
                int n3 = ((SwipeRefreshLayout)object).mFrom;
                int n4 = n3 + (int)((float)(n2 - n3) * f2) - ((SwipeRefreshLayout)object).mCircleView.getTop();
                v0.SwipeRefreshLayout.this.setTargetOffsetTopAndBottom(n4, false);
                v0.SwipeRefreshLayout.this.mProgress.setArrowScale(1.0f - f2);
            }
        };
        this.mPeek = new Animation(){

            public void applyTransformation(float f2, Transformation transformation) {
                int n2 = !object.SwipeRefreshLayout.this.mUsingCustomStart ? (int)(object.SwipeRefreshLayout.this.mSpinnerFinalOffset - (float)Math.abs(object.SwipeRefreshLayout.this.mOriginalOffsetTop)) : (int)object.SwipeRefreshLayout.this.mSpinnerFinalOffset;
                8 v0 = object;
                Object object = v0.SwipeRefreshLayout.this;
                int n3 = ((SwipeRefreshLayout)object).mFrom;
                int n4 = n3 + (int)((float)(n2 - n3) * f2) - ((SwipeRefreshLayout)object).mCircleView.getTop();
                v0.SwipeRefreshLayout.this.setTargetOffsetTopAndBottom(n4, false);
                v0.SwipeRefreshLayout.this.mProgress.setArrowScale(1.0f - f2);
            }
        };
        this.mAnimateToStartPosition = new Animation(){

            public void applyTransformation(float f2, Transformation transformation) {
                SwipeRefreshLayout.this.moveToStart(f2);
            }
        };
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        swipeRefreshLayout.mUseSys = bl;
        swipeRefreshLayout.mMediumAnimationDuration = swipeRefreshLayout.getResources().getInteger(0x10E0001);
        swipeRefreshLayout.setWillNotDraw(false);
        swipeRefreshLayout.mDecelerateInterpolator = new DecelerateInterpolator(2.0f);
        if (attributeSet != null) {
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, LAYOUT_ATTRS);
            this.setEnabled(typedArray.getBoolean(0, true));
            typedArray.recycle();
        }
        SwipeRefreshLayout swipeRefreshLayout2 = this;
        context = swipeRefreshLayout2.getResources().getDisplayMetrics();
        float f3 = context.density;
        this.mCircleWidth = (int)(f3 * 40.0f);
        swipeRefreshLayout2.mCircleHeight = (int)(f3 * 40.0f);
        swipeRefreshLayout2.createProgressView();
        ViewCompat.setChildrenDrawingOrderEnabled(swipeRefreshLayout2, true);
        swipeRefreshLayout2.mSpinnerFinalOffset = f2 = context.density * 64.0f;
        swipeRefreshLayout2.mTotalDragDistance = f2;
        swipeRefreshLayout2.F_SpinnerFinalOffset = f2;
        swipeRefreshLayout2.F_TotalDragDistance = f2;
        swipeRefreshLayout2.mNestedScrollingParentHelper = new NestedScrollingParentHelper(this);
        swipeRefreshLayout2.mNestedScrollingChildHelper = new NestedScrollingChildHelper((View)this);
        swipeRefreshLayout2.setNestedScrollingEnabled(true);
    }

    public SwipeRefreshLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, true);
    }

    private void createProgressView() {
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mCircleView = new CircleImageView(this.getContext(), -328966, 20.0f, false);
        this.mProgress = new MaterialProgressDrawable(this.getContext(), (View)this);
        this.mProgress.setBackgroundColor(-328966);
        swipeRefreshLayout.mCircleView.setImageDrawable(this.mProgress);
        swipeRefreshLayout.mCircleView.setVisibility(8);
        swipeRefreshLayout.addView((View)swipeRefreshLayout.mCircleView);
    }

    private boolean isAlphaUsedForScale() {
        return Build.VERSION.SDK_INT < 11;
    }

    private void startScaleUpAnimation(Animation.AnimationListener animationListener) {
        2 v1;
        2 var2_2;
        this.mCircleView.setVisibility(0);
        if (Build.VERSION.SDK_INT >= 11) {
            this.mProgress.setAlpha(255);
        }
        2 v0 = var2_2 = v1;
        v0();
        this.mScaleAnimation = v0;
        v1.setDuration(this.mMediumAnimationDuration);
        if (animationListener != null) {
            this.mCircleView.setAnimationListener(animationListener);
        }
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mCircleView.clearAnimation();
        swipeRefreshLayout.mCircleView.startAnimation(this.mScaleAnimation);
    }

    private void setAnimationProgress(float f2) {
        if (this.isAlphaUsedForScale()) {
            this.setColorViewAlpha((int)(f2 * 255.0f));
        } else {
            SwipeRefreshLayout swipeRefreshLayout = this;
            ViewCompat.setScaleX((View)swipeRefreshLayout.mCircleView, f2);
            ViewCompat.setScaleY((View)swipeRefreshLayout.mCircleView, f2);
        }
    }

    private void setRefreshing(boolean bl, boolean bl2) {
        if (this.mRefreshing != bl) {
            this.mNotify = bl2;
            this.ensureTarget();
            this.mRefreshing = bl;
            if (bl) {
                SwipeRefreshLayout swipeRefreshLayout = this;
                int n2 = swipeRefreshLayout.mCurrentTargetOffsetTop;
                swipeRefreshLayout.animateOffsetToCorrectPosition(n2, swipeRefreshLayout.mRefreshListener);
            } else {
                SwipeRefreshLayout swipeRefreshLayout = this;
                swipeRefreshLayout.startScaleDownAnimation(swipeRefreshLayout.mRefreshListener);
            }
        }
    }

    private void startScaleDownAnimation(Animation.AnimationListener animationListener) {
        SwipeRefreshLayout swipeRefreshLayout = this;
        this.mScaleDownAnimation = new Animation(){

            public void applyTransformation(float f2, Transformation transformation) {
                SwipeRefreshLayout.this.setAnimationProgress(1.0f - f2);
            }
        };
        this.mScaleDownAnimation.setDuration(150L);
        swipeRefreshLayout.mCircleView.setAnimationListener(animationListener);
        swipeRefreshLayout.mCircleView.clearAnimation();
        swipeRefreshLayout.mCircleView.startAnimation(this.mScaleDownAnimation);
    }

    private void startProgressAlphaStartAnimation() {
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mAlphaStartAnimation = swipeRefreshLayout.startAlphaAnimation(swipeRefreshLayout.mProgress.getAlpha(), 76);
    }

    private void startProgressAlphaMaxAnimation() {
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mAlphaMaxAnimation = swipeRefreshLayout.startAlphaAnimation(swipeRefreshLayout.mProgress.getAlpha(), 255);
    }

    private Animation startAlphaAnimation(int n2, int n3) {
        4 v0;
        if (this.mScale && this.isAlphaUsedForScale()) {
            return null;
        }
        4 var3_3 = v0;
        SwipeRefreshLayout swipeRefreshLayout = this;
        4 v2 = var3_3;
        v2(n2, n3);
        v2.setDuration(300L);
        swipeRefreshLayout.mCircleView.setAnimationListener(null);
        swipeRefreshLayout.mCircleView.clearAnimation();
        swipeRefreshLayout.mCircleView.startAnimation(var3_3);
        return v0;
    }

    private void ensureTarget() {
        if (this.mTarget == null) {
            for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
                View view = this.getChildAt(i2);
                if (view.equals((Object)this.mCircleView)) continue;
                this.mTarget = view;
                break;
            }
        }
    }

    private boolean isAnimationRunning(Animation animation) {
        return animation != null && animation.hasStarted() && !animation.hasEnded();
    }

    private void moveSpinner(float f2) {
        float f3;
        float f4 = f2;
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mProgress.showArrow(true);
        float f5 = Math.min(1.0f, Math.abs(f4 / swipeRefreshLayout.mTotalDragDistance));
        float f6 = (float)Math.max((double)f5 - 0.4, 0.0) * 5.0f / 3.0f;
        float f7 = Math.abs(f4) - this.mTotalDragDistance;
        float f8 = this.mUsingCustomStart ? this.mSpinnerFinalOffset - (float)this.mOriginalOffsetTop : this.mSpinnerFinalOffset;
        SwipeRefreshLayout swipeRefreshLayout2 = this;
        double d2 = Math.max(0.0f, Math.min(f7, f8 * 2.0f) / f8) / 4.0f;
        f7 = (float)(d2 - Math.pow(d2, 2.0)) * 2.0f;
        float f9 = f8 * f7 * 2.0f;
        int n2 = swipeRefreshLayout2.mOriginalOffsetTop + (int)(f8 * f5 + f9);
        if (swipeRefreshLayout2.mCircleView.getVisibility() != 0) {
            this.mCircleView.setVisibility(0);
        }
        if (!this.mScale) {
            SwipeRefreshLayout swipeRefreshLayout3 = this;
            ViewCompat.setScaleX((View)swipeRefreshLayout3.mCircleView, 1.0f);
            ViewCompat.setScaleY((View)swipeRefreshLayout3.mCircleView, 1.0f);
        }
        f8 = this.mTotalDragDistance;
        if (f2 < f3) {
            if (this.mScale) {
                this.setAnimationProgress(f2 / f8);
            }
            if (this.mProgress.getAlpha() > 76) {
                SwipeRefreshLayout swipeRefreshLayout4 = this;
                if (!swipeRefreshLayout4.isAnimationRunning(swipeRefreshLayout4.mAlphaStartAnimation)) {
                    this.startProgressAlphaStartAnimation();
                }
            }
            SwipeRefreshLayout swipeRefreshLayout5 = this;
            f2 = f6 * 0.8f;
            swipeRefreshLayout5.mProgress.setStartEndTrim(0.0f, Math.min(0.8f, f2));
            swipeRefreshLayout5.mProgress.setArrowScale(Math.min(1.0f, f6));
        } else if (this.mProgress.getAlpha() < 255) {
            SwipeRefreshLayout swipeRefreshLayout6 = this;
            if (!swipeRefreshLayout6.isAnimationRunning(swipeRefreshLayout6.mAlphaMaxAnimation)) {
                SwipeRefreshLayout swipeRefreshLayout7 = this;
                swipeRefreshLayout7.startProgressAlphaMaxAnimation();
                swipeRefreshLayout7.mProgress.setStartEndTrim(0.0f, 0.8f);
                swipeRefreshLayout7.mProgress.setArrowScale(1.0f);
            }
        }
        SwipeRefreshLayout swipeRefreshLayout8 = this;
        float f10 = (f6 * 0.4f + -0.25f + f7 * 2.0f) * 0.5f;
        swipeRefreshLayout8.mProgress.setProgressRotation(f10);
        this.setTargetOffsetTopAndBottom((int)((float)(n2 - swipeRefreshLayout8.mCurrentTargetOffsetTop)), true);
    }

    private void cancelRefresh() {
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mRefreshing = false;
        swipeRefreshLayout.mProgress.setStartEndTrim(0.0f, 0.0f);
        Animation.AnimationListener animationListener = null;
        if (!swipeRefreshLayout.mScale) {
            Animation.AnimationListener animationListener2;
            animationListener = animationListener2;
            animationListener2 = new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    if (SwipeRefreshLayout.this.mCircleView != null) {
                        SwipeRefreshLayout.this.mCircleView.setVisibility(8);
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                }
            };
        }
        SwipeRefreshLayout swipeRefreshLayout2 = this;
        swipeRefreshLayout2.animateOffsetToStartPosition(swipeRefreshLayout2.mCurrentTargetOffsetTop, animationListener);
        swipeRefreshLayout2.mProgress.showArrow(false);
    }

    private void finishSpinner(float f2) {
        if (f2 > this.mTotalDragDistance) {
            this.setRefreshing(true, true);
        } else {
            this.cancelRefresh();
        }
    }

    private boolean isDrawAble() {
        return this.mCircleView.getVisibility() == 0 && this.mCircleView.getTop() > this.mOriginalOffsetTop - this.mCircleView.getMeasuredHeight() && (this.mParentView.getScrollY() <= 0 || this.mPlusRefreshing);
    }

    private void parentInvalidate() {
        if (this.isDrawAble() && this.mParentView != null) {
            SwipeRefreshLayout swipeRefreshLayout = this;
            Log.d((String)"parentInvalidate", (String)"parentInvalidate");
            int n2 = (swipeRefreshLayout.mParentView.getWidth() - this.mCircleWidth) / 2 + this.mParentView.getScrollX();
            int n3 = swipeRefreshLayout.mOriginalOffsetTop + this.mCircleHeight + this.mParentView.getScrollY();
            int n4 = this.mCircleView.getTop() + n3 + this.mCircleHeight;
            swipeRefreshLayout.mDrawParentView.invalidate(n2, n3, n2 += this.mCircleWidth, n4);
        }
    }

    private boolean handleTouchEvent(MotionEvent motionEvent) {
        if (this.isRefreshing()) {
            return false;
        }
        return motionEvent.getAction() == 0 || this.mHandledDown;
    }

    private void animateOffsetToCorrectPosition(int n2, Animation.AnimationListener animationListener) {
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mFrom = n2;
        swipeRefreshLayout.mAnimateToCorrectPosition.reset();
        swipeRefreshLayout.mAnimateToCorrectPosition.setDuration(200L);
        swipeRefreshLayout.mAnimateToCorrectPosition.setInterpolator((Interpolator)this.mDecelerateInterpolator);
        if (animationListener != null) {
            this.mCircleView.setAnimationListener(animationListener);
        }
        SwipeRefreshLayout swipeRefreshLayout2 = this;
        swipeRefreshLayout2.mCircleView.clearAnimation();
        swipeRefreshLayout2.mCircleView.startAnimation(this.mAnimateToCorrectPosition);
    }

    private void peek(int n2, Animation.AnimationListener animationListener) {
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mFrom = n2;
        swipeRefreshLayout.mPeek.reset();
        swipeRefreshLayout.mPeek.setDuration(500L);
        swipeRefreshLayout.mPeek.setInterpolator((Interpolator)this.mDecelerateInterpolator);
        if (animationListener != null) {
            this.mCircleView.setAnimationListener(animationListener);
        }
        SwipeRefreshLayout swipeRefreshLayout2 = this;
        swipeRefreshLayout2.mCircleView.clearAnimation();
        swipeRefreshLayout2.mCircleView.startAnimation(this.mPeek);
    }

    private void animateOffsetToStartPosition(int n2, Animation.AnimationListener animationListener) {
        if (this.mScale) {
            this.startScaleDownReturnToStartAnimation(n2, animationListener);
        } else {
            SwipeRefreshLayout swipeRefreshLayout = this;
            swipeRefreshLayout.mFrom = n2;
            swipeRefreshLayout.mAnimateToStartPosition.reset();
            swipeRefreshLayout.mAnimateToStartPosition.setDuration(200L);
            swipeRefreshLayout.mAnimateToStartPosition.setInterpolator((Interpolator)this.mDecelerateInterpolator);
            if (animationListener != null) {
                this.mCircleView.setAnimationListener(animationListener);
            }
            SwipeRefreshLayout swipeRefreshLayout2 = this;
            swipeRefreshLayout2.mCircleView.clearAnimation();
            swipeRefreshLayout2.mCircleView.startAnimation(this.mAnimateToStartPosition);
        }
    }

    private void moveToStart(float f2) {
        SwipeRefreshLayout swipeRefreshLayout = this;
        int n2 = swipeRefreshLayout.mFrom;
        swipeRefreshLayout.setTargetOffsetTopAndBottom(n2 + (int)((float)(this.mOriginalOffsetTop - n2) * f2) - this.mCircleView.getTop(), false);
    }

    private void startScaleDownReturnToStartAnimation(int n2, Animation.AnimationListener animationListener) {
        10 v0;
        this.mFrom = n2;
        this.mStartingScale = this.isAlphaUsedForScale() ? (float)this.mProgress.getAlpha() : ViewCompat.getScaleX((View)this.mCircleView);
        10 var1_2 = v0;
        var1_2();
        this.mScaleDownToStartAnimation = var1_2;
        v0.setDuration(150L);
        if (animationListener != null) {
            this.mCircleView.setAnimationListener(animationListener);
        }
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mCircleView.clearAnimation();
        swipeRefreshLayout.mCircleView.startAnimation(this.mScaleDownToStartAnimation);
    }

    private void setTargetOffsetTopAndBottom(int n2, boolean bl) {
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mCircleView.bringToFront();
        swipeRefreshLayout.mCircleView.offsetTopAndBottom(n2);
        swipeRefreshLayout.mCurrentTargetOffsetTop = swipeRefreshLayout.mCircleView.getTop();
        if (bl && Build.VERSION.SDK_INT < 11) {
            this.invalidate();
        }
    }

    static /* synthetic */ boolean access$302(SwipeRefreshLayout swipeRefreshLayout, boolean bl) {
        swipeRefreshLayout.mPlusRefreshing = bl;
        return bl;
    }

    static /* synthetic */ int access$1002(SwipeRefreshLayout swipeRefreshLayout, int n2) {
        swipeRefreshLayout.mCurrentTargetOffsetTop = n2;
        return n2;
    }

    public void setProgressViewOffset(boolean bl, int n2, int n3, int n4) {
        this.mScale = bl;
        this.mCircleView.setVisibility(8);
        this.mCurrentTargetOffsetTop = n2;
        this.mOriginalOffsetTop = n2;
        this.mSpinnerFinalOffset = n3;
        this.mTotalDragDistance = n4;
        this.mUsingCustomStart = true;
        this.mCircleView.invalidate();
    }

    public void setProgressViewEndTarget(boolean bl, int n2) {
        this.mSpinnerFinalOffset = n2;
        this.mScale = bl;
        this.mCircleView.invalidate();
    }

    public void setSize(int n2) {
        if (n2 != 0 && n2 != 1) {
            return;
        }
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        if (n2 == 0) {
            int n3;
            SwipeRefreshLayout swipeRefreshLayout = this;
            swipeRefreshLayout.mCircleWidth = n3 = (int)(displayMetrics.density * 56.0f);
            swipeRefreshLayout.mCircleHeight = n3;
        } else {
            int n4;
            SwipeRefreshLayout swipeRefreshLayout = this;
            swipeRefreshLayout.mCircleWidth = n4 = (int)(displayMetrics.density * 40.0f);
            swipeRefreshLayout.mCircleHeight = n4;
        }
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mCircleView.setImageDrawable(null);
        swipeRefreshLayout.mProgress.updateSizes(n2);
        swipeRefreshLayout.mCircleView.setImageDrawable(this.mProgress);
    }

    protected int getChildDrawingOrder(int n2, int n3) {
        int n4 = this.mCircleViewIndex;
        if (n4 < 0) {
            return n3;
        }
        if (n3 == n2 - 1) {
            return n4;
        }
        if (n3 >= n4) {
            return n3 + 1;
        }
        return n3;
    }

    public void setOnRefreshListener(IRefreshAble.OnRefreshListener onRefreshListener) {
        this.mListener = onRefreshListener;
    }

    /*
     * WARNING - void declaration
     */
    public void setRefreshing(boolean bl) {
        if (bl && this.mRefreshing != bl) {
            void var1_4;
            this.mRefreshing = bl;
            if (!this.mUsingCustomStart) {
                int n2 = (int)(this.mSpinnerFinalOffset + (float)this.mOriginalOffsetTop);
            } else {
                int n3 = (int)this.mSpinnerFinalOffset;
            }
            SwipeRefreshLayout swipeRefreshLayout = this;
            swipeRefreshLayout.setTargetOffsetTopAndBottom((int)(var1_4 - this.mCurrentTargetOffsetTop), true);
            swipeRefreshLayout.mNotify = false;
            swipeRefreshLayout.startScaleUpAnimation(swipeRefreshLayout.mRefreshListener);
        } else {
            this.setRefreshing(bl, true);
        }
    }

    @Deprecated
    public void setProgressBackgroundColor(int n2) {
        this.setProgressBackgroundColorSchemeResource(n2);
    }

    public void setProgressBackgroundColorSchemeResource(@ColorRes int n2) {
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.setProgressBackgroundColorSchemeColor(swipeRefreshLayout.getResources().getColor(n2));
    }

    public void setProgressBackgroundColorSchemeColor(@ColorInt int n2) {
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mCircleView.setBackgroundColor(n2);
        swipeRefreshLayout.mProgress.setBackgroundColor(n2);
    }

    @Deprecated
    public void setColorScheme(int ... nArray) {
        this.setColorSchemeResources(nArray);
    }

    public void setColorSchemeResources(int ... nArray) {
        Resources resources = this.getResources();
        int[] nArray2 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray2[i2] = resources.getColor(nArray[i2]);
        }
        this.setColorSchemeColors(nArray2);
    }

    @ColorInt
    public void setColorSchemeColors(int ... nArray) {
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.ensureTarget();
        swipeRefreshLayout.mProgress.setColorSchemeColors(nArray);
    }

    @Override
    public boolean isRefreshing() {
        return this.mRefreshing;
    }

    @Override
    public boolean hasRefreshOperator() {
        return this.mIsBeingDragged || this.isRefreshing();
    }

    public void setDistanceToTriggerSync(int n2) {
        this.mTotalDragDistance = n2;
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        SwipeRefreshLayout swipeRefreshLayout = this;
        int n6 = swipeRefreshLayout.getMeasuredWidth();
        swipeRefreshLayout.getMeasuredHeight();
        if (swipeRefreshLayout.getChildCount() == 0) {
            return;
        }
        if (this.mTarget == null) {
            this.ensureTarget();
        }
        SwipeRefreshLayout swipeRefreshLayout2 = this;
        int n7 = swipeRefreshLayout2.mCircleView.getMeasuredWidth();
        int n8 = swipeRefreshLayout2.mCircleView.getMeasuredHeight();
        int n62 = n6 / 2;
        int n9 = n7 / 2;
        n7 = n62 - n9;
        int n10 = this.mCurrentTargetOffsetTop;
        int n11 = n10 + n8;
        swipeRefreshLayout2.mCircleView.layout(n7, n10, n62 += n9, n11);
    }

    public void onMeasure(int n2, int n3) {
        SwipeRefreshLayout swipeRefreshLayout = this;
        super.onMeasure(n2, n3);
        if (swipeRefreshLayout.mTarget == null) {
            this.ensureTarget();
        }
        SwipeRefreshLayout swipeRefreshLayout2 = this;
        swipeRefreshLayout2.mCircleView.measure(View.MeasureSpec.makeMeasureSpec((int)this.mCircleWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.mCircleHeight, (int)0x40000000));
        if (!swipeRefreshLayout2.mUsingCustomStart && !this.mOriginalOffsetCalculated) {
            this.mOriginalOffsetCalculated = true;
            this.mOriginalOffsetTop = n2 = -this.mCircleView.getMeasuredHeight();
            this.mCurrentTargetOffsetTop = n2;
            this.F_OriginalOffsetTop = n2;
        }
        this.mCircleViewIndex = -1;
        for (n2 = 0; n2 < this.getChildCount(); ++n2) {
            if (this.getChildAt(n2) != this.mCircleView) continue;
            this.mCircleViewIndex = n2;
            break;
        }
    }

    public int getProgressCircleDiameter() {
        Object object = object.mCircleView;
        return object != null ? object.getMeasuredHeight() : 0;
    }

    public boolean canChildScrollUp() {
        View view = swipeRefreshLayout.mTarget;
        if (view != null) {
            if (Build.VERSION.SDK_INT < 14) {
                if (view instanceof AbsListView) {
                    SwipeRefreshLayout swipeRefreshLayout = (AbsListView)view;
                    return swipeRefreshLayout.getChildCount() > 0 && (swipeRefreshLayout.getFirstVisiblePosition() > 0 || swipeRefreshLayout.getChildAt(0).getTop() < swipeRefreshLayout.getPaddingTop());
                }
                return ViewCompat.canScrollVertically(view, -1) || swipeRefreshLayout.mTarget.getScrollY() > 0;
            }
            return ViewCompat.canScrollVertically(view, -1);
        }
        return false;
    }

    @Override
    public void endRefresh() {
        this.setRefreshing(false);
    }

    @Override
    public void beginRefresh() {
        if (!this.mBeginRefresh && this.mCircleView.getVisibility() != 0) {
            Runnable runnable;
            Runnable runnable2 = runnable;
            runnable = new Runnable(){
                int offset = 0;

                @Override
                public void run() {
                    if ((float)this.offset < SwipeRefreshLayout.this.mTotalDragDistance) {
                        5 v0 = this;
                        v0.SwipeRefreshLayout.this.moveSpinner(this.offset);
                        v0.SwipeRefreshLayout.this.postDelayed(this, 1L);
                        v0.offset += 15;
                    } else {
                        SwipeRefreshLayout.this.setRefreshing(true, true);
                        SwipeRefreshLayout.this.mBeginRefresh = false;
                    }
                }
            };
            this.post(runnable2);
            this.mBeginRefresh = true;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void parseData(JSONObject var1_1, int var2_3, int var3_5, float var4_6) {
        block27: {
            block26: {
                block25: {
                    block24: {
                        if (var4_6 == 0.0f || var4_6 == 1.0f) {
                            var4_6 = this.mParentView.getContext().getResources().getDisplayMetrics().density;
                        }
                        v0 = this;
                        v1 = this;
                        v1.mOriginalOffsetTop = v1.F_OriginalOffsetTop;
                        v1.mSpinnerFinalOffset = v1.F_SpinnerFinalOffset;
                        v1.mTotalDragDistance = v1.F_TotalDragDistance;
                        this.mJsonData = var1_1;
                        var2_4 = var1_1.optString("offset");
                        var5_7 = v0.mOriginalOffsetTop;
                        if (TextUtils.isEmpty((CharSequence)var2_4)) break block24;
                        var5_7 = PdrUtil.convertToScreenInt(var2_4, var3_5, var5_7, var4_6);
                    }
                    var2_4 = var1_1.optString("height");
                    var6_8 = (int)this.mTotalDragDistance;
                    if (TextUtils.isEmpty((CharSequence)var2_4)) break block25;
                    var6_8 = PdrUtil.convertToScreenInt(var2_4, var3_5, var6_8, var4_6);
                }
                var2_4 = var1_1.optString("range");
                var7_9 = (int)this.mSpinnerFinalOffset;
                if (TextUtils.isEmpty((CharSequence)var2_4)) break block26;
                var7_9 = PdrUtil.convertToScreenInt(var2_4, var3_5, var7_9, var4_6);
            }
            var1_2 = var7_9 + var5_7;
            var2_4 = var1_1.optString("color");
            var3_5 = Color.parseColor((String)"#2BD009");
            if (TextUtils.isEmpty((CharSequence)var2_4)) ** GOTO lbl52
            if (!var2_4.startsWith("#")) ** GOTO lbl52
            try {
                var3_5 = Color.parseColor((String)var2_4);
                ** GOTO lbl52
            }
            catch (Exception v2) {
                v2.printStackTrace();
lbl52:
                // 4 sources

                v3 = this;
                v3.setColorSchemeColors(new int[]{var3_5});
                if (v3.mOriginalOffsetTop == var5_7) ** GOTO lbl57
            }
            this.isSetOffset = false;
lbl57:
            // 2 sources

            if (this.isSetOffset) break block27;
            this.isSetOffset = true;
            this.setProgressViewOffset(false, var5_7, var1_2, var6_8);
            {
                catch (Exception v4) {
                    v4.printStackTrace();
                }
            }
        }
    }

    @Override
    public void onResize(int n2, int n3, float f2) {
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.parseData(swipeRefreshLayout.mJsonData, n2, n3, f2);
    }

    public void requestDisallowInterceptTouchEvent(boolean bl) {
        View view;
        if (!(Build.VERSION.SDK_INT < 21 && this.mTarget instanceof AbsListView || (view = this.mTarget) != null && !ViewCompat.isNestedScrollingEnabled(view))) {
            super.requestDisallowInterceptTouchEvent(bl);
        }
    }

    @Override
    public boolean onStartNestedScroll(View view, View view2, int n2) {
        int n3;
        if (this.isEnabled() && (n3 = n2 & 2) != 0) {
            this.startNestedScroll(n3);
            return true;
        }
        return false;
    }

    @Override
    public void onNestedScrollAccepted(View view, View view2, int n2) {
        this.mNestedScrollingParentHelper.onNestedScrollAccepted(view, view2, n2);
        this.mTotalUnconsumed = 0.0f;
    }

    @Override
    public void onNestedPreScroll(View view, int n2, int n3, int[] nArray) {
        int n4;
        if (n3 > 0) {
            float f2;
            float f3 = ((SwipeRefreshLayout)this).mTotalUnconsumed;
            if (f2 > 0.0f) {
                float f4;
                float f5 = n3;
                if (f4 > f3) {
                    nArray[1] = n3 - (int)f3;
                    ((SwipeRefreshLayout)this).mTotalUnconsumed = 0.0f;
                } else {
                    ((SwipeRefreshLayout)this).mTotalUnconsumed = f3 - f5;
                    nArray[1] = n3;
                }
                Object object = this;
                super.moveSpinner(((SwipeRefreshLayout)object).mTotalUnconsumed);
            }
        }
        if (((SwipeRefreshLayout)this).dispatchNestedPreScroll(n4 = n2 - nArray[0], n3 - nArray[1], (int[])(this = (Object)((SwipeRefreshLayout)this).mParentScrollConsumed), null)) {
            int[] nArray2 = nArray;
            nArray2[0] = nArray[0] + this[0];
            nArray2[1] = nArray[1] + this[1];
        }
    }

    @Override
    public int getNestedScrollAxes() {
        return this.mNestedScrollingParentHelper.getNestedScrollAxes();
    }

    @Override
    public void onStopNestedScroll(View view) {
        float f2;
        SwipeRefreshLayout swipeRefreshLayout = this;
        swipeRefreshLayout.mNestedScrollingParentHelper.onStopNestedScroll(view);
        float f3 = swipeRefreshLayout.mTotalUnconsumed;
        if (f2 > 0.0f) {
            this.finishSpinner(f3);
            this.mTotalUnconsumed = 0.0f;
        }
        this.stopNestedScroll();
    }

    @Override
    public void onNestedScroll(View view, int n2, int n3, int n4, int n5) {
        if (n5 < 0) {
            float f2;
            SwipeRefreshLayout swipeRefreshLayout = this;
            int n6 = Math.abs(n5);
            swipeRefreshLayout.mTotalUnconsumed = f2 = swipeRefreshLayout.mTotalUnconsumed + (float)n6;
            swipeRefreshLayout.moveSpinner(f2);
        }
        this.dispatchNestedScroll(n2, n3, n4, n2, null);
    }

    @Override
    public boolean onNestedPreFling(View view, float f2, float f3) {
        return false;
    }

    @Override
    public boolean onNestedFling(View view, float f2, float f3, boolean bl) {
        return false;
    }

    @Override
    public void setNestedScrollingEnabled(boolean bl) {
        this.mNestedScrollingChildHelper.setNestedScrollingEnabled(bl);
    }

    @Override
    public boolean isNestedScrollingEnabled() {
        return this.mNestedScrollingChildHelper.isNestedScrollingEnabled();
    }

    @Override
    public boolean startNestedScroll(int n2) {
        return this.mNestedScrollingChildHelper.startNestedScroll(n2);
    }

    @Override
    public void stopNestedScroll() {
        this.mNestedScrollingChildHelper.stopNestedScroll();
    }

    @Override
    public boolean hasNestedScrollingParent() {
        return this.mNestedScrollingChildHelper.hasNestedScrollingParent();
    }

    @Override
    public boolean dispatchNestedScroll(int n2, int n3, int n4, int n5, int[] nArray) {
        return this.mNestedScrollingChildHelper.dispatchNestedScroll(n2, n3, n4, n5, nArray);
    }

    @Override
    public boolean dispatchNestedPreScroll(int n2, int n3, int[] nArray, int[] nArray2) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreScroll(n2, n3, nArray, nArray2);
    }

    @Override
    public boolean dispatchNestedFling(float f2, float f3, boolean bl) {
        return this.mNestedScrollingChildHelper.dispatchNestedFling(f2, f3, bl);
    }

    @Override
    public boolean dispatchNestedPreFling(float f2, float f3) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreFling(f2, f3);
    }

    @Override
    public void onInit(ViewGroup viewGroup, View view, IRefreshAble.OnRefreshListener onRefreshListener) {
        this.mParentView = view;
        this.mDrawParentView = view;
        this.setOnRefreshListener(onRefreshListener);
        viewGroup.addView((View)this, -1, -1);
    }

    @Override
    public void setRefreshEnable(boolean bl) {
        this.mRefreshEnable = bl;
    }

    @Override
    public boolean isRefreshEnable() {
        return this.mRefreshEnable;
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.mUseSys) {
            super.dispatchDraw(canvas);
        } else {
            this.parentInvalidate();
        }
    }

    @Override
    public void onSelfDraw(Canvas canvas) {
        if (this.isDrawAble()) {
            Canvas canvas2 = canvas;
            SwipeRefreshLayout swipeRefreshLayout = this;
            canvas.save();
            int n2 = swipeRefreshLayout.mCircleView.getMeasuredWidth();
            int n3 = swipeRefreshLayout.mCircleView.getMeasuredHeight();
            int n4 = (swipeRefreshLayout.mParentView.getWidth() - n2) / 2 + this.mParentView.getScrollX();
            int n5 = Math.max(this.mParentView.getScrollY() - n3 + this.mCircleView.getTop(), this.mOriginalOffsetTop);
            n2 = n4 + n2;
            canvas.clipRect(n4, n5, n2, n5 + n3);
            canvas2.translate((float)this.mParentView.getScrollX(), (float)(this.mParentView.getScrollY() - n3));
            super.dispatchDraw(canvas2);
            canvas.restore();
        }
    }

    @Override
    public boolean onSelfTouchEvent(MotionEvent motionEvent) {
        boolean bl;
        block14: {
            block13: {
                if (!this.handleTouchEvent(motionEvent)) {
                    return false;
                }
                int n2 = MotionEventCompat.getActionMasked(motionEvent);
                bl = false;
                if (this.mReturningToStart && n2 == 0) {
                    this.mReturningToStart = false;
                }
                if (!this.isEnabled() || this.mReturningToStart || this.canChildScrollUp()) break block13;
                switch (n2) {
                    default: {
                        break block14;
                    }
                    case 2: {
                        float f2;
                        float f3 = motionEvent.getY();
                        float f4 = motionEvent.getX();
                        if (f2 - this.mInitialDownY > (float)this.mTouchSlop && !this.mIsBeingDragged && Math.atan(Math.abs(f4 - this.mInitialDownX) / Math.abs(f3 - this.mInitialDownY)) * 180.0 / Math.PI < 40.0) {
                            SwipeRefreshLayout swipeRefreshLayout = this;
                            swipeRefreshLayout.mInitialMotionY = swipeRefreshLayout.mInitialDownY + (float)this.mTouchSlop;
                            swipeRefreshLayout.mIsBeingDragged = true;
                            swipeRefreshLayout.mProgress.setAlpha(76);
                        }
                        if (this.mIsBeingDragged) {
                            float f5;
                            bl = true;
                            f4 = (f3 - this.mInitialMotionY) * 0.5f;
                            if (f5 > 0.0f) {
                                this.moveSpinner(f4);
                            }
                        }
                        break block14;
                    }
                    case 1: 
                    case 3: {
                        float f6 = motionEvent.getY();
                        if (this.mIsBeingDragged) {
                            bl = true;
                            this.finishSpinner((f6 - this.mInitialMotionY) * 0.5f);
                        }
                        SwipeRefreshLayout swipeRefreshLayout = this;
                        swipeRefreshLayout.mInitialDownY = 0.0f;
                        swipeRefreshLayout.mIsBeingDragged = false;
                        swipeRefreshLayout.mHandledDown = false;
                        break block14;
                    }
                    case 0: {
                        if (!this.mIsBeingDragged) {
                            SwipeRefreshLayout swipeRefreshLayout = this;
                            swipeRefreshLayout.mHandledDown = true;
                            swipeRefreshLayout.setTargetOffsetTopAndBottom(swipeRefreshLayout.mOriginalOffsetTop - this.mCircleView.getTop(), true);
                            float f7 = motionEvent.getY();
                            if (f7 == -1.0f) break;
                            this.mInitialDownY = f7;
                            this.mInitialDownX = motionEvent.getX();
                            break;
                        }
                        SwipeRefreshLayout swipeRefreshLayout = this;
                        swipeRefreshLayout.moveSpinner(swipeRefreshLayout.mOriginalOffsetTop);
                        swipeRefreshLayout.mIsBeingDragged = false;
                        break block14;
                    }
                }
            }
            bl = false;
        }
        if (bl) {
            this.parentInvalidate();
        }
        return bl || this.mUseSys;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mUseSys) {
            return this.onSelfTouchEvent(motionEvent);
        }
        return false;
    }
}

