/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.downloader.core;

import com.dcloud.android.downloader.config.Config;
import com.dcloud.android.downloader.core.DownloadResponse;
import com.dcloud.android.downloader.core.task.DownloadTask;
import com.dcloud.android.downloader.core.task.GetFileInfoTask;
import com.dcloud.android.downloader.core.thread.DownloadThread;
import com.dcloud.android.downloader.domain.DownloadInfo;
import com.dcloud.android.downloader.domain.DownloadThreadInfo;
import com.dcloud.android.downloader.exception.DownloadException;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;

public class DownloadTaskImpl
implements DownloadTask,
GetFileInfoTask.OnGetFileInfoListener,
DownloadThread.DownloadProgressListener {
    private final ExecutorService executorService;
    private final DownloadResponse downloadResponse;
    private final DownloadInfo downloadInfo;
    private final Config config;
    private final List<DownloadThread> downloadThreads;
    private final DownloadTaskListener downloadTaskListener;
    private long lastRefreshTime;
    private long progress;
    private volatile AtomicBoolean isComputerDownload;

    public DownloadTaskImpl(ExecutorService executorService, DownloadResponse downloadResponse, DownloadInfo downloadInfo, Config config, DownloadTaskListener downloadTaskListener) {
        DownloadTaskImpl downloadTaskImpl = this;
        this.lastRefreshTime = System.currentTimeMillis();
        this.isComputerDownload = new AtomicBoolean(false);
        this.executorService = executorService;
        this.downloadResponse = downloadResponse;
        this.downloadInfo = downloadInfo;
        this.config = config;
        downloadTaskImpl.downloadTaskListener = downloadTaskListener;
        downloadTaskImpl.downloadThreads = new ArrayList<DownloadThread>();
    }

    private void getFileInfo() {
        GetFileInfoTask getFileInfoTask;
        GetFileInfoTask getFileInfoTask2 = getFileInfoTask;
        DownloadTaskImpl downloadTaskImpl = this;
        DownloadResponse downloadResponse = downloadTaskImpl.downloadResponse;
        getFileInfoTask = new GetFileInfoTask(downloadResponse, downloadTaskImpl.downloadInfo, this);
        this.executorService.submit(getFileInfoTask2);
    }

    private void removeDownlaodFile() {
        File file;
        File file2 = file;
        if (new File(this.downloadInfo.getPath()).exists()) {
            file2.delete();
        }
    }

    private void computerDownloadProgress() {
        this.progress = 0L;
        for (DownloadThreadInfo downloadThreadInfo : this.downloadInfo.getDownloadThreadInfos()) {
            this.progress += downloadThreadInfo.getProgress();
        }
        this.downloadInfo.setProgress(this.progress);
    }

    @Override
    public void start() {
        if (this.downloadInfo.getSize() <= 0L) {
            this.getFileInfo();
        } else {
            Iterator<DownloadThreadInfo> iterator = this.downloadInfo.getDownloadThreadInfos().iterator();
            while (iterator.hasNext()) {
                DownloadThread downloadThread;
                DownloadTaskImpl downloadTaskImpl = this;
                Object object = iterator.next();
                DownloadThread downloadThread2 = downloadThread;
                DownloadThreadInfo downloadThreadInfo = object;
                DownloadTaskImpl downloadTaskImpl2 = this;
                object = downloadTaskImpl2.downloadResponse;
                Config config = downloadTaskImpl2.config;
                DownloadInfo downloadInfo = downloadTaskImpl2.downloadInfo;
                downloadThread = new DownloadThread(downloadThreadInfo, (DownloadResponse)object, config, downloadInfo, this);
                downloadTaskImpl.executorService.submit(downloadThread2);
                downloadTaskImpl.downloadThreads.add(downloadThread2);
            }
            DownloadTaskImpl downloadTaskImpl = this;
            downloadTaskImpl.downloadInfo.setStatus(2);
            downloadTaskImpl.downloadResponse.onStatusChanged(this.downloadInfo);
        }
    }

    @Override
    public void onSuccess(long l2, boolean bl) {
        ArrayList<DownloadThreadInfo> arrayList;
        DownloadTaskImpl downloadTaskImpl = this;
        downloadTaskImpl.downloadInfo.setSupportRanges(bl);
        downloadTaskImpl.downloadInfo.setSize(l2);
        downloadTaskImpl.removeDownlaodFile();
        ArrayList<DownloadThreadInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<DownloadThreadInfo>();
        if (bl) {
            long object = this.downloadInfo.getSize();
            int object2 = this.config.getEachDownloadThread();
            long l7 = object / (long)object2;
            for (int i2 = 0; i2 < object2; ++i2) {
                DownloadThread downloadThread;
                DownloadThreadInfo downloadThreadInfo;
                long l3 = l7 * (long)i2;
                long l4 = i2 == object2 - 1 ? object : l3 + l7 - 1L;
                DownloadTaskImpl downloadTaskImpl2 = this;
                DownloadThreadInfo downloadThreadInfo2 = downloadThreadInfo;
                DownloadTaskImpl downloadTaskImpl3 = this;
                int n2 = downloadTaskImpl3.downloadInfo.getId();
                arrayList2.add(new DownloadThreadInfo(i2, n2, downloadTaskImpl3.downloadInfo.getDownloadUrl(), l3, l4));
                DownloadThread l5 = downloadThread;
                DownloadTaskImpl downloadTaskImpl4 = this;
                DownloadResponse downloadResponse = downloadTaskImpl4.downloadResponse;
                Config l6 = downloadTaskImpl4.config;
                DownloadInfo downloadInfo = downloadTaskImpl4.downloadInfo;
                downloadThread = new DownloadThread(downloadThreadInfo2, downloadResponse, l6, downloadInfo, this);
                downloadTaskImpl2.executorService.submit(l5);
                downloadTaskImpl2.downloadThreads.add(l5);
            }
        } else {
            DownloadThread downloadThread;
            DownloadThreadInfo downloadThreadInfo;
            DownloadTaskImpl downloadTaskImpl5 = this;
            Object object = downloadThreadInfo;
            DownloadTaskImpl downloadTaskImpl6 = this;
            int downloadThread3 = downloadTaskImpl6.downloadInfo.getId();
            Object object2 = downloadTaskImpl6.downloadInfo.getDownloadUrl();
            long downloadInfo = downloadTaskImpl6.downloadInfo.getSize();
            arrayList2.add(new DownloadThreadInfo(0, downloadThread3, (String)object2, 0L, downloadInfo));
            DownloadThread downloadThread2 = downloadThread;
            DownloadThreadInfo downloadThreadInfo3 = object;
            DownloadTaskImpl downloadTaskImpl7 = this;
            object = downloadTaskImpl7.downloadResponse;
            object2 = downloadTaskImpl7.config;
            DownloadInfo downloadInfo2 = downloadTaskImpl7.downloadInfo;
            downloadThread = new DownloadThread(downloadThreadInfo3, (DownloadResponse)object, (Config)object2, downloadInfo2, this);
            downloadTaskImpl5.executorService.submit(downloadThread2);
            downloadTaskImpl5.downloadThreads.add(downloadThread2);
        }
        DownloadTaskImpl downloadTaskImpl8 = this;
        downloadTaskImpl8.downloadInfo.setDownloadThreadInfos(arrayList2);
        downloadTaskImpl8.downloadInfo.setStatus(2);
        downloadTaskImpl8.downloadResponse.onStatusChanged(this.downloadInfo);
    }

    @Override
    public void onFailed(DownloadException downloadException) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onProgress() {
        if (this.isComputerDownload.get()) return;
        DownloadTaskImpl downloadTaskImpl = this;
        synchronized (downloadTaskImpl) {
            if (downloadTaskImpl.isComputerDownload.get()) return;
            this.isComputerDownload.set(true);
            long l2 = System.currentTimeMillis();
            if (l2 - this.lastRefreshTime > 1000L) {
                DownloadTaskImpl downloadTaskImpl2 = this;
                downloadTaskImpl2.computerDownloadProgress();
                downloadTaskImpl2.downloadResponse.onStatusChanged(this.downloadInfo);
                this.lastRefreshTime = l2;
            }
            this.isComputerDownload.set(false);
            // ** MonitorExit[this] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void onDownloadSuccess() {
        DownloadTaskImpl downloadTaskImpl = this;
        downloadTaskImpl.computerDownloadProgress();
        if (downloadTaskImpl.downloadInfo.getProgress() == this.downloadInfo.getSize()) {
            DownloadTaskImpl downloadTaskImpl2 = this;
            downloadTaskImpl2.downloadInfo.setStatus(5);
            downloadTaskImpl2.downloadResponse.onStatusChanged(this.downloadInfo);
            DownloadTaskListener downloadTaskListener = downloadTaskImpl2.downloadTaskListener;
            if (downloadTaskListener != null) {
                downloadTaskListener.onDownloadSuccess(this.downloadInfo);
            }
        }
    }

    public static interface DownloadTaskListener {
        public void onDownloadSuccess(DownloadInfo var1);
    }
}

