/*
 * Decompiled with CFR 0.152.
 */
package androidtranscoder.engine;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.util.Log;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class QueuedMuxer {
    private static final String TAG = "QueuedMuxer";
    private static final int BUFFER_SIZE = 65536;
    private final MediaMuxer mMuxer;
    private final Listener mListener;
    private MediaFormat mVideoFormat;
    private MediaFormat mAudioFormat;
    private int mVideoTrackIndex;
    private int mAudioTrackIndex;
    private ByteBuffer mByteBuffer;
    private final List<SampleInfo> mSampleInfoList;
    private boolean mStarted;

    public QueuedMuxer(MediaMuxer mediaMuxer, Listener listener) {
        ArrayList arrayList;
        ((QueuedMuxer)((Object)arrayList2)).mMuxer = mediaMuxer;
        ((QueuedMuxer)((Object)arrayList2)).mListener = listener;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        v1.mSampleInfoList = arrayList2;
    }

    private void onSetOutputFormat() {
        if (this.mVideoFormat != null && this.mAudioFormat != null) {
            MediaCodec.BufferInfo bufferInfo;
            QueuedMuxer queuedMuxer = this;
            queuedMuxer.mListener.onDetermineOutputFormat();
            queuedMuxer.mVideoTrackIndex = queuedMuxer.mMuxer.addTrack(this.mVideoFormat);
            Log.v((String)TAG, (String)("Added track #" + this.mVideoTrackIndex + " with " + this.mVideoFormat.getString("mime") + " to muxer"));
            queuedMuxer.mAudioTrackIndex = queuedMuxer.mMuxer.addTrack(this.mAudioFormat);
            Log.v((String)TAG, (String)("Added track #" + this.mAudioTrackIndex + " with " + this.mAudioFormat.getString("mime") + " to muxer"));
            queuedMuxer.mMuxer.start();
            queuedMuxer.mStarted = true;
            if (queuedMuxer.mByteBuffer == null) {
                this.mByteBuffer = ByteBuffer.allocate(0);
            }
            QueuedMuxer queuedMuxer2 = this;
            queuedMuxer2.mByteBuffer.flip();
            Log.v((String)TAG, (String)("Output format determined, writing " + this.mSampleInfoList.size() + " samples / " + this.mByteBuffer.limit() + " bytes to muxer."));
            MediaCodec.BufferInfo bufferInfo2 = bufferInfo;
            bufferInfo = new MediaCodec.BufferInfo();
            int n2 = 0;
            Iterator<SampleInfo> iterator = queuedMuxer2.mSampleInfoList.iterator();
            while (iterator.hasNext()) {
                int n3 = n2;
                SampleInfo sampleInfo = iterator.next();
                sampleInfo.writeToBufferInfo(bufferInfo2, n2);
                QueuedMuxer queuedMuxer3 = this;
                n2 = queuedMuxer3.getTrackIndexForSampleType(sampleInfo.mSampleType);
                this.mMuxer.writeSampleData(n2, queuedMuxer3.mByteBuffer, bufferInfo2);
                n2 = n3 + sampleInfo.mSize;
            }
            this.mSampleInfoList.clear();
            this.mByteBuffer = null;
            return;
        }
    }

    private int getTrackIndexForSampleType(SampleType sampleType) {
        int n2 = 1.$SwitchMap$androidtranscoder$engine$QueuedMuxer$SampleType[sampleType.ordinal()];
        if (n2 != 1) {
            if (n2 == 2) {
                return this.mAudioTrackIndex;
            }
            throw new AssertionError();
        }
        return this.mVideoTrackIndex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOutputFormat(SampleType sampleType, MediaFormat mediaFormat) {
        int n2 = 1.$SwitchMap$androidtranscoder$engine$QueuedMuxer$SampleType[sampleType.ordinal()];
        if (n2 != 1) {
            if (n2 != 2) throw new AssertionError();
            this.mAudioFormat = mediaFormat;
        } else {
            this.mVideoFormat = mediaFormat;
        }
        this.onSetOutputFormat();
    }

    public void writeSampleData(SampleType sampleType, ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo) {
        if (this.mStarted) {
            this.mMuxer.writeSampleData(this.getTrackIndexForSampleType(sampleType), byteBuffer, bufferInfo);
            return;
        }
        byteBuffer.limit(bufferInfo.offset + bufferInfo.size);
        byteBuffer.position(bufferInfo.offset);
        if (this.mByteBuffer == null) {
            this.mByteBuffer = ByteBuffer.allocateDirect(65536).order(ByteOrder.nativeOrder());
        }
        QueuedMuxer queuedMuxer = this;
        queuedMuxer.mByteBuffer.put(byteBuffer);
        queuedMuxer.mSampleInfoList.add(new SampleInfo(sampleType, bufferInfo.size, bufferInfo));
    }

    public static interface Listener {
        public void onDetermineOutputFormat();
    }

    private static class SampleInfo {
        private final SampleType mSampleType;
        private final int mSize;
        private final long mPresentationTimeUs;
        private final int mFlags;

        private SampleInfo(SampleType sampleType, int n2, MediaCodec.BufferInfo bufferInfo) {
            this.mSampleType = sampleType;
            this.mSize = n2;
            this.mPresentationTimeUs = bufferInfo.presentationTimeUs;
            this.mFlags = bufferInfo.flags;
        }

        private void writeToBufferInfo(MediaCodec.BufferInfo bufferInfo, int n2) {
            SampleInfo sampleInfo = this;
            int n3 = sampleInfo.mSize;
            long l2 = sampleInfo.mPresentationTimeUs;
            int n4 = sampleInfo.mFlags;
            bufferInfo.set(n2, n3, l2, n4);
        }
    }

    public static final class SampleType
    extends Enum<SampleType> {
        public static final /* enum */ SampleType VIDEO;
        public static final /* enum */ SampleType AUDIO;
        private static final /* synthetic */ SampleType[] $VALUES;

        public static SampleType[] values() {
            return (SampleType[])$VALUES.clone();
        }

        public static SampleType valueOf(String string2) {
            return Enum.valueOf(SampleType.class, string2);
        }

        static {
            SampleType sampleType;
            SampleType sampleType2;
            SampleType sampleType3 = sampleType2;
            VIDEO = new SampleType();
            SampleType sampleType4 = sampleType;
            AUDIO = new SampleType();
            $VALUES = new SampleType[]{sampleType3, sampleType4};
        }
    }
}

