/*
 * Decompiled with CFR 0.152.
 */
package androidtranscoder.engine;

import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.view.Surface;
import androidtranscoder.engine.TextureRender;

class OutputSurface
implements SurfaceTexture.OnFrameAvailableListener {
    private static final String TAG = "OutputSurface";
    private static final boolean VERBOSE = false;
    private EGLDisplay mEGLDisplay;
    private EGLContext mEGLContext;
    private EGLSurface mEGLSurface;
    private SurfaceTexture mSurfaceTexture;
    private Surface mSurface;
    private Object mFrameSyncObject;
    private boolean mFrameAvailable;
    private TextureRender mTextureRender;

    public OutputSurface(int n2, int n3) {
        this.mEGLDisplay = EGL14.EGL_NO_DISPLAY;
        this.mEGLContext = EGL14.EGL_NO_CONTEXT;
        this.mEGLSurface = EGL14.EGL_NO_SURFACE;
        this.mFrameSyncObject = new Object();
        if (n2 > 0 && n3 > 0) {
            OutputSurface outputSurface = this;
            outputSurface.eglSetup(n2, n3);
            outputSurface.makeCurrent();
            outputSurface.setup();
            return;
        }
        throw new IllegalArgumentException();
    }

    public OutputSurface() {
        OutputSurface outputSurface = this;
        outputSurface.mEGLDisplay = EGL14.EGL_NO_DISPLAY;
        outputSurface.mEGLContext = EGL14.EGL_NO_CONTEXT;
        outputSurface.mEGLSurface = EGL14.EGL_NO_SURFACE;
        outputSurface.mFrameSyncObject = new Object();
        outputSurface.setup();
    }

    private void setup() {
        SurfaceTexture surfaceTexture;
        SurfaceTexture surfaceTexture2;
        this.mTextureRender = new TextureRender();
        this.mTextureRender.surfaceCreated();
        SurfaceTexture surfaceTexture3 = surfaceTexture2 = surfaceTexture;
        surfaceTexture3(this.mTextureRender.getTextureId());
        this.mSurfaceTexture = surfaceTexture3;
        surfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.mSurface = new Surface(this.mSurfaceTexture);
    }

    private void eglSetup(int n2, int n3) {
        Object object;
        ((OutputSurface)object2).mEGLDisplay = object = EGL14.eglGetDisplay((int)0);
        if (object != EGL14.EGL_NO_DISPLAY) {
            int[] nArray = new int[2];
            if (EGL14.eglInitialize((EGLDisplay)object, (int[])nArray, (int)0, (int[])nArray, (int)1)) {
                int[] nArray2 = new int[11];
                object = nArray2;
                nArray2[0] = 12324;
                nArray2[1] = 8;
                nArray2[2] = 12323;
                nArray2[3] = 8;
                nArray2[4] = 12322;
                nArray2[5] = 8;
                nArray2[6] = 12352;
                nArray2[7] = 4;
                nArray2[8] = 12339;
                nArray2[9] = 1;
                nArray2[10] = 12344;
                EGLConfig[] eGLConfigArray = new EGLConfig[1];
                int[] nArray3 = new int[1];
                if (EGL14.eglChooseConfig((EGLDisplay)((OutputSurface)object2).mEGLDisplay, (int[])object, (int)0, (EGLConfig[])eGLConfigArray, (int)0, (int)1, (int[])nArray3, (int)0)) {
                    OutputSurface outputSurface = object2;
                    int[] nArray4 = new int[3];
                    object = nArray4;
                    nArray4[0] = 12440;
                    nArray4[1] = 2;
                    nArray4[2] = 12344;
                    outputSurface.mEGLContext = EGL14.eglCreateContext((EGLDisplay)outputSurface.mEGLDisplay, (EGLConfig)eGLConfigArray[0], (EGLContext)EGL14.EGL_NO_CONTEXT, (int[])object, (int)0);
                    outputSurface.checkEglError("eglCreateContext");
                    if (outputSurface.mEGLContext != null) {
                        OutputSurface outputSurface2 = object2;
                        int[] nArray5 = new int[5];
                        Object object2 = nArray5;
                        nArray5[0] = 12375;
                        nArray5[1] = n2;
                        nArray5[2] = 12374;
                        nArray5[3] = n3;
                        nArray5[4] = 12344;
                        outputSurface2.mEGLSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)outputSurface2.mEGLDisplay, (EGLConfig)eGLConfigArray[0], (int[])object2, (int)0);
                        outputSurface2.checkEglError("eglCreatePbufferSurface");
                        if (outputSurface2.mEGLSurface != null) {
                            return;
                        }
                        throw new RuntimeException("surface was null");
                    }
                    throw new RuntimeException("null context");
                }
                throw new RuntimeException("unable to find RGB888+recordable ES2 EGL config");
            }
            ((OutputSurface)object2).mEGLDisplay = null;
            throw new RuntimeException("unable to initialize EGL14");
        }
        throw new RuntimeException("unable to get EGL14 display");
    }

    private void checkEglError(String string2) {
        int n2 = EGL14.eglGetError();
        if (n2 == 12288) {
            return;
        }
        throw new RuntimeException(string2 + ": EGL error: 0x" + Integer.toHexString(n2));
    }

    public void release() {
        EGLDisplay eGLDisplay = this.mEGLDisplay;
        if (eGLDisplay != EGL14.EGL_NO_DISPLAY) {
            OutputSurface outputSurface = this;
            EGL14.eglDestroySurface((EGLDisplay)eGLDisplay, (EGLSurface)this.mEGLSurface);
            EGL14.eglDestroyContext((EGLDisplay)outputSurface.mEGLDisplay, (EGLContext)this.mEGLContext);
            EGL14.eglReleaseThread();
            EGL14.eglTerminate((EGLDisplay)outputSurface.mEGLDisplay);
        }
        this.mSurface.release();
        this.mEGLDisplay = EGL14.EGL_NO_DISPLAY;
        this.mEGLContext = EGL14.EGL_NO_CONTEXT;
        this.mEGLSurface = EGL14.EGL_NO_SURFACE;
        this.mTextureRender = null;
        this.mSurface = null;
        this.mSurfaceTexture = null;
    }

    public void makeCurrent() {
        OutputSurface outputSurface = outputSurface2;
        OutputSurface outputSurface2 = outputSurface.mEGLSurface;
        EGLContext eGLContext = outputSurface.mEGLContext;
        OutputSurface outputSurface3 = outputSurface2;
        if (EGL14.eglMakeCurrent((EGLDisplay)outputSurface2.mEGLDisplay, (EGLSurface)outputSurface3, (EGLSurface)outputSurface3, (EGLContext)eGLContext)) {
            return;
        }
        throw new RuntimeException("eglMakeCurrent failed");
    }

    public Surface getSurface() {
        return this.mSurface;
    }

    public void changeFragmentShader(String string2) {
        this.mTextureRender.changeFragmentShader(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public void awaitNewImage() {
        Object object = this.mFrameSyncObject;
        synchronized (object) {
            while (!this.mFrameAvailable) {
                try {
                    OutputSurface outputSurface = this;
                    outputSurface.mFrameSyncObject.wait(10000L);
                    if (outputSurface.mFrameAvailable) continue;
                    throw new RuntimeException("Surface frame wait timed out");
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
            }
            OutputSurface outputSurface = this;
            this.mFrameAvailable = false;
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl14 : MonitorExitStatement: MONITOREXIT : var1_2
            outputSurface.mTextureRender.checkGlError("before updateTexImage");
            outputSurface.mSurfaceTexture.updateTexImage();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean checkForNewImage(int n2) {
        Object object = this.mFrameSyncObject;
        synchronized (object) {
            while (!this.mFrameAvailable) {
                try {
                    OutputSurface outputSurface = this;
                    outputSurface.mFrameSyncObject.wait(n2);
                    if (outputSurface.mFrameAvailable) continue;
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
                return false;
            }
            OutputSurface outputSurface = this;
            this.mFrameAvailable = false;
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl15 : MonitorExitStatement: MONITOREXIT : object
            outputSurface.mTextureRender.checkGlError("before updateTexImage");
            outputSurface.mSurfaceTexture.updateTexImage();
            return true;
        }
    }

    public void drawImage() {
        this.mTextureRender.drawFrame(this.mSurfaceTexture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onFrameAvailable(SurfaceTexture object) {
        OutputSurface outputSurface = this;
        Object object2 = outputSurface.mFrameSyncObject;
        synchronized (object2) {
            if (outputSurface.mFrameAvailable) throw new RuntimeException("mFrameAvailable already set, frame could be dropped");
            this.mFrameAvailable = true;
            this.mFrameSyncObject.notifyAll();
            return;
        }
    }
}

