/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoguang.widget.mlkitscanner.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.mlkit.vision.barcode.Barcode;
import com.xiaoguang.widget.R;
import com.xiaoguang.widget.mlkitscanner.model.ScanConfig;
import com.xiaoguang.widget.mlkitscanner.utils.CommonUtils;
import com.xiaoguang.widget.mlkitscanner.utils.StatusBarUtil;
import java.util.List;

public class ScanResultPointView
extends FrameLayout {
    private ScanConfig scanConfig;
    private List<Barcode> resultPoint;
    private OnResultPointClickListener onResultPointClickListener;
    private int resultPointColor;
    private int resultPointStrokeColor;
    private int resultPointWithdHeight;
    private int resultPointRadiusCorners;
    private int resultPointStrokeWidth;
    private TextView tv_cancle;
    private FrameLayout fl_result_point_root;
    private View fakeStatusBar;
    private int statusBarHeight;
    private ImageView iv_show_result;
    private Bitmap barcodeBitmap;

    public void setOnResultPointClickListener(OnResultPointClickListener onResultPointClickListener) {
        this.onResultPointClickListener = onResultPointClickListener;
    }

    public ScanResultPointView(Context context) {
        this(context, null);
    }

    public ScanResultPointView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ScanResultPointView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.view_scan_result_point, (ViewGroup)this);
        this.fakeStatusBar = view.findViewById(R.id.fakeStatusBar2);
        this.iv_show_result = (ImageView)view.findViewById(R.id.iv_show_result);
        this.tv_cancle = (TextView)view.findViewById(R.id.tv_cancle);
        this.fl_result_point_root = (FrameLayout)view.findViewById(R.id.fl_result_point_root);
        this.statusBarHeight = StatusBarUtil.getStatusBarHeight(this.getContext());
        if (Build.VERSION.SDK_INT >= 19) {
            ViewGroup.LayoutParams fakeStatusBarLayoutParams = this.fakeStatusBar.getLayoutParams();
            fakeStatusBarLayoutParams.height = this.statusBarHeight;
            this.fakeStatusBar.setLayoutParams(fakeStatusBarLayoutParams);
        }
        this.tv_cancle.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ScanResultPointView.this.onResultPointClickListener != null) {
                    ScanResultPointView.this.onResultPointClickListener.onCancle();
                }
                ScanResultPointView.this.removeAllPoints();
            }
        });
        this.iv_show_result.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
    }

    public void setScanConfig(ScanConfig config) {
        this.scanConfig = config;
        this.initResultPointConfigs();
    }

    private void initResultPointConfigs() {
        if (this.scanConfig == null) {
            return;
        }
        this.resultPointRadiusCorners = CommonUtils.dip2px(this.getContext(), this.scanConfig.getResultPointCorners());
        this.resultPointWithdHeight = CommonUtils.dip2px(this.getContext(), this.scanConfig.getResultPointWithdHeight());
        this.resultPointStrokeWidth = CommonUtils.dip2px(this.getContext(), this.scanConfig.getResultPointStrokeWidth());
        String resultPointColorStr = this.scanConfig.getResultPointColor();
        String resultPointStrokeColorStr = this.scanConfig.getResultPointStrokeColor();
        if (this.resultPointWithdHeight == 0) {
            this.resultPointWithdHeight = CommonUtils.dip2px(this.getContext(), 36.0f);
        }
        if (this.resultPointRadiusCorners == 0) {
            this.resultPointRadiusCorners = CommonUtils.dip2px(this.getContext(), 36.0f);
        }
        if (this.resultPointStrokeWidth == 0) {
            this.resultPointStrokeWidth = CommonUtils.dip2px(this.getContext(), 3.0f);
        }
        this.resultPointColor = !TextUtils.isEmpty((CharSequence)resultPointColorStr) ? Color.parseColor((String)resultPointColorStr) : this.getContext().getResources().getColor(R.color.viewfinder_laser_result_point);
        this.resultPointStrokeColor = !TextUtils.isEmpty((CharSequence)resultPointStrokeColorStr) ? Color.parseColor((String)resultPointStrokeColorStr) : this.getContext().getResources().getColor(R.color.viewfinder_laser_result_point_border);
    }

    public void setDatas(List<Barcode> results, Bitmap barcode) {
        this.resultPoint = results;
        this.barcodeBitmap = barcode;
        this.drawableResultPoint();
    }

    public void removeAllPoints() {
        this.fl_result_point_root.removeAllViews();
    }

    private void drawableResultPoint() {
        Log.e((String)">>>>>>", (String)"drawableResultPoint---start");
        this.iv_show_result.setImageBitmap(this.barcodeBitmap);
        this.removeAllPoints();
        if (this.resultPoint == null || this.resultPoint.size() == 0) {
            if (this.onResultPointClickListener != null) {
                this.onResultPointClickListener.onCancle();
            }
            return;
        }
        if (this.scanConfig == null) {
            this.scanConfig = new ScanConfig.Builder().builder();
        }
        if (this.resultPoint.size() == 1) {
            this.tv_cancle.setVisibility(4);
        } else {
            this.tv_cancle.setVisibility(0);
        }
        for (int j = 0; j < this.resultPoint.size(); ++j) {
            final Barcode barcode = this.resultPoint.get(j);
            Rect boundingBox = barcode.getBoundingBox();
            int centerX = boundingBox.centerX();
            int centerY = boundingBox.centerY();
            View inflate = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.view_item_result_point, null);
            RelativeLayout rl_root = (RelativeLayout)inflate.findViewById(R.id.rl_root);
            ImageView iv_point_bg = (ImageView)inflate.findViewById(R.id.iv_point_bg);
            ImageView iv_point_arrow = (ImageView)inflate.findViewById(R.id.iv_point_arrow);
            RelativeLayout.LayoutParams lpRoot = new RelativeLayout.LayoutParams(this.resultPointWithdHeight, this.resultPointWithdHeight);
            rl_root.setLayoutParams((ViewGroup.LayoutParams)lpRoot);
            rl_root.setX((float)centerX - (float)this.resultPointWithdHeight / 2.0f);
            rl_root.setY((float)centerY - (float)this.resultPointWithdHeight / 2.0f);
            GradientDrawable gradientDrawable = new GradientDrawable();
            gradientDrawable.setCornerRadius((float)this.resultPointRadiusCorners);
            gradientDrawable.setShape(0);
            gradientDrawable.setStroke(this.resultPointStrokeWidth, this.resultPointStrokeColor);
            gradientDrawable.setColor(this.resultPointColor);
            iv_point_bg.setImageDrawable((Drawable)gradientDrawable);
            ViewGroup.LayoutParams lpPoint = iv_point_bg.getLayoutParams();
            lpPoint.width = this.resultPointWithdHeight;
            lpPoint.height = this.resultPointWithdHeight;
            iv_point_bg.setLayoutParams(lpPoint);
            if (this.resultPoint.size() > 1) {
                ViewGroup.LayoutParams lpArrow = iv_point_arrow.getLayoutParams();
                lpArrow.width = this.resultPointWithdHeight / 2;
                lpArrow.height = this.resultPointWithdHeight / 2;
                iv_point_arrow.setLayoutParams(lpArrow);
                iv_point_arrow.setVisibility(0);
            } else {
                iv_point_arrow.setVisibility(8);
            }
            iv_point_bg.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ScanResultPointView.this.onResultPointClickListener != null) {
                        ScanResultPointView.this.onResultPointClickListener.onPointClick(barcode.getRawValue());
                    }
                }
            });
            this.fl_result_point_root.addView(inflate);
        }
        int childCount = this.fl_result_point_root.getChildCount();
        Log.e((String)">>>>>>", (String)("fl_result_point_root---childCount\uff1a" + childCount));
        if (childCount <= 0 && this.onResultPointClickListener != null) {
            this.onResultPointClickListener.onCancle();
        }
        Log.e((String)">>>>>>", (String)"drawableResultPoint---end");
    }

    public static interface OnResultPointClickListener {
        public void onPointClick(String var1);

        public void onCancle();
    }
}

