/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoguang.widget.mlkitscanner.utils;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;

public class AmbientLightManager
implements SensorEventListener {
    private static final int INTERVAL_TIME = 200;
    protected static final float DARK_LUX = 45.0f;
    protected static final float BRIGHT_LUX = 100.0f;
    private float darkLightLux = 45.0f;
    private float brightLightLux = 100.0f;
    private SensorManager sensorManager;
    private Sensor lightSensor;
    private long lastTime;
    private boolean isLightSensorEnabled;
    private OnLightSensorEventListener mOnLightSensorEventListener;

    public AmbientLightManager(Context context) {
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
        this.lightSensor = this.sensorManager.getDefaultSensor(5);
        this.isLightSensorEnabled = true;
    }

    public void register() {
        if (this.sensorManager != null && this.lightSensor != null) {
            this.sensorManager.registerListener((SensorEventListener)this, this.lightSensor, 3);
        }
    }

    public void unregister() {
        if (this.sensorManager != null && this.lightSensor != null) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
        }
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        if (this.isLightSensorEnabled) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastTime < 200L) {
                return;
            }
            this.lastTime = currentTime;
            if (this.mOnLightSensorEventListener != null) {
                float lightLux = sensorEvent.values[0];
                this.mOnLightSensorEventListener.onSensorChanged(lightLux);
                if (lightLux <= this.darkLightLux) {
                    this.mOnLightSensorEventListener.onSensorChanged(true, lightLux);
                } else if (lightLux >= this.brightLightLux) {
                    this.mOnLightSensorEventListener.onSensorChanged(false, lightLux);
                }
            }
        }
    }

    public void setDarkLightLux(float lightLux) {
        this.darkLightLux = lightLux;
    }

    public void setBrightLightLux(float lightLux) {
        this.brightLightLux = lightLux;
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public boolean isLightSensorEnabled() {
        return this.isLightSensorEnabled;
    }

    public void setLightSensorEnabled(boolean lightSensorEnabled) {
        this.isLightSensorEnabled = lightSensorEnabled;
    }

    public void setOnLightSensorEventListener(OnLightSensorEventListener listener) {
        this.mOnLightSensorEventListener = listener;
    }

    public static interface OnLightSensorEventListener {
        default public void onSensorChanged(float lightLux) {
        }

        public void onSensorChanged(boolean var1, float var2);
    }
}

