/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import java.nio.ByteBuffer;

public abstract class CharsetProber {
    public static final float SHORTCUT_THRESHOLD = 0.95f;
    public static final int ASCII_A = 97;
    public static final int ASCII_Z = 122;
    public static final int ASCII_A_CAPITAL = 65;
    public static final int ASCII_Z_CAPITAL = 90;
    public static final int ASCII_LT = 60;
    public static final int ASCII_GT = 62;
    public static final int ASCII_SP = 32;
    private boolean active = true;

    private boolean isAscii(byte by) {
        return (by & 0x80) == 0;
    }

    private boolean isAsciiSymbol(byte by) {
        int n2 = by & 0xFF;
        return n2 < 65 || n2 > 90 && n2 < 97 || n2 > 122;
    }

    public abstract String getCharSetName();

    public abstract ProbingState handleData(byte[] var1, int var2, int var3);

    public abstract ProbingState getState();

    public abstract void reset();

    public abstract float getConfidence();

    public abstract void setOption();

    public ByteBuffer filterWithoutEnglishLetters(byte[] byArray, int n2, int n3) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
        int n4 = 0;
        n3 = n2 + n3;
        int n5 = n4;
        n4 = n2;
        int n6 = n5;
        while (n2 < n3) {
            byte by = byArray[n2];
            if (!this.isAscii(by)) {
                n6 = 1;
            } else if (this.isAsciiSymbol(by)) {
                if (n6 != 0 && n2 > n4) {
                    ByteBuffer byteBuffer2 = byteBuffer;
                    n6 = n2 - n4;
                    byteBuffer2.put(byArray, n4, n6);
                    byteBuffer2.put((byte)32);
                    n4 = n2 + 1;
                    n6 = 0;
                } else {
                    n4 = n2 + 1;
                }
            }
            ++n2;
        }
        if (n6 != 0 && n2 > n4) {
            int n7 = n2 - n4;
            byteBuffer.put(byArray, n4, n7);
        }
        return byteBuffer;
    }

    public ByteBuffer filterWithEnglishLetters(byte[] byArray, int n2, int n3) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
        int n4 = 0;
        n3 = n2 + n3;
        int n5 = n4;
        n4 = n2;
        int n6 = n5;
        while (n2 < n3) {
            int n7 = byArray[n2];
            if (n7 == 62) {
                n6 = 0;
            } else if (n7 == 60) {
                n6 = 1;
            }
            if (this.isAscii((byte)n7) && this.isAsciiSymbol((byte)n7)) {
                if (n2 > n4 && n6 == 0) {
                    ByteBuffer byteBuffer2 = byteBuffer;
                    n7 = n2 - n4;
                    byteBuffer2.put(byArray, n4, n7);
                    byteBuffer2.put((byte)32);
                    n4 = n2 + 1;
                } else {
                    n4 = n2 + 1;
                }
            }
            ++n2;
        }
        if (n6 == 0 && n2 > n4) {
            int n8 = n2 - n4;
            byteBuffer.put(byArray, n4, n8);
        }
        return byteBuffer;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public static final class ProbingState
    extends Enum<ProbingState> {
        public static final /* enum */ ProbingState DETECTING;
        public static final /* enum */ ProbingState FOUND_IT;
        public static final /* enum */ ProbingState NOT_ME;
        private static final /* synthetic */ ProbingState[] $VALUES;

        public static ProbingState[] values() {
            return (ProbingState[])$VALUES.clone();
        }

        public static ProbingState valueOf(String string2) {
            return Enum.valueOf(ProbingState.class, string2);
        }

        static {
            ProbingState probingState;
            ProbingState probingState2;
            ProbingState probingState3;
            ProbingState probingState4 = probingState3;
            DETECTING = new ProbingState();
            ProbingState probingState5 = probingState2;
            FOUND_IT = new ProbingState();
            ProbingState probingState6 = probingState;
            NOT_ME = new ProbingState();
            $VALUES = new ProbingState[]{probingState4, probingState5, probingState6};
        }
    }
}

