/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io.outputstream;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.CRC32;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.headers.FileHeaderFactory;
import net.lingala.zip4j.headers.HeaderSignature;
import net.lingala.zip4j.headers.HeaderWriter;
import net.lingala.zip4j.io.outputstream.AesCipherOutputStream;
import net.lingala.zip4j.io.outputstream.CipherOutputStream;
import net.lingala.zip4j.io.outputstream.CompressedOutputStream;
import net.lingala.zip4j.io.outputstream.CountingOutputStream;
import net.lingala.zip4j.io.outputstream.DeflaterOutputStream;
import net.lingala.zip4j.io.outputstream.NoCipherOutputStream;
import net.lingala.zip4j.io.outputstream.StoreOutputStream;
import net.lingala.zip4j.io.outputstream.ZipEntryOutputStream;
import net.lingala.zip4j.io.outputstream.ZipStandardCipherOutputStream;
import net.lingala.zip4j.model.AbstractFileHeader;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.model.Zip4jConfig;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.AesVersion;
import net.lingala.zip4j.model.enums.CompressionLevel;
import net.lingala.zip4j.model.enums.CompressionMethod;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import net.lingala.zip4j.util.FileUtils;
import net.lingala.zip4j.util.RawIO;
import net.lingala.zip4j.util.Zip4jUtil;

public class ZipOutputStream
extends OutputStream {
    private CountingOutputStream countingOutputStream;
    private char[] password;
    private ZipModel zipModel;
    private CompressedOutputStream compressedOutputStream;
    private FileHeader fileHeader;
    private LocalFileHeader localFileHeader;
    private FileHeaderFactory fileHeaderFactory;
    private HeaderWriter headerWriter;
    private CRC32 crc32;
    private RawIO rawIO;
    private long uncompressedSizeForThisEntry;
    private Zip4jConfig zip4jConfig;
    private boolean streamClosed;
    private boolean entryClosed;

    public ZipOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, null, null);
    }

    public ZipOutputStream(OutputStream outputStream, Charset charset) throws IOException {
        this(outputStream, null, charset);
    }

    public ZipOutputStream(OutputStream outputStream, char[] cArray) throws IOException {
        this(outputStream, cArray, null);
    }

    public ZipOutputStream(OutputStream outputStream, char[] cArray, Charset object) throws IOException {
        ZipModel zipModel;
        Zip4jConfig zip4jConfig;
        ZipOutputStream zipOutputStream = zip4jConfig2;
        Zip4jConfig zip4jConfig2 = zip4jConfig;
        zip4jConfig = new Zip4jConfig((Charset)object, 4096, true);
        object = zipModel;
        zipModel = new ZipModel();
        zipOutputStream(outputStream, cArray, zip4jConfig2, (ZipModel)object);
    }

    public ZipOutputStream(OutputStream outputStream, char[] cArray, Zip4jConfig zip4jConfig, ZipModel zipModel) throws IOException {
        outputStream2.fileHeaderFactory = new FileHeaderFactory();
        outputStream2.headerWriter = new HeaderWriter();
        outputStream2.crc32 = new CRC32();
        outputStream2.rawIO = new RawIO();
        outputStream2.uncompressedSizeForThisEntry = 0L;
        outputStream2.entryClosed = true;
        if (zip4jConfig.getBufferSize() >= 512) {
            CountingOutputStream countingOutputStream;
            ZipOutputStream zipOutputStream = outputStream2;
            ZipOutputStream zipOutputStream2 = outputStream2;
            ZipOutputStream zipOutputStream3 = outputStream2;
            ZipOutputStream zipOutputStream4 = outputStream2;
            OutputStream outputStream2 = countingOutputStream;
            zipOutputStream4.countingOutputStream = new CountingOutputStream(outputStream);
            zipOutputStream3.password = cArray;
            zipOutputStream2.zip4jConfig = zip4jConfig;
            zipOutputStream.zipModel = zipOutputStream.initializeZipModel(zipModel, (CountingOutputStream)outputStream2);
            zipOutputStream.streamClosed = false;
            zipOutputStream.writeSplitZipHeaderIfApplicable();
            return;
        }
        throw new IllegalArgumentException("Buffer size cannot be less than 512 bytes");
    }

    private void ensureStreamOpen() throws IOException {
        if (!this.streamClosed) {
            return;
        }
        throw new IOException("Stream is closed");
    }

    private ZipModel initializeZipModel(ZipModel zipModel, CountingOutputStream countingOutputStream) {
        if (zipModel == null) {
            ZipModel zipModel2;
            zipModel = zipModel2;
            zipModel2 = new ZipModel();
        }
        if (countingOutputStream.isSplitZipFile()) {
            zipModel.setSplitArchive(true);
            zipModel.setSplitLength(countingOutputStream.getSplitLength());
        }
        return zipModel;
    }

    private void initializeAndWriteFileHeader(ZipParameters zipParameters) throws IOException {
        AbstractFileHeader abstractFileHeader;
        ZipOutputStream zipOutputStream = charset;
        ZipOutputStream zipOutputStream2 = charset;
        boolean bl = zipOutputStream2.countingOutputStream.isSplitZipFile();
        int n2 = zipOutputStream2.countingOutputStream.getCurrentSplitFileCounter();
        Object object = zipOutputStream2.zip4jConfig.getCharset();
        RawIO rawIO = zipOutputStream2.rawIO;
        ((ZipOutputStream)((Object)charset)).fileHeader = abstractFileHeader = zipOutputStream.fileHeaderFactory.generateFileHeader(zipParameters, bl, n2, (Charset)object, rawIO);
        abstractFileHeader.setOffsetLocalHeader(((ZipOutputStream)((Object)charset)).countingOutputStream.getOffsetForNextEntry());
        abstractFileHeader = zipOutputStream.fileHeaderFactory.generateLocalFileHeader(((ZipOutputStream)((Object)charset)).fileHeader);
        zipOutputStream.localFileHeader = abstractFileHeader;
        ZipOutputStream zipOutputStream3 = charset;
        ZipModel zipModel = zipOutputStream3.zipModel;
        object = zipOutputStream3.countingOutputStream;
        Charset charset = ((ZipOutputStream)((Object)charset)).zip4jConfig.getCharset();
        zipOutputStream.headerWriter.writeLocalFileHeader(zipModel, (LocalFileHeader)abstractFileHeader, (OutputStream)object, charset);
    }

    private void reset() throws IOException {
        ZipOutputStream zipOutputStream = this;
        zipOutputStream.uncompressedSizeForThisEntry = 0L;
        zipOutputStream.crc32.reset();
        zipOutputStream.compressedOutputStream.close();
    }

    private void writeSplitZipHeaderIfApplicable() throws IOException {
        if (!this.countingOutputStream.isSplitZipFile()) {
            return;
        }
        this.rawIO.writeIntLittleEndian(this.countingOutputStream, (int)HeaderSignature.SPLIT_ZIP.getValue());
    }

    private CompressedOutputStream initializeCompressedOutputStream(ZipParameters zipParameters) throws IOException {
        ZipOutputStream zipOutputStream = this;
        return zipOutputStream.initializeCompressedOutputStream(zipOutputStream.initializeCipherOutputStream(new ZipEntryOutputStream(this.countingOutputStream), zipParameters), zipParameters);
    }

    private CipherOutputStream<?> initializeCipherOutputStream(ZipEntryOutputStream zipEntryOutputStream, ZipParameters zipParameters) throws IOException {
        if (!zipParameters.isEncryptFiles()) {
            return new NoCipherOutputStream(zipEntryOutputStream, zipParameters, null);
        }
        char[] cArray = ((ZipOutputStream)object).password;
        if (((ZipOutputStream)object).password != null && cArray.length != 0) {
            Object object;
            if (zipParameters.getEncryptionMethod() == EncryptionMethod.AES) {
                ZipOutputStream zipOutputStream = object;
                object = zipOutputStream.password;
                boolean bl = zipOutputStream.zip4jConfig.isUseUtf8CharsetForPasswords();
                return new AesCipherOutputStream(zipEntryOutputStream, zipParameters, (char[])object, bl);
            }
            if (zipParameters.getEncryptionMethod() == EncryptionMethod.ZIP_STANDARD) {
                Object object2 = object;
                object = ((ZipOutputStream)object2).password;
                boolean bl = ((ZipOutputStream)object2).zip4jConfig.isUseUtf8CharsetForPasswords();
                return new ZipStandardCipherOutputStream(zipEntryOutputStream, zipParameters, (char[])object, bl);
            }
            object = EncryptionMethod.ZIP_STANDARD_VARIANT_STRONG;
            if (zipParameters.getEncryptionMethod() == object) {
                throw new ZipException(object + " encryption method is not supported");
            }
            throw new ZipException("Invalid encryption method");
        }
        throw new ZipException("password not set");
    }

    private CompressedOutputStream initializeCompressedOutputStream(CipherOutputStream<?> cipherOutputStream, ZipParameters zipParameters) {
        if (zipParameters.getCompressionMethod() == CompressionMethod.DEFLATE) {
            ZipOutputStream zipOutputStream = object;
            Object object = zipParameters.getCompressionLevel();
            return new DeflaterOutputStream(cipherOutputStream, (CompressionLevel)((Object)object), zipOutputStream.zip4jConfig.getBufferSize());
        }
        return new StoreOutputStream(cipherOutputStream);
    }

    private void verifyZipParameters(ZipParameters zipParameters) {
        if (!Zip4jUtil.isStringNullOrEmpty(zipParameters.getFileNameInZip())) {
            if (zipParameters.getCompressionMethod() == CompressionMethod.STORE && zipParameters.getEntrySize() < 0L && !FileUtils.isZipEntryDirectory(zipParameters.getFileNameInZip()) && zipParameters.isWriteExtendedLocalFileHeader()) {
                throw new IllegalArgumentException("uncompressed size should be set for zip entries of compression type store");
            }
            return;
        }
        throw new IllegalArgumentException("fileNameInZip is null or empty");
    }

    private boolean writeCrc(FileHeader fileHeader) {
        if (!(fileHeader.isEncrypted() && fileHeader.getEncryptionMethod().equals((Object)EncryptionMethod.AES))) {
            return true;
        }
        return fileHeader.getAesExtraDataRecord().getAesVersion().equals((Object)AesVersion.ONE);
    }

    private ZipParameters cloneAndPrepareZipParameters(ZipParameters zipParameters) {
        ZipParameters zipParameters2;
        ZipParameters zipParameters3 = zipParameters2;
        zipParameters2 = new ZipParameters(zipParameters);
        if (FileUtils.isZipEntryDirectory(zipParameters.getFileNameInZip())) {
            ZipParameters zipParameters4 = zipParameters3;
            zipParameters4.setWriteExtendedLocalFileHeader(false);
            zipParameters4.setCompressionMethod(CompressionMethod.STORE);
            zipParameters4.setEncryptFiles(false);
            zipParameters4.setEntrySize(0L);
        }
        if (zipParameters.getLastModifiedFileTime() <= 0L) {
            zipParameters3.setLastModifiedFileTime(System.currentTimeMillis());
        }
        return zipParameters3;
    }

    public void putNextEntry(ZipParameters zipParameters) throws IOException {
        ZipOutputStream zipOutputStream = zipParameters2;
        ((ZipOutputStream)((Object)zipParameters2)).verifyZipParameters(zipParameters);
        ZipParameters zipParameters2 = zipOutputStream.cloneAndPrepareZipParameters(zipParameters);
        zipOutputStream.initializeAndWriteFileHeader(zipParameters2);
        zipOutputStream.compressedOutputStream = zipOutputStream.initializeCompressedOutputStream(zipParameters2);
        zipOutputStream.entryClosed = false;
    }

    @Override
    public void write(int n2) throws IOException {
        ZipOutputStream zipOutputStream = object;
        byte[] byArray = new byte[1];
        Object object = byArray;
        byArray[0] = (byte)n2;
        zipOutputStream.write((byte[])object);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        int n2 = byArray.length;
        this.write(byArray, 0, n2);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        ZipOutputStream zipOutputStream = this;
        zipOutputStream.ensureStreamOpen();
        zipOutputStream.crc32.update(byArray, n2, n3);
        zipOutputStream.compressedOutputStream.write(byArray, n2, n3);
        zipOutputStream.uncompressedSizeForThisEntry += (long)n3;
    }

    public FileHeader closeEntry() throws IOException {
        ZipOutputStream zipOutputStream = this;
        zipOutputStream.compressedOutputStream.closeEntry();
        long l2 = zipOutputStream.compressedOutputStream.getCompressedSize();
        zipOutputStream.fileHeader.setCompressedSize(l2);
        zipOutputStream.localFileHeader.setCompressedSize(l2);
        zipOutputStream.fileHeader.setUncompressedSize(this.uncompressedSizeForThisEntry);
        zipOutputStream.localFileHeader.setUncompressedSize(this.uncompressedSizeForThisEntry);
        if (zipOutputStream.writeCrc(zipOutputStream.fileHeader)) {
            ZipOutputStream zipOutputStream2 = this;
            zipOutputStream2.fileHeader.setCrc(this.crc32.getValue());
            zipOutputStream2.localFileHeader.setCrc(this.crc32.getValue());
        }
        ZipOutputStream zipOutputStream3 = this;
        zipOutputStream3.zipModel.getLocalFileHeaders().add(this.localFileHeader);
        zipOutputStream3.zipModel.getCentralDirectory().getFileHeaders().add(this.fileHeader);
        if (zipOutputStream3.localFileHeader.isDataDescriptorExists()) {
            ZipOutputStream zipOutputStream4 = this;
            LocalFileHeader localFileHeader = zipOutputStream4.localFileHeader;
            this.headerWriter.writeExtendedLocalHeader(localFileHeader, zipOutputStream4.countingOutputStream);
        }
        ZipOutputStream zipOutputStream5 = this;
        zipOutputStream5.reset();
        zipOutputStream5.entryClosed = true;
        return zipOutputStream5.fileHeader;
    }

    @Override
    public void close() throws IOException {
        if (!this.entryClosed) {
            this.closeEntry();
        }
        ZipOutputStream zipOutputStream = this;
        zipOutputStream.zipModel.getEndOfCentralDirectoryRecord().setOffsetOfStartOfCentralDirectory(this.countingOutputStream.getNumberOfBytesWritten());
        ZipOutputStream zipOutputStream2 = this;
        ZipModel zipModel = zipOutputStream2.zipModel;
        CountingOutputStream countingOutputStream = zipOutputStream2.countingOutputStream;
        zipOutputStream.headerWriter.finalizeZipFile(zipModel, countingOutputStream, this.zip4jConfig.getCharset());
        zipOutputStream.countingOutputStream.close();
        zipOutputStream.streamClosed = true;
    }

    public void setComment(String string2) throws IOException {
        ZipOutputStream zipOutputStream = this;
        zipOutputStream.ensureStreamOpen();
        zipOutputStream.zipModel.getEndOfCentralDirectoryRecord().setComment(string2);
    }
}

