/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.crypto;

import java.security.SecureRandom;
import net.lingala.zip4j.crypto.AesCipherUtil;
import net.lingala.zip4j.crypto.Encrypter;
import net.lingala.zip4j.crypto.PBKDF2.MacBasedPRF;
import net.lingala.zip4j.crypto.engine.AESEngine;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.enums.AesKeyStrength;

public class AESEncrypter
implements Encrypter {
    private AESEngine aesEngine;
    private MacBasedPRF mac;
    private final SecureRandom random;
    private boolean finished;
    private int nonce;
    private int loopCount;
    private final byte[] iv;
    private final byte[] counterBlock;
    private byte[] derivedPasswordVerifier;
    private byte[] saltBytes;

    public AESEncrypter(char[] cArray, AesKeyStrength aesKeyStrength, boolean bl) throws ZipException {
        SecureRandom secureRandom;
        SecureRandom secureRandom2 = secureRandom;
        secureRandom = new SecureRandom();
        this.random = secureRandom2;
        this.nonce = 1;
        this.loopCount = 0;
        if (cArray != null && cArray.length != 0) {
            if (aesKeyStrength != AesKeyStrength.KEY_STRENGTH_128 && aesKeyStrength != AesKeyStrength.KEY_STRENGTH_256) {
                throw new ZipException("Invalid AES key strength");
            }
            AESEncrypter aESEncrypter = this;
            aESEncrypter.finished = false;
            aESEncrypter.counterBlock = new byte[16];
            aESEncrypter.iv = new byte[16];
            this.init(cArray, aesKeyStrength, bl);
            return;
        }
        throw new ZipException("input password is empty or null");
    }

    private void init(char[] objectArray, AesKeyStrength aesKeyStrength, boolean bl) throws ZipException {
        byte[] byArray = this.generateSalt(aesKeyStrength.getSaltLength());
        this.saltBytes = byArray;
        byte[] byArray2 = AesCipherUtil.derivePasswordBasedKey(byArray, objectArray, aesKeyStrength, bl);
        objectArray = byArray2;
        this.derivedPasswordVerifier = AesCipherUtil.derivePasswordVerifier((byte[])objectArray, aesKeyStrength);
        this.aesEngine = AesCipherUtil.getAESEngine((byte[])objectArray, aesKeyStrength);
        this.mac = AesCipherUtil.getMacBasedPRF(byArray2, aesKeyStrength);
    }

    private byte[] generateSalt(int n2) throws ZipException {
        if (n2 != 8 && n2 != 16) {
            throw new ZipException("invalid salt size, cannot generate salt");
        }
        int n3 = n2 == 8 ? 2 : 4;
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4;
            int n5 = this.random.nextInt();
            int n6 = n4 = n5;
            int n7 = n4;
            int n8 = n4;
            n4 = i2 * 4;
            byArray[n4] = (byte)(n8 >> 24);
            int n9 = n4 + 1;
            byArray[n9] = (byte)(n7 >> 16);
            n9 = n4 + 2;
            byArray[n9] = (byte)(n6 >> 8);
            byArray[n4 += 3] = (byte)n5;
        }
        return byArray;
    }

    @Override
    public int encryptData(byte[] byArray) throws ZipException {
        if (byArray != null) {
            return this.encryptData(byArray, 0, byArray.length);
        }
        throw new ZipException("input bytes are null, cannot perform AES encryption");
    }

    @Override
    public int encryptData(byte[] byArray, int n2, int n3) throws ZipException {
        if (!this.finished) {
            int n4;
            if (n3 % 16 != 0) {
                this.finished = true;
            }
            int n5 = n2;
            while (n5 < (n4 = n2 + n3)) {
                int n6;
                int n7 = n5 + 16;
                n4 = n7 <= n4 ? 16 : (n4 -= n5);
                AESEncrypter aESEncrypter = this;
                aESEncrypter.loopCount = n4;
                AesCipherUtil.prepareBuffAESIVBytes(aESEncrypter.iv, this.nonce);
                AESEncrypter aESEncrypter2 = this;
                byte[] byArray2 = aESEncrypter2.iv;
                aESEncrypter.aesEngine.processBlock(byArray2, aESEncrypter2.counterBlock);
                for (n4 = 0; n4 < (n6 = this.loopCount); ++n4) {
                    n6 = n5 + n4;
                    byArray[n6] = (byte)(byArray[n6] ^ this.counterBlock[n4]);
                }
                AESEncrypter aESEncrypter3 = this;
                aESEncrypter3.mac.update(byArray, n5, n6);
                ++aESEncrypter3.nonce;
                n5 = n7;
            }
            return n3;
        }
        throw new ZipException("AES Encrypter is in finished state (A non 16 byte block has already been passed to encrypter)");
    }

    public byte[] getFinalMac() {
        Object object = ((AESEncrypter)object).mac.doFinal();
        byte[] byArray = new byte[10];
        System.arraycopy(object, 0, byArray, 0, 10);
        return byArray;
    }

    public byte[] getDerivedPasswordVerifier() {
        return this.derivedPasswordVerifier;
    }

    public byte[] getSaltBytes() {
        return this.saltBytes;
    }
}

