/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.adapter.util;

import android.graphics.Rect;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class NinePatchChunk {
    public static final int NO_COLOR = 1;
    public static final int TRANSPARENT_COLOR = 0;
    public Rect mPaddings;
    public int[] mDivX;
    public int[] mDivY;
    public int[] mColor;

    public NinePatchChunk() {
        Rect rect;
        NinePatchChunk ninePatchChunk = rect;
        rect = new Rect();
        v1.mPaddings = ninePatchChunk;
    }

    private static void readIntArray(int[] nArray, ByteBuffer byteBuffer) {
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = byteBuffer.getInt();
        }
    }

    private static void checkDivCount(int n2) {
        if (n2 != 0 && (n2 & 1) == 0) {
            return;
        }
        throw new RuntimeException("invalid nine-patch: " + n2);
    }

    public static NinePatchChunk deserialize(byte[] object) {
        NinePatchChunk ninePatchChunk;
        NinePatchChunk ninePatchChunk2;
        ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])object).order(ByteOrder.nativeOrder());
        object = byteBuffer;
        if (byteBuffer.get() == 0) {
            return null;
        }
        NinePatchChunk ninePatchChunk3 = ninePatchChunk2 = ninePatchChunk;
        Object object2 = object;
        NinePatchChunk ninePatchChunk4 = ninePatchChunk2;
        ninePatchChunk2();
        ninePatchChunk2.mDivX = new int[((ByteBuffer)object).get()];
        ninePatchChunk2.mDivY = new int[((ByteBuffer)object).get()];
        ninePatchChunk4.mColor = new int[((ByteBuffer)object).get()];
        NinePatchChunk.checkDivCount(ninePatchChunk4.mDivX.length);
        NinePatchChunk.checkDivCount(ninePatchChunk4.mDivY.length);
        ((ByteBuffer)object2).getInt();
        ((ByteBuffer)object2).getInt();
        ninePatchChunk3.mPaddings.left = ((ByteBuffer)object).getInt();
        ninePatchChunk3.mPaddings.right = ((ByteBuffer)object).getInt();
        ninePatchChunk3.mPaddings.top = ((ByteBuffer)object).getInt();
        ninePatchChunk3.mPaddings.bottom = ((ByteBuffer)object).getInt();
        ((ByteBuffer)object).getInt();
        NinePatchChunk.readIntArray(ninePatchChunk.mDivX, (ByteBuffer)object);
        NinePatchChunk.readIntArray(ninePatchChunk.mDivY, (ByteBuffer)object);
        NinePatchChunk.readIntArray(ninePatchChunk.mColor, (ByteBuffer)object);
        return ninePatchChunk;
    }
}

