/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.dcloudimageloader.core;

import android.graphics.Bitmap;
import android.os.Handler;
import android.text.TextUtils;
import android.widget.ImageView;
import com.nostra13.dcloudimageloader.cache.disc.DiscCacheAware;
import com.nostra13.dcloudimageloader.cache.memory.MemoryCacheAware;
import com.nostra13.dcloudimageloader.core.DisplayImageOptions;
import com.nostra13.dcloudimageloader.core.ImageLoaderConfiguration;
import com.nostra13.dcloudimageloader.core.ImageLoaderEngine;
import com.nostra13.dcloudimageloader.core.ImageLoadingInfo;
import com.nostra13.dcloudimageloader.core.LoadAndDisplayImageTask;
import com.nostra13.dcloudimageloader.core.ProcessAndDisplayImageTask;
import com.nostra13.dcloudimageloader.core.assist.ImageLoadingListener;
import com.nostra13.dcloudimageloader.core.assist.ImageSize;
import com.nostra13.dcloudimageloader.core.assist.LoadedFrom;
import com.nostra13.dcloudimageloader.core.assist.MemoryCacheUtil;
import com.nostra13.dcloudimageloader.core.assist.SimpleImageLoadingListener;
import com.nostra13.dcloudimageloader.core.assist.SyncImageLoadingListener;
import com.nostra13.dcloudimageloader.core.assist.ViewScaleType;
import com.nostra13.dcloudimageloader.core.imageaware.ImageAware;
import com.nostra13.dcloudimageloader.core.imageaware.ImageNonViewAware;
import com.nostra13.dcloudimageloader.core.imageaware.ImageViewAware;
import com.nostra13.dcloudimageloader.utils.ImageSizeUtils;
import com.nostra13.dcloudimageloader.utils.L;
import java.util.concurrent.locks.ReentrantLock;

public class ImageLoader {
    public static final String TAG = "ImageLoader";
    static final String LOG_INIT_CONFIG = "Initialize ImageLoader with configuration";
    static final String LOG_DESTROY = "Destroy ImageLoader";
    static final String LOG_LOAD_IMAGE_FROM_MEMORY_CACHE = "Load image from memory cache [%s]";
    private static final String WARNING_RE_INIT_CONFIG = "Try to initialize ImageLoader which had already been initialized before. To re-init ImageLoader with new configuration call ImageLoader.destroy() at first.";
    private static final String ERROR_WRONG_ARGUMENTS = "Wrong arguments were passed to displayImage() method (ImageView reference must not be null)";
    private static final String ERROR_NOT_INIT = "ImageLoader must be init with configuration before using";
    private static final String ERROR_INIT_CONFIG_WITH_NULL = "ImageLoader configuration can not be initialized with null";
    private static volatile ImageLoader instance;
    private ImageLoaderConfiguration configuration;
    private ImageLoaderEngine engine;
    private final ImageLoadingListener emptyListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageLoader getInstance() {
        if (instance != null) return instance;
        Class<ImageLoader> clazz = ImageLoader.class;
        synchronized (ImageLoader.class) {
            if (instance != null) return instance;
            instance = new ImageLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected ImageLoader() {
        SimpleImageLoadingListener simpleImageLoadingListener;
        SimpleImageLoadingListener simpleImageLoadingListener2 = simpleImageLoadingListener;
        simpleImageLoadingListener = new SimpleImageLoadingListener();
        v1.emptyListener = simpleImageLoadingListener2;
    }

    private void checkConfiguration() {
        if (this.configuration != null) {
            return;
        }
        throw new IllegalStateException(ERROR_NOT_INIT);
    }

    public synchronized void init(ImageLoaderConfiguration imageLoaderConfiguration) {
        if (imageLoaderConfiguration != null) {
            if (((ImageLoader)((Object)imageLoaderEngine2)).configuration == null) {
                ImageLoaderEngine imageLoaderEngine;
                if (imageLoaderConfiguration.writeLogs) {
                    L.d(LOG_INIT_CONFIG, new Object[0]);
                }
                ImageLoader imageLoader = imageLoaderEngine2;
                ImageLoaderEngine imageLoaderEngine2 = imageLoaderEngine;
                imageLoaderEngine = new ImageLoaderEngine(imageLoaderConfiguration);
                imageLoader.engine = imageLoaderEngine2;
                imageLoader.configuration = imageLoaderConfiguration;
            } else {
                L.w(WARNING_RE_INIT_CONFIG, new Object[0]);
            }
            return;
        }
        throw new IllegalArgumentException(ERROR_INIT_CONFIG_WITH_NULL);
    }

    public boolean isInited() {
        return this.configuration != null;
    }

    public void displayImage(String string2, ImageAware imageAware) {
        this.displayImage(string2, imageAware, null, null);
    }

    public void displayImage(String string2, ImageAware imageAware, ImageLoadingListener imageLoadingListener) {
        this.displayImage(string2, imageAware, null, imageLoadingListener);
    }

    public void displayImage(String string2, ImageAware imageAware, DisplayImageOptions displayImageOptions) {
        this.displayImage(string2, imageAware, displayImageOptions, null);
    }

    public void displayImage(String object, ImageAware object2, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener) {
        imageLoader.checkConfiguration();
        if (object2 != null) {
            if (imageLoadingListener == null) {
                imageLoadingListener = imageLoader.emptyListener;
            }
            if (displayImageOptions == null) {
                displayImageOptions = imageLoader.configuration.defaultDisplayImageOptions;
            }
            if (TextUtils.isEmpty((CharSequence)object)) {
                imageLoader.engine.cancelDisplayTaskFor((ImageAware)object2);
                imageLoadingListener.onLoadingStarted((String)object, object2.getWrappedView());
                if (displayImageOptions.shouldShowImageForEmptyUri()) {
                    object2.setImageDrawable(displayImageOptions.getImageForEmptyUri(imageLoader.configuration.resources));
                } else {
                    object2.setImageDrawable(null);
                }
                imageLoadingListener.onLoadingComplete((String)object, object2.getWrappedView(), null);
            } else {
                ImageSize imageSize = ImageSizeUtils.defineTargetSizeForView((ImageAware)object2, imageLoader.configuration.getMaxImageSize());
                String string2 = MemoryCacheUtil.generateKey((String)object, imageSize);
                imageLoader.engine.prepareDisplayTaskFor((ImageAware)object2, string2);
                imageLoadingListener.onLoadingStarted((String)object, object2.getWrappedView());
                Object object3 = imageLoader.configuration.memoryCache.get(string2);
                if (object3 != null && !object3.isRecycled()) {
                    Object[] objectArray;
                    if (imageLoader.configuration.writeLogs) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = string2;
                        L.d(LOG_LOAD_IMAGE_FROM_MEMORY_CACHE, objectArray);
                    }
                    if (displayImageOptions.shouldPostProcess()) {
                        ProcessAndDisplayImageTask processAndDisplayImageTask;
                        ImageLoadingInfo imageLoadingInfo;
                        DisplayImageOptions displayImageOptions2 = displayImageOptions;
                        objectArray = imageLoadingInfo;
                        String string3 = object;
                        object = imageLoader.engine.getLockForUri((String)object);
                        imageLoadingInfo = new ImageLoadingInfo(string3, (ImageAware)object2, imageSize, string2, displayImageOptions, imageLoadingListener, (ReentrantLock)object);
                        object = processAndDisplayImageTask;
                        object2 = imageLoader.engine;
                        displayImageOptions = displayImageOptions.getHandler();
                        processAndDisplayImageTask = new ProcessAndDisplayImageTask((ImageLoaderEngine)object2, (Bitmap)object3, (ImageLoadingInfo)objectArray, (Handler)displayImageOptions);
                        if (displayImageOptions2.isSyncLoading()) {
                            ((ProcessAndDisplayImageTask)object).run();
                        } else {
                            imageLoader.engine.submit((ProcessAndDisplayImageTask)object);
                        }
                    } else {
                        ImageLoader imageLoader = displayImageOptions.getDisplayer().display((Bitmap)object3, (ImageAware)object2, LoadedFrom.MEMORY_CACHE);
                        imageLoadingListener.onLoadingComplete((String)object, object2.getWrappedView(), (Bitmap)imageLoader);
                    }
                } else {
                    LoadAndDisplayImageTask loadAndDisplayImageTask;
                    ImageLoadingInfo imageLoadingInfo;
                    if (displayImageOptions.shouldShowImageOnLoading()) {
                        object2.setImageDrawable(displayImageOptions.getImageOnLoading(imageLoader.configuration.resources));
                    } else if (displayImageOptions.isResetViewBeforeLoading()) {
                        object2.setImageDrawable(null);
                    }
                    DisplayImageOptions displayImageOptions3 = displayImageOptions;
                    object3 = imageLoadingInfo;
                    String string4 = object;
                    object = imageLoader.engine.getLockForUri((String)object);
                    imageLoadingInfo = new ImageLoadingInfo(string4, (ImageAware)object2, imageSize, string2, displayImageOptions, imageLoadingListener, (ReentrantLock)object);
                    object = loadAndDisplayImageTask;
                    object2 = imageLoader.engine;
                    displayImageOptions = displayImageOptions.getHandler();
                    loadAndDisplayImageTask = new LoadAndDisplayImageTask((ImageLoaderEngine)object2, (ImageLoadingInfo)object3, (Handler)displayImageOptions);
                    if (displayImageOptions3.isSyncLoading()) {
                        ((LoadAndDisplayImageTask)object).run();
                    } else {
                        imageLoader.engine.submit((LoadAndDisplayImageTask)object);
                    }
                }
            }
            return;
        }
        throw new IllegalArgumentException(ERROR_WRONG_ARGUMENTS);
    }

    public void displayImage(String string2, ImageView imageView) {
        ImageViewAware imageViewAware;
        ImageLoader imageLoader = imageViewAware2;
        ImageViewAware imageViewAware2 = imageViewAware;
        imageViewAware = new ImageViewAware(imageView);
        imageLoader.displayImage(string2, imageViewAware2, null, null);
    }

    public void displayImage(String string2, ImageView imageView, DisplayImageOptions displayImageOptions) {
        ImageViewAware imageViewAware;
        ImageLoader imageLoader = imageViewAware2;
        ImageViewAware imageViewAware2 = imageViewAware;
        imageViewAware = new ImageViewAware(imageView);
        imageLoader.displayImage(string2, imageViewAware2, displayImageOptions, null);
    }

    public void displayImage(String string2, ImageView imageView, ImageLoadingListener imageLoadingListener) {
        ImageViewAware imageViewAware;
        ImageLoader imageLoader = imageViewAware2;
        ImageViewAware imageViewAware2 = imageViewAware;
        imageViewAware = new ImageViewAware(imageView);
        imageLoader.displayImage(string2, imageViewAware2, null, imageLoadingListener);
    }

    public void displayImage(String string2, ImageView imageView, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener) {
        ImageViewAware imageViewAware;
        ImageLoader imageLoader = imageViewAware2;
        ImageViewAware imageViewAware2 = imageViewAware;
        imageViewAware = new ImageViewAware(imageView);
        imageLoader.displayImage(string2, imageViewAware2, displayImageOptions, imageLoadingListener);
    }

    public void loadImage(String string2, ImageLoadingListener imageLoadingListener) {
        this.loadImage(string2, null, null, imageLoadingListener);
    }

    public void loadImage(String string2, ImageSize imageSize, ImageLoadingListener imageLoadingListener) {
        this.loadImage(string2, imageSize, null, imageLoadingListener);
    }

    public void loadImage(String string2, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener) {
        this.loadImage(string2, null, displayImageOptions, imageLoadingListener);
    }

    public void loadImage(String string2, ImageSize imageSize, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener) {
        ImageNonViewAware imageNonViewAware;
        ((ImageLoader)((Object)imageNonViewAware2)).checkConfiguration();
        if (imageSize == null) {
            imageSize = ((ImageLoader)((Object)imageNonViewAware2)).configuration.getMaxImageSize();
        }
        if (displayImageOptions == null) {
            displayImageOptions = ((ImageLoader)((Object)imageNonViewAware2)).configuration.defaultDisplayImageOptions;
        }
        ImageLoader imageLoader = imageNonViewAware2;
        ImageNonViewAware imageNonViewAware2 = imageNonViewAware;
        imageNonViewAware = new ImageNonViewAware(imageSize, ViewScaleType.CROP);
        imageLoader.displayImage(string2, imageNonViewAware2, displayImageOptions, imageLoadingListener);
    }

    public Bitmap loadImageSync(String string2) {
        return this.loadImageSync(string2, null, null);
    }

    public Bitmap loadImageSync(String string2, DisplayImageOptions displayImageOptions) {
        return this.loadImageSync(string2, null, displayImageOptions);
    }

    public Bitmap loadImageSync(String string2, ImageSize imageSize) {
        return this.loadImageSync(string2, imageSize, null);
    }

    public Bitmap loadImageSync(String string2, ImageSize imageSize, DisplayImageOptions displayImageOptions) {
        SyncImageLoadingListener syncImageLoadingListener;
        if (displayImageOptions == null) {
            displayImageOptions = ((ImageLoader)((Object)syncImageLoadingListener2)).configuration.defaultDisplayImageOptions;
        }
        ImageLoader imageLoader = syncImageLoadingListener2;
        SyncImageLoadingListener syncImageLoadingListener2 = syncImageLoadingListener;
        syncImageLoadingListener = new SyncImageLoadingListener();
        imageLoader.loadImage(string2, imageSize, new DisplayImageOptions.Builder().cloneFrom(displayImageOptions).syncLoading(true).build(), syncImageLoadingListener2);
        return syncImageLoadingListener2.getLoadedBitmap();
    }

    public MemoryCacheAware getMemoryCache() {
        ImageLoader imageLoader = this;
        imageLoader.checkConfiguration();
        return imageLoader.configuration.memoryCache;
    }

    public void clearMemoryCache() {
        ImageLoader imageLoader = this;
        imageLoader.checkConfiguration();
        imageLoader.configuration.memoryCache.clear();
    }

    public DiscCacheAware getDiscCache() {
        ImageLoader imageLoader = this;
        imageLoader.checkConfiguration();
        return imageLoader.configuration.discCache;
    }

    public void clearDiscCache() {
        ImageLoader imageLoader = this;
        imageLoader.checkConfiguration();
        imageLoader.configuration.discCache.clear();
    }

    public String getLoadingUriForView(ImageAware imageAware) {
        return this.engine.getLoadingUriForView(imageAware);
    }

    public String getLoadingUriForView(ImageView imageView) {
        return this.engine.getLoadingUriForView(new ImageViewAware(imageView));
    }

    public void cancelDisplayTask(ImageAware imageAware) {
        this.engine.cancelDisplayTaskFor(imageAware);
    }

    public void cancelDisplayTask(ImageView imageView) {
        this.engine.cancelDisplayTaskFor(new ImageViewAware(imageView));
    }

    public void denyNetworkDownloads(boolean bl) {
        this.engine.denyNetworkDownloads(bl);
    }

    public void handleSlowNetwork(boolean bl) {
        this.engine.handleSlowNetwork(bl);
    }

    public void pause() {
        this.engine.pause();
    }

    public void resume() {
        this.engine.resume();
    }

    public void stop() {
        this.engine.stop();
    }

    public void destroy() {
        ImageLoaderConfiguration imageLoaderConfiguration = this.configuration;
        if (imageLoaderConfiguration != null && imageLoaderConfiguration.writeLogs) {
            L.d(LOG_DESTROY, new Object[0]);
        }
        this.stop();
        this.engine = null;
        this.configuration = null;
    }
}

