/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.multi.qrcode.detector;

import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.ResultPointCallback;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.qrcode.detector.FinderPattern;
import com.dcloud.zxing2.qrcode.detector.FinderPatternFinder;
import com.dcloud.zxing2.qrcode.detector.FinderPatternInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

final class MultiFinderPatternFinder
extends FinderPatternFinder {
    private static final FinderPatternInfo[] EMPTY_RESULT_ARRAY = new FinderPatternInfo[0];
    private static final float MAX_MODULE_COUNT_PER_EDGE = 180.0f;
    private static final float MIN_MODULE_COUNT_PER_EDGE = 9.0f;
    private static final float DIFF_MODSIZE_CUTOFF_PERCENT = 0.05f;
    private static final float DIFF_MODSIZE_CUTOFF = 0.5f;

    MultiFinderPatternFinder(BitMatrix bitMatrix) {
        super(bitMatrix);
    }

    MultiFinderPatternFinder(BitMatrix bitMatrix, ResultPointCallback resultPointCallback) {
        super(bitMatrix, resultPointCallback);
    }

    private FinderPattern[][] selectMutipleBestPatterns() throws NotFoundException {
        int n2 = (this = ((FinderPatternFinder)this).getPossibleCenters()).size();
        if (n2 >= 3) {
            ArrayList arrayList;
            ModuleSizeComparator moduleSizeComparator;
            if (n2 == 3) {
                FinderPattern[][] finderPatternArray = new FinderPattern[1][];
                FinderPattern[] finderPatternArray2 = new FinderPattern[3];
                FinderPattern[] finderPatternArray3 = finderPatternArray2;
                finderPatternArray3[0] = (FinderPattern)this.get(0);
                finderPatternArray3[1] = (FinderPattern)this.get(1);
                finderPatternArray2[2] = (FinderPattern)this.get(2);
                finderPatternArray[0] = finderPatternArray3;
                return finderPatternArray;
            }
            Serializable serializable = moduleSizeComparator;
            moduleSizeComparator = new ModuleSizeComparator();
            Collections.sort(this, serializable);
            serializable = arrayList;
            arrayList = new ArrayList();
            block0: for (int i2 = 0; i2 < n2 - 2; ++i2) {
                FinderPattern finderPattern = (FinderPattern)this.get(i2);
                if (finderPattern == null) continue;
                block1: for (int i3 = i2 + 1; i3 < n2 - 1; ++i3) {
                    FinderPattern finderPattern2 = (FinderPattern)this.get(i3);
                    if (finderPattern2 == null) continue;
                    FinderPattern finderPattern3 = finderPattern;
                    float f2 = (finderPattern3.getEstimatedModuleSize() - finderPattern2.getEstimatedModuleSize()) / Math.min(finderPattern.getEstimatedModuleSize(), finderPattern2.getEstimatedModuleSize());
                    if (Math.abs(finderPattern3.getEstimatedModuleSize() - finderPattern2.getEstimatedModuleSize()) > 0.5f && f2 >= 0.05f) continue block0;
                    for (int i4 = i3 + 1; i4 < n2; ++i4) {
                        float f3;
                        FinderPatternInfo finderPatternInfo;
                        Object object = (FinderPattern)this.get(i4);
                        if (object == null) continue;
                        FinderPattern finderPattern4 = finderPattern2;
                        float f4 = (finderPattern4.getEstimatedModuleSize() - ((FinderPattern)object).getEstimatedModuleSize()) / Math.min(finderPattern2.getEstimatedModuleSize(), ((FinderPattern)object).getEstimatedModuleSize());
                        if (Math.abs(finderPattern4.getEstimatedModuleSize() - ((FinderPattern)object).getEstimatedModuleSize()) > 0.5f && f4 >= 0.05f) continue block1;
                        ResultPoint[] resultPointArray = new FinderPattern[3];
                        ResultPoint[] resultPointArray2 = resultPointArray;
                        resultPointArray[0] = finderPattern;
                        resultPointArray[1] = finderPattern2;
                        resultPointArray[2] = object;
                        ResultPoint.orderBestPatterns(resultPointArray);
                        object = finderPatternInfo;
                        float f5 = ResultPoint.distance(new FinderPatternInfo((FinderPattern[])resultPointArray2).getTopLeft(), ((FinderPatternInfo)object).getBottomLeft());
                        Object object2 = object;
                        float f6 = ResultPoint.distance(((FinderPatternInfo)object2).getTopRight(), ((FinderPatternInfo)object).getBottomLeft());
                        float f7 = ResultPoint.distance(((FinderPatternInfo)object2).getTopLeft(), ((FinderPatternInfo)object).getTopRight());
                        float f8 = (f5 + f7) / (finderPattern.getEstimatedModuleSize() * 2.0f);
                        if (f8 > 180.0f || f8 < 9.0f || Math.abs((f5 - f7) / Math.min(f5, f7)) >= 0.1f) continue;
                        float f9 = f5;
                        float f10 = f7;
                        f7 = (float)Math.sqrt(f9 * f9 + f10 * f10);
                        if (Math.abs((f6 - f3) / Math.min(f6, f7)) >= 0.1f) continue;
                        serializable.add(resultPointArray2);
                    }
                }
            }
            if (!serializable.isEmpty()) {
                Serializable serializable2 = serializable;
                return (FinderPattern[][])serializable2.toArray((T[])new FinderPattern[serializable2.size()][]);
            }
            throw NotFoundException.getNotFoundInstance();
        }
        throw NotFoundException.getNotFoundInstance();
    }

    public FinderPatternInfo[] findMulti(Map<DecodeHintType, ?> map) throws NotFoundException {
        ArrayList<FinderPatternInfo> arrayList;
        FinderPattern[][] finderPatternArray;
        boolean bl = map != null && map.containsKey((Object)DecodeHintType.TRY_HARDER);
        boolean bl2 = map != null && map.containsKey((Object)DecodeHintType.PURE_BARCODE);
        BitMatrix bitMatrix = finderPatternArray.getImage();
        int n2 = bitMatrix.getHeight();
        int n3 = bitMatrix.getWidth();
        int n4 = (int)((float)n2 / 228.0f * 3.0f);
        if (n4 < 3 || bl) {
            n4 = 3;
        }
        int[] nArray = new int[5];
        for (int i2 = n4 - 1; i2 < n2; i2 += n4) {
            int[] nArray2 = nArray;
            nArray2[0] = 0;
            nArray2[1] = 0;
            nArray2[2] = 0;
            nArray2[3] = 0;
            nArray[4] = 0;
            int n5 = 0;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (bitMatrix.get(i3, i2)) {
                    if (n5 & true) {
                        ++n5;
                    }
                    nArray[n5] = nArray[n5] + 1;
                    continue;
                }
                if (!(n5 & true)) {
                    if (n5 == 4) {
                        if (FinderPatternFinder.foundPatternCross(nArray) && finderPatternArray.handlePossibleCenter(nArray, i2, i3, bl2)) {
                            int[] nArray3 = nArray;
                            n5 = 0;
                            nArray3[0] = 0;
                            nArray3[1] = 0;
                            nArray3[2] = 0;
                            nArray3[3] = 0;
                            nArray[4] = 0;
                            continue;
                        }
                        int[] nArray4 = nArray;
                        int[] nArray5 = nArray;
                        nArray5[0] = nArray4[2];
                        nArray5[1] = nArray4[3];
                        nArray5[2] = nArray4[4];
                        nArray4[3] = 1;
                        nArray5[4] = 0;
                        n5 = 3;
                        continue;
                    }
                    nArray[++n5] = nArray[n5] + 1;
                    continue;
                }
                nArray[n5] = nArray[n5] + 1;
            }
            if (!FinderPatternFinder.foundPatternCross(nArray)) continue;
            finderPatternArray.handlePossibleCenter(nArray, i2, n3, bl2);
        }
        finderPatternArray = finderPatternArray.selectMutipleBestPatterns();
        ArrayList<FinderPatternInfo> arrayList2 = arrayList;
        arrayList = new ArrayList<FinderPatternInfo>();
        for (ResultPoint[] resultPointArray : finderPatternArray) {
            FinderPatternInfo finderPatternInfo;
            ResultPoint.orderBestPatterns(resultPointArray);
            FinderPatternInfo finderPatternInfo2 = finderPatternInfo;
            finderPatternInfo = new FinderPatternInfo((FinderPattern[])resultPointArray);
            arrayList2.add(finderPatternInfo2);
        }
        if (arrayList2.isEmpty()) {
            return EMPTY_RESULT_ARRAY;
        }
        ArrayList<FinderPatternInfo> arrayList3 = arrayList2;
        return arrayList3.toArray(new FinderPatternInfo[arrayList3.size()]);
    }

    private static final class ModuleSizeComparator
    implements Comparator<FinderPattern>,
    Serializable {
        private ModuleSizeComparator() {
        }

        @Override
        public int compare(FinderPattern finderPattern, FinderPattern finderPattern2) {
            double d2;
            double d3 = finderPattern2.getEstimatedModuleSize() - finderPattern.getEstimatedModuleSize();
            return d2 < 0.0 ? -1 : (d3 > 0.0 ? 1 : 0);
        }
    }
}

