/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.downloader.core.thread;

import android.os.Process;
import android.util.Log;
import com.dcloud.android.downloader.config.Config;
import com.dcloud.android.downloader.core.DownloadResponse;
import com.dcloud.android.downloader.domain.DownloadInfo;
import com.dcloud.android.downloader.domain.DownloadThreadInfo;
import com.dcloud.android.downloader.exception.DownloadException;
import com.dcloud.android.downloader.exception.DownloadPauseException;
import io.dcloud.common.adapter.util.DCloudTrustManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;

public class DownloadThread
implements Runnable {
    public static final String TAG = "DownloadThread";
    private final DownloadThreadInfo downloadThreadInfo;
    private final DownloadResponse downloadResponse;
    private final Config config;
    private final DownloadInfo downloadInfo;
    private final DownloadProgressListener downloadProgressListener;
    private long lastProgress;
    private InputStream inputStream;
    private int retryDownloadCount = 0;

    public DownloadThread(DownloadThreadInfo downloadThreadInfo, DownloadResponse downloadResponse, Config config, DownloadInfo downloadInfo, DownloadProgressListener downloadProgressListener) {
        this.downloadThreadInfo = downloadThreadInfo;
        this.downloadResponse = downloadResponse;
        this.config = config;
        this.downloadInfo = downloadInfo;
        this.lastProgress = downloadThreadInfo.getProgress();
        this.downloadProgressListener = downloadProgressListener;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeDownload() {
        var1_6 = null;
        var1_6 = (HttpURLConnection)new URL(this.downloadThreadInfo.getUri()).openConnection();
        if (var1_6 instanceof HttpsURLConnection) {
            var2_7 = DCloudTrustManager.getSSLSocketFactory();
            if (var2_7 != null) {
                ((HttpsURLConnection)var1_6).setSSLSocketFactory(var2_7);
            }
            ((HttpsURLConnection)var1_6).setHostnameVerifier((HostnameVerifier)DCloudTrustManager.getHostnameVerifier(false));
        }
        v0 = this;
        var1_6.setConnectTimeout(this.config.getConnectTimeout());
        var1_6.setReadTimeout(this.config.getReadTimeout());
        var1_6.setRequestMethod(this.config.getMethod());
        var2_8 = v0.downloadThreadInfo.getStart() + this.lastProgress;
        if (v0.downloadInfo.isSupportRanges()) {
            if (var2_8 > this.downloadThreadInfo.getEnd()) {
                var2_8 = 0L;
                this.lastProgress = 0L;
            }
            if (this.config.getEachDownloadThread() == 1) {
                var1_6.setRequestProperty("Range", "bytes=" + var2_8 + "-");
            } else {
                var1_6.setRequestProperty("Range", "bytes=" + var2_8 + "-" + this.downloadThreadInfo.getEnd());
            }
        }
        v1 = var1_6;
        var4_10 = v1.getResponseCode();
        var5_12 = (long)Integer.parseInt(v1.getHeaderField("Content-Length")) + var2_8;
        if (this.config.getEachDownloadThread() != 1 || var5_12 == this.downloadThreadInfo.getEnd()) ** GOTO lbl32
        if (var5_12 - this.downloadThreadInfo.getEnd() != 1L) throw new DownloadException(5, "IO error Data source change");
        --var2_8;
        v2 = this.lastProgress;
        this.lastProgress = v2 - 1L;
lbl32:
        // 2 sources

        if (var4_10 == 206 || var4_10 == 200) ** GOTO lbl35
        throw new DownloadException(8, "UnSupported response code:" + var4_10);
lbl35:
        // 1 sources

        v3 = this;
        this.inputStream = var1_6.getInputStream();
        var4_11 = v4;
        try {
            v4 = new RandomAccessFile(this.downloadInfo.getPath(), "rwd");
            if (v3.config.getEachDownloadThread() == 1 && var4_11.length() < this.lastProgress) {
                throw new DownloadException(5, "IO error Have small download size");
            }
            var4_11.seek(var2_8);
            var2_9 = new byte[4096];
            var3_14 = 0;
            while (true) {
                v5 = this;
                v5.checkPause();
                var5_13 = v5.inputStream.read(var2_9);
                if (var5_13 == -1) {
                    v6 = this;
                    v6.downloadProgressListener.onDownloadSuccess();
                    v6.checkPause();
                    var1_6.disconnect();
                }
                v7 = this;
                var4_11.write(var2_9, 0, var5_13);
                v7.downloadThreadInfo.setProgress(this.lastProgress + (long)(var3_14 += var5_13));
                v7.downloadProgressListener.onProgress();
                Log.d((String)"DownloadThread", (String)("downloadInfo:" + this.downloadInfo.getId() + " thread:" + this.downloadThreadInfo.getThreadId() + " progress:" + this.downloadThreadInfo.getProgress() + ",start:" + this.downloadThreadInfo.getStart() + ",end:" + this.downloadThreadInfo.getEnd()));
            }
        }
        catch (ProtocolException var0_5) {
            throw new DownloadException(4, "Protocol error", var0_5);
        }
        {
            catch (Throwable var0_1) {}
            catch (KeyManagementException var0_2) {
                throw new DownloadException(5, "Key management", var0_2);
            }
            catch (NoSuchAlgorithmException var0_3) {
                throw new DownloadException(5, "NO such", var0_3);
            }
            catch (DownloadPauseException v8) {
                if (var1_6 == null) return;
                var1_6.disconnect();
                return;
            }
            catch (IOException var0_4) {}
            {
                throw new DownloadException(5, "IO error", var0_4);
            }
        }
        ** finally { 
lbl75:
        // 1 sources

        if (var1_6 == null) throw var0_1;
        var1_6.disconnect();
        throw var0_1;
    }

    private void checkPause() {
        if (!this.downloadInfo.isPause()) {
            return;
        }
        throw new DownloadPauseException(7);
    }

    @Override
    public void run() {
        DownloadThread downloadThread = this;
        Process.setThreadPriority((int)10);
        downloadThread.checkPause();
        try {
            downloadThread.executeDownload();
        }
        catch (Exception exception) {
            DownloadException downloadException;
            DownloadThread downloadThread2 = this;
            DownloadException downloadException2 = downloadException;
            downloadException = new DownloadException(9, "other error", exception);
            downloadThread2.downloadInfo.setStatus(6);
            downloadThread2.downloadInfo.setException(downloadException2);
            downloadThread2.downloadResponse.onStatusChanged(this.downloadInfo);
            downloadThread2.downloadResponse.handleException(downloadException2);
        }
        catch (DownloadException downloadException) {
            DownloadThread downloadThread3 = this;
            downloadThread3.downloadInfo.setStatus(6);
            downloadThread3.downloadInfo.setException(downloadException);
            downloadThread3.downloadResponse.onStatusChanged(this.downloadInfo);
            downloadThread3.downloadResponse.handleException(downloadException);
        }
    }

    public static interface DownloadProgressListener {
        public void onProgress();

        public void onDownloadSuccess();
    }
}

